CREATE TABLE ensTranscript (
  id int(10) unsigned NOT NULL auto_increment,
  db varchar(40) NOT NULL default '',
  analysis varchar(40) NOT NULL default '',
  type varchar(40) NOT NULL default '',
  transcript_id int(10) unsigned NOT NULL default '0',
  transcript_name varchar(40) NOT NULL default '',
  transcript_version smallint(5) unsigned NOT NULL default '0',
  chr_name varchar(20) NOT NULL default '',
  chr_start int(10) unsigned NOT NULL default '0',
  chr_end int(10) unsigned NOT NULL default '0',
  chr_strand tinyint(4) NOT NULL default '0',
  coding_start int(10) unsigned NOT NULL default '0',
  coding_end int(10) unsigned NOT NULL default '0',
  translation_id int(10) unsigned NOT NULL default '0',
  translation_name varchar(40) NOT NULL default '',
  translation_version smallint(5) unsigned NOT NULL default '0',
  gene_id int(10) unsigned NOT NULL default '0',
  gene_name varchar(40) NOT NULL default 'unknown',
  gene_version smallint(5) unsigned NOT NULL default '0',
  exon_structure text NOT NULL,
  exon_ids text NOT NULL,
  external_db varchar(40) NOT NULL default '',
  external_name varchar(40) NOT NULL default '',
  external_status varchar(10) NOT NULL default '',
  PRIMARY KEY  (id),
  UNIQUE KEY db (db,transcript_id),
  KEY chr_name (chr_name,chr_start),
  KEY db_2 (db,chr_name,chr_start),
  KEY db_3 (db,transcript_name),
  KEY transcript_name (transcript_name),
  KEY transcript_id (transcript_id),
  KEY gene_id (gene_id),
  KEY db_4 (db,gene_id),
  KEY gene_name (gene_name),
  KEY db_5 (db,gene_name),
  KEY t1 (translation_name),
  KEY trC1 (transcript_name),
  KEY trL1 (translation_name)
) TYPE=MyISAM;

