/* goaPart.c was originally generated by the autoSql program, which also 
 * generated goaPart.h and goaPart.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "goaPart.h"


void goaPartStaticLoad(char **row, struct goaPart *ret)
/* Load a row from goaPart table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->dbObjectId = row[0];
ret->dbObjectSymbol = row[1];
ret->notId = row[2];
ret->goId = row[3];
ret->aspect = row[4];
}

struct goaPart *goaPartLoad(char **row)
/* Load a goaPart from row fetched with select * from goaPart
 * from database.  Dispose of this with goaPartFree(). */
{
struct goaPart *ret;

AllocVar(ret);
ret->dbObjectId = cloneString(row[0]);
ret->dbObjectSymbol = cloneString(row[1]);
ret->notId = cloneString(row[2]);
ret->goId = cloneString(row[3]);
ret->aspect = cloneString(row[4]);
return ret;
}

struct goaPart *goaPartLoadAll(char *fileName) 
/* Load all goaPart from a whitespace-separated file.
 * Dispose of this with goaPartFreeList(). */
{
struct goaPart *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = goaPartLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct goaPart *goaPartLoadAllByChar(char *fileName, char chopper) 
/* Load all goaPart from a chopper separated file.
 * Dispose of this with goaPartFreeList(). */
{
struct goaPart *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = goaPartLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct goaPart *goaPartCommaIn(char **pS, struct goaPart *ret)
/* Create a goaPart out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new goaPart */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->dbObjectId = sqlStringComma(&s);
ret->dbObjectSymbol = sqlStringComma(&s);
ret->notId = sqlStringComma(&s);
ret->goId = sqlStringComma(&s);
ret->aspect = sqlStringComma(&s);
*pS = s;
return ret;
}

void goaPartFree(struct goaPart **pEl)
/* Free a single dynamically allocated goaPart such as created
 * with goaPartLoad(). */
{
struct goaPart *el;

if ((el = *pEl) == NULL) return;
freeMem(el->dbObjectId);
freeMem(el->dbObjectSymbol);
freeMem(el->notId);
freeMem(el->goId);
freeMem(el->aspect);
freez(pEl);
}

void goaPartFreeList(struct goaPart **pList)
/* Free a list of dynamically allocated goaPart's */
{
struct goaPart *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    goaPartFree(&el);
    }
*pList = NULL;
}

void goaPartOutput(struct goaPart *el, FILE *f, char sep, char lastSep) 
/* Print out goaPart.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dbObjectId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dbObjectSymbol);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->notId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->goId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->aspect);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

