/* hapmapAllelesSummary.c was originally generated by the autoSql program, which also 
 * generated hapmapAllelesSummary.h and hapmapAllelesSummary.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "hapmapAllelesSummary.h"


void hapmapAllelesSummaryStaticLoad(char **row, struct hapmapAllelesSummary *ret)
/* Load a row from hapmapAllelesSummary table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->observed = row[6];
safecpy(ret->allele1, sizeof(ret->allele1), row[7]);
ret->allele2 = row[8];
ret->popCount = sqlUnsigned(row[9]);
ret->isMixed = row[10];
ret->majorAlleleCEU = row[11];
ret->majorAlleleCountCEU = sqlUnsigned(row[12]);
ret->totalAlleleCountCEU = sqlUnsigned(row[13]);
ret->majorAlleleCHB = row[14];
ret->majorAlleleCountCHB = sqlUnsigned(row[15]);
ret->totalAlleleCountCHB = sqlUnsigned(row[16]);
ret->majorAlleleJPT = row[17];
ret->majorAlleleCountJPT = sqlUnsigned(row[18]);
ret->totalAlleleCountJPT = sqlUnsigned(row[19]);
ret->majorAlleleYRI = row[20];
ret->majorAlleleCountYRI = sqlUnsigned(row[21]);
ret->totalAlleleCountYRI = sqlUnsigned(row[22]);
ret->chimpAllele = row[23];
ret->chimpAlleleQuality = sqlUnsigned(row[24]);
ret->macaqueAllele = row[25];
ret->macaqueAlleleQuality = sqlUnsigned(row[26]);
}

struct hapmapAllelesSummary *hapmapAllelesSummaryLoad(char **row)
/* Load a hapmapAllelesSummary from row fetched with select * from hapmapAllelesSummary
 * from database.  Dispose of this with hapmapAllelesSummaryFree(). */
{
struct hapmapAllelesSummary *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->observed = cloneString(row[6]);
safecpy(ret->allele1, sizeof(ret->allele1), row[7]);
ret->allele2 = cloneString(row[8]);
ret->popCount = sqlUnsigned(row[9]);
ret->isMixed = cloneString(row[10]);
ret->majorAlleleCEU = cloneString(row[11]);
ret->majorAlleleCountCEU = sqlUnsigned(row[12]);
ret->totalAlleleCountCEU = sqlUnsigned(row[13]);
ret->majorAlleleCHB = cloneString(row[14]);
ret->majorAlleleCountCHB = sqlUnsigned(row[15]);
ret->totalAlleleCountCHB = sqlUnsigned(row[16]);
ret->majorAlleleJPT = cloneString(row[17]);
ret->majorAlleleCountJPT = sqlUnsigned(row[18]);
ret->totalAlleleCountJPT = sqlUnsigned(row[19]);
ret->majorAlleleYRI = cloneString(row[20]);
ret->majorAlleleCountYRI = sqlUnsigned(row[21]);
ret->totalAlleleCountYRI = sqlUnsigned(row[22]);
ret->chimpAllele = cloneString(row[23]);
ret->chimpAlleleQuality = sqlUnsigned(row[24]);
ret->macaqueAllele = cloneString(row[25]);
ret->macaqueAlleleQuality = sqlUnsigned(row[26]);
return ret;
}

struct hapmapAllelesSummary *hapmapAllelesSummaryLoadAll(char *fileName) 
/* Load all hapmapAllelesSummary from a whitespace-separated file.
 * Dispose of this with hapmapAllelesSummaryFreeList(). */
{
struct hapmapAllelesSummary *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[27];

while (lineFileRow(lf, row))
    {
    el = hapmapAllelesSummaryLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct hapmapAllelesSummary *hapmapAllelesSummaryLoadAllByChar(char *fileName, char chopper) 
/* Load all hapmapAllelesSummary from a chopper separated file.
 * Dispose of this with hapmapAllelesSummaryFreeList(). */
{
struct hapmapAllelesSummary *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[27];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = hapmapAllelesSummaryLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct hapmapAllelesSummary *hapmapAllelesSummaryCommaIn(char **pS, struct hapmapAllelesSummary *ret)
/* Create a hapmapAllelesSummary out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hapmapAllelesSummary */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->observed = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->allele1, sizeof(ret->allele1));
ret->allele2 = sqlStringComma(&s);
ret->popCount = sqlUnsignedComma(&s);
ret->isMixed = sqlStringComma(&s);
ret->majorAlleleCEU = sqlStringComma(&s);
ret->majorAlleleCountCEU = sqlUnsignedComma(&s);
ret->totalAlleleCountCEU = sqlUnsignedComma(&s);
ret->majorAlleleCHB = sqlStringComma(&s);
ret->majorAlleleCountCHB = sqlUnsignedComma(&s);
ret->totalAlleleCountCHB = sqlUnsignedComma(&s);
ret->majorAlleleJPT = sqlStringComma(&s);
ret->majorAlleleCountJPT = sqlUnsignedComma(&s);
ret->totalAlleleCountJPT = sqlUnsignedComma(&s);
ret->majorAlleleYRI = sqlStringComma(&s);
ret->majorAlleleCountYRI = sqlUnsignedComma(&s);
ret->totalAlleleCountYRI = sqlUnsignedComma(&s);
ret->chimpAllele = sqlStringComma(&s);
ret->chimpAlleleQuality = sqlUnsignedComma(&s);
ret->macaqueAllele = sqlStringComma(&s);
ret->macaqueAlleleQuality = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void hapmapAllelesSummaryFree(struct hapmapAllelesSummary **pEl)
/* Free a single dynamically allocated hapmapAllelesSummary such as created
 * with hapmapAllelesSummaryLoad(). */
{
struct hapmapAllelesSummary *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->observed);
freeMem(el->allele2);
freeMem(el->isMixed);
freeMem(el->majorAlleleCEU);
freeMem(el->majorAlleleCHB);
freeMem(el->majorAlleleJPT);
freeMem(el->majorAlleleYRI);
freeMem(el->chimpAllele);
freeMem(el->macaqueAllele);
freez(pEl);
}

void hapmapAllelesSummaryFreeList(struct hapmapAllelesSummary **pList)
/* Free a list of dynamically allocated hapmapAllelesSummary's */
{
struct hapmapAllelesSummary *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    hapmapAllelesSummaryFree(&el);
    }
*pList = NULL;
}

void hapmapAllelesSummaryOutput(struct hapmapAllelesSummary *el, FILE *f, char sep, char lastSep) 
/* Print out hapmapAllelesSummary.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->observed);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->allele1);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->allele2);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->popCount);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->isMixed);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->majorAlleleCEU);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->majorAlleleCountCEU);
fputc(sep,f);
fprintf(f, "%u", el->totalAlleleCountCEU);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->majorAlleleCHB);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->majorAlleleCountCHB);
fputc(sep,f);
fprintf(f, "%u", el->totalAlleleCountCHB);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->majorAlleleJPT);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->majorAlleleCountJPT);
fputc(sep,f);
fprintf(f, "%u", el->totalAlleleCountJPT);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->majorAlleleYRI);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->majorAlleleCountYRI);
fputc(sep,f);
fprintf(f, "%u", el->totalAlleleCountYRI);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chimpAllele);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chimpAlleleQuality);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->macaqueAllele);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->macaqueAlleleQuality);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

