/*
 * ARCload (c) 2005 Stanislaw Skowronek
 */

#ifndef CONFIG_H
#define CONFIG_H

/*
 * this function parses the config file
 *  label - input parameter, contains names of configurations
 *  label_count - input parameter, number of configurations
 *  image - output parameter, will contain path to bootable file
 *  n_image - input parameter, contains maximum length of image
 *  append - output parameter, will contain kernel arguments
 *  n_image - input parameter, contains maximum length of image
 *  append_space - in-out parameter, will contain append as linear string
 *  n_append_space - input parameter, size of append_space
 *  append_count - output parameter, count of kernel arguments
 *
 * if image[0] == 0 on output, we failed
 */
void parseconfig(char **label, int n_label, int *label_count,
		 char *image, int n_image, 
		 char **append, int n_append,
		 char *append_space, int n_append_space,
		 int *append_count, char *system);

/* this function parses text label format into an array
 * I'm pretty sure that by know you can guess the meanings */
void parselabel(char *text,
		char **label, int n_label, int *label_count,
		char *label_space, int n_label_space);

#endif
