#ifndef ECOFF_H
#define ECOFF_H


/* file header */

/* f_flags */
#define	F_RELFLG		0x0001
#define	F_EXEC			0x0002
#define	F_LNNO			0x0004
#define	F_LSYMS			0x0008
#define	F_MINMAL		0x0010
#define	F_UPDATE		0x0020
#define	F_SWABD			0x0040
#define	F_AR16WR		0x0080
#define	F_AR32WR		0x0100
#define	F_AR32W			0x0200
#define	F_PATCH			0x0400
#define	F_NODF			0x0400
#define	F_64INT			0x0800		/* basic int size is 64 bits */

#define	F_MIPS_NO_SHARED	0x1000
#define	F_MIPS_SHARABLE		0x2000
#define	F_MIPS_CALL_SHARED	0x3000
#define	F_MIPS_NO_REORG		0x4000		/* may remove nops */
#define	F_MIPS_XGOT		0x8000
#define	F_MIPS_UGEN_ALLOC	F_MIPS_XGOT	/* obsolete flags */

/* magic */
#define	MIPSEBMAGIC		0x0160
#define	MIPSELMAGIC		0x0162
#define	SMIPSEBMAGIC		0x6001
#define	SMIPSELMAGIC		0x6201
#define	MIPSEBUMAGIC		0x0180
#define	MIPSELUMAGIC		0x0182

#define	MIPS2EBMAGIC		0x0163


struct filehdr {
	unsigned short	f_magic;	/* magic number */
	unsigned short	f_nscns;	/* number of sections */
	int		f_timdat;	/* time & date stamp */
	int		f_symptr;	/* file pointer to symbolic header */
	int		f_nsyms;	/* sizeof(symbolic hdr) */
	unsigned short	f_opthdr;	/* sizeof(optional hdr) */
	unsigned short	f_flags;	/* flags */
};

#define swap_filehdr(x)			\
	swap16(&((x)->f_magic));	\
	swap16(&((x)->f_nscns));	\
	swap32(&((x)->f_timdat));	\
	swap32(&((x)->f_symptr));	\
	swap32(&((x)->f_nsyms));	\
	swap16(&((x)->f_opthdr));	\
	swap16(&((x)->f_flags));


/* a.out header */
#define	OMAGIC		0407
#define	NMAGIC		0410
#define	ZMAGIC		0413
#define SMAGIC		0411
#define	LIBMAGIC	0443

#define AOUT_VERSION	0x071e

struct aouthdr {
	short	magic;		/* see above				*/
	short	vstamp;		/* version stamp			*/
	int	tsize;		/* text size in bytes, padded to DW bdry*/
	int	dsize;		/* initialized data "  "		*/
	int	bsize;		/* uninitialized data "   "		*/
	int	entry;		/* entry pt.				*/
	int	text_start;	/* base of text used for this file	*/
	int	data_start;	/* base of data used for this file	*/
	int	bss_start;	/* base of bss used for this file	*/
	int	gprmask;	/* general purpose register mask	*/
	int	cprmask[4];	/* co-processor register masks		*/
	int	gp_value;	/* the gp value used for this object    */
};

#define swap_aouthdr(x)			\
	swap16(&((x)->magic));		\
	swap16(&((x)->vstamp));		\
	swap32(&((x)->tsize));		\
	swap32(&((x)->dsize));		\
	swap32(&((x)->bsize));		\
	swap32(&((x)->entry));		\
	swap32(&((x)->text_start));	\
	swap32(&((x)->data_start));	\
	swap32(&((x)->bss_start));	\
	swap32(&((x)->gprmask));	\
	swap32(&((x)->cprmask[0]));	\
	swap32(&((x)->cprmask[1]));	\
	swap32(&((x)->cprmask[2]));	\
	swap32(&((x)->cprmask[3]));	\
	swap32(&((x)->gp_value));


/* section header */
#define	STYP_REG		0x00000000	/* "regular" section: allocated, relocated, loaded */
#define	STYP_DSECT		0x00000001	/* "dummy" section: not allocated, relocated, not loaded */
#define	STYP_NOLOAD		0x00000002	/* "noload" section: allocated, relocated, not loaded */
#define	STYP_GROUP		0x00000004	/* "grouped" section: formed of input sections */
#define	STYP_PAD		0x00000008	/* "padding" section: not allocated, not relocated, loaded */
#define	STYP_COPY		0x00000010	/* "copy" section: for decision function used by field update; not allocated, not relocated, loaded;  reloc & lineno entries processed normally */
#define	STYP_TEXT		0x00000020	/* section contains text only */
#define	STYP_DATA		0x00000040	/* section contains data only */
#define	STYP_BSS		0x00000080	/* section contains bss only */
#define	STYP_RDATA		0x00000100	/* section contains read only data */
#define	STYP_SDATA		0x00000200	/* section contains small data only */
#define	STYP_SBSS		0x00000400	/* section contains small bss only */
#define	STYP_UCODE		0x00000800	/* section only contains ucodes */

/* of dso related sections types */
#define	STYP_GOT		0x00001000
#define	STYP_DYNAMIC		0x00002000
#define	STYP_DYNSYM		0x00004000
#define	STYP_REL_DYN		0x00008000
#define	STYP_DYNSTR		0x00010000
#define	STYP_HASH		0x00020000

/* Mips specific dso sections */
#define	STYP_DSOLIST		0x00040000
#define	STYP_RESERVED1		0x00080000	/* Reserved */
#define	_STYP_LOCAL_DATA	0x00100000
#define	_STYP_RESOURCE		0x00200000

struct scnhdr {
	char		s_name[8];	/* section name */
	int		s_paddr;	/* physical address, aliased s_nlib */
	int		s_vaddr;	/* virtual address */
	int		s_size;		/* section size */
	int		s_scnptr;	/* file ptr to raw data for section */
	int		s_relptr;	/* file ptr to relocation */
	int		s_lnnoptr;	/* file ptr to gp histogram */
	unsigned short	s_nreloc;	/* number of relocation entries */
	unsigned short	s_nlnno;	/* number of gp histogram entries */
	int		s_flags;	/* flags */
	};

#define swap_scnhdr(x)			\
	swap32(&((x)->s_paddr));	\
	swap32(&((x)->s_vaddr));	\
	swap32(&((x)->s_size));		\
	swap32(&((x)->s_scnptr));	\
	swap32(&((x)->s_relptr));	\
	swap32(&((x)->s_lnnoptr));	\
	swap16(&((x)->s_nreloc));	\
	swap16(&((x)->s_nlnno));	\
	swap32(&((x)->s_flags));


/* relocs */
#define	R_SN_NULL	0
#define	R_SN_TEXT	1
#define	R_SN_RDATA	2
#define	R_SN_DATA	3
#define	R_SN_SDATA	4
#define	R_SN_SBSS	5
#define	R_SN_BSS	6
#define	R_SN_INIT	7
#define	R_SN_LIT8	8
#define	R_SN_LIT4	9
#define	R_SN_XDATA	10
#define	R_SN_PDATA	11
#define	R_SN_FINI	12
#define	MAX_R_SN	12

#define	R_ABS		0

#define	R_REFHALF	1
#define	R_REFWORD	2
#define	R_JMPADDR	3
#define	R_REFHI		4
#define	R_REFLO		5
#define	R_GPREL		6
#define	R_LITERAL	7
#define	R_REL32		8
#define	R_REFGOT	R_REL32		/* alias for compatibility */
#define	R_REFHI_64	9
#define	R_REFLO_64	10
#define	R_REFWORD_64	11
#define	R_PC16		12
#define	R_RELHI		13
#define	R_RELLO		14
#define	R_REFSHFT	15
#define	R_REFHI_ADDEND	16		/* lo value is in immed of inst */
#define	R_SHFTCNT	17
#define	R_MULTRELHI	18
#define	R_MULTRELLO	19
#define	R_DATA16	20

struct reloc {
	int		r_vaddr;	/* (virtual) address of reference */
	unsigned	r;
#define	R_SYMNDX(x)			(((x) >> 8) & 0xFFFFFF)	/* index into symbol table */
#define	R_TYPE(x)			(((x) >> 1) & 0x1F)	/* relocation type */
#define	R_EXTERN(x)			((x) & 1)		/* if 1 symndx is an index into the external symbol table, else symndx is a section # */
#define	R_R(symndx, type, extern)	(((symndx) << 8) | ((type) << 1) | (extern))
};

#define swap_reloc(x)			\
	swap32(&((x)->r_vaddr));	\
	swap32(&((x)->r));


/* symbol header */
#define SGIHDRR_MAGIC	0x7009
struct sgihdrr  {
	short		magic;		/* to verify validity of the table */
	short		vstamp;		/* version stamp */
	unsigned	ilineMax;	/* number of line number entries in the
					 * virtual table of uncompressed lines
					 * (ie, the number
					 * of 32-bit words of text, which is
					 * by definition identical to the size
					 * of the virtual (uncompressed) line table).
					 */
	unsigned	cbLine;		/* number of bytes for compressed
					 * line number entries
					 */
	unsigned	cbLineOffset;	/* offset to start of compressed
					 * line number table
					 */
	unsigned	idnMax;		/* max index into dense number table */
	unsigned	cbDnOffset;	/* offset to start dense number table */
	unsigned	ipdMax;		/* number of procedures */
	unsigned	cbPdOffset;	/* offset to procedure descriptor table */
	unsigned	isymMax;	/* number of local symbols */
	unsigned	cbSymOffset;	/* offset to start of local symbols*/
	unsigned	ioptMax;	/* max index into optimization symbol entries */
	unsigned	cbOptOffset;	/* offset to optimization symbol entries */
	unsigned	iauxMax;	/* number of auxillary symbol entries */
	unsigned	cbAuxOffset;	/* offset to start of auxillary symbol entries*/
	unsigned	issMax;		/* max index into local strings */
	unsigned	cbSsOffset;	/* offset to start of local strings */
	unsigned	issExtMax;	/* max index into external strings */
	unsigned	cbSsExtOffset;	/* offset to start of external strings */
	unsigned	ifdMax;		/* number of file descriptor entries */
	unsigned	cbFdOffset;	/* offset to file descriptor table */
	unsigned	crfd;		/* number of relative file descriptor entries */
	unsigned	cbRfdOffset;	/* offset to relative file descriptor table */
	unsigned	iextMax;	/* max index into external symbols */
	unsigned	cbExtOffset;	/* offset to start of external symbol entries*/
};

#define swap_sgihdrr(x)			\
	swap16(&((x)->magic));		\
	swap16(&((x)->vstamp));		\
	swap32(&((x)->ilineMax));	\
	swap32(&((x)->cbLine));		\
	swap32(&((x)->cbLineOffset));	\
	swap32(&((x)->idnMax));		\
	swap32(&((x)->cbDnOffset));	\
	swap32(&((x)->ipdMax));		\
	swap32(&((x)->cbPdOffset));	\
	swap32(&((x)->isymMax));	\
	swap32(&((x)->cbSymOffset));	\
	swap32(&((x)->ioptMax));	\
	swap32(&((x)->cbOptOffset));	\
	swap32(&((x)->iauxMax));	\
	swap32(&((x)->cbAuxOffset));	\
	swap32(&((x)->issMax));		\
	swap32(&((x)->cbSsOffset));	\
	swap32(&((x)->issExtMax));	\
	swap32(&((x)->cbSsExtOffset));	\
	swap32(&((x)->ifdMax));		\
	swap32(&((x)->cbFdOffset));	\
	swap32(&((x)->crfd));		\
	swap32(&((x)->cbRfdOffset));	\
	swap32(&((x)->iextMax));	\
	swap32(&((x)->cbExtOffset));


#define scNil		0
#define scText		1	/* text symbol */
#define scData		2	/* initialized data symbol */
#define scBss		3	/* un-initialized data symbol */
#define scRegister	4	/* value of symbol is register number */
#define scAbs		5	/* value of symbol is absolute */

struct sgisymr {
	unsigned iss;		/* index into String Space of name */
	unsigned value;		/* value of symbol */
	unsigned data;
#define S_ST(x)		(((x) >> 26) & 0x3F)
#define S_SC(x)		(((x) >> 21) & 0x1F)
#define S_INDEX(x)	((x) & 0xFFFFF)
};

#define swap_sgisymr(x)		\
	swap32(&((x)->iss));	\
	swap32(&((x)->value));	\
	swap32(&((x)->data));

struct sgiextr {
	unsigned flags;
	unsigned iss;		/* index into String Space of name */
	unsigned value;		/* value of symbol */
	unsigned data;
#define S_DATA(st, sc, index)	(((st) << 26) | ((sc) << 21) | index)
#define S_ST(x)			(((x) >> 26) & 0x3F)
#define S_SC(x)			(((x) >> 21) & 0x1F)
#define S_INDEX(x)		((x) & 0xFFFFF)
};

#define swap_sgiextr(x)		\
	swap32(&((x)->flags));	\
	swap32(&((x)->iss));	\
	swap32(&((x)->value));	\
	swap32(&((x)->data));


#endif /* ECOFF_H */
