/* vulninfo.H
 * John Viega
 *
 * Jan 28-29 2000
 */

#ifndef __VULNINFO_H__
#define __VULNINFO_H__

typedef enum Severity_enum
{ S_NO_RISK, S_LOW_RISK, S_MODERATE_RISK, S_RISKY, S_VERY_RISKY, S_MOST_RISKY,
S_ERROR }
Severity;

const Severity MAX_SEVERITY = S_MOST_RISKY;

class VulnInfo {
 public:
  VulnInfo(int d, int s, Severity v, int h, int i, int inp)
    {
      desc     = d;
      solution = s;
      severity = v;
      handler  = h;
      id       = i;
      input    = inp;
      printed  = 0;
    }
  unsigned int       desc;
  unsigned int       solution;
  Severity           severity;
  int                handler;
  int                id;
  int                input;
  // Used in the formatter to avoid duplicating the same error message twice.
  short              printed;
};

#endif
