/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractList<E>
extends AbstractCollection<E>
implements List<E> {
    protected transient int modCount;

    protected AbstractList() {
    }

    @Override
    public boolean add(E e) {
        return false;
    }

    @Override
    public abstract E get(int var1);

    @Override
    public E set(int n, E e) {
        return null;
    }

    @Override
    public void add(int n, E e) {
    }

    @Override
    public E remove(int n) {
        return null;
    }

    @Override
    public int indexOf(Object object) {
        return 0;
    }

    @Override
    public int lastIndexOf(Object object) {
        return 0;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return null;
    }

    @Override
    public ListIterator<E> listIterator() {
        return null;
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return null;
    }

    @Override
    public List<E> subList(int n, int n2) {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    protected void removeRange(int n, int n2) {
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            try {
                int i = this.cursor - 1;
                Object previous = AbstractList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException((Throwable)e);
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractList.this.set(this.lastRet, e);
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                AbstractList.this.add(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = AbstractList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != AbstractList.this.size();
        }

        @Override
        public E next() {
            this.checkForComodification();
            try {
                int i = this.cursor;
                Object next = AbstractList.this.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException((Throwable)e);
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (AbstractList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

