/* Copyright (C) 2023 Alif Semiconductor - All Rights Reserved.
 * Use, distribution and modification of this code is permitted under the
 * terms stated in the Alif Semiconductor Software License Agreement
 *
 * You should have received a copy of the Alif Semiconductor Software
 * License Agreement with this file. If not, please write to:
 * contact@alifsemi.com, or visit: https://alifsemi.com/license
 *
 */

/******************************************************************************
 * @file     conductor_board_config.h
 * @author   Silesh C V
 * @email    silesh@alifsemi.com
 * @version  V1.0.0
 * @date     21-Aug-2023
 * @brief    Public header file for the conductor (https://conductor.alifsemi.com)
             board configuration library.
 ******************************************************************************/
#ifndef CONDUCTOR_BOARD_CONFIG_H_
#define CONDUCTOR_BOARD_CONFIG_H_

#ifdef  __cplusplus
extern "C"
{
#endif

#include <stdint.h>
/**
  \fn          int32_t conductor_pins_config(void)
  \brief       Initialize board pins as per the information generated by the conductor tool.
  \return      0 on success, -1 on failure
*/
int32_t conductor_pins_config(void);

#ifdef  __cplusplus
}
#endif
#endif /* CONDUCTOR_BOARD_CONFIG_H_*/
