package suppressions

import (
	"time"

	"github.com/hashicorp/go-azure-helpers/lang/dates"
)

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See NOTICE.txt in the project root for license information.

type SuppressionProperties struct {
	ExpirationTimeStamp *string `json:"expirationTimeStamp,omitempty"`
	SuppressionId       *string `json:"suppressionId,omitempty"`
	Ttl                 *string `json:"ttl,omitempty"`
}

func (o *SuppressionProperties) GetExpirationTimeStampAsTime() (*time.Time, error) {
	if o.ExpirationTimeStamp == nil {
		return nil, nil
	}
	return dates.ParseAsFormat(o.ExpirationTimeStamp, "2006-01-02T15:04:05Z07:00")
}

func (o *SuppressionProperties) SetExpirationTimeStampAsTime(input time.Time) {
	formatted := input.Format("2006-01-02T15:04:05Z07:00")
	o.ExpirationTimeStamp = &formatted
}
