
## `github.com/hashicorp/go-azure-sdk/resource-manager/alertsmanagement/2019-05-05-preview/actionrules` Documentation

The `actionrules` SDK allows for interaction with Azure Resource Manager `alertsmanagement` (API Version `2019-05-05-preview`).

This readme covers example usages, but further information on [using this SDK can be found in the project root](https://github.com/hashicorp/go-azure-sdk/tree/main/docs).

### Import Path

```go
import "github.com/hashicorp/go-azure-helpers/resourcemanager/commonids"
import "github.com/hashicorp/go-azure-sdk/resource-manager/alertsmanagement/2019-05-05-preview/actionrules"
```


### Client Initialization

```go
client := actionrules.NewActionRulesClientWithBaseURI("https://management.azure.com")
client.Client.Authorizer = authorizer
```


### Example Usage: `ActionRulesClient.CreateUpdate`

```go
ctx := context.TODO()
id := actionrules.NewActionRuleID("12345678-1234-9876-4563-123456789012", "example-resource-group", "actionRuleName")

payload := actionrules.ActionRule{
	// ...
}


read, err := client.CreateUpdate(ctx, id, payload)
if err != nil {
	// handle the error
}
if model := read.Model; model != nil {
	// do something with the model/response object
}
```


### Example Usage: `ActionRulesClient.Delete`

```go
ctx := context.TODO()
id := actionrules.NewActionRuleID("12345678-1234-9876-4563-123456789012", "example-resource-group", "actionRuleName")

read, err := client.Delete(ctx, id)
if err != nil {
	// handle the error
}
if model := read.Model; model != nil {
	// do something with the model/response object
}
```


### Example Usage: `ActionRulesClient.GetByName`

```go
ctx := context.TODO()
id := actionrules.NewActionRuleID("12345678-1234-9876-4563-123456789012", "example-resource-group", "actionRuleName")

read, err := client.GetByName(ctx, id)
if err != nil {
	// handle the error
}
if model := read.Model; model != nil {
	// do something with the model/response object
}
```


### Example Usage: `ActionRulesClient.ListByResourceGroup`

```go
ctx := context.TODO()
id := commonids.NewResourceGroupID("12345678-1234-9876-4563-123456789012", "example-resource-group")

// alternatively `client.ListByResourceGroup(ctx, id, actionrules.DefaultListByResourceGroupOperationOptions())` can be used to do batched pagination
items, err := client.ListByResourceGroupComplete(ctx, id, actionrules.DefaultListByResourceGroupOperationOptions())
if err != nil {
	// handle the error
}
for _, item := range items {
	// do something
}
```


### Example Usage: `ActionRulesClient.ListBySubscription`

```go
ctx := context.TODO()
id := commonids.NewSubscriptionID("12345678-1234-9876-4563-123456789012")

// alternatively `client.ListBySubscription(ctx, id, actionrules.DefaultListBySubscriptionOperationOptions())` can be used to do batched pagination
items, err := client.ListBySubscriptionComplete(ctx, id, actionrules.DefaultListBySubscriptionOperationOptions())
if err != nil {
	// handle the error
}
for _, item := range items {
	// do something
}
```


### Example Usage: `ActionRulesClient.Update`

```go
ctx := context.TODO()
id := actionrules.NewActionRuleID("12345678-1234-9876-4563-123456789012", "example-resource-group", "actionRuleName")

payload := actionrules.PatchObject{
	// ...
}


read, err := client.Update(ctx, id, payload)
if err != nil {
	// handle the error
}
if model := read.Model; model != nil {
	// do something with the model/response object
}
```
