<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/integrations/cloud-notifications/integrations/rocketchat.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/integrations/cloud-notifications/metadata.yaml"
sidebar_label: "RocketChat"
learn_status: "Published"
learn_rel_path: "Alerts & Notifications/Notifications/Centralized Cloud Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# RocketChat


<img src="https://netdata.cloud/img/rocketchat.png" width="150"/>


From the Netdata Cloud UI, you can manage your space's notification settings and enable the configuration to deliver notifications on RocketChat.


<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup

### Prerequisites

- A Netdata Cloud account
- Access to the Netdata Space as an **administrator**
- The Netdata Space needs to be on **Business** plan or higher
- You need to have permissions on Mattermost to add new integrations.
- You need to have a RocketChat app on your workspace to receive the webhooks.

### Mattermost Server Configuration

Steps to configure your RocketChat to receive notifications from Netdata:

1. In RocketChat, Navigate to Administration > Workspace > Integrations.
2. Click **+New** at the top right corner.
3. For more details about each parameter, check [create-a-new-incoming-webhook](https://docs.rocket.chat/use-rocket.chat/workspace-administration/integrations#create-a-new-incoming-webhook).
4. After configuring integration, click Save.
5. You will end up with a webhook endpoint that looks like below:
  `https://your-server.rocket.chat/hooks/YYYYYYYYYYYYYYYYYYYYYYYY/XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX`
  - Treat this endpoint as a secret. Anyone who has it will be able to post messages to your RocketChat instance.


For more details please check RocketChat's article Incoming webhooks for [RocketChat](https://docs.rocket.chat/use-rocket.chat/workspace-administration/integrations/).

### Netdata Configuration Steps

1. Click on the **Space settings** cog (located above your profile icon)
2. Click on the **Notification** tab
3. Click on the **+ Add configuration** button (near the top-right corner of your screen)
4. On the **RocketChat** card click on **+ Add**
5. A modal will be presented to you to enter the required details to enable the configuration:
  * **Notification settings** are Netdata specific settings
    - Configuration name - you can optionally provide a name for your configuration you can easily refer to it
    - Rooms - by specifying a list of Rooms you are select to which nodes or areas of your infrastructure you want to be notified using this configuration
    - Notification - you specify which notifications you want to be notified using this configuration: All Alerts and unreachable, All Alerts, Critical only
  * **Integration configuration** are the specific notification integration required settings, which vary by notification method. For RocketChat:
    - Webhook URL - URL provided on RocketChat for the channel you want to receive your notifications.


