<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/freeipmi.plugin/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/freeipmi.plugin/metadata.yaml"
sidebar_label: "Intelligent Platform Management Interface (IPMI)"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Hardware Devices and Sensors"
most_popular: True
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Intelligent Platform Management Interface (IPMI)


<img src="https://netdata.cloud/img/netdata.png" width="150"/>


Plugin: freeipmi.plugin
Module: freeipmi

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

"Monitor enterprise server sensor readings, event log entries, and hardware statuses to ensure reliable server operations."


The plugin uses open source library IPMImonitoring to communicate with sensors.


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.

The plugin needs setuid.

### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

Linux kernel module for IPMI can create big overhead.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.

The plugin does a speed test when it starts, to find out the duration needed by the IPMI processor to respond. Depending on the speed of your IPMI processor, charts may need several seconds to show up on the dashboard.


### Per Intelligent Platform Management Interface (IPMI) instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| ipmi.sel | events | events |

### Per sensor



Labels:

| Label      | Description     |
|:-----------|:----------------|
| sensor | The sensor name |
| type | One of 45 recognized sensor types (Battery, Voltage...) |
| component | One of 25 recognized components (Processor, Peripheral). |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| ipmi.sensor_state | nominal, critical, warning, unknown | state |
| ipmi.sensor_temperature_c | temperature | Celsius |
| ipmi.sensor_temperature_f | temperature | Fahrenheit |
| ipmi.sensor_voltage | voltage | Volts |
| ipmi.sensor_ampere | ampere | Amps |
| ipmi.sensor_fan_speed | rotations | RPM |
| ipmi.sensor_power | power | Watts |
| ipmi.sensor_reading_percent | percentage | % |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ ipmi_sensor_state ](https://github.com/netdata/netdata/blob/master/src/health/health.d/ipmi.conf) | ipmi.sensor_state | IPMI sensor ${label:sensor} (${label:component}) state |


## Setup

### Prerequisites

#### Install freeipmi.plugin

When using our official DEB/RPM packages, the FreeIPMI plugin is included in a separate package named `netdata-plugin-freeipmi` which needs to be manually installed using your system package manager. It is not installed automatically due to the large number of dependencies it requires.

When using a static build of Netdata, the FreeIPMI plugin will be included and installed automatically, though you will still need to have FreeIPMI installed on your system to be able to use the plugin.

When using a local build of Netdata, you need to ensure that the FreeIPMI development packages (typically called `libipmimonitoring-dev`, `libipmimonitoring-devel`, or `freeipmi-devel`) are installed when building Netdata.


#### Preliminary actions

If you have not previously used IPMI on your system, you will probably need to run the `ipmimonitoring` command as root
to initialize IPMI settings so that the Netdata plugin works correctly. It should return information about available sensors on the system.



### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:freeipmi]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options

The configuration is set using command line options:

```
# netdata.conf
[plugin:freeipmi]
  command options = opt1 opt2 ... optN
```

To display a help message listing the available command line options:

```bash
./usr/libexec/netdata/plugins.d/freeipmi.plugin --help
```


<details><summary>Command options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| SECONDS | Data collection frequency. |  | no |
| debug | Enable verbose output. | disabled | no |
| no-sel | Disable System Event Log (SEL) collection. | disabled | no |
| reread-sdr-cache | Re-read SDR cache on every iteration. | disabled | no |
| interpret-oem-data | Attempt to parse OEM data. | disabled | no |
| assume-system-event-record | treat illegal SEL events records as normal. | disabled | no |
| ignore-non-interpretable-sensors | Do not read sensors that cannot be interpreted. | disabled | no |
| bridge-sensors | Bridge sensors not owned by the BMC. | disabled | no |
| shared-sensors | Enable shared sensors if found. | disabled | no |
| no-discrete-reading | Do not read sensors if their event/reading type code is invalid. | enabled | no |
| ignore-scanning-disabled | Ignore the scanning bit and read sensors no matter what. | disabled | no |
| assume-bmc-owner | Assume the BMC is the sensor owner no matter what (usually bridging is required too). | disabled | no |
| hostname HOST | Remote IPMI hostname or IP address. | local | no |
| username USER | Username that will be used when connecting to the remote host. |  | no |
| password PASS | Password that will be used when connecting to the remote host. |  | no |
| noauthcodecheck / no-auth-code-check | Don't check the authentication codes returned. |  | no |
| driver-type IPMIDRIVER | Specify the driver type to use instead of doing an auto selection. The currently available outofband drivers are LAN and LAN_2_0, which  perform  IPMI  1.5  and  IPMI  2.0 respectively. The currently available inband drivers are KCS, SSIF, OPENIPMI and SUNBMC. |  | no |
| sdr-cache-dir PATH | SDR cache files directory. | /tmp | no |
| sensor-config-file FILE | Sensors configuration filename. | system default | no |
| sel-config-file FILE | SEL configuration filename. | system default | no |
| ignore N1,N2,N3,... | Sensor IDs to ignore. |  | no |
| ignore-status N1,N2,N3,... | Sensor IDs to ignore status (nominal/warning/critical). |  | no |
| -v | Print version and exit. |  | no |
| --help | Print usage message and exit. |  | no |

</details>

#### Examples

##### Decrease data collection frequency

Basic example decreasing data collection frequency. The minimum `update every` is 5 (enforced internally by the plugin). IPMI is slow and CPU hungry. So, once every 5 seconds is pretty acceptable.

```yaml
[plugin:freeipmi]
  update every = 10

```
##### Disable SEL collection

Append to `command options =` the options you need.

<details><summary>Config</summary>

```yaml
[plugin:freeipmi]
  command options = no-sel

```
</details>

##### Ignore specific sensors

Specific sensor IDs can be excluded from freeipmi tools by editing `/etc/freeipmi/freeipmi.conf` and setting the IDs to be ignored at `ipmi-sensors-exclude-record-ids`.

**However this file is not used by `libipmimonitoring`** (the library used by Netdata's `freeipmi.plugin`).

To find the IDs to ignore, run the command `ipmimonitoring`. The first column is the wanted ID:

ID  | Name             | Type                     | State    | Reading    | Units | Event
1   | Ambient Temp     | Temperature              | Nominal  | 26.00      | C     | 'OK'
2   | Altitude         | Other Units Based Sensor | Nominal  | 480.00     | ft    | 'OK'
3   | Avg Power        | Current                  | Nominal  | 100.00     | W     | 'OK'
4   | Planar 3.3V      | Voltage                  | Nominal  | 3.29       | V     | 'OK'
5   | Planar 5V        | Voltage                  | Nominal  | 4.90       | V     | 'OK'
6   | Planar 12V       | Voltage                  | Nominal  | 11.99      | V     | 'OK'
7   | Planar VBAT      | Voltage                  | Nominal  | 2.95       | V     | 'OK'
8   | Fan 1A Tach      | Fan                      | Nominal  | 3132.00    | RPM   | 'OK'
9   | Fan 1B Tach      | Fan                      | Nominal  | 2150.00    | RPM   | 'OK'
10  | Fan 2A Tach      | Fan                      | Nominal  | 2494.00    | RPM   | 'OK'
11  | Fan 2B Tach      | Fan                      | Nominal  | 1825.00    | RPM   | 'OK'
12  | Fan 3A Tach      | Fan                      | Nominal  | 3538.00    | RPM   | 'OK'
13  | Fan 3B Tach      | Fan                      | Nominal  | 2625.00    | RPM   | 'OK'
14  | Fan 1            | Entity Presence          | Nominal  | N/A        | N/A   | 'Entity Present'
15  | Fan 2            | Entity Presence          | Nominal  | N/A        | N/A   | 'Entity Present'
...

`freeipmi.plugin` supports the option `ignore` that accepts a comma separated list of sensor IDs to ignore. To configure it set on `netdata.conf`:


<details><summary>Config</summary>

```yaml
[plugin:freeipmi]
      command options = ignore 1,2,3,4,...

```
</details>



## Troubleshooting

### Debug Mode



### kimpi0 CPU usage




