<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/ipfs/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/ipfs/metadata.yaml"
sidebar_label: "IPFS"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Storage, Mount Points and Filesystems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# IPFS


<img src="https://netdata.cloud/img/ipfs.svg" width="150"/>


Plugin: python.d.plugin
Module: ipfs

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors IPFS server metrics about its quality and performance.

It connects to an http endpoint of the IPFS server to collect the metrics

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

If the endpoint is accessible by the Agent, netdata will autodetect it

#### Limits

Calls to the following endpoints are disabled due to IPFS bugs:

/api/v0/stats/repo (https://github.com/ipfs/go-ipfs/issues/3874)
/api/v0/pin/ls (https://github.com/ipfs/go-ipfs/issues/7528)


#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per IPFS instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| ipfs.bandwidth | in, out | kilobits/s |
| ipfs.peers | peers | peers |
| ipfs.repo_size | avail, size | GiB |
| ipfs.repo_objects | objects, pinned, recursive_pins | objects |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ ipfs_datastore_usage ](https://github.com/netdata/netdata/blob/master/src/health/health.d/ipfs.conf) | ipfs.repo_size | IPFS datastore utilization |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `python.d/ipfs.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/ipfs.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details><summary></summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | The JOB's name as it will appear at the dashboard (by default is the job_name) | job_name | no |
| url | URL to the IPFS API | no | yes |
| repoapi | Collect repo metrics. | no | no |
| pinapi | Set status of IPFS pinned object polling. | no | no |

</details>

#### Examples

##### Basic (default out-of-the-box)

A basic example configuration, one job will run at a time. Autodetect mechanism uses it by default.

```yaml
localhost:
  name: 'local'
  url: 'http://localhost:5001'
  repoapi: no
  pinapi: no

```
##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details><summary>Config</summary>

```yaml
localhost:
  name: 'local'
  url: 'http://localhost:5001'
  repoapi: no
  pinapi: no

remote_host:
  name: 'remote'
  url: 'http://192.0.2.1:5001'
  repoapi: no
  pinapi: no

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `ipfs` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin ipfs debug trace
  ```


