<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/memcached/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/memcached/metadata.yaml"
sidebar_label: "Memcached"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Databases"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Memcached


<img src="https://netdata.cloud/img/memcached.svg" width="150"/>


Plugin: python.d.plugin
Module: memcached

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitor Memcached metrics for proficient in-memory key-value store operations. Track cache hits, misses, and memory usage for efficient data caching.

It reads server response to stats command ([stats interface](https://github.com/memcached/memcached/wiki/Commands#stats)).

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

If no configuration is given, collector will attempt to connect to memcached instance on `127.0.0.1:11211` address.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Memcached instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| memcached.cache | available, used | MiB |
| memcached.net | in, out | kilobits/s |
| memcached.connections | current, rejected, total | connections/s |
| memcached.items | current, total | items |
| memcached.evicted_reclaimed | reclaimed, evicted | items |
| memcached.get | hints, misses | requests |
| memcached.get_rate | rate | requests/s |
| memcached.set_rate | rate | requests/s |
| memcached.delete | hits, misses | requests |
| memcached.cas | hits, misses, bad value | requests |
| memcached.increment | hits, misses | requests |
| memcached.decrement | hits, misses | requests |
| memcached.touch | hits, misses | requests |
| memcached.touch_rate | rate | requests/s |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ memcached_cache_memory_usage ](https://github.com/netdata/netdata/blob/master/src/health/health.d/memcached.conf) | memcached.cache | cache memory utilization |
| [ memcached_cache_fill_rate ](https://github.com/netdata/netdata/blob/master/src/health/health.d/memcached.conf) | memcached.cache | average rate the cache fills up (positive), or frees up (negative) space over the last hour |
| [ memcached_out_of_cache_space_time ](https://github.com/netdata/netdata/blob/master/src/health/health.d/memcached.conf) | memcached.cache | estimated time the cache will run out of space if the system continues to add data at the same rate as the past hour |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `python.d/memcached.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/memcached.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| host | the host to connect to. | 127.0.0.1 | no |
| port | the port to connect to. | 11211 | no |
| update_every | Sets the default data collection frequency. | 10 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | no |

</details>

#### Examples

##### localhost

An example configuration for localhost.

```yaml
localhost:
  name: 'local'
  host: 'localhost'
  port: 11211

```
##### localipv4

An example configuration for localipv4.

<details><summary>Config</summary>

```yaml
localhost:
  name: 'local'
  host: '127.0.0.1'
  port: 11211

```
</details>

##### localipv6

An example configuration for localipv6.

<details><summary>Config</summary>

```yaml
localhost:
  name: 'local'
  host: '::1'
  port: 11211

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `memcached` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin memcached debug trace
  ```


