<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/monit/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/monit/metadata.yaml"
sidebar_label: "Monit"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Synthetic Checks"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Monit


<img src="https://netdata.cloud/img/monit.png" width="150"/>


Plugin: python.d.plugin
Module: monit

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Monit targets such as filesystems, directories, files, FIFO pipes and more.


It gathers data from Monit's XML interface.


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

By default, this collector will attempt to connect to Monit at `http://localhost:2812`

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Monit instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| monit.filesystems | a dimension per target | filesystems |
| monit.directories | a dimension per target | directories |
| monit.files | a dimension per target | files |
| monit.fifos | a dimension per target | pipes |
| monit.programs | a dimension per target | programs |
| monit.services | a dimension per target | processes |
| monit.process_uptime | a dimension per target | seconds |
| monit.process_threads | a dimension per target | threads |
| monit.process_childrens | a dimension per target | children |
| monit.hosts | a dimension per target | hosts |
| monit.host_latency | a dimension per target | milliseconds |
| monit.networks | a dimension per target | interfaces |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `python.d/monit.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/monit.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 1 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. | local | no |
| url | The URL to fetch Monit's metrics. | http://localhost:2812 | yes |
| user | Username in case the URL is password protected. |  | no |
| pass | Password in case the URL is password protected. |  | no |

</details>

#### Examples

##### Basic

A basic configuration example.

```yaml
localhost:
  name : 'local'
  url  : 'http://localhost:2812'

```
##### Basic Authentication

Example using basic username and password in order to authenticate.

<details><summary>Config</summary>

```yaml
localhost:
  name : 'local'
  url  : 'http://localhost:2812'
  user: 'foo'
  pass: 'bar'

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details><summary>Config</summary>

```yaml
localhost:
  name: 'local'
  url: 'http://localhost:2812'

remote_job:
  name: 'remote'
  url: 'http://192.0.2.1:2812'

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `monit` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin monit debug trace
  ```


