<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/puppet/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/puppet/metadata.yaml"
sidebar_label: "Puppet"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/CICD Platforms"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Puppet


<img src="https://netdata.cloud/img/puppet.svg" width="150"/>


Plugin: python.d.plugin
Module: puppet

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Puppet metrics about JVM Heap, Non-Heap, CPU usage and file descriptors.'


It uses Puppet's metrics API endpoint to gather the metrics.


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

By default, this collector will use `https://fqdn.example.com:8140` as the URL to look for metrics.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Puppet instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| puppet.jvm | committed, used | MiB |
| puppet.jvm | committed, used | MiB |
| puppet.cpu | execution, GC | percentage |
| puppet.fdopen | used | descriptors |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `python.d/puppet.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/puppet.conf
```
#### Options

This particular collector does not need further configuration to work if permissions are satisfied, but you can always customize it's data collection behavior.

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.

> Notes:
> - Exact Fully Qualified Domain Name of the node should be used.
> - Usually Puppet Server/DB startup time is VERY long. So, there should be quite reasonable retry count.
> - A secured PuppetDB config may require a client certificate. This does not apply to the default PuppetDB configuration though.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| url | HTTP or HTTPS URL, exact Fully Qualified Domain Name of the node should be used. | https://fqdn.example.com:8081 | yes |
| tls_verify | Control HTTPS server certificate verification. | False | no |
| tls_ca_file | Optional CA (bundle) file to use |  | no |
| tls_cert_file | Optional client certificate file |  | no |
| tls_key_file | Optional client key file |  | no |
| update_every | Sets the default data collection frequency. | 30 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | no |

</details>

#### Examples

##### Basic

A basic example configuration

```yaml
puppetserver:
  url: 'https://fqdn.example.com:8140'
  autodetection_retry: 1

```
##### TLS Certificate

An example using a TLS certificate

<details><summary>Config</summary>

```yaml
puppetdb:
  url: 'https://fqdn.example.com:8081'
  tls_cert_file: /path/to/client.crt
  tls_key_file: /path/to/client.key
  autodetection_retry: 1

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details><summary>Config</summary>

```yaml
puppetserver1:
  url: 'https://fqdn.example.com:8140'
  autodetection_retry: 1

puppetserver2:
  url: 'https://fqdn.example2.com:8140'
  autodetection_retry: 1

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `puppet` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin puppet debug trace
  ```


