<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/timex.plugin/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/timex.plugin/metadata.yaml"
sidebar_label: "Timex"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/System Clock and NTP"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Timex


<img src="https://netdata.cloud/img/syslog.png" width="150"/>


Plugin: timex.plugin
Module: timex.plugin

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Examine Timex metrics to gain insights into system clock operations. Study time sync status, clock drift, and adjustments to ensure accurate system timekeeping.

It uses system call adjtimex on Linux and ntp_adjtime on FreeBSD or Mac to monitor the system kernel clock synchronization state.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Timex instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.clock_sync_state | state | state |
| system.clock_status | unsync, clockerr | status |
| system.clock_sync_offset | offset | milliseconds |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ system_clock_sync_state ](https://github.com/netdata/netdata/blob/master/src/health/health.d/timex.conf) | system.clock_sync_state | when set to 0, the system kernel believes the system clock is not properly synchronized to a reliable server |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:timex]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options

At least one option ('clock synchronization state', 'time offset') needs to be enabled for this collector to run.

<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update every | Data collection frequency. | 1 | no |
| clock synchronization state | Make chart showing system clock synchronization state. | yes | yes |
| time offset | Make chart showing computed time offset between local system and reference clock | yes | yes |

</details>

#### Examples

##### Basic

A basic configuration example.

<details><summary>Config</summary>

```yaml
[plugin:timex]
  update every = 1
  clock synchronization state = yes
  time offset = yes

```
</details>


