<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/dnsquery/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/dnsquery/metadata.yaml"
sidebar_label: "DNS query"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/DNS and DHCP Servers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# DNS query


<img src="https://netdata.cloud/img/network-wired.svg" width="150"/>


Plugin: go.d.plugin
Module: dns_query

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This module monitors DNS query round-trip time (RTT).




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per server

These metrics refer to the DNS server.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| server | DNS server address. |
| network | Network protocol name (tcp, udp, tcp-tls). |
| record_type | DNS record type (e.g. A, AAAA, CNAME). |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| dns_query.query_status | success, network_error, dns_error | status |
| dns_query.query_time | query_time | seconds |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ dns_query_query_status ](https://github.com/netdata/netdata/blob/master/src/health/health.d/dns_query.conf) | dns_query.query_status | DNS request type ${label:record_type} to server ${label:server} is unsuccessful |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/dns_query.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/dns_query.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details><summary>All options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| domains | Domain or subdomains to query. The collector will choose a random domain from the list on every iteration. |  | yes |
| servers | Servers to query. |  | yes |
| port | DNS server port. | 53 | no |
| network | Network protocol name. Available options: udp, tcp, tcp-tls. | udp | no |
| record_types | Query record type. Available options: A, AAAA, CNAME, MX, NS, PTR, TXT, SOA, SPF, TXT, SRV. | A | no |
| timeout | Query read timeout. | 2 | no |

</details>

#### Examples

##### Basic

An example configuration.

<details><summary>Config</summary>

```yaml
jobs:
  - name: job1
    record_types:
      - A
      - AAAA
    domains:
      - google.com
      - github.com
      - reddit.com
    servers:
      - 8.8.8.8
      - 8.8.4.4

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `dns_query` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m dns_query
  ```


