<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/openvpn_status_log/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/openvpn_status_log/metadata.yaml"
sidebar_label: "OpenVPN status log"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/VPNs"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# OpenVPN status log


<img src="https://netdata.cloud/img/openvpn.svg" width="150"/>


Plugin: go.d.plugin
Module: openvpn_status_log

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors OpenVPN server.

It parses server log files and provides summary and per user metrics.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per OpenVPN status log instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| openvpn.active_clients | clients | clients |
| openvpn.total_traffic | in, out | kilobits/s |

### Per user

These metrics refer to the VPN user.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| username | VPN username |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| openvpn.user_traffic | in, out | kilobits/s |
| openvpn.user_connection_time | time | seconds |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/openvpn_status_log.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/openvpn_status_log.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| log_path | Path to status log. | /var/log/openvpn/status.log | yes |
| per_user_stats | User selector. Determines which user metrics will be collected. |  | no |

</details>

#### Examples

##### With user metrics

Collect metrics of all users.

<details><summary>Config</summary>

```yaml
jobs:
  - name: local
    per_user_stats:
      includes:
        - "* *"

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `openvpn_status_log` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m openvpn_status_log
  ```


