<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/prometheus/integrations/odbc.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/prometheus/metadata.yaml"
sidebar_label: "ODBC"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Databases"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# ODBC


<img src="https://netdata.cloud/img/odbc.svg" width="150"/>


Plugin: go.d.plugin
Module: prometheus

<img src="https://img.shields.io/badge/maintained%20by-Community-blue" />

## Overview

Keep tabs on Open Database Connectivity (ODBC) metrics for efficient database connection and performance.


Metrics are gathered by periodically sending HTTP requests to [ODBC Exporter](https://github.com/MACHBASE/prometheus-odbc-exporter).


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

By default, it detects instances running on the local host by trying to connect to known ports that are [allocated to exporters](https://github.com/prometheus/prometheus/wiki/Default-port-allocations).
The full list of endpoints is available in the collector's [configuration file](https://github.com/netdata/netdata/blob/master/src/go/collectors/go.d.plugin/config/go.d/prometheus.conf).


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

This collector has built-in grouping logic based on the [type of metrics](https://prometheus.io/docs/concepts/metric_types/).

| Metric                    | Chart                                     | Dimension(s)         | Algorithm   |
|---------------------------|-------------------------------------------|----------------------|-------------|
| Gauge                     | for each label set                        | one, the metric name | absolute    |
| Counter                   | for each label set                        | one, the metric name | incremental |
| Summary (quantiles)       | for each label set (excluding 'quantile') | for each quantile    | absolute    |
| Summary (sum and count)   | for each label set                        | the metric name      | incremental |
| Histogram (buckets)       | for each label set (excluding 'le')       | for each bucket      | incremental |
| Histogram (sum and count) | for each label set                        | the metric name      | incremental |

Untyped metrics (have no '# TYPE') processing:

- As Counter or Gauge depending on pattern match when 'fallback_type' is used.
- As Counter if it has suffix '_total'.
- As Summary if it has 'quantile' label.
- As Histogram if it has 'le' label.

**The rest are ignored**.



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Install Exporter

Install [ODBC Exporter](https://github.com/MACHBASE/prometheus-odbc-exporter) by following the instructions mentioned in the exporter README.



### Configuration

#### File

The configuration file name for this integration is `go.d/prometheus.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/prometheus.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 10 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| url | Server URL. |  | yes |
| selector | Time series selector (filter). |  | no |
| fallback_type | Time series selector (filter). |  | no |
| max_time_series | Global time series limit. If an endpoint returns number of time series > limit the data is not processed. | 2000 | no |
| max_time_series_per_metric | Time series per metric (metric name) limit. Metrics with number of time series > limit are skipped. | 200 | no |
| timeout | HTTP request timeout. | 10 | no |
| username | Username for basic HTTP authentication. |  | no |
| password | Password for basic HTTP authentication. |  | no |
| proxy_url | Proxy URL. |  | no |
| proxy_username | Username for proxy basic HTTP authentication. |  | no |
| proxy_password | Password for proxy basic HTTP authentication. |  | no |
| method | HTTP request method. | GET | no |
| body | HTTP request body. |  | no |
| headers | HTTP request headers. |  | no |
| not_follow_redirects | Redirect handling policy. Controls whether the client follows redirects. | no | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | no | no |
| tls_ca | Certification authority that the client uses when verifying the server's certificates. |  | no |
| tls_cert | Client TLS certificate. |  | no |
| tls_key | Client TLS key. |  | no |

##### selector

This option allows you to filter out unwanted time series. Only metrics matching the selector will be collected.

- Logic: (pattern1 OR pattern2) AND !(pattern3 or pattern4)
- Pattern syntax: [selector](https://github.com/netdata/netdata/blob/master/src/go/collectors/go.d.plugin/pkg/prometheus/selector/README.md).
- Option syntax:

```yaml
selector:
  allow:
    - pattern1
    - pattern2
  deny:
    - pattern3
    - pattern4
```


##### fallback_type

This option allows you to process Untyped metrics as Counter or Gauge instead of ignoring them.

- Metric name pattern syntax: [shell file name pattern](https://golang.org/pkg/path/filepath/#Match).
- Option syntax:

```yaml
fallback_type:
  counter:
    - metric_name_pattern1
    - metric_name_pattern2
  gauge:
    - metric_name_pattern3
    - metric_name_pattern4
```


</details>

#### Examples

##### Basic

> **Note**: Change the port of the monitored application on which it provides metrics.

A basic example configuration.


```yaml
jobs:
  - name: local
    url: http://127.0.0.1:9090/metrics

```
##### Read metrics from a file

An example configuration to read metrics from a file.

<details><summary>Config</summary>

```yaml
# use "file://" scheme
jobs:
  - name: myapp
    url: file:///opt/metrics/myapp/metrics.txt

```
</details>

##### HTTP authentication

> **Note**: Change the port of the monitored application on which it provides metrics.

Basic HTTP authentication.


<details><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:9090/metrics
    username: username
    password: password

```
</details>

##### HTTPS with self-signed certificate

> **Note**: Change the port of the monitored application on which it provides metrics.

Do not validate server certificate chain and hostname.


<details><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: https://127.0.0.1:9090/metrics
    tls_skip_verify: yes

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.
> **Note**: Change the port of the monitored application on which it provides metrics.

Collecting metrics from local and remote instances.


<details><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:9090/metrics

  - name: remote
    url: http://192.0.2.1:9090/metrics

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `prometheus` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m prometheus
  ```


