<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/rabbitmq/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/rabbitmq/metadata.yaml"
sidebar_label: "RabbitMQ"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Message Brokers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# RabbitMQ


<img src="https://netdata.cloud/img/rabbitmq.svg" width="150"/>


Plugin: go.d.plugin
Module: rabbitmq

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors RabbitMQ instances.

It collects data using an HTTP-based API provided by the [management plugin](https://www.rabbitmq.com/management.html).
The following endpoints are used:

- `/api/overview`
- `/api/node/{node_name}`
- `/api/vhosts`
- `/api/queues` (disabled by default)




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per RabbitMQ instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| rabbitmq.messages_count | ready, unacknowledged | messages |
| rabbitmq.messages_rate | ack, publish, publish_in, publish_out, confirm, deliver, deliver_no_ack, get, get_no_ack, deliver_get, redeliver, return_unroutable | messages/s |
| rabbitmq.objects_count | channels, consumers, connections, queues, exchanges | messages |
| rabbitmq.connection_churn_rate | created, closed | operations/s |
| rabbitmq.channel_churn_rate | created, closed | operations/s |
| rabbitmq.queue_churn_rate | created, deleted, declared | operations/s |
| rabbitmq.file_descriptors_count | available, used | fd |
| rabbitmq.sockets_count | available, used | sockets |
| rabbitmq.erlang_processes_count | available, used | processes |
| rabbitmq.erlang_run_queue_processes_count | length | processes |
| rabbitmq.memory_usage | used | bytes |
| rabbitmq.disk_space_free_size | free | bytes |

### Per vhost

These metrics refer to the virtual host.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| vhost | virtual host name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| rabbitmq.vhost_messages_count | ready, unacknowledged | messages |
| rabbitmq.vhost_messages_rate | ack, publish, publish_in, publish_out, confirm, deliver, deliver_no_ack, get, get_no_ack, deliver_get, redeliver, return_unroutable | messages/s |

### Per queue

These metrics refer to the virtual host queue.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| vhost | virtual host name |
| queue | queue name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| rabbitmq.queue_messages_count | ready, unacknowledged, paged_out, persistent | messages |
| rabbitmq.queue_messages_rate | ack, publish, publish_in, publish_out, confirm, deliver, deliver_no_ack, get, get_no_ack, deliver_get, redeliver, return_unroutable | messages/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Enable management plugin.

The management plugin is included in the RabbitMQ distribution, but disabled.
To enable see [Management Plugin](https://www.rabbitmq.com/management.html#getting-started) documentation.



### Configuration

#### File

The configuration file name for this integration is `go.d/rabbitmq.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/rabbitmq.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| url | Server URL. | http://localhost:15672 | yes |
| collect_queues_metrics | Collect stats per vhost per queues. Enabling this can introduce serious overhead on both Netdata and RabbitMQ if many queues are configured and used. | no | no |
| timeout | HTTP request timeout. | 1 | no |
| username | Username for basic HTTP authentication. |  | no |
| password | Password for basic HTTP authentication. |  | no |
| proxy_url | Proxy URL. |  | no |
| proxy_username | Username for proxy basic HTTP authentication. |  | no |
| proxy_password | Password for proxy basic HTTP authentication. |  | no |
| method | HTTP request method. | GET | no |
| body | HTTP request body. |  | no |
| headers | HTTP request headers. |  | no |
| not_follow_redirects | Redirect handling policy. Controls whether the client follows redirects. | no | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | no | no |
| tls_ca | Certification authority that the client uses when verifying the server's certificates. |  | no |
| tls_cert | Client TLS certificate. |  | no |
| tls_key | Client TLS key. |  | no |

</details>

#### Examples

##### Basic

An example configuration.

<details><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:15672

```
</details>

##### Basic HTTP auth

Local server with basic HTTP authentication.

<details><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:15672
    username: admin
    password: password

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Local and remote instances.


<details><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:15672

  - name: remote
    url: http://192.0.2.0:15672

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `rabbitmq` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m rabbitmq
  ```


