<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/vernemq/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/vernemq/metadata.yaml"
sidebar_label: "VerneMQ"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Message Brokers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# VerneMQ


<img src="https://netdata.cloud/img/vernemq.svg" width="150"/>


Plugin: go.d.plugin
Module: vernemq

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors VerneMQ instances.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per VerneMQ instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| vernemq.sockets | open | sockets |
| vernemq.socket_operations | open, close | sockets/s |
| vernemq.client_keepalive_expired | closed | sockets/s |
| vernemq.socket_close_timeout | closed | sockets/s |
| vernemq.socket_errors | errors | errors/s |
| vernemq.queue_processes | queue_processes | queue processes |
| vernemq.queue_processes_operations | setup, teardown | events/s |
| vernemq.queue_process_init_from_storage | queue_processes | queue processes/s |
| vernemq.queue_messages | received, sent | messages/s |
| vernemq.queue_undelivered_messages | dropped, expired, unhandled | messages/s |
| vernemq.router_subscriptions | subscriptions | subscriptions |
| vernemq.router_matched_subscriptions | local, remote | subscriptions/s |
| vernemq.router_memory | used | KiB |
| vernemq.average_scheduler_utilization | utilization | percentage |
| vernemq.system_utilization_scheduler | a dimension per scheduler | percentage |
| vernemq.system_processes | processes | processes |
| vernemq.system_reductions | reductions | ops/s |
| vernemq.system_context_switches | context_switches | ops/s |
| vernemq.system_io | received, sent | kilobits/s |
| vernemq.system_run_queue | ready | processes |
| vernemq.system_gc_count | gc | ops/s |
| vernemq.system_gc_words_reclaimed | words_reclaimed | ops/s |
| vernemq.system_allocated_memory | processes, system | KiB |
| vernemq.bandwidth | received, sent | kilobits/s |
| vernemq.retain_messages | messages | messages |
| vernemq.retain_memory | used | KiB |
| vernemq.cluster_bandwidth | received, sent | kilobits/s |
| vernemq.cluster_dropped | dropped | kilobits/s |
| vernemq.netsplit_unresolved | unresolved | netsplits |
| vernemq.netsplits | resolved, detected | netsplits/s |
| vernemq.mqtt_auth | received, sent | packets/s |
| vernemq.mqtt_auth_received_reason | a dimensions per reason | packets/s |
| vernemq.mqtt_auth_sent_reason | a dimensions per reason | packets/s |
| vernemq.mqtt_connect | connect, connack | packets/s |
| vernemq.mqtt_connack_sent_reason | a dimensions per reason | packets/s |
| vernemq.mqtt_disconnect | received, sent | packets/s |
| vernemq.mqtt_disconnect_received_reason | a dimensions per reason | packets/s |
| vernemq.mqtt_disconnect_sent_reason | a dimensions per reason | packets/s |
| vernemq.mqtt_subscribe | subscribe, suback | packets/s |
| vernemq.mqtt_subscribe_error | failed | ops/s |
| vernemq.mqtt_subscribe_auth_error | unauth | attempts/s |
| vernemq.mqtt_unsubscribe | unsubscribe, unsuback | packets/s |
| vernemq.mqtt_unsubscribe | mqtt_unsubscribe_error | ops/s |
| vernemq.mqtt_publish | received, sent | packets/s |
| vernemq.mqtt_publish_errors | failed | ops/s |
| vernemq.mqtt_publish_auth_errors | unauth | attempts/s |
| vernemq.mqtt_puback | received, sent | packets/s |
| vernemq.mqtt_puback_received_reason | a dimensions per reason | packets/s |
| vernemq.mqtt_puback_sent_reason | a dimensions per reason | packets/s |
| vernemq.mqtt_puback_invalid_error | unexpected | messages/s |
| vernemq.mqtt_pubrec | received, sent | packets/s |
| vernemq.mqtt_pubrec_received_reason | a dimensions per reason | packets/s |
| vernemq.mqtt_pubrec_sent_reason | a dimensions per reason | packets/s |
| vernemq.mqtt_pubrec_invalid_error | unexpected | messages/s |
| vernemq.mqtt_pubrel | received, sent | packets/s |
| vernemq.mqtt_pubrel_received_reason | a dimensions per reason | packets/s |
| vernemq.mqtt_pubrel_sent_reason | a dimensions per reason | packets/s |
| vernemq.mqtt_pubcom | received, sent | packets/s |
| vernemq.mqtt_pubcomp_received_reason | a dimensions per reason | packets/s |
| vernemq.mqtt_pubcomp_sent_reason | a dimensions per reason | packets/s |
| vernemq.mqtt_pubcomp_invalid_error | unexpected | messages/s |
| vernemq.mqtt_ping | pingreq, pingresp | packets/s |
| vernemq.node_uptime | time | seconds |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ vernemq_socket_errors ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.socket_errors | number of socket errors in the last minute |
| [ vernemq_queue_message_drop ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.queue_undelivered_messages | number of dropped messaged due to full queues in the last minute |
| [ vernemq_queue_message_expired ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.queue_undelivered_messages | number of messages which expired before delivery in the last minute |
| [ vernemq_queue_message_unhandled ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.queue_undelivered_messages | number of unhandled messages (connections with clean session=true) in the last minute |
| [ vernemq_average_scheduler_utilization ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.average_scheduler_utilization | average scheduler utilization over the last 10 minutes |
| [ vernemq_cluster_dropped ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.cluster_dropped | amount of traffic dropped during communication with the cluster nodes in the last minute |
| [ vernemq_netsplits ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vvernemq.netsplits | number of detected netsplits (split brain situation) in the last minute |
| [ vernemq_mqtt_connack_sent_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_connack_sent_reason | number of sent unsuccessful v3/v5 CONNACK packets in the last minute |
| [ vernemq_mqtt_disconnect_received_reason_not_normal ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_disconnect_received_reason | number of received not normal v5 DISCONNECT packets in the last minute |
| [ vernemq_mqtt_disconnect_sent_reason_not_normal ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_disconnect_sent_reason | number of sent not normal v5 DISCONNECT packets in the last minute |
| [ vernemq_mqtt_subscribe_error ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_subscribe_error | number of failed v3/v5 SUBSCRIBE operations in the last minute |
| [ vernemq_mqtt_subscribe_auth_error ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_subscribe_auth_error | number of unauthorized v3/v5 SUBSCRIBE attempts in the last minute |
| [ vernemq_mqtt_unsubscribe_error ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_unsubscribe_error | number of failed v3/v5 UNSUBSCRIBE operations in the last minute |
| [ vernemq_mqtt_publish_errors ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_publish_errors | number of failed v3/v5 PUBLISH operations in the last minute |
| [ vernemq_mqtt_publish_auth_errors ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_publish_auth_errors | number of unauthorized v3/v5 PUBLISH attempts in the last minute |
| [ vernemq_mqtt_puback_received_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_puback_received_reason | number of received unsuccessful v5 PUBACK packets in the last minute |
| [ vernemq_mqtt_puback_sent_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_puback_sent_reason | number of sent unsuccessful v5 PUBACK packets in the last minute |
| [ vernemq_mqtt_puback_unexpected ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_puback_invalid_error | number of received unexpected v3/v5 PUBACK packets in the last minute |
| [ vernemq_mqtt_pubrec_received_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_pubrec_received_reason | number of received unsuccessful v5 PUBREC packets in the last minute |
| [ vernemq_mqtt_pubrec_sent_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_pubrec_sent_reason | number of sent unsuccessful v5 PUBREC packets in the last minute |
| [ vernemq_mqtt_pubrec_invalid_error ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_pubrec_invalid_error | number of received unexpected v3 PUBREC packets in the last minute |
| [ vernemq_mqtt_pubrel_received_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_pubrel_received_reason | number of received unsuccessful v5 PUBREL packets in the last minute |
| [ vernemq_mqtt_pubrel_sent_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_pubrel_sent_reason | number of sent unsuccessful v5 PUBREL packets in the last minute |
| [ vernemq_mqtt_pubcomp_received_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_pubcomp_received_reason | number of received unsuccessful v5 PUBCOMP packets in the last minute |
| [ vernemq_mqtt_pubcomp_sent_reason_unsuccessful ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_pubcomp_sent_reason | number of sent unsuccessful v5 PUBCOMP packets in the last minute |
| [ vernemq_mqtt_pubcomp_unexpected ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vernemq.conf) | vernemq.mqtt_pubcomp_invalid_error | number of received unexpected v3/v5 PUBCOMP packets in the last minute |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/vernemq.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/vernemq.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| url | Server URL. | http://127.0.0.1:8888/metrics | yes |
| timeout | HTTP request timeout. | 1 | no |
| username | Username for basic HTTP authentication. |  | no |
| password | Password for basic HTTP authentication. |  | no |
| proxy_url | Proxy URL. |  | no |
| proxy_username | Username for proxy basic HTTP authentication. |  | no |
| proxy_password | Password for proxy basic HTTP authentication. |  | no |
| method | HTTP request method. | GET | no |
| body | HTTP request body. |  | no |
| headers | HTTP request headers. |  | no |
| not_follow_redirects | Redirect handling policy. Controls whether the client follows redirects. | no | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | no | no |
| tls_ca | Certification authority that the client uses when verifying the server's certificates. |  | no |
| tls_cert | Client TLS certificate. |  | no |
| tls_key | Client TLS key. |  | no |

</details>

#### Examples

##### Basic

An example configuration.

<details><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8888/metrics

```
</details>

##### HTTP authentication

Local instance with basic HTTP authentication.

<details><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8888/metrics
    username: username
    password: password

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Local and remote instances.


<details><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8888/metrics

  - name: remote
    url: http://203.0.113.10:8888/metrics

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `vernemq` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m vernemq
  ```


