<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/windows/integrations/windows.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/windows/metadata.yaml"
sidebar_label: "Windows"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Windows Systems"
most_popular: True
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Windows


<img src="https://netdata.cloud/img/windows.svg" width="150"/>


Plugin: go.d.plugin
Module: windows

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors the performance of Windows machines, collects both host metrics and metrics from various Windows applications (e.g. Active Directory, MSSQL).


It collect metrics by periodically sending HTTP requests to [Prometheus exporter for Windows machines](https://github.com/prometheus-community/windows_exporter), a native Windows agent running on each host.


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

It detects Windows exporter instances running on localhost (requires using [Netdata MSI installer](https://github.com/netdata/msi-installer#instructions)).

Using the Netdata MSI installer is recommended for testing purposes only. For production use, you need to install Netdata on a Linux host and configure it to collect metrics remotely.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

Data collection affects the CPU usage of the Windows host. CPU usage depends on the frequency of data collection and the [enabled collectors](https://github.com/prometheus-community/windows_exporter#collectors).



## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.

The collected set of metrics depends on the [enabled collectors](https://github.com/prometheus-community/windows_exporter#collectors).

Supported collectors:

- [cpu](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.cpu.md)
- [iis](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.iis.md)
- [memory](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.memory.md)
- [net](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.net.md)
- [logical_disk](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.logical_disk.md)
- [os](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.os.md)
- [system](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.system.md)
- [logon](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.logon.md)
- [tcp](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.tcp.md)
- [thermalzone](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.thermalzone.md)
- [process](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.process.md)
- [service](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.service.md)
- [mssql](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.mssql.md)
- [ad](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.ad.md)
- [adcs](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.adcs.md)
- [adfs](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.adfs.md)
- [netframework_clrexceptions](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.netframework_clrexceptions.md)
- [netframework_clrinterop](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.netframework_clrinterop.md)
- [netframework_clrjit](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.netframework_clrjit.md)
- [netframework_clrloading](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.netframework_clrloading.md)
- [netframework_clrlocksandthreads](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.netframework_clrlocksandthreads.md)
- [netframework_clrmemory](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.netframework_clrmemory.md)
- [netframework_clrremoting](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.netframework_clrremoting.md)
- [exchange](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.exchange.md)
- [hyperv](https://github.com/prometheus-community/windows_exporter/blob/master/docs/collector.hyperv.md)


### Per Active Directory instance

These metrics refer to the entire monitored host.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| windows.cpu_utilization_total | dpc, user, privileged, interrupt | percentage |
| windows.memory_utilization | available, used | bytes |
| windows.memory_page_faults | page_faults | events/s |
| windows.memory_swap_utilization | available, used | bytes |
| windows.memory_swap_operations | read, write | operations/s |
| windows.memory_swap_pages | read, written | pages/s |
| windows.memory_cached | cached | KiB |
| windows.memory_cache_faults | cache_faults | events/s |
| windows.memory_system_pool | paged, non-paged | bytes |
| windows.tcp_conns_established | ipv4, ipv6 | connections |
| windows.tcp_conns_active | ipv4, ipv6 | connections/s |
| windows.tcp_conns_passive | ipv4, ipv6 | connections/s |
| windows.tcp_conns_failures | ipv4, ipv6 | failures/s |
| windows.tcp_conns_resets | ipv4, ipv6 | resets/s |
| windows.tcp_segments_received | ipv4, ipv6 | segments/s |
| windows.tcp_segments_sent | ipv4, ipv6 | segments/s |
| windows.tcp_segments_retransmitted | ipv4, ipv6 | segments/s |
| windows.os_processes | processes | number |
| windows.os_users | users | users |
| windows.os_visible_memory_usage | free, used | bytes |
| windows.os_paging_files_usage | free, used | bytes |
| windows.system_threads | threads | number |
| windows.system_uptime | time | seconds |
| windows.logon_type_sessions | system, interactive, network, batch, service, proxy, unlock, network_clear_text, new_credentials, remote_interactive, cached_interactive, cached_remote_interactive, cached_unlock | seconds |
| windows.processes_cpu_utilization | a dimension per process | percentage |
| windows.processes_handles | a dimension per process | handles |
| windows.processes_io_bytes | a dimension per process | bytes/s |
| windows.processes_io_operations | a dimension per process | operations/s |
| windows.processes_page_faults | a dimension per process | pgfaults/s |
| windows.processes_page_file_bytes | a dimension per process | bytes |
| windows.processes_pool_bytes | a dimension per process | bytes |
| windows.processes_threads | a dimension per process | threads |
| ad.database_operations | add, delete, modify, recycle | operations/s |
| ad.directory_operations | read, write, search | operations/s |
| ad.name_cache_lookups | lookups | lookups/s |
| ad.name_cache_hits | hits | hits/s |
| ad.atq_average_request_latency | time | seconds |
| ad.atq_outstanding_requests | outstanding | requests |
| ad.dra_replication_intersite_compressed_traffic | inbound, outbound | bytes/s |
| ad.dra_replication_intrasite_compressed_traffic | inbound, outbound | bytes/s |
| ad.dra_replication_sync_objects_remaining | inbound, outbound | objects |
| ad.dra_replication_objects_filtered | inbound, outbound | objects/s |
| ad.dra_replication_properties_updated | inbound, outbound | properties/s |
| ad.dra_replication_properties_filtered | inbound, outbound | properties/s |
| ad.dra_replication_pending_syncs | pending | syncs |
| ad.dra_replication_sync_requests | requests | requests/s |
| ad.ds_threads | in_use | threads |
| ad.ldap_last_bind_time | last_bind | seconds |
| ad.binds | binds | binds/s |
| ad.ldap_searches | searches | searches/s |
| adfs.ad_login_connection_failures | connection | failures/s |
| adfs.certificate_authentications | authentications | authentications/s |
| adfs.db_artifact_failures | connection | failures/s |
| adfs.db_artifact_query_time_seconds | query_time | seconds/s |
| adfs.db_config_failures | connection | failures/s |
| adfs.db_config_query_time_seconds | query_time | seconds/s |
| adfs.device_authentications | authentications | authentications/s |
| adfs.external_authentications | success, failure | authentications/s |
| adfs.federated_authentications | authentications | authentications/s |
| adfs.federation_metadata_requests | requests | requests/s |
| adfs.oauth_authorization_requests | requests | requests/s |
| adfs.oauth_client_authentications | success, failure | authentications/s |
| adfs.oauth_client_credentials_requests | success, failure | requests/s |
| adfs.oauth_client_privkey_jwt_authentications | success, failure | authentications/s |
| adfs.oauth_client_secret_basic_authentications | success, failure | authentications/s |
| adfs.oauth_client_secret_post_authentications | success, failure | authentications/s |
| adfs.oauth_client_windows_authentications | success, failure | authentications/s |
| adfs.oauth_logon_certificate_requests | success, failure | requests/s |
| adfs.oauth_password_grant_requests | success, failure | requests/s |
| adfs.oauth_token_requests_success | success | requests/s |
| adfs.passive_requests | passive | requests/s |
| adfs.passport_authentications | passport | authentications/s |
| adfs.password_change_requests | success, failure | requests/s |
| adfs.samlp_token_requests_success | success | requests/s |
| adfs.sso_authentications | success, failure | authentications/s |
| adfs.token_requests | requests | requests/s |
| adfs.userpassword_authentications | success, failure | authentications/s |
| adfs.windows_integrated_authentications | authentications | authentications/s |
| adfs.wsfed_token_requests_success | success | requests/s |
| adfs.wstrust_token_requests_success | success | requests/s |
| exchange.activesync_ping_cmds_pending | pending | commands |
| exchange.activesync_requests | received | requests/s |
| exchange.activesync_sync_cmds | processed | commands/s |
| exchange.autodiscover_requests | processed | requests/s |
| exchange.avail_service_requests | serviced | requests/s |
| exchange.owa_current_unique_users | logged-in | users |
| exchange.owa_requests_total | handled | requests/s |
| exchange.rpc_active_user_count | active | users |
| exchange.rpc_avg_latency | latency | seconds |
| exchange.rpc_connection_count | connections | connections |
| exchange.rpc_operations | operations | operations/s |
| exchange.rpc_requests | processed | requests |
| exchange.rpc_user_count | users | users |
| exchange.transport_queues_active_mail_box_delivery | low, high, none, normal | messages/s |
| exchange.transport_queues_external_active_remote_delivery | low, high, none, normal | messages/s |
| exchange.transport_queues_external_largest_delivery | low, high, none, normal | messages/s |
| exchange.transport_queues_internal_active_remote_delivery | low, high, none, normal | messages/s |
| exchange.transport_queues_internal_largest_delivery | low, high, none, normal | messages/s |
| exchange.transport_queues_retry_mailbox_delivery | low, high, none, normal | messages/s |
| exchange.transport_queues_poison | low, high, none, normal | messages/s |
| hyperv.vms_health | ok, critical | vms |
| hyperv.root_partition_device_space_pages | 4K, 2M, 1G | pages |
| hyperv.root_partition_gpa_space_pages | 4K, 2M, 1G | pages |
| hyperv.root_partition_gpa_space_modifications | gpa | modifications/s |
| hyperv.root_partition_attached_devices | attached | devices |
| hyperv.root_partition_deposited_pages | deposited | pages |
| hyperv.root_partition_skipped_interrupts | skipped | interrupts |
| hyperv.root_partition_device_dma_errors | illegal_dma | requests |
| hyperv.root_partition_device_interrupt_errors | illegal_interrupt | requests |
| hyperv.root_partition_device_interrupt_throttle_events | throttling | events |
| hyperv.root_partition_io_tlb_flush | flushes | flushes/s |
| hyperv.root_partition_address_space | address_spaces | address spaces |
| hyperv.root_partition_virtual_tlb_flush_entries | flushes | flushes/s |
| hyperv.root_partition_virtual_tlb_pages | used | pages |

### Per cpu core

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| core | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| windows.cpu_core_utilization | dpc, user, privileged, interrupt | percentage |
| windows.cpu_core_interrupts | interrupts | interrupts/s |
| windows.cpu_core_dpcs | dpcs | dpcs/s |
| windows.cpu_core_cstate | c1, c2, c3 | percentage |

### Per logical disk

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| disk | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| windows.logical_disk_utilization | free, used | bytes |
| windows.logical_disk_bandwidth | read, write | bytes/s |
| windows.logical_disk_operations | reads, writes | operations/s |
| windows.logical_disk_latency | read, write | seconds |

### Per network device

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| nic | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| windows.net_nic_bandwidth | received, sent | kilobits/s |
| windows.net_nic_packets | received, sent | packets/s |
| windows.net_nic_errors | inbound, outbound | errors/s |
| windows.net_nic_discarded | inbound, outbound | discards/s |

### Per thermalzone

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| thermalzone | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| windows.thermalzone_temperature | temperature | celsius |

### Per service

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| service | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| windows.service_state | running, stopped, start_pending, stop_pending, continue_pending, pause_pending, paused, unknown | state |
| windows.service_status | ok, error, unknown, degraded, pred_fail, starting, stopping, service, stressed, nonrecover, no_contact, lost_comm | status |

### Per website

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| website | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| iis.website_traffic | received, sent | bytes/s |
| iis.website_requests_rate | requests | requests/s |
| iis.website_active_connections_count | active | connections |
| iis.website_users_count | anonymous, non_anonymous | users |
| iis.website_connection_attempts_rate | connection | attempts/s |
| iis.website_isapi_extension_requests_count | isapi | requests |
| iis.website_isapi_extension_requests_rate | isapi | requests/s |
| iis.website_ftp_file_transfer_rate | received, sent | files/s |
| iis.website_logon_attempts_rate | logon | attempts/s |
| iis.website_errors_rate | document_locked, document_not_found | errors/s |
| iis.website_uptime | document_locked, document_not_found | seconds |

### Per mssql instance

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| mssql_instance | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| mssql.instance_accessmethods_page_splits | page | splits/s |
| mssql.instance_cache_hit_ratio | hit_ratio | percentage |
| mssql.instance_bufman_checkpoint_pages | flushed | pages/s |
| mssql.instance_bufman_page_life_expectancy | life_expectancy | seconds |
| mssql.instance_bufman_iops | read, written | iops |
| mssql.instance_blocked_processes | blocked | processes |
| mssql.instance_user_connection | user | connections |
| mssql.instance_locks_lock_wait | alloc_unit, application, database, extent, file, hobt, key, metadata, oib, object, page, rid, row_group, xact | locks/s |
| mssql.instance_locks_deadlocks | alloc_unit, application, database, extent, file, hobt, key, metadata, oib, object, page, rid, row_group, xact | locks/s |
| mssql.instance_memmgr_connection_memory_bytes | memory | bytes |
| mssql.instance_memmgr_external_benefit_of_memory | benefit | bytes |
| mssql.instance_memmgr_pending_memory_grants | pending | processes |
| mssql.instance_memmgr_server_memory | memory | bytes |
| mssql.instance_sql_errors | db_offline, info, kill_connection, user | errors |
| mssql.instance_sqlstats_auto_parameterization_attempts | failed | attempts/s |
| mssql.instance_sqlstats_batch_requests | batch | requests/s |
| mssql.instance_sqlstats_safe_auto_parameterization_attempts | safe | attempts/s |
| mssql.instance_sqlstats_sql_compilations | compilations | compilations/s |
| mssql.instance_sqlstats_sql_recompilations | recompiles | recompiles/s |

### Per database

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| mssql_instance | TBD |
| database | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| mssql.database_active_transactions | active | transactions |
| mssql.database_backup_restore_operations | backup | operations/s |
| mssql.database_data_files_size | size | bytes |
| mssql.database_log_flushed | flushed | bytes/s |
| mssql.database_log_flushes | log | flushes/s |
| mssql.database_transactions | transactions | transactions/s |
| mssql.database_write_transactions | write | transactions/s |

### Per certificate template

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| cert_template | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| adcs.cert_template_requests | requests | requests/s |
| adcs.cert_template_failed_requests | failed | requests/s |
| adcs.cert_template_issued_requests | issued | requests/s |
| adcs.cert_template_pending_requests | pending | requests/s |
| adcs.cert_template_request_processing_time | processing_time | seconds |
| adcs.cert_template_retrievals | retrievals | retrievals/s |
| adcs.cert_template_retrieval_processing_time | processing_time | seconds |
| adcs.cert_template_request_cryptographic_signing_time | singing_time | seconds |
| adcs.cert_template_request_policy_module_processing | processing_time | seconds |
| adcs.cert_template_challenge_responses | challenge | responses/s |
| adcs.cert_template_challenge_response_processing_time | processing_time | seconds |
| adcs.cert_template_signed_certificate_timestamp_lists | processed | lists/s |
| adcs.cert_template_signed_certificate_timestamp_list_processing_time | processing_time | seconds |

### Per process

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| process | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| netframework.clrexception_thrown | exceptions | exceptions/s |
| netframework.clrexception_filters | filters | filters/s |
| netframework.clrexception_finallys | finallys | finallys/s |
| netframework.clrexception_throw_to_catch_depth | traversed | stack_frames/s |
| netframework.clrinterop_com_callable_wrappers | com_callable_wrappers | ccw/s |
| netframework.clrinterop_interop_marshallings | marshallings | marshallings/s |
| netframework.clrinterop_interop_stubs_created | created | stubs/s |
| netframework.clrjit_methods | jit-compiled | methods/s |
| netframework.clrjit_time | time | percentage |
| netframework.clrjit_standard_failures | failures | failures/s |
| netframework.clrjit_il_bytes | compiled_msil | bytes/s |
| netframework.clrloading_loader_heap_size | committed | bytes |
| netframework.clrloading_appdomains_loaded | loaded | domain/s |
| netframework.clrloading_appdomains_unloaded | unloaded | domain/s |
| netframework.clrloading_assemblies_loaded | loaded | assemblies/s |
| netframework.clrloading_classes_loaded | loaded | classes/s |
| netframework.clrloading_class_load_failures | class_load | failures/s |
| netframework.clrlocksandthreads_queue_length | threads | threads/s |
| netframework.clrlocksandthreads_current_logical_threads | logical | threads |
| netframework.clrlocksandthreads_current_physical_threads | physical | threads |
| netframework.clrlocksandthreads_recognized_threads | threads | threads/s |
| netframework.clrlocksandthreads_contentions | contentions | contentions/s |
| netframework.clrmemory_allocated_bytes | allocated | bytes/s |
| netframework.clrmemory_finalization_survivors | survived | objects |
| netframework.clrmemory_heap_size | heap | bytes |
| netframework.clrmemory_promoted | promoted | bytes |
| netframework.clrmemory_number_gc_handles | used | handles |
| netframework.clrmemory_collections | gc | gc/s |
| netframework.clrmemory_induced_gc | gc | gc/s |
| netframework.clrmemory_number_pinned_objects | pinned | objects |
| netframework.clrmemory_number_sink_blocks_in_use | used | blocks |
| netframework.clrmemory_committed | committed | bytes |
| netframework.clrmemory_reserved | reserved | bytes |
| netframework.clrmemory_gc_time | time | percentage |
| netframework.clrremoting_channels | registered | channels/s |
| netframework.clrremoting_context_bound_classes_loaded | loaded | classes |
| netframework.clrremoting_context_bound_objects | allocated | objects/s |
| netframework.clrremoting_context_proxies | objects | objects/s |
| netframework.clrremoting_contexts | contexts | contexts |
| netframework.clrremoting_remote_calls | rpc | calls/s |
| netframework.clrsecurity_link_time_checks | linktime | checks/s |
| netframework.clrsecurity_checks_time | time | percentage |
| netframework.clrsecurity_stack_walk_depth | stack | depth |
| netframework.clrsecurity_runtime_checks | runtime | checks/s |

### Per exchange workload

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| workload | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| exchange.workload_active_tasks | active | tasks |
| exchange.workload_completed_tasks | completed | tasks/s |
| exchange.workload_queued_tasks | queued | tasks/s |
| exchange.workload_yielded_tasks | yielded | tasks/s |
| exchange.workload_activity_status | active, paused | status |

### Per ldap process

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| workload | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| exchange.ldap_long_running_ops_per_sec | long-running | operations/s |
| exchange.ldap_read_time | read | seconds |
| exchange.ldap_search_time | search | seconds |
| exchange.ldap_write_time | write | seconds |
| exchange.ldap_timeout_errors | timeout | errors/s |

### Per http proxy

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| workload | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| exchange.http_proxy_avg_auth_latency | latency | seconds |
| exchange.http_proxy_avg_cas_processing_latency_sec | latency | seconds |
| exchange.http_proxy_mailbox_proxy_failure_rate | failures | percentage |
| exchange.http_proxy_mailbox_server_locator_avg_latency_sec | latency | seconds |
| exchange.http_proxy_outstanding_proxy_requests | outstanding | requests |
| exchange.http_proxy_requests | processed | requests/s |

### Per vm

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| vm_name | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| hyperv.vm_cpu_usage | gues, hypervisor, remote | percentage |
| hyperv.vm_memory_physical | assigned_memory | MiB |
| hyperv.vm_memory_physical_guest_visible | visible_memory | MiB |
| hyperv.vm_memory_pressure_current | pressure | percentage |
| hyperv.vm_vid_physical_pages_allocated | allocated | pages |
| hyperv.vm_vid_remote_physical_pages | remote_physical | pages |

### Per vm device

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| vm_device | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| hyperv.vm_device_bytes | read, written | bytes/s |
| hyperv.vm_device_operations | read, write | operations/s |
| hyperv.vm_device_errors | errors | errors/s |

### Per vm interface

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| vm_interface | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| hyperv.vm_interface_bytes | received, sent | bytes/s |
| hyperv.vm_interface_packets | received, sent | packets/s |
| hyperv.vm_interface_packets_dropped | incoming, outgoing | drops/s |

### Per vswitch

TBD

Labels:

| Label      | Description     |
|:-----------|:----------------|
| vswitch | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| hyperv.vswitch_bytes | received, sent | bytes/s |
| hyperv.vswitch_packets | received, sent | packets/s |
| hyperv.vswitch_directed_packets | received, sent | packets/s |
| hyperv.vswitch_broadcast_packets | received, sent | packets/s |
| hyperv.vswitch_multicast_packets | received, sent | packets/s |
| hyperv.vswitch_dropped_packets | incoming, outgoing | drops/s |
| hyperv.vswitch_extensions_dropped_packets | incoming, outgoing | drops/s |
| hyperv.vswitch_packets_flooded | flooded | packets/s |
| hyperv.vswitch_learned_mac_addresses | learned | mac addresses/s |
| hyperv.vswitch_purged_mac_addresses | purged | mac addresses/s |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ windows_10min_cpu_usage ](https://github.com/netdata/netdata/blob/master/src/health/health.d/windows.conf) | windows.cpu_utilization_total | average CPU utilization over the last 10 minutes |
| [ windows_ram_in_use ](https://github.com/netdata/netdata/blob/master/src/health/health.d/windows.conf) | windows.memory_utilization | memory utilization |
| [ windows_inbound_packets_discarded ](https://github.com/netdata/netdata/blob/master/src/health/health.d/windows.conf) | windows.net_nic_discarded | number of inbound discarded packets for the network interface in the last 10 minutes |
| [ windows_outbound_packets_discarded ](https://github.com/netdata/netdata/blob/master/src/health/health.d/windows.conf) | windows.net_nic_discarded | number of outbound discarded packets for the network interface in the last 10 minutes |
| [ windows_inbound_packets_errors ](https://github.com/netdata/netdata/blob/master/src/health/health.d/windows.conf) | windows.net_nic_errors | number of inbound errors for the network interface in the last 10 minutes |
| [ windows_outbound_packets_errors ](https://github.com/netdata/netdata/blob/master/src/health/health.d/windows.conf) | windows.net_nic_errors | number of outbound errors for the network interface in the last 10 minutes |
| [ windows_disk_in_use ](https://github.com/netdata/netdata/blob/master/src/health/health.d/windows.conf) | windows.logical_disk_space_usage | disk space utilization |


## Setup

### Prerequisites

#### Install Windows exporter

To install the Windows exporter, follow the [official installation guide](https://github.com/prometheus-community/windows_exporter#installation).



### Configuration

#### File

The configuration file name for this integration is `go.d/windows.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/windows.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| url | Server URL. |  | yes |
| timeout | HTTP request timeout. | 1 | no |
| username | Username for basic HTTP authentication. |  | no |
| password | Password for basic HTTP authentication. |  | no |
| proxy_url | Proxy URL. |  | no |
| proxy_username | Username for proxy basic HTTP authentication. |  | no |
| proxy_password | Password for proxy basic HTTP authentication. |  | no |
| method | HTTP request method. | GET | no |
| body | HTTP request body. |  | no |
| headers | HTTP request headers. |  | no |
| not_follow_redirects | Redirect handling policy. Controls whether the client follows redirects. | no | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | no | no |
| tls_ca | Certification authority that the client uses when verifying the server's certificates. |  | no |
| tls_cert | Client TLS certificate. |  | no |
| tls_key | Client TLS key. |  | no |

</details>

#### Examples

##### Basic

A basic example configuration.

```yaml
jobs:
  - name: win_server
    url: http://192.0.2.1:9182/metrics

```
##### HTTP authentication

Basic HTTP authentication.

<details><summary>Config</summary>

```yaml
jobs:
  - name: win_server
    url: http://192.0.2.1:9182/metrics
    username: username
    password: password

```
</details>

##### HTTPS with self-signed certificate

Do not validate server certificate chain and hostname.

<details><summary>Config</summary>

```yaml
jobs:
  - name: win_server
    url: https://192.0.2.1:9182/metrics
    tls_skip_verify: yes

```
</details>

##### Virtual Node

The Virtual Node functionality allows you to define nodes in configuration files and treat them as ordinary nodes in all interfaces, panels, tabs, filters, etc.
You can create a virtual node for all your Windows machines and control them as separate entities.

To make your Windows server a virtual node, you need to define virtual nodes in `/etc/netdata/vnodes/vnodes.conf`:

> **Note**: To create a valid guid, you can use the `uuidgen` command on Linux, or the `[guid]::NewGuid()` command in PowerShell on Windows.

```yaml
# /etc/netdata/vnodes/vnodes.conf
- hostname: win_server
  guid: <value>
```


<details><summary>Config</summary>

```yaml
jobs:
  - name: win_server
    vnode: win_server
    url: http://192.0.2.1:9182/metrics

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from multiple remote instances.


<details><summary>Config</summary>

```yaml
jobs:
  - name: win_server1
    url: http://192.0.2.1:9182/metrics

  - name: win_server2
    url: http://192.0.2.2:9182/metrics

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `windows` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m windows
  ```


