<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/zookeeper/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/zookeeper/metadata.yaml"
sidebar_label: "ZooKeeper"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Service Discovery / Registry"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# ZooKeeper


<img src="https://netdata.cloud/img/zookeeper.svg" width="150"/>


Plugin: go.d.plugin
Module: zookeeper

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview



It connects to the Zookeeper instance via a TCP and executes the following commands:

- [mntr](https://zookeeper.apache.org/doc/r3.4.8/zookeeperAdmin.html#sc_zkCommands).


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

By default, it detects instances running on localhost by attempting to connect using known ZooKeeper TCP sockets:

- 127.0.0.1:2181
- 127.0.0.1:2182


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per ZooKeeper instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| zookeeper.requests | outstanding | requests |
| zookeeper.requests_latency | min, avg, max | ms |
| zookeeper.connections | alive | connections |
| zookeeper.packets | received, sent | pps |
| zookeeper.file_descriptor | open | file descriptors |
| zookeeper.nodes | znode, ephemerals | nodes |
| zookeeper.watches | watches | watches |
| zookeeper.approximate_data_size | size | KiB |
| zookeeper.server_state | state | state |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Whitelist `mntr` command

Add `mntr` to Zookeeper's [4lw.commands.whitelist](https://zookeeper.apache.org/doc/current/zookeeperAdmin.html#sc_4lw).



### Configuration

#### File

The configuration file name for this integration is `go.d/zookeeper.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/zookeeper.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| address | Server address. The format is IP:PORT. | 127.0.0.1:2181 | yes |
| timeout | Connection/read/write/ssl handshake timeout. | 1 | no |
| use_tls | Whether to use TLS or not. | no | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | no | no |
| tls_ca | Certification authority that the client uses when verifying the server's certificates. |  | no |
| tls_cert | Client TLS certificate. |  | no |
| tls_key | Client TLS key. |  | no |

</details>

#### Examples

##### Basic

Local server.

<details><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:2181

```
</details>

##### TLS with self-signed certificate

Zookeeper with TLS and self-signed certificate.

<details><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:2181
    use_tls: yes
    tls_skip_verify: yes

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:2181

  - name: remote
    address: 192.0.2.1:2181

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `zookeeper` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m zookeeper
  ```


