<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/health/notifications/irc/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/health/notifications/irc/metadata.yaml"
sidebar_label: "IRC"
learn_status: "Published"
learn_rel_path: "Alerts & Notifications/Notifications/Agent Dispatched Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# IRC


<img src="https://netdata.cloud/img/irc.png" width="150"/>


Send notifications to IRC using Netdata's Agent alert notification feature, which supports dozens of endpoints, user roles, and more.



<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup

### Prerequisites

#### 

- The `nc` utility. You can set the path to it, or Netdata will search for it in your system `$PATH`.
- Access to the terminal where Netdata Agent is running



### Configuration

#### File

The configuration file name for this integration is `health_alarm_notify.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config health_alarm_notify.conf
```
#### Options

The following options can be defined for this notification

<details><summary>Config Options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| nc path | Set the path for nc, otherwise Netdata will search for it in your system $PATH |  | yes |
| SEND_IRC | Set `SEND_IRC` YES. | YES | yes |
| IRC_NETWORK | Set `IRC_NETWORK` to the IRC network which your preferred channels belong to. |  | yes |
| IRC_PORT | Set `IRC_PORT` to the IRC port to which a connection will occur. |  | no |
| IRC_NICKNAME | Set `IRC_NICKNAME` to the IRC nickname which is required to send the notification. It must not be an already registered name as the connection's MODE is defined as a guest. |  | yes |
| IRC_REALNAME | Set `IRC_REALNAME` to the IRC realname which is required in order to make the connection. |  | yes |
| DEFAULT_RECIPIENT_IRC | You can have different channels per role, by editing `DEFAULT_RECIPIENT_IRC` with the channel you want |  | yes |

##### nc path

```sh
#------------------------------------------------------------------------------
# external commands
#
# The full path of the nc command.
# If empty, the system $PATH will be searched for it.
# If not found, irc notifications will be silently disabled.
nc="/usr/bin/nc"
```


##### DEFAULT_RECIPIENT_IRC

The `DEFAULT_RECIPIENT_IRC` can be edited in the following entries at the bottom of the same file:
```conf
role_recipients_irc[sysadmin]="#systems"
role_recipients_irc[domainadmin]="#domains"
role_recipients_irc[dba]="#databases #systems"
role_recipients_irc[webmaster]="#marketing #development"
role_recipients_irc[proxyadmin]="#proxy-admin"
role_recipients_irc[sitemgr]="#sites"
```


</details>

#### Examples

##### Basic Configuration



```yaml
#------------------------------------------------------------------------------
# irc notification options
#
SEND_IRC="YES"
DEFAULT_RECIPIENT_IRC="#system-alarms"
IRC_NETWORK="irc.freenode.net"
IRC_NICKNAME="netdata-alarm-user"
IRC_REALNAME="netdata-user"

```


## Troubleshooting

### Test Notification

You can run the following command by hand, to test alerts configuration:

```bash
# become user netdata
sudo su -s /bin/bash netdata

# enable debugging info on the console
export NETDATA_ALARM_NOTIFY_DEBUG=1

# send test alarms to sysadmin
/usr/libexec/netdata/plugins.d/alarm-notify.sh test

# send test alarms to any role
/usr/libexec/netdata/plugins.d/alarm-notify.sh test "ROLE"
```

Note that this will test _all_ alert mechanisms for the selected role.


