<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/health/notifications/kavenegar/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/health/notifications/kavenegar/metadata.yaml"
sidebar_label: "Kavenegar"
learn_status: "Published"
learn_rel_path: "Alerts & Notifications/Notifications/Agent Dispatched Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# Kavenegar


<img src="https://netdata.cloud/img/kavenegar.png" width="150"/>


[Kavenegar](https://kavenegar.com/) as service for software developers, based in Iran, provides send and receive SMS, calling voice by using its APIs.
You can send notifications to Kavenegar using Netdata's Agent alert notification feature, which supports dozens of endpoints, user roles, and more.



<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup

### Prerequisites

#### 

- The APIKEY and Sender from http://panel.kavenegar.com/client/setting/account
- Access to the terminal where Netdata Agent is running



### Configuration

#### File

The configuration file name for this integration is `health_alarm_notify.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config health_alarm_notify.conf
```
#### Options

The following options can be defined for this notification

<details><summary>Config Options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| SEND_KAVENEGAR | Set `SEND_KAVENEGAR` to YES | YES | yes |
| KAVENEGAR_API_KEY | Set `KAVENEGAR_API_KEY` to your API key. |  | yes |
| KAVENEGAR_SENDER | Set `KAVENEGAR_SENDER` to the value of your Sender. |  | yes |
| DEFAULT_RECIPIENT_KAVENEGAR | Set `DEFAULT_RECIPIENT_KAVENEGAR` to the SMS recipient you want the alert notifications to be sent to. You can define multiple recipients like this: 09155555555 09177777777. |  | yes |

##### DEFAULT_RECIPIENT_KAVENEGAR

All roles will default to this variable if lest unconfigured.

You can then have different SMS recipients per role, by editing `DEFAULT_RECIPIENT_KAVENEGAR` with the SMS recipients you want, in the following entries at the bottom of the same file:
```conf
role_recipients_kavenegar[sysadmin]="09100000000"
role_recipients_kavenegar[domainadmin]="09111111111"
role_recipients_kavenegar[dba]="0922222222"
role_recipients_kavenegar[webmaster]="0933333333"
role_recipients_kavenegar[proxyadmin]="0944444444"
role_recipients_kavenegar[sitemgr]="0955555555"
```

The values you provide should be defined as environments in `/etc/alertad.conf` with `ALLOWED_ENVIRONMENTS` option.


</details>

#### Examples

##### Basic Configuration



```yaml
#------------------------------------------------------------------------------
# Kavenegar (Kavenegar.com) SMS options

SEND_KAVENEGAR="YES"
KAVENEGAR_API_KEY="XXXXXXXXXXXX"
KAVENEGAR_SENDER="YYYYYYYY"
DEFAULT_RECIPIENT_KAVENEGAR="0912345678"

```


## Troubleshooting

### Test Notification

You can run the following command by hand, to test alerts configuration:

```bash
# become user netdata
sudo su -s /bin/bash netdata

# enable debugging info on the console
export NETDATA_ALARM_NOTIFY_DEBUG=1

# send test alarms to sysadmin
/usr/libexec/netdata/plugins.d/alarm-notify.sh test

# send test alarms to any role
/usr/libexec/netdata/plugins.d/alarm-notify.sh test "ROLE"
```

Note that this will test _all_ alert mechanisms for the selected role.


