/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  rommngr.h

  Roms informations functions
*/

#ifndef MAMORY_ROMMNGR_H
#define MAMORY_ROMMNGR_H

#include <stdio.h>
#include <mamory/readinfo.h>
#include <mamory/chainlst.h>


typedef struct
{
  s_RomInfo *Rom;
  unsigned char Type;
#define SAME 0
#define CHANGEDNAME 1
#define ADDEDTRANSFERT 2
#define ADDEDNEW 3
#define SUPPRTRANSFERT 4
#define SUPPRESSED 5
#define UNKNOWN 6
  s_RomInfo *SourceRom;
} s_DiffRom;

#define DIFF_ROM(x) ((s_DiffRom*)x)

typedef struct
{
  s_GameInfo *Game;
  unsigned int NbrMISSINGRoms;
  unsigned int NbrSAMERoms;
  unsigned int NbrRoms;
  s_chainlst *Roms;
} s_DiffGame;

#define DIFF_GAME(x) ((s_DiffGame*)x)

typedef struct
{
  s_GamesList *GamesList1;
  s_GamesList *GamesList2;
  unsigned int OptionFlags;
#define OPTION_NONE 0x0000
#define OPTION_IGNORE_MISSING_NO_DUMP_ROMS 0x0001
#define OPTION_DELETE_INCOMPLETE_GAMES 0x0002
  unsigned long int TempNeededSize;
  unsigned long int MainNeededSize;
  unsigned long int BackUpNeededSize;
  unsigned int NbrNewRoms;
  s_chainlst *NewRoms;
  unsigned int NbrSupprRoms;
  s_chainlst *SupprRoms;
  unsigned int NbrGames;
  s_chainlst *Games;  
} s_Diff;


void GetSameCRCRoms(FILE *fp,s_GamesList *GamesList);
void GetSameNameRoms(FILE *fp,s_GamesList *GamesList);
s_Diff *DiffGamesLists(s_GamesList *GamesList1,s_GamesList *GamesList2, 
		       unsigned int OptionFlags);
void StripDiff(s_Diff *Diff);
void FreeDiffGame(s_DiffGame *DiffGame);
void FreeDiff(s_Diff *Diff);
s_GamesList *MISSINGtoGamesList(s_Diff *Diff);

#endif
 
 
  
 
 
