/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  chainlst.h
  
  Chain Lists management functions
*/

#ifndef MAMORY_CHAINLST_H
#define MAMORY_CHAINLST_H

typedef struct s_chainlst s_chainlst;

struct s_chainlst
{
  void *Data;
  s_chainlst *Prev;
  s_chainlst *Next;
};

unsigned int CLLen(s_chainlst *CL);
s_chainlst *CLFirst(s_chainlst *CL);
s_chainlst *CLLast(s_chainlst *CL);
s_chainlst *CLAppend(s_chainlst *CL,void *data);
s_chainlst *CLPrepend(s_chainlst *CL,void *data);
s_chainlst *CLInsert(s_chainlst *CL,void *data,unsigned int pos);
s_chainlst *CLRemove(s_chainlst *CL,void *data);
s_chainlst *CLRemoveAll(s_chainlst *CL,void *data);
inline void *CLGetData(s_chainlst *CL);
void FreeCL(s_chainlst *CL);

#endif

