/* SearchFonts.java (2024-02-28-13:19), generated from tex4ht-fonts-noncjk.tex
   Copyright 2009-2020 TeX Users Group
   Copyright 2002-2009 Eitan M. Gurari
%
% This work may be distributed and/or modified under the
% conditions of the LaTeX Project Public License, either
% version 1.3c of this license or (at your option) any
% later version. The latest version of this license is in
%   http://www.latex-project.org/lppl.txt
% and version 1.3c or later is part of all distributions
% of LaTeX version 2005/12/01 or later.
%
% This work has the LPPL maintenance status "maintained".
%
% The Current Maintainer of this work
% is the TeX4ht Project <http://tug.org/tex4ht>.
%
% If you modify this program, changing the
% version identification would be appreciated. */

/* It seems that this tool prints the character table for an HTF font
   from tex4ht-fonts-modern.tex, invoked something like this:
     java SearchFonts -xrpxb tex4ht-fonts-modern.tex
   Although presumably Eitan found it useful, those of us left behind
   haven't found a need for it, and it is not used anywhere.  We'll
   leave it in the sources as usual but we don't try to compile it or do
   anything with it.  */

import java.io.*;
import java.util.*;
class SearchFonts{
   public static void main(String [] args){
      try{
         if( args.length != 2 ){
           System.err.println(
              "       java SearchFonts pattern.file tex4ht-fonts-modern.tex"
              + "\n       java SearchFonts -xname tex4ht-fonts-modern.tex"
              + "\n       java SearchFonts -Xname tex4ht-fonts-modern.tex"
              + "\n  pattern.file: "
              + "\n      00A1 189 "
              + "\n      00BF 190 "
              + "\n      00A3 191 "
              + "\n      00DF 255   "
           );
           System.exit(0);
         }
         if( args[0].startsWith("-x") || args[0].startsWith("-X") ){
             String name = args[0].substring(2);
FileReader fr  = new FileReader( args[1] );
BufferedReader in = new BufferedReader( fr );
boolean inFont = false;
String s;
while( (s=in.readLine()) != null ){
  s += " ";
  s = s.trim().replaceAll("\\s+"," ");
  if( !s.equals("") ){
    if( s.equals("\\<" + name + "\\><<<") ){
       inFont = true;
    } else if( inFont && s.equals(">>>") ){
       System.exit(0);
    } else if( inFont ){
         s += " ";
         int i = args[0].startsWith("-X")? s.indexOf(" ") : 0;
         System.out.println(
           s.substring(0,s.indexOf(" ",i))
         );
    }
  }
}

         } else { ArrayList<Pattern> p = new ArrayList<Pattern>();
String records = null;
String s, name = null;
FileReader fr  = new FileReader( args[0] );
BufferedReader in = new BufferedReader( fr );
while( (s=in.readLine()) != null ){
  s = s.trim().replaceAll("\\s+"," ");
  if( !s.equals("") ){
    p.add( new Pattern( s ) );
  }
}
fr  = new FileReader( args[1] );
in = new BufferedReader( fr );
boolean inFont = false;
int cnt = 0;
while( (s=in.readLine()) != null ){
  s = s.trim().replaceAll("\\s+"," ");
  if( !s.equals("") ){
    if( s.startsWith("\\<") && s.endsWith("\\><<<") ){
       inFont = true;
       cnt = 0;
       name = s.substring(2, s.length()-5);
       records = "";
    } else if( s.equals(">>>") ){
       inFont = false;
    } else if( inFont ){
       if( p.get(cnt).isWithin(s) ){
           cnt++;
           records += "\n" + s;
       }
       if( cnt == p.size() ){
         System.out.println(
           "-----------------------\n"
           + name
           + "\n-----------------------"
           + records );
         inFont = false;
       }
    }
  }
}
 }
      } catch(java.io.IOException e){
         System.err.println("--- Error ---");
      }
   }
}
class Pattern{
     String [] p;
   Pattern( String p ){
     p = p.trim().replaceAll("\\s+"," ");
     this.p = p.split(" ");
   }
   boolean isWithin( String s ){
     int from = 0;
     for(int i=0; i<p.length; i++){
        int idx = s.indexOf(p[i], from);
        if( idx == -1 ){ return false; }
        from = i;
     }
     return true;
   }
}

