/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Comparator;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RangeTest
extends AbstractLangTest {
    private Range<Byte> byteRange;
    private Range<Byte> byteRange2;
    private Range<Byte> byteRange3;
    private Range<Double> doubleRange;
    private Range<Float> floatRange;
    private Range<Integer> intRange;
    private Range<Long> longRange;

    @BeforeEach
    public void setUp() {
        this.byteRange = Range.of((Comparable)Byte.valueOf((byte)0), (Comparable)Byte.valueOf((byte)5));
        this.byteRange2 = Range.of((Comparable)Byte.valueOf((byte)0), (Comparable)Byte.valueOf((byte)5));
        this.byteRange3 = Range.of((Comparable)Byte.valueOf((byte)0), (Comparable)Byte.valueOf((byte)10));
        this.intRange = Range.of((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20));
        this.longRange = Range.of((Comparable)Long.valueOf(10L), (Comparable)Long.valueOf(20L));
        this.floatRange = Range.of((Comparable)Float.valueOf(10.0f), (Comparable)Float.valueOf(20.0f));
        this.doubleRange = Range.of((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(20.0));
    }

    @Test
    public void testBetweenWithCompare() {
        Comparator c = (o1, o2) -> 0;
        Comparator<String> lengthComp = Comparator.comparingInt(String::length);
        Range rb = Range.between((Comparable)Integer.valueOf(-10), (Comparable)Integer.valueOf(20));
        Assertions.assertFalse((boolean)rb.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)rb.contains((Object)10), (String)"should contain 10");
        Assertions.assertTrue((boolean)rb.contains((Object)-10), (String)"should contain -10");
        Assertions.assertFalse((boolean)rb.contains((Object)21), (String)"should not contain 21");
        Assertions.assertFalse((boolean)rb.contains((Object)-11), (String)"should not contain -11");
        rb = Range.between((Object)-10, (Object)20, (Comparator)c);
        Assertions.assertFalse((boolean)rb.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)rb.contains((Object)10), (String)"should contain 10");
        Assertions.assertTrue((boolean)rb.contains((Object)-10), (String)"should contain -10");
        Assertions.assertTrue((boolean)rb.contains((Object)21), (String)"should contain 21");
        Assertions.assertTrue((boolean)rb.contains((Object)-11), (String)"should contain -11");
        Range rbstr = Range.between((Comparable)((Object)"house"), (Comparable)((Object)"i"));
        Assertions.assertFalse((boolean)rbstr.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)rbstr.contains((Object)"house"), (String)"should contain house");
        Assertions.assertTrue((boolean)rbstr.contains((Object)"i"), (String)"should contain i");
        Assertions.assertFalse((boolean)rbstr.contains((Object)"hose"), (String)"should not contain hose");
        Assertions.assertFalse((boolean)rbstr.contains((Object)"ice"), (String)"should not contain ice");
        rbstr = Range.between((Object)"house", (Object)"i", lengthComp);
        Assertions.assertFalse((boolean)rbstr.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)rbstr.contains((Object)"house"), (String)"should contain house");
        Assertions.assertTrue((boolean)rbstr.contains((Object)"i"), (String)"should contain i");
        Assertions.assertFalse((boolean)rbstr.contains((Object)"houses"), (String)"should not contain houses");
        Assertions.assertFalse((boolean)rbstr.contains((Object)""), (String)"should not contain ''");
        Assertions.assertThrows(NullPointerException.class, () -> Range.between(null, null, (Comparator)lengthComp));
    }

    @Test
    public void testComparableConstructors() {
        Comparable<Object> c = other -> 1;
        Range r1 = Range.is(c);
        Range r2 = Range.between(c, c);
        Assertions.assertTrue((boolean)r1.isNaturalOrdering());
        Assertions.assertTrue((boolean)r2.isNaturalOrdering());
    }

    @Test
    public void testConstructorSignatureWithAbstractComparableClasses() {
        DerivedComparableA derivedComparableA = new DerivedComparableA();
        DerivedComparableB derivedComparableB = new DerivedComparableB();
        Range mixed = Range.between((Comparable)derivedComparableA, (Comparable)derivedComparableB);
        mixed = Range.between((Object)derivedComparableA, (Object)derivedComparableB, null);
        Assertions.assertTrue((boolean)mixed.contains((Object)derivedComparableA));
        Range same = Range.between((Comparable)derivedComparableA, (Comparable)derivedComparableA);
        same = Range.between((Object)derivedComparableA, (Object)derivedComparableA, null);
        Assertions.assertTrue((boolean)same.contains((Object)derivedComparableA));
        Range rangeA = Range.between((Comparable)derivedComparableA, (Comparable)derivedComparableA);
        rangeA = Range.between((Object)derivedComparableA, (Object)derivedComparableA, null);
        Assertions.assertTrue((boolean)rangeA.contains((Object)derivedComparableA));
        Range rangeB = Range.is((Comparable)derivedComparableB);
        rangeB = Range.is((Object)derivedComparableB, null);
        Assertions.assertTrue((boolean)rangeB.contains((Object)derivedComparableB));
    }

    @Test
    public void testContains() {
        Assertions.assertFalse((boolean)this.intRange.contains(null));
        Assertions.assertFalse((boolean)this.intRange.contains((Object)5));
        Assertions.assertTrue((boolean)this.intRange.contains((Object)10));
        Assertions.assertTrue((boolean)this.intRange.contains((Object)15));
        Assertions.assertTrue((boolean)this.intRange.contains((Object)20));
        Assertions.assertFalse((boolean)this.intRange.contains((Object)25));
    }

    @Test
    public void testContainsRange() {
        Assertions.assertFalse((boolean)this.intRange.containsRange(null));
        Assertions.assertTrue((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(18))));
        Assertions.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(32), (Comparable)Integer.valueOf(45))));
        Assertions.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8))));
        Assertions.assertTrue((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
        Assertions.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(14))));
        Assertions.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(16), (Comparable)Integer.valueOf(21))));
        Assertions.assertTrue((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(19))));
        Assertions.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(21))));
        Assertions.assertTrue((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(11), (Comparable)Integer.valueOf(20))));
        Assertions.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(20))));
        Assertions.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(-11), (Comparable)Integer.valueOf(-18))));
    }

    @Test
    public void testElementCompareTo() {
        Assertions.assertThrows(NullPointerException.class, () -> this.intRange.elementCompareTo(null));
        Assertions.assertEquals((int)-1, (int)this.intRange.elementCompareTo((Object)5));
        Assertions.assertEquals((int)0, (int)this.intRange.elementCompareTo((Object)10));
        Assertions.assertEquals((int)0, (int)this.intRange.elementCompareTo((Object)15));
        Assertions.assertEquals((int)0, (int)this.intRange.elementCompareTo((Object)20));
        Assertions.assertEquals((int)1, (int)this.intRange.elementCompareTo((Object)25));
    }

    @Test
    public void testEqualsObject() {
        Assertions.assertEquals(this.byteRange, this.byteRange);
        Assertions.assertEquals(this.byteRange, this.byteRange2);
        Assertions.assertEquals(this.byteRange2, this.byteRange2);
        Assertions.assertEquals(this.byteRange, this.byteRange);
        Assertions.assertEquals(this.byteRange2, this.byteRange2);
        Assertions.assertEquals(this.byteRange3, this.byteRange3);
        Assertions.assertNotEquals(this.byteRange2, this.byteRange3);
        Assertions.assertNotEquals(null, this.byteRange2);
        Assertions.assertNotEquals((Object)"Ni!", this.byteRange2);
    }

    @Test
    public void testFit() {
        Assertions.assertEquals((Integer)((Integer)this.intRange.getMinimum()), (Integer)((Integer)this.intRange.fit((Object)Integer.MIN_VALUE)));
        Assertions.assertEquals((Integer)((Integer)this.intRange.getMinimum()), (Integer)((Integer)this.intRange.fit((Object)((Integer)this.intRange.getMinimum()))));
        Assertions.assertEquals((Integer)((Integer)this.intRange.getMaximum()), (Integer)((Integer)this.intRange.fit((Object)Integer.MAX_VALUE)));
        Assertions.assertEquals((Integer)((Integer)this.intRange.getMaximum()), (Integer)((Integer)this.intRange.fit((Object)((Integer)this.intRange.getMaximum()))));
        Assertions.assertEquals((int)15, (Integer)((Integer)this.intRange.fit((Object)15)));
    }

    @Test
    public void testFitNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.intRange.fit(null));
    }

    @Test
    public void testGetMaximum() {
        Assertions.assertEquals((int)20, (int)((Integer)this.intRange.getMaximum()));
        Assertions.assertEquals((long)20L, (long)((Long)this.longRange.getMaximum()));
        Assertions.assertEquals((float)20.0f, (float)((Float)this.floatRange.getMaximum()).floatValue(), (float)1.0E-5f);
        Assertions.assertEquals((double)20.0, (double)((Double)this.doubleRange.getMaximum()), (double)1.0E-5);
    }

    @Test
    public void testGetMinimum() {
        Assertions.assertEquals((int)10, (int)((Integer)this.intRange.getMinimum()));
        Assertions.assertEquals((long)10L, (long)((Long)this.longRange.getMinimum()));
        Assertions.assertEquals((float)10.0f, (float)((Float)this.floatRange.getMinimum()).floatValue(), (float)1.0E-5f);
        Assertions.assertEquals((double)10.0, (double)((Double)this.doubleRange.getMinimum()), (double)1.0E-5);
    }

    @Test
    public void testHashCode() {
        Assertions.assertEquals((int)this.byteRange.hashCode(), (int)this.byteRange2.hashCode());
        Assertions.assertNotEquals((int)this.byteRange.hashCode(), (int)this.byteRange3.hashCode());
        Assertions.assertEquals((int)this.intRange.hashCode(), (int)this.intRange.hashCode());
        Assertions.assertTrue((this.intRange.hashCode() != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIntersectionWith() {
        Assertions.assertSame(this.intRange, (Object)this.intRange.intersectionWith(this.intRange));
        Assertions.assertSame(this.byteRange, (Object)this.byteRange.intersectionWith(this.byteRange));
        Assertions.assertSame(this.longRange, (Object)this.longRange.intersectionWith(this.longRange));
        Assertions.assertSame(this.floatRange, (Object)this.floatRange.intersectionWith(this.floatRange));
        Assertions.assertSame(this.doubleRange, (Object)this.doubleRange.intersectionWith(this.doubleRange));
        Assertions.assertEquals((Object)Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15)), (Object)this.intRange.intersectionWith(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(15))));
    }

    @Test
    public void testIntersectionWithNonOverlapping() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.intRange.intersectionWith(Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(9))));
    }

    @Test
    public void testIntersectionWithNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.intRange.intersectionWith(null));
    }

    @Test
    public void testIsAfter() {
        Assertions.assertFalse((boolean)this.intRange.isAfter(null));
        Assertions.assertTrue((boolean)this.intRange.isAfter((Object)5));
        Assertions.assertFalse((boolean)this.intRange.isAfter((Object)10));
        Assertions.assertFalse((boolean)this.intRange.isAfter((Object)15));
        Assertions.assertFalse((boolean)this.intRange.isAfter((Object)20));
        Assertions.assertFalse((boolean)this.intRange.isAfter((Object)25));
    }

    @Test
    public void testIsAfterRange() {
        Assertions.assertFalse((boolean)this.intRange.isAfterRange(null));
        Assertions.assertTrue((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(9))));
        Assertions.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(10))));
        Assertions.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(20))));
        Assertions.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(25))));
        Assertions.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(25))));
        Assertions.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(21), (Comparable)Integer.valueOf(25))));
        Assertions.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
    }

    @Test
    public void testIsBefore() {
        Assertions.assertFalse((boolean)this.intRange.isBefore(null));
        Assertions.assertFalse((boolean)this.intRange.isBefore((Object)5));
        Assertions.assertFalse((boolean)this.intRange.isBefore((Object)10));
        Assertions.assertFalse((boolean)this.intRange.isBefore((Object)15));
        Assertions.assertFalse((boolean)this.intRange.isBefore((Object)20));
        Assertions.assertTrue((boolean)this.intRange.isBefore((Object)25));
    }

    @Test
    public void testIsBeforeRange() {
        Assertions.assertFalse((boolean)this.intRange.isBeforeRange(null));
        Assertions.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(9))));
        Assertions.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(10))));
        Assertions.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(20))));
        Assertions.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(25))));
        Assertions.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(25))));
        Assertions.assertTrue((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(21), (Comparable)Integer.valueOf(25))));
        Assertions.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
    }

    @Test
    public void testIsEndedBy() {
        Assertions.assertFalse((boolean)this.intRange.isEndedBy(null));
        Assertions.assertFalse((boolean)this.intRange.isEndedBy((Object)5));
        Assertions.assertFalse((boolean)this.intRange.isEndedBy((Object)10));
        Assertions.assertFalse((boolean)this.intRange.isEndedBy((Object)15));
        Assertions.assertTrue((boolean)this.intRange.isEndedBy((Object)20));
        Assertions.assertFalse((boolean)this.intRange.isEndedBy((Object)25));
    }

    @Test
    public void testIsOverlappedBy() {
        Assertions.assertFalse((boolean)this.intRange.isOverlappedBy(null));
        Assertions.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(18))));
        Assertions.assertFalse((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(32), (Comparable)Integer.valueOf(45))));
        Assertions.assertFalse((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8))));
        Assertions.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
        Assertions.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(14))));
        Assertions.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(16), (Comparable)Integer.valueOf(21))));
        Assertions.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(19))));
        Assertions.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(21))));
        Assertions.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(11), (Comparable)Integer.valueOf(20))));
        Assertions.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(20))));
        Assertions.assertFalse((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(-11), (Comparable)Integer.valueOf(-18))));
        Assertions.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(21))));
    }

    @Test
    public void testIsStartedBy() {
        Assertions.assertFalse((boolean)this.intRange.isStartedBy(null));
        Assertions.assertFalse((boolean)this.intRange.isStartedBy((Object)5));
        Assertions.assertTrue((boolean)this.intRange.isStartedBy((Object)10));
        Assertions.assertFalse((boolean)this.intRange.isStartedBy((Object)15));
        Assertions.assertFalse((boolean)this.intRange.isStartedBy((Object)20));
        Assertions.assertFalse((boolean)this.intRange.isStartedBy((Object)25));
    }

    @Test
    public void testIsWithCompare() {
        Comparator c = (o1, o2) -> 0;
        Range ri = Range.is((Comparable)Integer.valueOf(10));
        Assertions.assertFalse((boolean)ri.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)ri.contains((Object)10), (String)"should contain 10");
        Assertions.assertFalse((boolean)ri.contains((Object)11), (String)"should not contain 11");
        ri = Range.is((Object)10, (Comparator)c);
        Assertions.assertFalse((boolean)ri.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)ri.contains((Object)10), (String)"should contain 10");
        Assertions.assertTrue((boolean)ri.contains((Object)11), (String)"should contain 11");
    }

    @Test
    public void testOfWithCompare() {
        Comparator c = (o1, o2) -> 0;
        Comparator<String> lengthComp = Comparator.comparingInt(String::length);
        Range rb = Range.of((Comparable)Integer.valueOf(-10), (Comparable)Integer.valueOf(20));
        Assertions.assertFalse((boolean)rb.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)rb.contains((Object)10), (String)"should contain 10");
        Assertions.assertTrue((boolean)rb.contains((Object)-10), (String)"should contain -10");
        Assertions.assertFalse((boolean)rb.contains((Object)21), (String)"should not contain 21");
        Assertions.assertFalse((boolean)rb.contains((Object)-11), (String)"should not contain -11");
        rb = Range.of((Object)-10, (Object)20, (Comparator)c);
        Assertions.assertFalse((boolean)rb.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)rb.contains((Object)10), (String)"should contain 10");
        Assertions.assertTrue((boolean)rb.contains((Object)-10), (String)"should contain -10");
        Assertions.assertTrue((boolean)rb.contains((Object)21), (String)"should contain 21");
        Assertions.assertTrue((boolean)rb.contains((Object)-11), (String)"should contain -11");
        Range rbstr = Range.of((Comparable)((Object)"house"), (Comparable)((Object)"i"));
        Assertions.assertFalse((boolean)rbstr.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)rbstr.contains((Object)"house"), (String)"should contain house");
        Assertions.assertTrue((boolean)rbstr.contains((Object)"i"), (String)"should contain i");
        Assertions.assertFalse((boolean)rbstr.contains((Object)"hose"), (String)"should not contain hose");
        Assertions.assertFalse((boolean)rbstr.contains((Object)"ice"), (String)"should not contain ice");
        rbstr = Range.of((Object)"house", (Object)"i", lengthComp);
        Assertions.assertFalse((boolean)rbstr.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)rbstr.contains((Object)"house"), (String)"should contain house");
        Assertions.assertTrue((boolean)rbstr.contains((Object)"i"), (String)"should contain i");
        Assertions.assertFalse((boolean)rbstr.contains((Object)"houses"), (String)"should not contain houses");
        Assertions.assertFalse((boolean)rbstr.contains((Object)""), (String)"should not contain ''");
        Assertions.assertThrows(NullPointerException.class, () -> Range.of(null, null, (Comparator)lengthComp));
    }

    @Test
    public void testRangeOfChars() {
        Range chars = Range.between((Comparable)Character.valueOf('a'), (Comparable)Character.valueOf('z'));
        Assertions.assertTrue((boolean)chars.contains((Object)Character.valueOf('b')));
        Assertions.assertFalse((boolean)chars.contains((Object)Character.valueOf('B')));
    }

    @Test
    public void testSerializing() {
        SerializationUtils.clone(this.intRange);
    }

    @Test
    public void testToString() {
        Assertions.assertNotNull((Object)this.byteRange.toString());
        String str = this.intRange.toString();
        Assertions.assertEquals((Object)"[10..20]", (Object)str);
        Assertions.assertEquals((Object)"[-20..-10]", (Object)Range.between((Comparable)Integer.valueOf(-20), (Comparable)Integer.valueOf(-10)).toString());
    }

    @Test
    public void testToStringFormat() {
        String str = this.intRange.toString("From %1$s to %2$s");
        Assertions.assertEquals((Object)"From 10 to 20", (Object)str);
    }

    static final class DerivedComparableA
    extends AbstractComparable {
        DerivedComparableA() {
        }
    }

    static final class DerivedComparableB
    extends AbstractComparable {
        DerivedComparableB() {
        }
    }

    static abstract class AbstractComparable
    implements Comparable<AbstractComparable> {
        AbstractComparable() {
        }

        @Override
        public int compareTo(AbstractComparable o) {
            return 0;
        }
    }
}

