/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.compare;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.compare.ObjectToStringComparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObjectToStringComparatorTest
extends AbstractLangTest {
    @Test
    public void testNull() {
        List<Thing> things = Arrays.asList(null, new Thing("y"), null);
        things.sort((Comparator<Thing>)ObjectToStringComparator.INSTANCE);
        Assertions.assertEquals((Object)"y", (Object)things.get((int)0).string);
        Assertions.assertNull((Object)things.get(1));
        Assertions.assertNull((Object)things.get(2));
    }

    @Test
    public void testNullToString() {
        List<Thing> things = Arrays.asList(new Thing(null), new Thing("y"), new Thing(null));
        things.sort((Comparator<Thing>)ObjectToStringComparator.INSTANCE);
        Assertions.assertEquals((Object)"y", (Object)things.get((int)0).string);
        Assertions.assertNull((Object)things.get((int)1).string);
        Assertions.assertNull((Object)things.get((int)2).string);
    }

    @Test
    public void testSortCollection() {
        List<Thing> things = Arrays.asList(new Thing("z"), new Thing("y"), new Thing("x"));
        things.sort((Comparator<Thing>)ObjectToStringComparator.INSTANCE);
        Assertions.assertEquals((Object)"x", (Object)things.get((int)0).string);
        Assertions.assertEquals((Object)"y", (Object)things.get((int)1).string);
        Assertions.assertEquals((Object)"z", (Object)things.get((int)2).string);
    }

    private static final class Thing {
        final String string;

        Thing(String string) {
            this.string = string;
        }

        public String toString() {
            return this.string;
        }
    }
}

