/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.MultiBackgroundInitializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MultiBackgroundInitializerTest
extends AbstractLangTest {
    private static final String CHILD_INIT = "childInitializer";
    protected static final long PERIOD_MILLIS = 50L;
    protected MultiBackgroundInitializer initializer;

    private void checkChild(BackgroundInitializer<?> child, ExecutorService expExec) throws ConcurrentException {
        AbstractChildBackgroundInitializer cinit = (AbstractChildBackgroundInitializer)child;
        Integer result = ((CloseableCounter)cinit.get()).getInitializeCalls();
        Assertions.assertEquals((int)1, (int)result, (String)"Wrong result");
        Assertions.assertEquals((int)1, (int)cinit.initializeCalls, (String)"Wrong number of executions");
        if (expExec != null) {
            Assertions.assertEquals((Object)expExec, (Object)cinit.currentExecutor, (String)"Wrong executor service");
        }
    }

    private MultiBackgroundInitializer.MultiBackgroundInitializerResults checkInitialize() throws ConcurrentException {
        int count = 5;
        for (int i = 0; i < 5; ++i) {
            this.initializer.addInitializer(CHILD_INIT + i, (BackgroundInitializer)this.createChildBackgroundInitializer());
        }
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assertions.assertEquals((int)5, (int)res.initializerNames().size(), (String)"Wrong number of child initializers");
        for (int i = 0; i < 5; ++i) {
            String key = CHILD_INIT + i;
            Assertions.assertTrue((boolean)res.initializerNames().contains(key), (String)("Name not found: " + key));
            Assertions.assertEquals((Object)CloseableCounter.wrapInteger(1), (Object)res.getResultObject(key), (String)"Wrong result object");
            Assertions.assertFalse((boolean)res.isException(key), (String)"Exception flag");
            Assertions.assertNull((Object)((Object)res.getException(key)), (String)"Got an exception");
            this.checkChild(res.getInitializer(key), this.initializer.getActiveExecutor());
        }
        return res;
    }

    protected AbstractChildBackgroundInitializer createChildBackgroundInitializer() {
        return new MethodChildBackgroundInitializer();
    }

    @BeforeEach
    public void setUp() {
        this.initializer = new MultiBackgroundInitializer();
    }

    @Test
    public void testAddInitializerAfterStart() throws ConcurrentException {
        this.initializer.start();
        Assertions.assertThrows(IllegalStateException.class, () -> this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)this.createChildBackgroundInitializer()), (String)"Could add initializer after start()!");
        this.initializer.get();
    }

    @Test
    public void testAddInitializerNullInit() {
        Assertions.assertThrows(NullPointerException.class, () -> this.initializer.addInitializer(CHILD_INIT, null));
    }

    @Test
    public void testAddInitializerNullName() {
        Assertions.assertThrows(NullPointerException.class, () -> this.initializer.addInitializer(null, (BackgroundInitializer)this.createChildBackgroundInitializer()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitializeChildWithExecutor() throws ConcurrentException, InterruptedException {
        String initExec = "childInitializerWithExecutor";
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            AbstractChildBackgroundInitializer c1 = this.createChildBackgroundInitializer();
            AbstractChildBackgroundInitializer c2 = this.createChildBackgroundInitializer();
            c2.setExternalExecutor(exec);
            this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)c1);
            this.initializer.addInitializer("childInitializerWithExecutor", (BackgroundInitializer)c2);
            this.initializer.start();
            this.initializer.get();
            this.checkChild(c1, this.initializer.getActiveExecutor());
            this.checkChild(c2, exec);
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testInitializeEx() throws ConcurrentException {
        AbstractChildBackgroundInitializer child = this.createChildBackgroundInitializer();
        child.ex = new Exception();
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)child);
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assertions.assertTrue((boolean)res.isException(CHILD_INIT), (String)"No exception flag");
        Assertions.assertNull((Object)res.getResultObject(CHILD_INIT), (String)"Got a results object");
        ConcurrentException cex = res.getException(CHILD_INIT);
        Assertions.assertEquals((Object)child.ex, (Object)cex.getCause(), (String)"Wrong cause");
    }

    @Test
    public void testInitializeExternalExec() throws ConcurrentException, InterruptedException {
        ExecutorService exec = Executors.newCachedThreadPool();
        try {
            this.initializer = new MultiBackgroundInitializer(exec);
            this.checkInitialize();
            Assertions.assertEquals((Object)exec, (Object)this.initializer.getActiveExecutor(), (String)"Wrong executor");
            Assertions.assertFalse((boolean)exec.isShutdown(), (String)"Executor was shutdown");
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testInitializeNested() throws ConcurrentException {
        String nameMulti = "multiChildInitializer";
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)this.createChildBackgroundInitializer());
        MultiBackgroundInitializer mi2 = new MultiBackgroundInitializer();
        int count = 3;
        for (int i = 0; i < 3; ++i) {
            mi2.addInitializer(CHILD_INIT + i, (BackgroundInitializer)this.createChildBackgroundInitializer());
        }
        this.initializer.addInitializer("multiChildInitializer", (BackgroundInitializer)mi2);
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        ExecutorService exec = this.initializer.getActiveExecutor();
        this.checkChild(res.getInitializer(CHILD_INIT), exec);
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res2 = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)res.getResultObject("multiChildInitializer");
        Assertions.assertEquals((int)3, (int)res2.initializerNames().size(), (String)"Wrong number of initializers");
        for (int i = 0; i < 3; ++i) {
            this.checkChild(res2.getInitializer(CHILD_INIT + i), exec);
        }
        Assertions.assertTrue((boolean)exec.isShutdown(), (String)"Executor not shutdown");
    }

    @Test
    public void testInitializeNoChildren() throws ConcurrentException {
        Assertions.assertTrue((boolean)this.initializer.start(), (String)"Wrong result of start()");
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assertions.assertTrue((boolean)res.initializerNames().isEmpty(), (String)"Got child initializers");
        Assertions.assertTrue((boolean)this.initializer.getActiveExecutor().isShutdown(), (String)"Executor not shutdown");
    }

    @Test
    public void testInitializeResultsIsSuccessfulFalse() throws ConcurrentException {
        AbstractChildBackgroundInitializer child = this.createChildBackgroundInitializer();
        child.ex = new Exception();
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)child);
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assertions.assertFalse((boolean)res.isSuccessful(), (String)"Wrong success flag");
    }

    @Test
    public void testInitializeResultsIsSuccessfulTrue() throws ConcurrentException {
        AbstractChildBackgroundInitializer child = this.createChildBackgroundInitializer();
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)child);
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assertions.assertTrue((boolean)res.isSuccessful(), (String)"Wrong success flag");
    }

    @Test
    public void testInitializeRuntimeEx() {
        AbstractChildBackgroundInitializer child = this.createChildBackgroundInitializer();
        child.ex = new RuntimeException();
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)child);
        this.initializer.start();
        Exception ex = (Exception)Assertions.assertThrows(Exception.class, () -> ((MultiBackgroundInitializer)this.initializer).get());
        Assertions.assertEquals((Object)child.ex, (Object)ex, (String)"Wrong exception");
    }

    @Test
    public void testInitializeTempExec() throws ConcurrentException {
        this.checkInitialize();
        Assertions.assertTrue((boolean)this.initializer.getActiveExecutor().isShutdown(), (String)"Executor not shutdown");
    }

    @Test
    public void testIsInitialized() throws ConcurrentException, InterruptedException {
        AbstractChildBackgroundInitializer childOne = this.createChildBackgroundInitializer();
        AbstractChildBackgroundInitializer childTwo = this.createChildBackgroundInitializer();
        childOne.enableLatch();
        childTwo.enableLatch();
        Assertions.assertFalse((boolean)this.initializer.isInitialized(), (String)"Initalized without having anything to initalize");
        this.initializer.addInitializer("child one", (BackgroundInitializer)childOne);
        this.initializer.addInitializer("child two", (BackgroundInitializer)childTwo);
        this.initializer.start();
        long startTime = System.currentTimeMillis();
        long waitTime = 3000L;
        long endTime = startTime + waitTime;
        while (!childOne.isStarted() || !childTwo.isStarted()) {
            if (System.currentTimeMillis() <= endTime) continue;
            Assertions.fail((String)"children never started");
            Thread.sleep(50L);
        }
        Assertions.assertFalse((boolean)this.initializer.isInitialized(), (String)"Initalized with two children running");
        childOne.releaseLatch();
        childOne.get();
        Assertions.assertFalse((boolean)this.initializer.isInitialized(), (String)"Initalized with one child running");
        childTwo.releaseLatch();
        childTwo.get();
        Assertions.assertTrue((boolean)this.initializer.isInitialized(), (String)"Not initalized with no children running");
    }

    @Test
    public void testResultGetExceptionUnknown() throws ConcurrentException {
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = this.checkInitialize();
        Assertions.assertThrows(NoSuchElementException.class, () -> res.getException("unknown"));
    }

    @Test
    public void testResultGetInitializerUnknown() throws ConcurrentException {
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = this.checkInitialize();
        Assertions.assertThrows(NoSuchElementException.class, () -> res.getInitializer("unknown"));
    }

    @Test
    public void testResultGetResultObjectUnknown() throws ConcurrentException {
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = this.checkInitialize();
        Assertions.assertThrows(NoSuchElementException.class, () -> res.getResultObject("unknown"));
    }

    @Test
    public void testResultInitializerNamesModify() throws ConcurrentException {
        this.checkInitialize();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Iterator it = res.initializerNames().iterator();
        it.next();
        Assertions.assertThrows(UnsupportedOperationException.class, it::remove);
    }

    @Test
    public void testResultIsExceptionUnknown() throws ConcurrentException {
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = this.checkInitialize();
        Assertions.assertThrows(NoSuchElementException.class, () -> res.isException("unknown"));
    }

    protected static class AbstractChildBackgroundInitializer
    extends BackgroundInitializer<CloseableCounter> {
        volatile ExecutorService currentExecutor;
        CloseableCounter counter = new CloseableCounter();
        volatile int initializeCalls;
        Exception ex;
        final CountDownLatch latch = new CountDownLatch(1);
        boolean waitForLatch;

        protected AbstractChildBackgroundInitializer() {
        }

        public void enableLatch() {
            this.waitForLatch = true;
        }

        public CloseableCounter getCloseableCounter() {
            return this.counter;
        }

        protected CloseableCounter initializeInternal() throws Exception {
            ++this.initializeCalls;
            this.currentExecutor = this.getActiveExecutor();
            if (this.waitForLatch) {
                this.latch.await();
            }
            if (this.ex != null) {
                throw this.ex;
            }
            return this.counter.increment();
        }

        public void releaseLatch() {
            this.latch.countDown();
        }
    }

    protected static class CloseableCounter {
        volatile int initializeCalls;
        volatile boolean closed;

        protected CloseableCounter() {
        }

        public static CloseableCounter wrapInteger(int i) {
            return new CloseableCounter().setInitializeCalls(i);
        }

        public void close() {
            this.closed = true;
        }

        public boolean equals(Object other) {
            if (other instanceof CloseableCounter) {
                return this.initializeCalls == ((CloseableCounter)other).getInitializeCalls();
            }
            return false;
        }

        public int getInitializeCalls() {
            return this.initializeCalls;
        }

        public CloseableCounter increment() {
            ++this.initializeCalls;
            return this;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public CloseableCounter setInitializeCalls(int i) {
            this.initializeCalls = i;
            return this;
        }
    }

    protected static class MethodChildBackgroundInitializer
    extends AbstractChildBackgroundInitializer {
        protected MethodChildBackgroundInitializer() {
        }

        protected CloseableCounter initialize() throws Exception {
            return this.initializeInternal();
        }
    }
}

