/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.concurrent.ThresholdCircuitBreaker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThresholdCircuitBreakerTest
extends AbstractLangTest {
    private static final long threshold = 10L;
    private static final long zeroThreshold = 0L;

    @Test
    public void testClosingThresholdCircuitBreaker() {
        ThresholdCircuitBreaker circuit = new ThresholdCircuitBreaker(10L);
        circuit.incrementAndCheckState(Long.valueOf(9L));
        circuit.close();
        Assertions.assertTrue((boolean)circuit.incrementAndCheckState(Long.valueOf(9L)), (String)"Internal counter was not reset back to zero");
    }

    @Test
    public void testGettingThreshold() {
        ThresholdCircuitBreaker circuit = new ThresholdCircuitBreaker(10L);
        Assertions.assertEquals((Long)10L, (Long)circuit.getThreshold(), (String)"Wrong value of threshold");
    }

    @Test
    public void testThreshold() {
        ThresholdCircuitBreaker circuit = new ThresholdCircuitBreaker(10L);
        circuit.incrementAndCheckState(Long.valueOf(9L));
        Assertions.assertTrue((boolean)circuit.incrementAndCheckState(Long.valueOf(1L)), (String)"Circuit opened before reaching the threshold");
    }

    @Test
    public void testThresholdCircuitBreakingException() {
        ThresholdCircuitBreaker circuit = new ThresholdCircuitBreaker(10L);
        circuit.incrementAndCheckState(Long.valueOf(9L));
        Assertions.assertFalse((boolean)circuit.incrementAndCheckState(Long.valueOf(2L)), (String)"The circuit was supposed to be open after increment above the threshold");
    }

    @Test
    public void testThresholdEqualsZero() {
        ThresholdCircuitBreaker circuit = new ThresholdCircuitBreaker(0L);
        Assertions.assertFalse((boolean)circuit.incrementAndCheckState(Long.valueOf(0L)), (String)"When the threshold is zero, the circuit is supposed to be always open");
    }
}

