/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent.locks;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ThreadUtils;
import org.apache.commons.lang3.concurrent.locks.LockingVisitors;
import org.apache.commons.lang3.function.FailableConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LockingVisitorsTest
extends AbstractLangTest {
    private static final Duration SHORT_DELAY = Duration.ofMillis(100L);
    private static final Duration DELAY = Duration.ofMillis(1500L);
    private static final int NUMBER_OF_THREADS = 10;
    private static final Duration TOTAL_DELAY = DELAY.multipliedBy(10L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsTrue(boolean[] booleanArray) {
        boolean[] blArray = booleanArray;
        synchronized (booleanArray) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ArrayUtils.contains((boolean[])booleanArray, (boolean)true);
        }
    }

    private void runTest(Duration delay, boolean exclusiveLock, LongConsumer runTimeCheck, boolean[] booleanValues, LockingVisitors.LockVisitor<boolean[], ?> visitor) throws InterruptedException {
        boolean[] runningValues = new boolean[10];
        long startTimeMillis = System.currentTimeMillis();
        for (int i = 0; i < booleanValues.length; ++i) {
            int index = i;
            FailableConsumer consumer = b -> {
                b[index] = false;
                ThreadUtils.sleep((Duration)delay);
                b[index] = true;
                this.set(runningValues, index, false);
            };
            Thread t = new Thread(() -> {
                if (exclusiveLock) {
                    visitor.acceptWriteLocked(consumer);
                } else {
                    visitor.acceptReadLocked(consumer);
                }
            });
            this.set(runningValues, i, true);
            t.start();
        }
        while (this.containsTrue(runningValues)) {
            ThreadUtils.sleep((Duration)SHORT_DELAY);
        }
        long endTimeMillis = System.currentTimeMillis();
        for (boolean booleanValue : booleanValues) {
            Assertions.assertTrue((boolean)booleanValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set(boolean[] booleanArray, int offset, boolean value) {
        boolean[] blArray = booleanArray;
        synchronized (booleanArray) {
            booleanArray[offset] = value;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Test
    public void testCreate() {
        AtomicInteger res = new AtomicInteger();
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        LockingVisitors.create((Object)res, (ReadWriteLock)rwLock).acceptReadLocked(AtomicInteger::incrementAndGet);
        Assertions.assertEquals((int)1, (int)res.get());
        LockingVisitors.create((Object)res, (ReadWriteLock)rwLock).acceptWriteLocked(AtomicInteger::incrementAndGet);
        Assertions.assertEquals((int)2, (int)res.get());
    }

    @Test
    public void testReentrantReadWriteLockExclusive() throws Exception {
        boolean[] booleanValues = new boolean[10];
        this.runTest(DELAY, true, millis -> Assertions.assertTrue((millis >= TOTAL_DELAY.toMillis() ? 1 : 0) != 0), booleanValues, (LockingVisitors.LockVisitor<boolean[], ?>)LockingVisitors.reentrantReadWriteLockVisitor((Object)booleanValues));
    }

    @Test
    public void testReentrantReadWriteLockNotExclusive() throws Exception {
        boolean[] booleanValues = new boolean[10];
        this.runTest(DELAY, false, millis -> Assertions.assertTrue((millis < TOTAL_DELAY.toMillis() ? 1 : 0) != 0), booleanValues, (LockingVisitors.LockVisitor<boolean[], ?>)LockingVisitors.reentrantReadWriteLockVisitor((Object)booleanValues));
    }

    @Test
    public void testResultValidation() {
        Object hidden = new Object();
        LockingVisitors.StampedLockVisitor lock = LockingVisitors.stampedLockVisitor((Object)hidden);
        Object o1 = lock.applyReadLocked(h -> new Object());
        Assertions.assertNotNull((Object)o1);
        Assertions.assertNotSame((Object)hidden, (Object)o1);
        Object o2 = lock.applyWriteLocked(h -> new Object());
        Assertions.assertNotNull((Object)o2);
        Assertions.assertNotSame((Object)hidden, (Object)o2);
    }

    @Test
    public void testStampedLockExclusive() throws Exception {
        boolean[] booleanValues = new boolean[10];
        this.runTest(DELAY, true, millis -> Assertions.assertTrue((millis >= TOTAL_DELAY.toMillis() ? 1 : 0) != 0), booleanValues, (LockingVisitors.LockVisitor<boolean[], ?>)LockingVisitors.stampedLockVisitor((Object)booleanValues));
    }

    @Test
    public void testStampedLockNotExclusive() throws Exception {
        boolean[] booleanValues = new boolean[10];
        this.runTest(DELAY, false, millis -> Assertions.assertTrue((millis < TOTAL_DELAY.toMillis() ? 1 : 0) != 0), booleanValues, (LockingVisitors.LockVisitor<boolean[], ?>)LockingVisitors.stampedLockVisitor((Object)booleanValues));
    }
}

