/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache;

import java.util.concurrent.TimeUnit;

public interface CleanupFrequency {
    public static final long NEVER_CLEANED = 0L;
    public static final CleanupFrequency DAILY = new CleanupFrequency(){

        @Override
        public boolean requiresCleanup(long lastCleanupTimestamp) {
            if (lastCleanupTimestamp == 0L) {
                return true;
            }
            long duration = System.currentTimeMillis() - lastCleanupTimestamp;
            long timeInHours = TimeUnit.MILLISECONDS.toHours(duration);
            return timeInHours >= 24L;
        }
    };
    public static final CleanupFrequency ALWAYS = new CleanupFrequency(){

        @Override
        public boolean requiresCleanup(long lastCleanupTimestamp) {
            return true;
        }

        @Override
        public boolean shouldCleanupOnEndOfSession() {
            return true;
        }
    };
    public static final CleanupFrequency NEVER = new CleanupFrequency(){

        @Override
        public boolean requiresCleanup(long lastCleanupTimestamp) {
            return false;
        }
    };

    public boolean requiresCleanup(long var1);

    default public boolean shouldCleanupOnEndOfSession() {
        return false;
    }
}

