// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2022-02-15/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ListConsulVersionsReader is a Reader for the ListConsulVersions structure.
type ListConsulVersionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListConsulVersionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListConsulVersionsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListConsulVersionsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListConsulVersionsOK creates a ListConsulVersionsOK with default headers values
func NewListConsulVersionsOK() *ListConsulVersionsOK {
	return &ListConsulVersionsOK{}
}

/*
ListConsulVersionsOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListConsulVersionsOK struct {
	Payload *models.HashicorpCloudGlobalNetworkManager20220215ListConsulVersionsResponse
}

// IsSuccess returns true when this list consul versions o k response has a 2xx status code
func (o *ListConsulVersionsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list consul versions o k response has a 3xx status code
func (o *ListConsulVersionsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list consul versions o k response has a 4xx status code
func (o *ListConsulVersionsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list consul versions o k response has a 5xx status code
func (o *ListConsulVersionsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list consul versions o k response a status code equal to that given
func (o *ListConsulVersionsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list consul versions o k response
func (o *ListConsulVersionsOK) Code() int {
	return 200
}

func (o *ListConsulVersionsOK) Error() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/list_consul_versions][%d] listConsulVersionsOK  %+v", 200, o.Payload)
}

func (o *ListConsulVersionsOK) String() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/list_consul_versions][%d] listConsulVersionsOK  %+v", 200, o.Payload)
}

func (o *ListConsulVersionsOK) GetPayload() *models.HashicorpCloudGlobalNetworkManager20220215ListConsulVersionsResponse {
	return o.Payload
}

func (o *ListConsulVersionsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudGlobalNetworkManager20220215ListConsulVersionsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListConsulVersionsDefault creates a ListConsulVersionsDefault with default headers values
func NewListConsulVersionsDefault(code int) *ListConsulVersionsDefault {
	return &ListConsulVersionsDefault{
		_statusCode: code,
	}
}

/*
ListConsulVersionsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListConsulVersionsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this list consul versions default response has a 2xx status code
func (o *ListConsulVersionsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list consul versions default response has a 3xx status code
func (o *ListConsulVersionsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list consul versions default response has a 4xx status code
func (o *ListConsulVersionsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list consul versions default response has a 5xx status code
func (o *ListConsulVersionsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list consul versions default response a status code equal to that given
func (o *ListConsulVersionsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list consul versions default response
func (o *ListConsulVersionsDefault) Code() int {
	return o._statusCode
}

func (o *ListConsulVersionsDefault) Error() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/list_consul_versions][%d] ListConsulVersions default  %+v", o._statusCode, o.Payload)
}

func (o *ListConsulVersionsDefault) String() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/list_consul_versions][%d] ListConsulVersions default  %+v", o._statusCode, o.Payload)
}

func (o *ListConsulVersionsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ListConsulVersionsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
