'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) pushbutton.n 1.21 94/12/17 16:04:44
'\" 
.so man.macros
.HS iwidgets::pushbutton iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
iwidgets::pushbutton \- Create and manipulate a push button widget
.SH SYNOPSIS
\fBiwidgets::pushbutton\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- iwidgets::Pushbutton
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fB
activeBackground       activeForeground       background
bitmap                 borderWidth            command
cursor                 disabledForeground     font
foreground             highlightBackground    highlightColor
highlightThickness     image                  padX
padY                   state                  text
underline              wrapLength\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBdefaultRing\fR
Class:	\fBDefaultRing\fR
Command-Line Switch:	\fB-defaultring\fR
.fi
.IP
Boolean describing whether the button displays its default ring given in 
any of the forms acceptable to \fBTcl_GetBoolean\fR.  The default is false.
.LP
.nf
Name:	\fBdefaultRingPad\fR
Class:	\fBPad\fR
Command-Line Switch:	\fB-defaultringpad\fR
.fi
.IP 
Specifies the amount of space to be allocated to the indentation of the
default ring ring given in any of the forms acceptable to \fBTcl_GetPixels\fR.
The option has no effect if the defaultring option is set to false.  The 
default is 2 pixels.
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB-height\fR
.fi
.IP
Specifies the height of the button inclusive of any default ring given in
any of the forms acceptable to \fBTk_GetPixels\fR.  A value of zero lets 
the push button determine the height based on the requested height plus 
highlightring and defaultringpad.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-width\fR
.fi
.IP
Specifies the width of the button inclusive of any default ring given in
any of the forms acceptable to \fBTk_GetPixels\fR.  A value of zero lets 
the push button determine the width based on the requested width plus 
highlightring and defaultringpad.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBiwidgets::pushbutton\fR command creates a push button with an 
optional default ring used for default designation and traversal.

.SH "METHODS"
.PP
The \fBiwidgets::pushbutton\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for pushbutton widgets:
.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBflash\fR	\fBinvoke\fR
.fi
.LP
See the "button" manual entry for details on the associated methods.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::pushbutton\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::pushbutton\fR
command.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBpushbutton\fR
Class:	\fBButton\fR
.fi
.IP
The pushbutton component is the button surrounded by the optional default ring.
See the "button" widget manual entry for details on the pushbutton
component item.
.fi

.SH EXAMPLE
.DS
package require Iwidgets 4.0
iwidgets::pushbutton .pb -text "Hello" -command {puts "Hello World"} -defaultring 1
pack .pb -padx 10 -pady 10
.DE
.SH AUTHOR
Bret A. Schuhmacher
.DE
Mark L. Ulferts
.SH KEYWORDS
pushbutton, widget
