SET DEFINE OFF
INSERT INTO role (roleid,name,type,readonly)
values ('1','User role','1','0')
/

INSERT INTO role (roleid,name,type,readonly)
values ('2','Admin role','2','0')
/

INSERT INTO role (roleid,name,type,readonly)
values ('3','Super admin role','3','1')
/

INSERT INTO role (roleid,name,type,readonly)
values ('4','Guest role','1','0')
/

INSERT INTO ugset (ugsetid,hash)
values ('1','b21d61561974b06cbeb97a71ca880e92f0fc06d49ac3246280afb88dfa6050a6')
/

INSERT INTO users (userid,username,name,surname,passwd,url,autologin,autologout,refresh,rows_per_page,roleid)
values ('1','Admin','Zabbix','Administrator','$2y$10$92nDno4n0Zm7Ej7Jfsz8WukBfgSS/U0QkIuu8WkJPihXBb2A1UrEK','','1','0','30s','50','3')
/

INSERT INTO users (userid,username,name,surname,passwd,url,autologin,autologout,refresh,rows_per_page,roleid)
values ('2','guest','','','$2y$10$89otZrRNmde97rIyzclecuk6LwKAsHN0BcvoOKGjbT.BwMBfm7G06','','0','15m','30s','50','4')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('1','Templates','0','7df96b18c230490a9a0a9e2307226338','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('2','Linux servers','0','dc579cd7a1a34222933f24f52a68bcd8','0')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('4','Zabbix servers','0','6f6799aa69e844b4b3918f779f2abf08','0')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('5','Discovered hosts','0','f2481361f99448eea617b7b1d4765566','0')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('6','Virtual machines','0','137f19e6e2dc4219b33553b812627bc2','0')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('7','Hypervisors','0','1b837a3c078647049a0c00c61b4d57b5','0')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('9','Templates/Network devices','0','36bff6c29af64692839d077febfc7079','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('10','Templates/Operating systems','0','846977d1dfed4968bc5f8bdb363285bc','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('11','Templates/Server hardware','0','e960332b3f6c46a1956486d4f3f99fce','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('12','Templates/Applications','0','a571c0d144b14fd4a87a9d9b2aa9fcd6','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('13','Templates/Databases','0','748ad4d098d447d492bb935c907f652f','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('14','Templates/Virtualization','0','02e4df4f20b848e79267641790f241da','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('15','Templates/Telephony','0','1d12408342854fd5a4436dd6d5d1bd4a','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('16','Templates/SAN','0','7c2cb727f85b492d88cd56e17127c64d','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('17','Templates/Video surveillance','0','d37f71c7e3f7469bab645852a69a2018','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('18','Templates/Power','0','3dcd5bbe90534f9e8eb5c2d53756af63','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('19','Applications','0','a571c0d144b14fd4a87a9d9b2aa9fcd6','0')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('20','Databases','0','748ad4d098d447d492bb935c907f652f','0')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('21','Templates/Cloud','0','c2c162144c2d4c5491c8801193af4945','1')
/

INSERT INTO drules (druleid,proxyid,name,iprange,delay,status,concurrency_max)
values ('2',NULL,'Local network','192.168.0.1-254','1h','1','0')
/

INSERT INTO dchecks (dcheckid,druleid,type,key_,snmp_community,ports,snmpv3_securityname,snmpv3_securitylevel,snmpv3_authpassphrase,snmpv3_privpassphrase,uniq,snmpv3_authprotocol,snmpv3_privprotocol,snmpv3_contextname,host_source,name_source,allow_redirect)
values ('2','2','9','system.uname','','10050','','0','','','0','0','0','','1','0','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('1','0','Email','mail.example.com','example.com','zabbix@example.com','','','','','25','0','0','0','0','1','3','10s','0','','30s','0','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('3','2','SMS','','','','','/dev/ttyS0','','','25','0','0','0','0','1','3','10s','1','','30s','0','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('4','0','Email (HTML)','mail.example.com','example.com','zabbix@example.com','','','','','25','0','0','0','0','1','3','10s','1','','30s','0','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('34','0','Gmail','smtp.gmail.com','example.com','zabbix@example.com','','','','','587','1','0','0','1','1','3','10s','1','','30s','0','0','','','','1')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('35','0','Gmail relay','smtp-relay.gmail.com','example.com','zabbix@example.com','','','','','587','1','0','0','0','1','3','10s','1','','30s','0','0','','','','2')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('36','0','Office365','smtp.office365.com','example.com','zabbix@example.com','','','','','587','1','0','0','1','1','3','10s','1','','30s','0','0','','','','3')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('37','0','Office365 relay','example-com.mail.protection.outlook.com','example.com','zabbix@example.com','','','','','25','1','0','0','0','1','3','10s','1','','30s','0','0','','','','4')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('38','4','Brevis.one','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var BrevisOne = {' || chr(13) || chr(10) || '    params: [],' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addParam: function (name, value) {' || chr(13) || chr(10) || '        BrevisOne.params.push(name + ''='' + encodeURIComponent(value));' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        BrevisOne.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setPayload: function (params) {' || chr(13) || chr(10) || '        var parts = params.send_to.split('':''),' || chr(13) || chr(10) || '            defaultValues = {' || chr(13) || chr(10) || '                ring: ''true'',' || chr(13) || chr(10) || '                flash: ''true'',' || chr(13) || chr(10) || '                telauto: ''false''' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        BrevisOne.addParam(''username'', params.username);' || chr(13) || chr(10) || '        BrevisOne.addParam(''password'', params.password);' || chr(13) || chr(10) || '        BrevisOne.addParam(''text'', params.text);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (parts.length > 1) {' || chr(13) || chr(10) || '            BrevisOne.addParam(''mode'', parts[0]);' || chr(13) || chr(10) || '            BrevisOne.addParam(''to'', parts[1]);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            BrevisOne.addParam(''to'', parts[0]);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Object.keys(defaultValues)' || chr(13) || chr(10) || '            .forEach(function (key) {' || chr(13) || chr(10) || '                if (params[key] && params[key].trim() && params[key].toLowerCase() === defaultValues[key]) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                    BrevisOne.addParam(key, defaultValues[key]);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function () {' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            data = ''?'' + BrevisOne.params.join(''&'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: multipart/form-data'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof BrevisOne.HTTPProxy !== ''undefined'' && BrevisOne.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(BrevisOne.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ BrevisOne Webhook ] Sending request.'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(params.endpoint + data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ BrevisOne Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response) {' || chr(13) || chr(10) || '                message += '': '' + response;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '    [''endpoint'', ''password'', ''username'', ''text'', ''send_to''].forEach(function (field) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'' || typeof params[field] === ''undefined''' || chr(13) || chr(10) || '                || !params[field].trim()) {' || chr(13) || chr(10) || '            throw ''Required parameter is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.send_to === ''{ALERT.SENDTO}'') {' || chr(13) || chr(10) || '        throw ''Required parameter is not set: "send_to".'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    BrevisOne.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    BrevisOne.setPayload(params);' || chr(13) || chr(10) || '    BrevisOne.request();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ BrevisOne Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('39','4','Discord','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('const CLogger = function(serviceName) {' || chr(13) || chr(10) || '	this.serviceName = serviceName;' || chr(13) || chr(10) || '	this.INFO = 4' || chr(13) || chr(10) || '	this.WARN = 3' || chr(13) || chr(10) || '	this.ERROR = 2' || chr(13) || chr(10) || '	this.log = function(level, msg) {' || chr(13) || chr(10) || '		Zabbix.log(level, ''['' + this.serviceName + ''] '' + msg);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhook = function(value) {' || chr(13) || chr(10) || '	try {' || chr(13) || chr(10) || '		params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''1'', ''2'', ''3'', ''4''].indexOf(params.event_source) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''.\nMust be 0-4.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1 && [''0'', ''1''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1) {' || chr(13) || chr(10) || '			if (params.event_source === ''1'' && [''0'', ''1'', ''2'', ''3''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0-3.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if (params.event_source === ''0'' && [''0'', ''1''].indexOf(params.event_update_status) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '			if (params.event_source === ''4'') {' || chr(13) || chr(10) || '				if ([''0'', ''1'', ''2'', ''3'', ''4'', ''5''].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {' || chr(13) || chr(10) || '					params.event_nseverity = params.event_update_nseverity;' || chr(13) || chr(10) || '					params.event_severity = params.event_update_severity;' || chr(13) || chr(10) || '					params.event_update_status = ''1'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.runCallback = function(name, params) {' || chr(13) || chr(10) || '			if (typeof this[name] === ''function'') {' || chr(13) || chr(10) || '				return this[name].apply(this, [params]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEvent = function(source, event) {' || chr(13) || chr(10) || '			const alert = { source: source, event: event };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''on'' + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEventless = function(source) {' || chr(13) || chr(10) || '			const alert = { source: source, event: null };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.run = function() {' || chr(13) || chr(10) || '			var results = [];' || chr(13) || chr(10) || '')||
TO_NCLOB('			if (typeof this.httpProxy === ''string'' && this.httpProxy.trim() !== '''') {' || chr(13) || chr(10) || '				this.request.setProxy(this.httpProxy);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			const types = { ''0'': ''Trigger'', ''1'': ''Discovery'', ''2'': ''Autoreg'', ''3'': ''Internal'', ''4'': ''Service'' };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if ([''0'', ''3'', ''4''].indexOf(this.params.event_source) !== -1) {' || chr(13) || chr(10) || '				var event = (this.params.event_update_status === ''1'')' || chr(13) || chr(10) || '					? ''Update''' || chr(13) || chr(10) || '					: ((this.params.event_value === ''1'') ? ''Problem'' : ''Resolve'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				results = this.handleEvent(types[this.params.event_source], event);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else if (typeof types[this.params.event_source] !== ''undefined'') {' || chr(13) || chr(10) || '				results = this.handleEventless(types[this.params.event_source]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				throw ''Unexpected "event_source": '' + this.params.event_source;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			for (idx in results) {' || chr(13) || chr(10) || '				if (typeof results[idx] !== ''undefined'') {' || chr(13) || chr(10) || '					return JSON.stringify(results[idx]);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.httpProxy = params.http_proxy;' || chr(13) || chr(10) || '		this.params = params;' || chr(13) || chr(10) || '		this.runCallback(''onCheckParams'', {});' || chr(13) || chr(10) || '	} catch (error) {' || chr(13) || chr(10) || '		throw ''Webhook processing failed: '' + error;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CParamValidator = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isType: function(value, type) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (type === ''array'') {' || chr(13) || chr(10) || '			return Array.isArray(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''integer'') {' || chr(13) || chr(10) || '			return CParamValidator.isInteger(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''float'') {' || chr(13) || chr(10) || '			return CParamValidator.isFloat(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (typeof value === type);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isInteger: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseInt(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isFloat: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+\.\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseFloat(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isDefined: function(value) {' || chr(13) || chr(10) || '		return !CParamValidator.isType(value, ''undefined'');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isEmpty: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be checked for emptiness.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (value.trim() === '''');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isMacroSet: function(value, macro) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (CParamValidator.isDefined(macro)) {' || chr(13) || chr(10) || '			return !(CParamValidator.ifMatch(value, ''^\{'' + macro + ''\}$''))' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !(CParamValidator.ifMatch(value, ''^\{[$#]{0,1}[A-Z_\.]+[\:]{0,1}["]{0,1}.*["]{0,1}\}$'') || value === ''*UNKNOWN*'')' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	withinRange: function(value, min, max) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''number'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a number to be checked for range.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (value < ((CParamValidator.isDefined(min)) ? min : value)' || chr(13) || chr(10) || '			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return true;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	inArray: function(value, array) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(array, ''array'')) {' || chr(13) || chr(10) || '			throw ''The array must be an array to check the value for existing in it.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (array.indexOf((typeof value === ''string'') ? value.toLowerCase() : value) !== -1);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	ifMatch: function(value, regex) {' || chr(13) || chr(10) || '		return (new RegExp(regex)).test(value);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	match: function(value, regex) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be matched with the regular expression.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '		return value.match(new RegExp(regex));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	checkURL: function(value) {' || chr(13) || chr(10) || '		if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must be a non-empty string.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, ''^(http|https):\/\/.+'')) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must contain a schema.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.endsWith(''/'') ? value.slice(0, -1) : value;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	check: function(key, rule, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(rule.type)) {' || chr(13) || chr(10) || '			throw ''Mandatory attribute "type" has not been defined for parameter "'' + key + ''".'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(params[key])) {' || chr(13) || chr(10) || '			throw ''Checked parameter "'' + key + ''" was not found in the list of input parameters.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		var value = params[key],' || chr(13) || chr(10) || '			error_message = null;' || chr(13) || chr(10) || '		switch (rule.type) {' || chr(13) || chr(10) || '			case ''string'':' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" must be a string.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a non-empty string'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '')||
TO_NCLOB('				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a string with a length > '' + rule.len;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must match the regular expression "'' + rule.regex + ''"'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.url) && rule.url === true) {' || chr(13) || chr(10) || '					value = CParamValidator.checkURL(value);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''integer'':' || chr(13) || chr(10) || '				if (!CParamValidator.isInteger(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an integer'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseInt(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''float'':' || chr(13) || chr(10) || '				if (!CParamValidator.isFloat(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a floating-point number'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseFloat(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''boolean'':' || chr(13) || chr(10) || '				if (CParamValidator.inArray(value, [''1'', ''true'', ''yes'', ''on''])) {' || chr(13) || chr(10) || '					value = true;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (CParamValidator.inArray(value, [''0'', ''false'', ''no'', ''off''])) {' || chr(13) || chr(10) || '					value = false;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a boolean-like.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''array'':' || chr(13) || chr(10) || '				try {' || chr(13) || chr(10) || '					value = JSON.parse(value);' || chr(13) || chr(10) || '				} catch (error) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" contains invalid JSON.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''array'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an array.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {' || chr(13) || chr(10) || '					value = value.reduce(function(acc, obj) {' || chr(13) || chr(10) || '						acc[obj.tag] = obj.value || null;' || chr(13) || chr(10) || '						return acc;' || chr(13) || chr(10) || '					}, {});' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''object'':' || chr(13) || chr(10) || '				value = JSON.parse(value);' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''object'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an object.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			default:' || chr(13) || chr(10) || '				throw ''Unexpected attribute type "'' + rule.type + ''" for value "'' + key + ''". Available: '' +' || chr(13) || chr(10) || '				[''integer'', ''float'', ''string'', ''boolean'', ''array'', ''object''].join('', '');' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		params[key] = value;' || chr(13) || chr(10) || '		if (CParamValidator.inArray(rule.type, [''integer'', ''float'']) && error_message === null && (CParamValidator.isDefined(rule.min)' || chr(13) || chr(10) || '			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			error_message = ''Value "'' + key + ''" must be a number '' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))' || chr(13) || chr(10) || '				? (rule.min + ''..'' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? ''>'' + rule.min : ''<'' + rule.max));' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be in the array '' + JSON.stringify(rule.array);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {' || chr(13) || chr(10) || '			error_message = ''The macro '' + ((CParamValidator.isDefined(rule.macro)) ? ''{'' + rule.macro + ''} '' : '' '') + ''is not set'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (error_message !== null) {' || chr(13) || chr(10) || '			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {' || chr(13) || chr(10) || '				params[key] = rule.default;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				Zabbix.log(4, ''Default value for "'' + key + ''" must be a '' + rule.type + ''. Skipped.'');' || chr(13) || chr(10) || '				throw ''Incorrect value for variable "'' + key + ''". '' + error_message;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return this;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	validate: function(rules, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(params, ''object'') || CParamValidator.isType(params, ''array'')) {' || chr(13) || chr(10) || '			throw ''Incorrect parameters value. The value must be an object.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		for (var key in rules) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			CParamValidator.check(key, rules[key], params);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CHttpRequest = function(logger) {' || chr(13) || chr(10) || '	this.request = new HttpRequest();' || chr(13) || chr(10) || '	if (typeof logger !== ''object'' || logger === null) {' || chr(13) || chr(10) || '		this.logger = Zabbix;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		this.logger = logger;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.clearHeader = function() {' || chr(13) || chr(10) || '		this.request.clearHeader();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.addHeaders = function(value) {' || chr(13) || chr(10) || '		var headers = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (typeof value === ''object'' && value !== null) {' || chr(13) || chr(10) || '			if (!Array.isArray(value)) {' || chr(13) || chr(10) || '				Object.keys(value).forEach(function(key) {' || chr(13) || chr(10) || '					headers.push(key + '': '' + value[key]);' || chr(13) || chr(10) || '				});' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				headers = value;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (typeof value === ''string'') {' || chr(13) || chr(10) || '			value.split(''\r\n'').forEach(function(header) {' || chr(13) || chr(10) || '				headers.push(header);' || chr(13) || chr(10) || '			});' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		for (var idx in headers) {' || chr(13) || chr(10) || '			this.request.addHeader(headers[idx]);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.setProxy = function(proxy) {' || chr(13) || chr(10) || '		this.request.setProxy(proxy);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '	this.plainRequest = function(method, url, data) {' || chr(13) || chr(10) || '		var resp = null;' || chr(13) || chr(10) || '		method = method.toLowerCase();' || chr(13) || chr(10) || '		this.logger.log(4, ''Sending '' + method + '' request:'' + JSON.stringify(data));' || chr(13) || chr(10) || '		if ([''get'', ''post'', ''put'', ''patch'', ''delete'', ''trace''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url, data);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if ([''connect'', ''head'', ''options''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unexpected method. Method '' + method + '' is not supported.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.logger.log(4, ''Response has been received: '' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.jsonRequest = function(method, url, data) {' || chr(13) || chr(10) || '		this.addHeaders(''Content-Type: application/json'');' || chr(13) || chr(10) || '		var resp = this.plainRequest(method, url, JSON.stringify(data));' || chr(13) || chr(10) || '		try {' || chr(13) || chr(10) || '			resp = JSON.parse(resp);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		catch (error) {' || chr(13) || chr(10) || '			throw ''Failed to parse response: not well-formed JSON was received'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.getStatus = function() {' || chr(13) || chr(10) || '		return this.request.getStatus();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('const CWebhookHelper = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {' || chr(13) || chr(10) || '		if (event_source === ''0'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/tr_events.php?triggerid='' + trigger_id + ''&eventid='' + event_id;' || chr(13) || chr(10) || '		} else if (event_source === ''4'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/zabbix.php?action=service.list'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return zabbix_url;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var SEVERITY_COLORS = [' || chr(13) || chr(10) || '	''#97AAB3'',' || chr(13) || chr(10) || '	''#7499FF'',' || chr(13) || chr(10) || '	''#FFC859'',' || chr(13) || chr(10) || '	''#FFA059'',' || chr(13) || chr(10) || '	''#E97659'',' || chr(13) || chr(10) || '	''#E45959'',' || chr(13) || chr(10) || '	''#009900''' || chr(13) || chr(10) || '],' || chr(13) || chr(10) || '	serviceLogName = ''Discord Webhook'',' || chr(13) || chr(10) || '	Logger = new CLogger(serviceLogName),' || chr(13) || chr(10) || '	Discord = CWebhook;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function stringTruncate(str, len) {' || chr(13) || chr(10) || '	return str.length > len ? str.substring(0, len - 3) + ''...'' : str;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Discord.prototype.onCheckParams = function () {' || chr(13) || chr(10) || '	CParamValidator.validate({discord_endpoint: {type: ''string'', url: true}, zabbix_url: {type: ''string'', url: true}, alert_message: {type: ''string''},' || chr(13) || chr(10) || '		alert_subject: {type: ''string''}, event_nseverity: {type: ''integer'', default: 1}, user_agent: {type: ''string''}}, this.params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('	this.params.discord_endpoint = this.params.discord_endpoint.replace(''/api/'', ''/api/v10/'') + ''?wait=True'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.event_source === ''3'' && this.params.event_value === ''1'') {' || chr(13) || chr(10) || '		this.params.event_nseverity = 4;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.event_value === ''0'') {' || chr(13) || chr(10) || '		this.params.event_nseverity = 6;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.event_source === ''0'') {' || chr(13) || chr(10) || '		CParamValidator.validate({event_id: {type: ''integer''}, trigger_id: {type: ''integer''}}, this.params);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.data = {' || chr(13) || chr(10) || '		embeds: [' || chr(13) || chr(10) || '			{' || chr(13) || chr(10) || '				color: parseInt(SEVERITY_COLORS[this.params.event_nseverity].replace(''#'', ''''), 16),' || chr(13) || chr(10) || '				url: CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id),' || chr(13) || chr(10) || '				title: stringTruncate(this.params.alert_subject, 256),' || chr(13) || chr(10) || '				description: stringTruncate(this.params.alert_message, 4096)' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		]' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Discord.prototype.onEvent = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.request.addHeaders({"User-Agent": this.params.user_agent});' || chr(13) || chr(10) || '	const response = this.request.jsonRequest(''POST'', this.params.discord_endpoint, this.data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (!response.id) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		const error_message = CParamValidator.isType(response.message, ''string'') ? response.message : ''Unknown error'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		throw error_message + ''. For more details check the Zabbix server log.'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return ''OK'';' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '	var hook = new Discord(value);' || chr(13) || chr(10) || '	hook.request = new CHttpRequest(Logger);' || chr(13) || chr(10) || '	return hook.run();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '	Logger.log(Logger.WARN, ''notification failed: '' + error);' || chr(13) || chr(10) || '	throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','',TO_NCLOB('This media type integrates your Zabbix installation with your Discord server using the Zabbix webhook feature.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Discord configuration:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Go to `https://discord.com/app` or open the Discord desktop application. Open your *Server Settings* and head to the *Integrations* tab.  ' || chr(13) || chr(10) || '2. Press the *Create Webhook* button to create a new webhook.' || chr(13) || chr(10) || '3. Click on the webhook that has been created and edit the details if needed.' || chr(13) || chr(10) || '4. After setting up your Discord webhook press "Save Changes". Now you can copy Discord webhook URL now by pressing "Copy Webhook URL" or you can view it later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Zabbix configuration:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Before you can start using Discord webhook, set up the global macro "{$ZABBIX.URL}":' || chr(13) || chr(10) || '- In the Zabbix web interface, go to "Administration" → "Macros" section in the dropdown menu in the top left corner.' || chr(13) || chr(10) || '- Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend. The URL should be either an IP address, a fully qualified domain name, or localhost.' || chr(13) || chr(10) || '- Specifying a protocol is mandatory, whereas the port is optional. Depending on the web server configuration you might also need to append "/zabbix" to the end of URL. Good examples: ' || chr(13) || chr(10) || '  - http://zabbix.com' || chr(13) || chr(10) || '  - https://zabbix.lan/zabbix' || chr(13) || chr(10) || '  - http://server.zabbix.lan/' || chr(13) || chr(10) || '  - http://localhost' || chr(13) || chr(10) || '  - http://127.0.0.1:8080' || chr(13) || chr(10) || '- Bad examples:' || chr(13) || chr(10) || '  - zabbix.com' || chr(13) || chr(10) || '  - http://zabbix/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('2. Create a Zabbix user and add media:' || chr(13) || chr(10) || '- If you want to create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks). ' || chr(13) || chr(10) || '- In the "Media" tab, add a new media and select "Discord" type from the drop-down list. The "Send to" field must contain the URL of the Discord webhook created before.' || chr(13) || chr(10) || '- Make sure this user has access to all hosts for which you would like problem notifications to be sent to Discord.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. Great! You can now start using this media type in actions and receive alerts!' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can find the latest version of this media and additional information in the official Zabbix repository:' || chr(13) || chr(10) || '')||
TO_NCLOB('https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/discord'),'0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('40','4','Event-Driven Ansible','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Eda = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        var required_params = [' || chr(13) || chr(10) || '                ''send_to'',' || chr(13) || chr(10) || '                ''event_source'',' || chr(13) || chr(10) || '                ''event_value'',' || chr(13) || chr(10) || '                ''event_date'',' || chr(13) || chr(10) || '                ''event_time''],' || chr(13) || chr(10) || '            integer_fields = [' || chr(13) || chr(10) || '                ''event_id'',' || chr(13) || chr(10) || '                ''event_nseverity'',' || chr(13) || chr(10) || '                ''event_object'',' || chr(13) || chr(10) || '                ''event_source'',' || chr(13) || chr(10) || '                ''event_value'',' || chr(13) || chr(10) || '                ''host_id'',' || chr(13) || chr(10) || '                ''trigger_id''];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        required_params.forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof params !== ''object'' || typeof params[field] === ''undefined'' || params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Eda.params = params;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        integer_fields.forEach(function (key) {' || chr(13) || chr(10) || '                if (typeof Eda.params[key] !== ''undefined'') {' || chr(13) || chr(10) || '                    if (isNaN(Eda.params[key])) {' || chr(13) || chr(10) || '                        throw ''Parameter "'' + key + ''" must be integer. Given value: '' + Eda.params[key];' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '')||
TO_NCLOB('                    Eda.params[key] = parseInt(Eda.params[key]);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        // Check type of event. Possible values: 0 - Trigger' || chr(13) || chr(10) || '        if (params.event_source != 0) {' || chr(13) || chr(10) || '            throw (''Incorrect "event_source" parameter given: '' + params.event_source ' || chr(13) || chr(10) || '                + ''\nOnly trigger-based events are supported'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        // Check trigger update and trigger resolve events' || chr(13) || chr(10) || '        if (params.event_source == 0 && params.event_value != 1) {' || chr(13) || chr(10) || '            throw (''Incorrect "event_value" parameter given: "'' + params.event_value ' || chr(13) || chr(10) || '                + ''".\nOnly trigger-based events of problem are supported'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        ' || chr(13) || chr(10) || '        // Check endpoint' || chr(13) || chr(10) || '        Eda.params.endpoint = (Eda.params.endpoint.startsWith(''/''))' || chr(13) || chr(10) || '                ? Eda.params.endpoint : ''/'' + Eda.params.endpoint;' || chr(13) || chr(10) || '        // Prepare groups' || chr(13) || chr(10) || '        Eda.params.host_groups = (typeof Eda.params[''host_groups''] !== ''undefined'')' || chr(13) || chr(10) || '                ? this.prepareHostgroups(Eda.params.host_groups): []' || chr(13) || chr(10) || '        // Prepare tags' || chr(13) || chr(10) || '        Eda.params.event_tags = (typeof Eda.params[''event_tags''] !== ''undefined'')' || chr(13) || chr(10) || '                ? this.transformTags(Eda.params.event_tags): {}' || chr(13) || chr(10) || '        // Prepare timestamp' || chr(13) || chr(10) || '        Eda.params.event_datetime_timestamp = this.getTimestamp(' || chr(13) || chr(10) || '            Eda.params.event_date, Eda.params.event_time)' || chr(13) || chr(10) || '')||
TO_NCLOB('    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Eda.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    prepareHostgroups: function (hostgroups) {' || chr(13) || chr(10) || '        var host_groups = []; ' || chr(13) || chr(10) || '        hostgroups.split('','').forEach(function (group) {' || chr(13) || chr(10) || '            group = group.trim();' || chr(13) || chr(10) || '            if (group.length > 0) {' || chr(13) || chr(10) || '                host_groups.push(group);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '        return host_groups;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getTimestamp: function (date, time) {' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            return Date.parse(date.split(''.'').join(''-'') + ''T'' + time + ''.000Z'') / 1000 + new Date().getTimezoneOffset() * 60;' || chr(13) || chr(10) || '        } catch (_) {}' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '        throw (''Failed to parse event time.'');' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    transformTags: function (event_tags) {' || chr(13) || chr(10) || '        var tags = {};' || chr(13) || chr(10) || '        if (event_tags) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                JSON.parse(event_tags).forEach(function (object) {' || chr(13) || chr(10) || '                    var tag = object[''tag''];' || chr(13) || chr(10) || '                    tags[tag] = tags[tag] || [];' || chr(13) || chr(10) || '                    tags[tag].push(object[''value'']);' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '            } catch (error) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                throw ''Event tags format is invalid.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '        return tags;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    sendMessage: function () {' || chr(13) || chr(10) || '        var response, request = new HttpRequest();' || chr(13) || chr(10) || '        var url = Eda.params[''send_to''] + Eda.params[''endpoint''];' || chr(13) || chr(10) || '        var data = JSON.stringify(Eda.params);' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Event-Driven Ansible webhook ] URL: '' + url + '' data: '' + data);' || chr(13) || chr(10) || '        ' || chr(13) || chr(10) || '        if (typeof Eda.HTTPProxy !== ''undefined'' && Eda.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Eda.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        response = request.post(url, data);' || chr(13) || chr(10) || '        ' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Event-Driven Ansible webhook ] HTTP code: '' + request.getStatus()' || chr(13) || chr(10) || '            + '' response: '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() !== 200) {' || chr(13) || chr(10) || '            throw ''Request failed with status code '' + request.getStatus() + '': '' + response;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '    Eda.setParams(params);' || chr(13) || chr(10) || '    Eda.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    Eda.sendMessage();' || chr(13) || chr(10) || '    return true;' || chr(13) || chr(10) || '')||
TO_NCLOB('}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Event-Driven Ansible webhook ] notification failed: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('41','4','Express.ms','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Express = {' || chr(13) || chr(10) || '    params: [],' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Express.params = params;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Express.params.url === ''string'' && !Express.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '            Express.params.url += ''/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Express.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (query, data) {' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Express.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Bearer '' + Express.params.token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Express.HTTPProxy !== ''undefined'' && Express.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Express.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Express Webhook ] Sending request: '' + url +' || chr(13) || chr(10) || '')||
TO_NCLOB('            ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(url, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Express Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Express Webhook ] Failed to parse response received from Express'');' || chr(13) || chr(10) || '                response = {};' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response.status !== ''ok'') {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (typeof response.reason !== ''undefined'') {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.reason);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response.result;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    postMessage: function (is_problem) {' || chr(13) || chr(10) || '        var data,' || chr(13) || chr(10) || '            url,' || chr(13) || chr(10) || '            result = {tags: {}},' || chr(13) || chr(10) || '            response;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (is_problem) {' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                group_chat_id: Express.params.send_to,' || chr(13) || chr(10) || '                notification: {' || chr(13) || chr(10) || '                    status: ''ok'',' || chr(13) || chr(10) || '                    body: Express.params.message' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '            url = ''api/v4/botx/notifications/direct'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                reply: {' || chr(13) || chr(10) || '                    status: ''ok'',' || chr(13) || chr(10) || '                    body: Express.params.message' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '            url = ''api/v3/botx/events/reply_event'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                var tags = JSON.parse(Express.params.tags);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                throw ''Value of "express_tags" is not JSON. Value: '' + Express.params.tags + ''.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            tags.forEach(function(tag) {' || chr(13) || chr(10) || '                if (tag.tag === ''__zbx_ex_sync_id_'' + Express.params.send_to) {' || chr(13) || chr(10) || '                    data.source_sync_id = tag.value;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (!data.source_sync_id) {' || chr(13) || chr(10) || '                throw ''Cannot update data. sync_id for the provided sender is unknown.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = Express.request(url, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (is_problem && response.sync_id) {' || chr(13) || chr(10) || '            result.tags[''__zbx_ex_sync_id_'' + Express.params.send_to] = response.sync_id;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            return JSON.stringify(result);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            return ''OK'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        express = {},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''express_url'', ''express_send_to'', ''express_message'', ''express_tags'', ''express_token'',' || chr(13) || chr(10) || '            ''event_source'', ''event_value'', ''event_update_status''' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''express_'')) {' || chr(13) || chr(10) || '                express[key.substring(8)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (required_params.indexOf(key) !== -1' || chr(13) || chr(10) || '                    && (params[key].trim() === '''' || params[key] === ''{ALERT.SENDTO}'')) {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Forcing event_value and event_update_status for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' ) {' || chr(13) || chr(10) || '        params.event_value = ''1'';' || chr(13) || chr(10) || '        params.event_update_status = ''0'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Express.setParams(express);' || chr(13) || chr(10) || '    Express.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return Express.postMessage(params.event_value === ''1'' && params.event_update_status === ''0'');' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Express Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('42','4','GitHub','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('const CLogger = function(serviceName) {' || chr(13) || chr(10) || '	this.serviceName = serviceName;' || chr(13) || chr(10) || '	this.INFO = 4' || chr(13) || chr(10) || '	this.WARN = 3' || chr(13) || chr(10) || '	this.ERROR = 2' || chr(13) || chr(10) || '	this.log = function(level, msg) {' || chr(13) || chr(10) || '		Zabbix.log(level, ''['' + this.serviceName + ''] '' + msg);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhook = function(value) {' || chr(13) || chr(10) || '	try {' || chr(13) || chr(10) || '		params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''1'', ''2'', ''3'', ''4''].indexOf(params.event_source) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''.\nMust be 0-4.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1 && [''0'', ''1''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1) {' || chr(13) || chr(10) || '			if (params.event_source === ''1'' && [''0'', ''1'', ''2'', ''3''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0-3.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if (params.event_source === ''0'' && [''0'', ''1''].indexOf(params.event_update_status) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '			if (params.event_source === ''4'') {' || chr(13) || chr(10) || '				if ([''0'', ''1'', ''2'', ''3'', ''4'', ''5''].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {' || chr(13) || chr(10) || '					params.event_nseverity = params.event_update_nseverity;' || chr(13) || chr(10) || '					params.event_severity = params.event_update_severity;' || chr(13) || chr(10) || '					params.event_update_status = ''1'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.runCallback = function(name, params) {' || chr(13) || chr(10) || '			if (typeof this[name] === ''function'') {' || chr(13) || chr(10) || '				return this[name].apply(this, [params]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEvent = function(source, event) {' || chr(13) || chr(10) || '			const alert = { source: source, event: event };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''on'' + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEventless = function(source) {' || chr(13) || chr(10) || '			const alert = { source: source, event: null };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.run = function() {' || chr(13) || chr(10) || '			var results = [];' || chr(13) || chr(10) || '')||
TO_NCLOB('			if (typeof this.httpProxy === ''string'' && this.httpProxy.trim() !== '''') {' || chr(13) || chr(10) || '				this.request.setProxy(this.httpProxy);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			const types = { ''0'': ''Trigger'', ''1'': ''Discovery'', ''2'': ''Autoreg'', ''3'': ''Internal'', ''4'': ''Service'' };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if ([''0'', ''3'', ''4''].indexOf(this.params.event_source) !== -1) {' || chr(13) || chr(10) || '				var event = (this.params.event_update_status === ''1'')' || chr(13) || chr(10) || '					? ''Update''' || chr(13) || chr(10) || '					: ((this.params.event_value === ''1'') ? ''Problem'' : ''Resolve'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				results = this.handleEvent(types[this.params.event_source], event);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else if (typeof types[this.params.event_source] !== ''undefined'') {' || chr(13) || chr(10) || '				results = this.handleEventless(types[this.params.event_source]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				throw ''Unexpected "event_source": '' + this.params.event_source;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			for (idx in results) {' || chr(13) || chr(10) || '				if (typeof results[idx] !== ''undefined'') {' || chr(13) || chr(10) || '					return JSON.stringify(results[idx]);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.httpProxy = params.http_proxy;' || chr(13) || chr(10) || '		this.params = params;' || chr(13) || chr(10) || '		this.runCallback(''onCheckParams'', {});' || chr(13) || chr(10) || '	} catch (error) {' || chr(13) || chr(10) || '		throw ''Webhook processing failed: '' + error;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CParamValidator = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isType: function(value, type) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (type === ''array'') {' || chr(13) || chr(10) || '			return Array.isArray(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''integer'') {' || chr(13) || chr(10) || '			return CParamValidator.isInteger(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''float'') {' || chr(13) || chr(10) || '			return CParamValidator.isFloat(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (typeof value === type);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isInteger: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseInt(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isFloat: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+\.\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseFloat(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isDefined: function(value) {' || chr(13) || chr(10) || '		return !CParamValidator.isType(value, ''undefined'');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isEmpty: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be checked for emptiness.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (value.trim() === '''');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isMacroSet: function(value, macro) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (CParamValidator.isDefined(macro)) {' || chr(13) || chr(10) || '			return !(CParamValidator.ifMatch(value, ''^\{'' + macro + ''\}$''))' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !(CParamValidator.ifMatch(value, ''^\{[$#]{0,1}[A-Z_\.]+[\:]{0,1}["]{0,1}.*["]{0,1}\}$'') || value === ''*UNKNOWN*'')' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	withinRange: function(value, min, max) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''number'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a number to be checked for range.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (value < ((CParamValidator.isDefined(min)) ? min : value)' || chr(13) || chr(10) || '			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return true;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	inArray: function(value, array) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(array, ''array'')) {' || chr(13) || chr(10) || '			throw ''The array must be an array to check the value for existing in it.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (array.indexOf((typeof value === ''string'') ? value.toLowerCase() : value) !== -1);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	ifMatch: function(value, regex) {' || chr(13) || chr(10) || '		return (new RegExp(regex)).test(value);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	match: function(value, regex) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be matched with the regular expression.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '		return value.match(new RegExp(regex));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	checkURL: function(value) {' || chr(13) || chr(10) || '		if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must be a non-empty string.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, ''^(http|https):\/\/.+'')) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must contain a schema.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.endsWith(''/'') ? value.slice(0, -1) : value;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	check: function(key, rule, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(rule.type)) {' || chr(13) || chr(10) || '			throw ''Mandatory attribute "type" has not been defined for parameter "'' + key + ''".'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(params[key])) {' || chr(13) || chr(10) || '			throw ''Checked parameter "'' + key + ''" was not found in the list of input parameters.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		var value = params[key],' || chr(13) || chr(10) || '			error_message = null;' || chr(13) || chr(10) || '		switch (rule.type) {' || chr(13) || chr(10) || '			case ''string'':' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" must be a string.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a non-empty string'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '')||
TO_NCLOB('				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a string with a length > '' + rule.len;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must match the regular expression "'' + rule.regex + ''"'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.url) && rule.url === true) {' || chr(13) || chr(10) || '					value = CParamValidator.checkURL(value);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''integer'':' || chr(13) || chr(10) || '				if (!CParamValidator.isInteger(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an integer'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseInt(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''float'':' || chr(13) || chr(10) || '				if (!CParamValidator.isFloat(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a floating-point number'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseFloat(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''boolean'':' || chr(13) || chr(10) || '				if (CParamValidator.inArray(value, [''1'', ''true'', ''yes'', ''on''])) {' || chr(13) || chr(10) || '					value = true;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (CParamValidator.inArray(value, [''0'', ''false'', ''no'', ''off''])) {' || chr(13) || chr(10) || '					value = false;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a boolean-like.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''array'':' || chr(13) || chr(10) || '				try {' || chr(13) || chr(10) || '					value = JSON.parse(value);' || chr(13) || chr(10) || '				} catch (error) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" contains invalid JSON.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''array'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an array.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {' || chr(13) || chr(10) || '					value = value.reduce(function(acc, obj) {' || chr(13) || chr(10) || '						acc[obj.tag] = obj.value || null;' || chr(13) || chr(10) || '						return acc;' || chr(13) || chr(10) || '					}, {});' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''object'':' || chr(13) || chr(10) || '				value = JSON.parse(value);' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''object'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an object.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			default:' || chr(13) || chr(10) || '				throw ''Unexpected attribute type "'' + rule.type + ''" for value "'' + key + ''". Available: '' +' || chr(13) || chr(10) || '				[''integer'', ''float'', ''string'', ''boolean'', ''array'', ''object''].join('', '');' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		params[key] = value;' || chr(13) || chr(10) || '		if (CParamValidator.inArray(rule.type, [''integer'', ''float'']) && error_message === null && (CParamValidator.isDefined(rule.min)' || chr(13) || chr(10) || '			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			error_message = ''Value "'' + key + ''" must be a number '' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))' || chr(13) || chr(10) || '				? (rule.min + ''..'' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? ''>'' + rule.min : ''<'' + rule.max));' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be in the array '' + JSON.stringify(rule.array);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {' || chr(13) || chr(10) || '			error_message = ''The macro '' + ((CParamValidator.isDefined(rule.macro)) ? ''{'' + rule.macro + ''} '' : '' '') + ''is not set'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (error_message !== null) {' || chr(13) || chr(10) || '			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {' || chr(13) || chr(10) || '				params[key] = rule.default;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				Zabbix.log(4, ''Default value for "'' + key + ''" must be a '' + rule.type + ''. Skipped.'');' || chr(13) || chr(10) || '				throw ''Incorrect value for variable "'' + key + ''". '' + error_message;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return this;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	validate: function(rules, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(params, ''object'') || CParamValidator.isType(params, ''array'')) {' || chr(13) || chr(10) || '			throw ''Incorrect parameters value. The value must be an object.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		for (var key in rules) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			CParamValidator.check(key, rules[key], params);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CHttpRequest = function(logger) {' || chr(13) || chr(10) || '	this.request = new HttpRequest();' || chr(13) || chr(10) || '	if (typeof logger !== ''object'' || logger === null) {' || chr(13) || chr(10) || '		this.logger = Zabbix;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		this.logger = logger;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.clearHeader = function() {' || chr(13) || chr(10) || '		this.request.clearHeader();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.addHeaders = function(value) {' || chr(13) || chr(10) || '		var headers = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (typeof value === ''object'' && value !== null) {' || chr(13) || chr(10) || '			if (!Array.isArray(value)) {' || chr(13) || chr(10) || '				Object.keys(value).forEach(function(key) {' || chr(13) || chr(10) || '					headers.push(key + '': '' + value[key]);' || chr(13) || chr(10) || '				});' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				headers = value;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (typeof value === ''string'') {' || chr(13) || chr(10) || '			value.split(''\r\n'').forEach(function(header) {' || chr(13) || chr(10) || '				headers.push(header);' || chr(13) || chr(10) || '			});' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		for (var idx in headers) {' || chr(13) || chr(10) || '			this.request.addHeader(headers[idx]);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.setProxy = function(proxy) {' || chr(13) || chr(10) || '		this.request.setProxy(proxy);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '	this.plainRequest = function(method, url, data) {' || chr(13) || chr(10) || '		var resp = null;' || chr(13) || chr(10) || '		method = method.toLowerCase();' || chr(13) || chr(10) || '		this.logger.log(4, ''Sending '' + method + '' request:'' + JSON.stringify(data));' || chr(13) || chr(10) || '		if ([''get'', ''post'', ''put'', ''patch'', ''delete'', ''trace''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url, data);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if ([''connect'', ''head'', ''options''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unexpected method. Method '' + method + '' is not supported.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.logger.log(4, ''Response has been received: '' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.jsonRequest = function(method, url, data) {' || chr(13) || chr(10) || '		this.addHeaders(''Content-Type: application/json'');' || chr(13) || chr(10) || '		var resp = this.plainRequest(method, url, JSON.stringify(data));' || chr(13) || chr(10) || '		try {' || chr(13) || chr(10) || '			resp = JSON.parse(resp);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		catch (error) {' || chr(13) || chr(10) || '			throw ''Failed to parse response: not well-formed JSON was received'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.getStatus = function() {' || chr(13) || chr(10) || '		return this.request.getStatus();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('const CWebhookHelper = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {' || chr(13) || chr(10) || '		if (event_source === ''0'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/tr_events.php?triggerid='' + trigger_id + ''&eventid='' + event_id;' || chr(13) || chr(10) || '		} else if (event_source === ''4'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/zabbix.php?action=service.list'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return zabbix_url;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var serviceLogName = ''GitHub Webhook'',' || chr(13) || chr(10) || '	Logger = new CLogger(serviceLogName),' || chr(13) || chr(10) || '	GitHub = CWebhook;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GitHub.prototype.onCheckParams = function () {' || chr(13) || chr(10) || '	CParamValidator.validate({' || chr(13) || chr(10) || '		alert_message: {type: ''string''},' || chr(13) || chr(10) || '		alert_subject: {type: ''string''},' || chr(13) || chr(10) || '		github_api_version: {type: ''string''},' || chr(13) || chr(10) || '		github_repo: {type: ''string''},' || chr(13) || chr(10) || '		github_token: {type: ''string''},' || chr(13) || chr(10) || '		github_url: {type: ''string'', url: true},' || chr(13) || chr(10) || '		github_user_agent: {type: ''string''},' || chr(13) || chr(10) || '		github_zabbix_event_priority_label_prefix: {type: ''string'', default: ''Zabbix Event Priority: ''},' || chr(13) || chr(10) || '		github_zabbix_event_source_label_prefix: {type: ''string'', default: ''Zabbix Event Source: ''},' || chr(13) || chr(10) || '		github_zabbix_event_status_label_prefix: {type: ''string'', default: ''Zabbix Event Status: ''},' || chr(13) || chr(10) || '		github_zabbix_generic_label: {type: ''string'', default: ''Zabbix GitHub Webhook''},' || chr(13) || chr(10) || '')||
TO_NCLOB('		zabbix_url: {type: ''string'', url: true}' || chr(13) || chr(10) || '	}, this.params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.request_headers = {' || chr(13) || chr(10) || '		''User-Agent'': this.params.github_user_agent,' || chr(13) || chr(10) || '		''Accept'': ''application/vnd.github+json'',' || chr(13) || chr(10) || '		''X-GitHub-Api-Version'': this.params.github_api_version,' || chr(13) || chr(10) || '		''Authorization'': ''Bearer '' + this.params.github_token' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.payload_data = {' || chr(13) || chr(10) || '		title: this.params.alert_subject,' || chr(13) || chr(10) || '		labels: [' || chr(13) || chr(10) || '			{' || chr(13) || chr(10) || '				name: this.params.github_zabbix_generic_label' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		]' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.result = {tags: {}};' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function checkResponse(response, received_code, required_code, response_field, error_message) {' || chr(13) || chr(10) || '	if (received_code != required_code || !CParamValidator.isDefined(response[response_field])) {' || chr(13) || chr(10) || '		var message = error_message + '' Request failed with status code '' + received_code;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (CParamValidator.isDefined(response.message) && Object.keys(response.message).length > 0) {' || chr(13) || chr(10) || '			message += '': '' + response.message;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GitHub.prototype.createIssue = function () {' || chr(13) || chr(10) || '')||
TO_NCLOB('	this.payload_data.body = this.params.alert_message + ''\n'' + CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.request.addHeaders(this.request_headers);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	const response = this.request.jsonRequest(''POST'', this.params.github_url + ''/repos/'' + this.params.github_repo + ''/issues'', this.payload_data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	checkResponse(response, this.request.getStatus(), 201, ''number'', ''Cannot create GitHub issue.'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return response;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GitHub.prototype.updateIssue = function () {' || chr(13) || chr(10) || '	this.request.addHeaders(this.request_headers);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	const response = this.request.jsonRequest(''PATCH'', this.params.github_url + ''/repos/'' + this.params.github_repo + ''/issues/'' + this.params.github_issue_number, this.payload_data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	checkResponse(response, this.request.getStatus(), 200, ''number'', ''Cannot update GitHub issue.'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return response;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GitHub.prototype.addIssueComment = function () {' || chr(13) || chr(10) || '	this.payload_data = {' || chr(13) || chr(10) || '		body: this.params.alert_message' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.request.addHeaders(this.request_headers);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	const response = this.request.jsonRequest(''POST'', this.params.github_url + ''/repos/'' + this.params.github_repo + ''/issues/'' + this.params.github_issue_number + ''/comments'', this.payload_data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('	checkResponse(response, this.request.getStatus(), 201, ''id'', ''Cannot add comment for GitHub issue.'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return response;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GitHub.prototype.onProblem = function (alert) {' || chr(13) || chr(10) || '	if (CParamValidator.isMacroSet(this.params.github_issue_number)) {' || chr(13) || chr(10) || '		return this.onUpdate(alert);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.event_source === ''0'') {' || chr(13) || chr(10) || '		CParamValidator.validate({event_id: {type: ''integer''}, trigger_id: {type: ''integer''}}, this.params);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.payload_data.labels.push({name: this.params.github_zabbix_event_source_label_prefix + alert.source});' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.payload_data.labels.push({name: this.params.github_zabbix_event_status_label_prefix + ''Problem''});' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (!CParamValidator.isEmpty(this.params.event_severity) && CParamValidator.isMacroSet(this.params.event_severity, ''EVENT.SEVERITY'')) {' || chr(13) || chr(10) || '		this.payload_data.labels.push({name: this.params.github_zabbix_event_priority_label_prefix + this.params.event_severity});' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	const response = this.createIssue();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.result.tags = {' || chr(13) || chr(10) || '		__zbx_github_issue_number: response.number,' || chr(13) || chr(10) || '		__zbx_github_repo: this.params.github_repo,' || chr(13) || chr(10) || '		__zbx_github_link: response.html_url' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '')||
TO_NCLOB('}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GitHub.prototype.onUpdate = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (!CParamValidator.isMacroSet(this.params.github_issue_number)) {' || chr(13) || chr(10) || '		throw "Failed to update the existing issue: no issue number was received."' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.payload_data.labels.push({name: this.params.github_zabbix_event_source_label_prefix + alert.source});' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.event_value === ''0'') {' || chr(13) || chr(10) || '		this.payload_data.labels.push({name: this.params.github_zabbix_event_status_label_prefix + ''Resolved''});' || chr(13) || chr(10) || '	} else {' || chr(13) || chr(10) || '		this.payload_data.labels.push({name: this.params.github_zabbix_event_status_label_prefix + ''Problem''});' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (!CParamValidator.isEmpty(this.params.event_severity) && CParamValidator.isMacroSet(this.params.event_severity, ''EVENT.SEVERITY'')) {' || chr(13) || chr(10) || '		this.payload_data.labels.push({name: this.params.github_zabbix_event_priority_label_prefix + this.params.event_severity});' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.updateIssue();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.request.clearHeader();' || chr(13) || chr(10) || '	this.addIssueComment();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GitHub.prototype.onResolve = function (alert) {' || chr(13) || chr(10) || '	return this.onUpdate(alert);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('GitHub.prototype.onDiscovery = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.payload_data.labels.push({name: this.params.github_zabbix_event_source_label_prefix + alert.source});' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.createIssue();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GitHub.prototype.onAutoreg = function (alert) {' || chr(13) || chr(10) || '	return this.onDiscovery(alert);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '	var hook = new GitHub(value);' || chr(13) || chr(10) || '	hook.request = new CHttpRequest(Logger);' || chr(13) || chr(10) || '	return hook.run();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '	Logger.log(Logger.WARN, ''notification failed: '' + error);' || chr(13) || chr(10) || '	throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_github_link}','Github: Issue {EVENT.TAGS.__zbx_github_issue_number}',TO_NCLOB('This media type integrates your Zabbix installation with GitHub using the Zabbix webhook feature.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GitHub configuration:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Create an access token.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'One of the simplest ways to send authenticated requests is to use a personal access token - either a classic or a fine-grained one:' || chr(13) || chr(10) || 'https://docs.github.com/en/rest/authentication/authenticating-to-the-rest-api?apiVersion=2022-11-28#authenticating-with-a-personal-access-token' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Classic personal access token' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can create a new classic personal access token by following the instructions in the official documentation:' || chr(13) || chr(10) || 'https://docs.github.com/en/authentication/keeping-your-account-and-data-secure/managing-your-personal-access-tokens#creating-a-personal-access-token-classic' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The token user must have a permission to create issues and issue comments in the desired repositories. For webhook to work on private repositories, the "repo" scope must be set in token settings to have full control of private repositories.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Additional information about OAuth scopes is available in the official documentation:' || chr(13) || chr(10) || 'https://docs.github.com/en/apps/oauth-apps/building-oauth-apps/scopes-for-oauth-apps#available-scopes' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Fine-grained personal access token' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Alternatively, you can use a fine-grained personal access token:' || chr(13) || chr(10) || 'https://docs.github.com/en/authentication/keeping-your-account-and-data-secure/managing-your-personal-access-tokens#creating-a-fine-grained-personal-access-token' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || 'In order to use fine-grained tokens to monitor organization-owned repositories, organizations must opt in to fine-grained personal access tokens and set up a personal access token policy:' || chr(13) || chr(10) || 'https://docs.github.com/en/organizations/managing-programmatic-access-to-your-organization/setting-a-personal-access-token-policy-for-your-organization' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The fine-grained token needs to have the following permission set to provide access to the repository issues:' || chr(13) || chr(10) || '- "Issues" repository permissions (write)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Copy and save the created token somewhere, as it will be shown only once for security reasons.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Zabbix configuration:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Before you can start using Zammad webhook, set up the global macro "{$ZABBIX.URL}":' || chr(13) || chr(10) || '- In the Zabbix web interface, go to "Administration" → "Macros" section in the dropdown menu in the top left corner.' || chr(13) || chr(10) || '- Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend. The URL should be either an IP address, a fully qualified domain name, or localhost.' || chr(13) || chr(10) || '- Specifying a protocol is mandatory, whereas the port is optional. Depending on the web server configuration you might also need to append "/zabbix" to the end of URL. Good examples:' || chr(13) || chr(10) || '  - http://zabbix.com' || chr(13) || chr(10) || '  - https://zabbix.lan/zabbix' || chr(13) || chr(10) || '  - http://server.zabbix.lan/' || chr(13) || chr(10) || '  - http://localhost' || chr(13) || chr(10) || '  - http://127.0.0.1:8080' || chr(13) || chr(10) || '- Bad examples:' || chr(13) || chr(10) || '  - zabbix.com' || chr(13) || chr(10) || '  - http://zabbix/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('2. Set the "github_token" webhook parameter value to the access token that you created previously.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can also adjust the issue labels created by the webhook in the following parameters:' || chr(13) || chr(10) || '- github_zabbix_event_priority_label_prefix - the prefix for the issue label that displays the Zabbix event priority in the supported event sources. It is set to "Zabbix Event Priority: " by default.' || chr(13) || chr(10) || '- github_zabbix_event_source_label_prefix - the prefix for the issue label that displays the Zabbix event source. It is set to "Zabbix Event Source: " by default.' || chr(13) || chr(10) || '- github_zabbix_event_status_label_prefix - the prefix for the issue label that displays the Zabbix event status. It is set to "Zabbix Event Status: " by default.' || chr(13) || chr(10) || '- github_zabbix_generic_label - the label that is added to all issues created by the webhook. It is set to "Zabbix GitHub Webhook" by default.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Note that the webhook will reuse the labels with the same name that already exist in the repository (including the color, so it can changed from the default value for new labels in GitHub, if needed). Also, the labels are replaced when the issue is updated, so any user-added labels will be removed.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '4. Create a Zabbix user and add media:' || chr(13) || chr(10) || '- If you want to create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks).' || chr(13) || chr(10) || '- In the "Media" tab, add a new media and select "Zammad" type from the drop-down list. In field "Send to" specify the full repo name (owner/project name) e.g. johndoe/example-project.' || chr(13) || chr(10) || '- Make sure this user has access to all hosts for which you would like problem notifications to be sent to GitHub.' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '5. Great! You can now start using this media type in actions and create GitHub issues!' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can find the latest version of this media and additional information in the official Zabbix repository:' || chr(13) || chr(10) || '')||
TO_NCLOB('https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/github'),'0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('43','4','GLPi','','','','','','','','25','0','0','0','0','1','1','10s','1',TO_NCLOB('const CLogger = function(serviceName) {' || chr(13) || chr(10) || '	this.serviceName = serviceName;' || chr(13) || chr(10) || '	this.INFO = 4' || chr(13) || chr(10) || '	this.WARN = 3' || chr(13) || chr(10) || '	this.ERROR = 2' || chr(13) || chr(10) || '	this.log = function(level, msg) {' || chr(13) || chr(10) || '		Zabbix.log(level, ''['' + this.serviceName + ''] '' + msg);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhook = function(value) {' || chr(13) || chr(10) || '	try {' || chr(13) || chr(10) || '		params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''1'', ''2'', ''3'', ''4''].indexOf(params.event_source) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''.\nMust be 0-4.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1 && [''0'', ''1''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1) {' || chr(13) || chr(10) || '			if (params.event_source === ''1'' && [''0'', ''1'', ''2'', ''3''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0-3.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if (params.event_source === ''0'' && [''0'', ''1''].indexOf(params.event_update_status) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '			if (params.event_source === ''4'') {' || chr(13) || chr(10) || '				if ([''0'', ''1'', ''2'', ''3'', ''4'', ''5''].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {' || chr(13) || chr(10) || '					params.event_nseverity = params.event_update_nseverity;' || chr(13) || chr(10) || '					params.event_severity = params.event_update_severity;' || chr(13) || chr(10) || '					params.event_update_status = ''1'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.runCallback = function(name, params) {' || chr(13) || chr(10) || '			if (typeof this[name] === ''function'') {' || chr(13) || chr(10) || '				return this[name].apply(this, [params]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEvent = function(source, event) {' || chr(13) || chr(10) || '			const alert = { source: source, event: event };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''on'' + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEventless = function(source) {' || chr(13) || chr(10) || '			const alert = { source: source, event: null };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.run = function() {' || chr(13) || chr(10) || '			var results = [];' || chr(13) || chr(10) || '')||
TO_NCLOB('			if (typeof this.httpProxy === ''string'' && this.httpProxy.trim() !== '''') {' || chr(13) || chr(10) || '				this.request.setProxy(this.httpProxy);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			const types = { ''0'': ''Trigger'', ''1'': ''Discovery'', ''2'': ''Autoreg'', ''3'': ''Internal'', ''4'': ''Service'' };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if ([''0'', ''3'', ''4''].indexOf(this.params.event_source) !== -1) {' || chr(13) || chr(10) || '				var event = (this.params.event_update_status === ''1'')' || chr(13) || chr(10) || '					? ''Update''' || chr(13) || chr(10) || '					: ((this.params.event_value === ''1'') ? ''Problem'' : ''Resolve'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				results = this.handleEvent(types[this.params.event_source], event);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else if (typeof types[this.params.event_source] !== ''undefined'') {' || chr(13) || chr(10) || '				results = this.handleEventless(types[this.params.event_source]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				throw ''Unexpected "event_source": '' + this.params.event_source;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			for (idx in results) {' || chr(13) || chr(10) || '				if (typeof results[idx] !== ''undefined'') {' || chr(13) || chr(10) || '					return JSON.stringify(results[idx]);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.httpProxy = params.http_proxy;' || chr(13) || chr(10) || '		this.params = params;' || chr(13) || chr(10) || '		this.runCallback(''onCheckParams'', {});' || chr(13) || chr(10) || '	} catch (error) {' || chr(13) || chr(10) || '		throw ''Webhook processing failed: '' + error;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CParamValidator = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isType: function(value, type) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (type === ''array'') {' || chr(13) || chr(10) || '			return Array.isArray(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''integer'') {' || chr(13) || chr(10) || '			return CParamValidator.isInteger(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''float'') {' || chr(13) || chr(10) || '			return CParamValidator.isFloat(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (typeof value === type);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isInteger: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseInt(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isFloat: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+\.\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseFloat(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isDefined: function(value) {' || chr(13) || chr(10) || '		return !CParamValidator.isType(value, ''undefined'');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isEmpty: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be checked for emptiness.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (value.trim() === '''');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isMacroSet: function(value, macro) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (CParamValidator.isDefined(macro)) {' || chr(13) || chr(10) || '			return !(CParamValidator.ifMatch(value, ''^\{'' + macro + ''\}$''))' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !(CParamValidator.ifMatch(value, ''^\{[$#]{0,1}[A-Z_\.]+[\:]{0,1}["]{0,1}.*["]{0,1}\}$'') || value === ''*UNKNOWN*'')' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	withinRange: function(value, min, max) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''number'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a number to be checked for range.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (value < ((CParamValidator.isDefined(min)) ? min : value)' || chr(13) || chr(10) || '			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return true;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	inArray: function(value, array) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(array, ''array'')) {' || chr(13) || chr(10) || '			throw ''The array must be an array to check the value for existing in it.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (array.indexOf((typeof value === ''string'') ? value.toLowerCase() : value) !== -1);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	ifMatch: function(value, regex) {' || chr(13) || chr(10) || '		return (new RegExp(regex)).test(value);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	match: function(value, regex) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be matched with the regular expression.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '		return value.match(new RegExp(regex));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	checkURL: function(value) {' || chr(13) || chr(10) || '		if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must be a non-empty string.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, ''^(http|https):\/\/.+'')) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must contain a schema.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.endsWith(''/'') ? value.slice(0, -1) : value;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	check: function(key, rule, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(rule.type)) {' || chr(13) || chr(10) || '			throw ''Mandatory attribute "type" has not been defined for parameter "'' + key + ''".'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(params[key])) {' || chr(13) || chr(10) || '			throw ''Checked parameter "'' + key + ''" was not found in the list of input parameters.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		var value = params[key],' || chr(13) || chr(10) || '			error_message = null;' || chr(13) || chr(10) || '		switch (rule.type) {' || chr(13) || chr(10) || '			case ''string'':' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" must be a string.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a non-empty string'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '')||
TO_NCLOB('				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a string with a length > '' + rule.len;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must match the regular expression "'' + rule.regex + ''"'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.url) && rule.url === true) {' || chr(13) || chr(10) || '					value = CParamValidator.checkURL(value);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''integer'':' || chr(13) || chr(10) || '				if (!CParamValidator.isInteger(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an integer'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseInt(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''float'':' || chr(13) || chr(10) || '				if (!CParamValidator.isFloat(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a floating-point number'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseFloat(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''boolean'':' || chr(13) || chr(10) || '				if (CParamValidator.inArray(value, [''1'', ''true'', ''yes'', ''on''])) {' || chr(13) || chr(10) || '					value = true;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (CParamValidator.inArray(value, [''0'', ''false'', ''no'', ''off''])) {' || chr(13) || chr(10) || '					value = false;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a boolean-like.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''array'':' || chr(13) || chr(10) || '				try {' || chr(13) || chr(10) || '					value = JSON.parse(value);' || chr(13) || chr(10) || '				} catch (error) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" contains invalid JSON.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''array'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an array.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {' || chr(13) || chr(10) || '					value = value.reduce(function(acc, obj) {' || chr(13) || chr(10) || '						acc[obj.tag] = obj.value || null;' || chr(13) || chr(10) || '						return acc;' || chr(13) || chr(10) || '					}, {});' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''object'':' || chr(13) || chr(10) || '				value = JSON.parse(value);' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''object'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an object.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			default:' || chr(13) || chr(10) || '				throw ''Unexpected attribute type "'' + rule.type + ''" for value "'' + key + ''". Available: '' +' || chr(13) || chr(10) || '				[''integer'', ''float'', ''string'', ''boolean'', ''array'', ''object''].join('', '');' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		params[key] = value;' || chr(13) || chr(10) || '		if (CParamValidator.inArray(rule.type, [''integer'', ''float'']) && error_message === null && (CParamValidator.isDefined(rule.min)' || chr(13) || chr(10) || '			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			error_message = ''Value "'' + key + ''" must be a number '' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))' || chr(13) || chr(10) || '				? (rule.min + ''..'' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? ''>'' + rule.min : ''<'' + rule.max));' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be in the array '' + JSON.stringify(rule.array);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {' || chr(13) || chr(10) || '			error_message = ''The macro '' + ((CParamValidator.isDefined(rule.macro)) ? ''{'' + rule.macro + ''} '' : '' '') + ''is not set'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (error_message !== null) {' || chr(13) || chr(10) || '			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {' || chr(13) || chr(10) || '				params[key] = rule.default;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				Zabbix.log(4, ''Default value for "'' + key + ''" must be a '' + rule.type + ''. Skipped.'');' || chr(13) || chr(10) || '				throw ''Incorrect value for variable "'' + key + ''". '' + error_message;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return this;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	validate: function(rules, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(params, ''object'') || CParamValidator.isType(params, ''array'')) {' || chr(13) || chr(10) || '			throw ''Incorrect parameters value. The value must be an object.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		for (var key in rules) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			CParamValidator.check(key, rules[key], params);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CHttpRequest = function(logger) {' || chr(13) || chr(10) || '	this.request = new HttpRequest();' || chr(13) || chr(10) || '	if (typeof logger !== ''object'' || logger === null) {' || chr(13) || chr(10) || '		this.logger = Zabbix;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		this.logger = logger;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.clearHeader = function() {' || chr(13) || chr(10) || '		this.request.clearHeader();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.addHeaders = function(value) {' || chr(13) || chr(10) || '		var headers = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (typeof value === ''object'' && value !== null) {' || chr(13) || chr(10) || '			if (!Array.isArray(value)) {' || chr(13) || chr(10) || '				Object.keys(value).forEach(function(key) {' || chr(13) || chr(10) || '					headers.push(key + '': '' + value[key]);' || chr(13) || chr(10) || '				});' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				headers = value;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (typeof value === ''string'') {' || chr(13) || chr(10) || '			value.split(''\r\n'').forEach(function(header) {' || chr(13) || chr(10) || '				headers.push(header);' || chr(13) || chr(10) || '			});' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		for (var idx in headers) {' || chr(13) || chr(10) || '			this.request.addHeader(headers[idx]);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.setProxy = function(proxy) {' || chr(13) || chr(10) || '		this.request.setProxy(proxy);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '	this.plainRequest = function(method, url, data) {' || chr(13) || chr(10) || '		var resp = null;' || chr(13) || chr(10) || '		method = method.toLowerCase();' || chr(13) || chr(10) || '		this.logger.log(4, ''Sending '' + method + '' request:'' + JSON.stringify(data));' || chr(13) || chr(10) || '		if ([''get'', ''post'', ''put'', ''patch'', ''delete'', ''trace''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url, data);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if ([''connect'', ''head'', ''options''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unexpected method. Method '' + method + '' is not supported.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.logger.log(4, ''Response has been received: '' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.jsonRequest = function(method, url, data) {' || chr(13) || chr(10) || '		this.addHeaders(''Content-Type: application/json'');' || chr(13) || chr(10) || '		var resp = this.plainRequest(method, url, JSON.stringify(data));' || chr(13) || chr(10) || '		try {' || chr(13) || chr(10) || '			resp = JSON.parse(resp);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		catch (error) {' || chr(13) || chr(10) || '			throw ''Failed to parse response: not well-formed JSON was received'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.getStatus = function() {' || chr(13) || chr(10) || '		return this.request.getStatus();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('const CWebhookHelper = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {' || chr(13) || chr(10) || '		if (event_source === ''0'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/tr_events.php?triggerid='' + trigger_id + ''&eventid='' + event_id;' || chr(13) || chr(10) || '		} else if (event_source === ''4'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/zabbix.php?action=service.list'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return zabbix_url;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const serviceLogName = ''GLPi Webhook'',' || chr(13) || chr(10) || '	Logger = new CLogger(serviceLogName),' || chr(13) || chr(10) || '	GLPi = CWebhook;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GLPi.prototype.onCheckParams = function () {' || chr(13) || chr(10) || '	CParamValidator.validate({' || chr(13) || chr(10) || '		alert_message: { type: ''string'' },' || chr(13) || chr(10) || '		alert_subject: { type: ''string'' },' || chr(13) || chr(10) || '		zabbix_url: { type: ''string'', url: true },' || chr(13) || chr(10) || '		glpi_url: { type: ''string'', url: true },' || chr(13) || chr(10) || '		glpi_user_token: { type: ''string'' }' || chr(13) || chr(10) || '	}, this.params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.params.use_app_token = false;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (CParamValidator.isDefined(this.params.glpi_app_token) && !CParamValidator.isEmpty(this.params.glpi_app_token)) {' || chr(13) || chr(10) || '		this.params.use_app_token = true;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.event_source === ''0'') {' || chr(13) || chr(10) || '		CParamValidator.validate({ trigger_id: { type: ''integer'' }, event_id: { type: ''integer'' } }, this.params);' || chr(13) || chr(10) || '')||
TO_NCLOB('		this.params.zabbix_url = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (params.event_value != ''0'' && CParamValidator.isMacroSet(this.params.glpi_problem_id)) {' || chr(13) || chr(10) || '		this.params.event_update_status = ''1'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.data = {' || chr(13) || chr(10) || '		input: {' || chr(13) || chr(10) || '			name: this.params.alert_subject,' || chr(13) || chr(10) || '			urgency: (this.params.event_nseverity = isNaN(Number(this.params.event_nseverity)) ? 2 : this.params.event_nseverity)' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.dataFollowup = {' || chr(13) || chr(10) || '		input: {' || chr(13) || chr(10) || '			items_id: this.params.glpi_problem_id,' || chr(13) || chr(10) || '			itemtype: ''Problem'',' || chr(13) || chr(10) || '			content: this.params.alert_message + ''<br> <a href='' + this.params.zabbix_url + ''>Link to problem in Zabbix</a>'',' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.result = { tags: {} };' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GLPi.prototype.getAuthToken = function () {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.request.addHeaders(''Authorization: user_token '' + this.params.glpi_user_token);' || chr(13) || chr(10) || '	if (this.params.use_app_token) {' || chr(13) || chr(10) || '		this.request.addHeaders(''App-Token: '' + this.params.glpi_app_token);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	var response = this.request.jsonRequest(''post'', this.params.glpi_url + ''/apirest.php/initSession'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('	if ((this.request.getStatus() !== 200 && this.request.getStatus() !== 201)) {' || chr(13) || chr(10) || '		Logger.log(Logger.INFO, ''HTTP code: '' + this.request.getStatus());' || chr(13) || chr(10) || '		if (CParamValidator.isType(response.description, ''string'')) {' || chr(13) || chr(10) || '			throw response.description;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			Logger.log(Logger.INFO, ''Request not successful. Received response: '' + JSON.stringify(response));' || chr(13) || chr(10) || '			throw ''Unknown INFO. Check debug log for more information.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	if (!CParamValidator.isType(response.session_token, ''string'') || CParamValidator.isEmpty(response.session_token)) {' || chr(13) || chr(10) || '		Logger.log(Logger.INFO, ''Check getting GLPi sessionToken: '' + response.session_token);' || chr(13) || chr(10) || '		throw ''Required GLPi sessionToken is not received.'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return response.session_token;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GLPi.prototype.sendRequest = function (method, path, data) {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.request.clearHeader();' || chr(13) || chr(10) || '	this.request.addHeaders(''Session-Token:'' + this.params.authToken);' || chr(13) || chr(10) || '	if (this.params.use_app_token) {' || chr(13) || chr(10) || '		this.request.addHeaders(''App-Token: '' + this.params.glpi_app_token);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	var response = this.request.jsonRequest(method, this.params.glpi_url + path, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if ((this.request.getStatus() !== 200 && this.request.getStatus() !== 201)) {' || chr(13) || chr(10) || '		Logger.log(Logger.INFO, ''HTTP code: '' + this.request.getStatus());' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (CParamValidator.isType(response.description, ''string'')) {' || chr(13) || chr(10) || '			throw response.description;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			Logger.log(Logger.INFO, ''Request not successful. Received response: '' + JSON.stringify(response));' || chr(13) || chr(10) || '			throw ''Unknown INFO. Check debug log for more information.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return response;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GLPi.prototype.createProblem = function (status) {' || chr(13) || chr(10) || '	this.data.input.content = this.params.alert_message + ''<br> <a href='' + this.params.zabbix_url + ''>Link to problem in Zabbix</a>'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (CParamValidator.isDefined(status)) {' || chr(13) || chr(10) || '		this.data.input.status = status;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	var response = this.sendRequest(''post'', ''/apirest.php/Problem/'', this.data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (!CParamValidator.isDefined(response.id)) {' || chr(13) || chr(10) || '		throw ''Cannot create GPLi problem. Check debug log for more information.'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return response.id' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GLPi.prototype.updateProblem = function (status) {' || chr(13) || chr(10) || '	CParamValidator.validate({ glpi_problem_id: { type: ''string'' } }, this.params);' || chr(13) || chr(10) || '	this.data.id = this.params.glpi_problem_id;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (CParamValidator.isDefined(status)) {' || chr(13) || chr(10) || '		this.data.input.status = status;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('	this.sendRequest(''put'', ''/apirest.php/Problem/'' + this.params.glpi_problem_id, this.data);' || chr(13) || chr(10) || '	this.sendRequest(''post'', ''/apirest.php/Problem/'' + this.params.glpi_problem_id + ''/ITILFollowup'', this.dataFollowup);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GLPi.prototype.onProblem = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '	const problem_id = this.createProblem(1)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.result.tags.__zbx_glpi_problem_id = problem_id;' || chr(13) || chr(10) || '	this.result.tags.__zbx_glpi_link = this.params.glpi_url + ''/front/problem.form.php?id='' + problem_id;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GLPi.prototype.onUpdate = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '	this.updateProblem();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GLPi.prototype.onResolve = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '	this.updateProblem(5);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GLPi.prototype.onDiscovery = function () {' || chr(13) || chr(10) || '	return this.createProblem();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GLPi.prototype.onAutoreg = function () {' || chr(13) || chr(10) || '	return this.createProblem();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '')||
TO_NCLOB('	var hook = new GLPi(value);' || chr(13) || chr(10) || '	hook.request = new CHttpRequest(Logger);' || chr(13) || chr(10) || '	hook.params.authToken = hook.getAuthToken();' || chr(13) || chr(10) || '	return hook.run();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '	Logger.log(Logger.WARN, ''notification failed: '' + error);' || chr(13) || chr(10) || '	throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_glpi_link}','GLPi: Problem {EVENT.TAGS.__zbx_glpi_problem_id}',TO_NCLOB('This media type integrates your Zabbix installation with your GLPi installation using the Zabbix webhook feature.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'GLPi configuration:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Enable access to the GLPi REST API:' || chr(13) || chr(10) || '- In the GLPi web interface, go to "Setup" → "General" → "API".' || chr(13) || chr(10) || '- Set the "Enable Rest API" and "Enable Rest API" options to "Yes" and click the "Save" button.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Add a new API client:' || chr(13) || chr(10) || '- Click the "Add API client" button.' || chr(13) || chr(10) || '- Specify the API client name and set the "Active" option to "Yes".' || chr(13) || chr(10) || '- For security reasons, you may want to restrict the API client to the IP address of Zabbix server and/or create an additional application token (will be generated by default; you can uncheck the "Regenerate" checkbox if you don''t want to use it).' || chr(13) || chr(10) || '- Click the "Add" button.' || chr(13) || chr(10) || '- If you''ve opted to create an application token, open the settings of the created API client, and then copy and save the generated application token.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. Create a new user profile with permissions to create problems and followups (alternatively, you can use an existing profile with sufficient privileges):' || chr(13) || chr(10) || '- Go to "Administration" → "Profiles" and click the "Add" button on the top of the page.' || chr(13) || chr(10) || '- Specify the profile name and set the "Profile''s Interface" option to "Standard Interface", and then click the "Add" button.' || chr(13) || chr(10) || '- Open the created profile and click the "Assistance" tab.' || chr(13) || chr(10) || '- Set the "Add followup (requester)" permission for the "Followups" line in the "Followups/Tasks" section.' || chr(13) || chr(10) || '')||
TO_NCLOB('- Set the "Update", "Create", and "See all" permissions in the "Problems" section.' || chr(13) || chr(10) || '- Click the "Save" button.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '4. Create a new user:' || chr(13) || chr(10) || '- Go to "Administration" → "Users" and click the "Add User" button on the top of the page.' || chr(13) || chr(10) || '- Specify the user login and set the "Profiles" option to the profile that you created in the previous step (or any other existing profile with permissions to create problems and followups).' || chr(13) || chr(10) || '- Click the "Add" button.' || chr(13) || chr(10) || '- Open the profile of the created user and check the "Regenerate" checkbox of the "API token" option; click "Save".' || chr(13) || chr(10) || '- Copy and save the generated user API token.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Zabbix configuration:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Before you can start using the GLPi webhook, set the global macro "{$ZABBIX.URL}":' || chr(13) || chr(10) || '- In the Zabbix web interface, go to "Administration" → "Macros" in the top-left drop-down menu.' || chr(13) || chr(10) || '- Set the global macro "{$ZABBIX.URL}" to the URL of the Zabbix frontend. The URL should be either an IP address, a fully qualified domain name, or localhost.' || chr(13) || chr(10) || '- Specifying a protocol is mandatory, whereas the port is optional. Depending on the web server configuration, you might also need to append "/zabbix" to the end of URL. Good examples:' || chr(13) || chr(10) || '  - http://zabbix.com' || chr(13) || chr(10) || '  - https://zabbix.lan/zabbix' || chr(13) || chr(10) || '  - http://server.zabbix.lan/' || chr(13) || chr(10) || '  - http://localhost' || chr(13) || chr(10) || '  - http://127.0.0.1:8080' || chr(13) || chr(10) || '- Bad examples:' || chr(13) || chr(10) || '  - zabbix.com' || chr(13) || chr(10) || '  - http://zabbix/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the following webhook parameters:' || chr(13) || chr(10) || '')||
TO_NCLOB('- glpi_app_token - if you''ve opted to use an application token during the creation of API client, specify it here; otherwise leave it empty' || chr(13) || chr(10) || '- glpi_url - the frontend URL of your GLPi installation' || chr(13) || chr(10) || '- glpi_user_token - the user token that was generated during creation of GLPi user' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. Click the "Enabled" checkbox to enable the media type and click the "Update" button to save the webhook settings.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '4. Create a Zabbix user and add media:' || chr(13) || chr(10) || '- To create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks).' || chr(13) || chr(10) || '- In the "Media" tab, click "Add" and select the type "GLPi" from the drop-down list. Add any value in the "Send to" field: it is not used in the webhook, but is required.' || chr(13) || chr(10) || '- Make sure this user has access to all hosts for which you would like problem notifications to be sent to GLPi.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '5. Done! You can now start using this media type in actions and create problem items in GLPi.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can find the latest version of this media and additional information in the official Zabbix repository:' || chr(13) || chr(10) || '')||
TO_NCLOB('https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/glpi'),'0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('44','4','iLert','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('try {' || chr(13) || chr(10) || '    var result = { tags: {} },' || chr(13) || chr(10) || '        params = JSON.parse(value),' || chr(13) || chr(10) || '        req = new HttpRequest(),' || chr(13) || chr(10) || '        resp = '''';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        req.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    var alertSourceKey = params[''.ILERT.ALERT.SOURCE.KEY''];' || chr(13) || chr(10) || '    if (!alertSourceKey || (typeof alertSourceKey === ''string'' && alertSourceKey.trim() === '''')) {' || chr(13) || chr(10) || '        throw ''incorrect value for variable "ILERT.ALERT.SOURCE.KEY". The value must be a non-empty string.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    delete params[''.ILERT.ALERT.SOURCE.KEY''];' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '    var ilertApiBaseURL = "https://api.ilert.com";' || chr(13) || chr(10) || '    var reqURL = encodeURI(ilertApiBaseURL + "/api/v1/events/zabbix-mt/" + alertSourceKey)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var incidentKey = "zabbix-" + params[''EVENT.ID''];' || chr(13) || chr(10) || '    var incidentViewURL = ilertApiBaseURL + "/api/v1/incidents/resolve-ik/" + alertSourceKey + "/" + incidentKey;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    req.addHeader(''Accept: application/json'');' || chr(13) || chr(10) || '    req.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[iLert Webhook] Sending request:'' + JSON.stringify(params));' || chr(13) || chr(10) || '    resp = req.post(reqURL, JSON.stringify(params));' || chr(13) || chr(10) || '    Zabbix.log(4, ''[iLert Webhook] Receiving response:'' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    try {' || chr(13) || chr(10) || '')||
TO_NCLOB('        resp = JSON.parse(resp);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    catch (error) {' || chr(13) || chr(10) || '        throw ''incorrect response. iLert returned a non-JSON object.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() == 200) {' || chr(13) || chr(10) || '        result.tags.__ilert_incident_url = incidentViewURL;' || chr(13) || chr(10) || '        return JSON.stringify(result);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() == 400 && typeof resp === ''object'' && typeof resp.code === ''string'') {' || chr(13) || chr(10) || '        if (resp.code === ''NO_OPEN_INCIDENT_WITH_KEY'') {' || chr(13) || chr(10) || '          return JSON.stringify(result);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (resp.code === ''INCIDENT_ALREADY_ACCEPTED'') {' || chr(13) || chr(10) || '          result.tags.__ilert_incident_url = incidentViewURL;' || chr(13) || chr(10) || '          return JSON.stringify(result);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof resp === ''object'' && typeof resp.message === ''string'') {' || chr(13) || chr(10) || '        throw resp.message;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        throw ''Unknown error.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[iLert Webhook] Notification failed : '' + error);' || chr(13) || chr(10) || '    throw ''iLert notification failed : '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__ilert_incident_url}','iLert incident','Please refer to https://docs.ilert.com/integrations/zabbix/native ' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || 'Set global macro {$ZABBIX.URL} with your Zabbix server URL.' || chr(13) || chr(10) || 'Add a dedicated user with the media type "iLert". You can also rewrite the incident summary via ".ILERT.INCIDENT.SUMMARY" parameter or leave it empty to use the standard pattern.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('45','4','iTop','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Itop = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.log !== ''private_log'' && params.log !== ''public_log'') {' || chr(13) || chr(10) || '            throw ''Incorrect "itop_log" parameter given: '' + params.log + ''\nMust be "private_log" or "public_log".'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Itop.params = params;' || chr(13) || chr(10) || '        if (typeof Itop.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Itop.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Itop.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            Itop.params.url += ''webservices/rest.php?version='' + encodeURIComponent(Itop.params.api_version);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Itop.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setCreatePayload: function () {' || chr(13) || chr(10) || '        json_data.operation = ''core/create'';' || chr(13) || chr(10) || '        json_data.fields.org_id = Itop.params.organization_id;' || chr(13) || chr(10) || '        json_data.fields.title = params.alert_subject;' || chr(13) || chr(10) || '        json_data.fields.description = params.alert_message.replace(''<'', ''&lt;'')' || chr(13) || chr(10) || '            .replace(''>'', ''&gt;'')' || chr(13) || chr(10) || '            .replace(/(?:\r\n|\r|\n)/g, ''<br>'');' || chr(13) || chr(10) || '')||
TO_NCLOB('    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setUpdatePayload: function () {' || chr(13) || chr(10) || '        json_data.operation = ''core/update'';' || chr(13) || chr(10) || '        json_data.key = Itop.params.id;' || chr(13) || chr(10) || '        json_data.fields.title = params.alert_subject;' || chr(13) || chr(10) || '        json_data.fields[Itop.params.log] = {' || chr(13) || chr(10) || '            add_item: {' || chr(13) || chr(10) || '                message: params.alert_subject + ''\n'' + params.alert_message,' || chr(13) || chr(10) || '                format: ''text''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (data) {' || chr(13) || chr(10) || '        [''url'', ''user'', ''password'', ''organization_id'', ''class'', ''api_version'', ''id''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Itop.params !== ''object'' || typeof Itop.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || Itop.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required Itop param is not set: "itop_'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Itop.params.url,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            object;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: multipart/form-data'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Basic '' + btoa(Itop.params.user + '':'' + Itop.params.password));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Itop.HTTPProxy) {' || chr(13) || chr(10) || '            request.setProxy(Itop.HTTPProxy);' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ iTop Webhook ] Sending request: '' + url + ''&json_data='' + data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(url + ''&json_data='' + encodeURIComponent(data));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ iTop Webhook ] Received response with status code '' + request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            response = JSON.parse(response);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        catch (error) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ iTop Webhook ] Failed to parse response received from iTop'');' || chr(13) || chr(10) || '            throw ''Failed to parse response received from iTop.\nRequest status code '' +' || chr(13) || chr(10) || '                    request.getStatus() + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            throw ''Request failed with status code '' + request.getStatus() + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if (typeof response.code !== ''undefined'' && response.code !== 0) {' || chr(13) || chr(10) || '            throw ''Request failed with iTop code '' + response.code + '': '' +' || chr(13) || chr(10) || '                    JSON.stringify(response.message) + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '')||
TO_NCLOB('            Object.keys(response.objects)' || chr(13) || chr(10) || '                .forEach(function (key) {' || chr(13) || chr(10) || '                    object = response.objects[key];' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '            return {' || chr(13) || chr(10) || '                status: request.getStatus(),' || chr(13) || chr(10) || '                response: object.fields' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        json_data = {},' || chr(13) || chr(10) || '        itop_params = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''summary'', ''event_recovery_value'',' || chr(13) || chr(10) || '            ''event_source'', ''event_value'', ''action_name''' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''itop_'')) {' || chr(13) || chr(10) || '                itop_params[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '            && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Itop.setParams(itop_params);' || chr(13) || chr(10) || '    Itop.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    json_data.operation = '''';' || chr(13) || chr(10) || '    json_data.class = Itop.params.class;' || chr(13) || chr(10) || '    json_data.comment = Itop.params.comment;' || chr(13) || chr(10) || '    json_data.output_fields = ''id, friendlyname'';' || chr(13) || chr(10) || '    json_data.fields = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('        Itop.setCreatePayload();' || chr(13) || chr(10) || '        Itop.request(json_data);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params.event_update_status === ''0''' || chr(13) || chr(10) || '            && (Itop.params.id === ''{EVENT.TAGS.__zbx_itop_id}'' || Itop.params.id === ''*UNKNOWN*'')) {' || chr(13) || chr(10) || '        Itop.setCreatePayload();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response = Itop.request(json_data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_itop_id = response.response.id;' || chr(13) || chr(10) || '        result.tags.__zbx_itop_key = response.response.friendlyname;' || chr(13) || chr(10) || '        result.tags.__zbx_itop_link = params.itop_url + (params.itop_url.endsWith(''/'') ? '''' : ''/'') +' || chr(13) || chr(10) || '                ''pages/UI.php?operation=details&class='' + encodeURIComponent(Itop.params.class) + ''&id='' +' || chr(13) || chr(10) || '                encodeURIComponent(response.response.id);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        if (Itop.params.id === ''{EVENT.TAGS.__zbx_itop_id}'' || Itop.params.id === ''*UNKNOWN*'') {' || chr(13) || chr(10) || '            throw ''Incorrect iTop ticket ID given: '' + Itop.params.id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        Itop.setUpdatePayload();' || chr(13) || chr(10) || '        Itop.request(json_data);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ iTop Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_itop_link}','iTop: {EVENT.TAGS.__zbx_itop_key}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('46','4','Jira','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('const CLogger = function(serviceName) {' || chr(13) || chr(10) || '	this.serviceName = serviceName;' || chr(13) || chr(10) || '	this.INFO = 4' || chr(13) || chr(10) || '	this.WARN = 3' || chr(13) || chr(10) || '	this.ERROR = 2' || chr(13) || chr(10) || '	this.log = function(level, msg) {' || chr(13) || chr(10) || '		Zabbix.log(level, ''['' + this.serviceName + ''] '' + msg);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhook = function(value) {' || chr(13) || chr(10) || '	try {' || chr(13) || chr(10) || '		params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''1'', ''2'', ''3'', ''4''].indexOf(params.event_source) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''.\nMust be 0-4.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1 && [''0'', ''1''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1) {' || chr(13) || chr(10) || '			if (params.event_source === ''1'' && [''0'', ''1'', ''2'', ''3''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0-3.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if (params.event_source === ''0'' && [''0'', ''1''].indexOf(params.event_update_status) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '			if (params.event_source === ''4'') {' || chr(13) || chr(10) || '				if ([''0'', ''1'', ''2'', ''3'', ''4'', ''5''].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {' || chr(13) || chr(10) || '					params.event_nseverity = params.event_update_nseverity;' || chr(13) || chr(10) || '					params.event_severity = params.event_update_severity;' || chr(13) || chr(10) || '					params.event_update_status = ''1'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.runCallback = function(name, params) {' || chr(13) || chr(10) || '			if (typeof this[name] === ''function'') {' || chr(13) || chr(10) || '				return this[name].apply(this, [params]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEvent = function(source, event) {' || chr(13) || chr(10) || '			const alert = { source: source, event: event };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''on'' + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEventless = function(source) {' || chr(13) || chr(10) || '			const alert = { source: source, event: null };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.run = function() {' || chr(13) || chr(10) || '			var results = [];' || chr(13) || chr(10) || '')||
TO_NCLOB('			if (typeof this.httpProxy === ''string'' && this.httpProxy.trim() !== '''') {' || chr(13) || chr(10) || '				this.request.setProxy(this.httpProxy);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			const types = { ''0'': ''Trigger'', ''1'': ''Discovery'', ''2'': ''Autoreg'', ''3'': ''Internal'', ''4'': ''Service'' };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if ([''0'', ''3'', ''4''].indexOf(this.params.event_source) !== -1) {' || chr(13) || chr(10) || '				var event = (this.params.event_update_status === ''1'')' || chr(13) || chr(10) || '					? ''Update''' || chr(13) || chr(10) || '					: ((this.params.event_value === ''1'') ? ''Problem'' : ''Resolve'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				results = this.handleEvent(types[this.params.event_source], event);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else if (typeof types[this.params.event_source] !== ''undefined'') {' || chr(13) || chr(10) || '				results = this.handleEventless(types[this.params.event_source]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				throw ''Unexpected "event_source": '' + this.params.event_source;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			for (idx in results) {' || chr(13) || chr(10) || '				if (typeof results[idx] !== ''undefined'') {' || chr(13) || chr(10) || '					return JSON.stringify(results[idx]);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.httpProxy = params.http_proxy;' || chr(13) || chr(10) || '		this.params = params;' || chr(13) || chr(10) || '		this.runCallback(''onCheckParams'', {});' || chr(13) || chr(10) || '	} catch (error) {' || chr(13) || chr(10) || '		throw ''Webhook processing failed: '' + error;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhookHelper = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {' || chr(13) || chr(10) || '		if (event_source === ''0'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/tr_events.php?triggerid='' + trigger_id + ''&eventid='' + event_id;' || chr(13) || chr(10) || '		} else if (event_source === ''4'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/zabbix.php?action=service.list'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return zabbix_url;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CParamValidator = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isType: function(value, type) {' || chr(13) || chr(10) || '		if (type === ''array'') {' || chr(13) || chr(10) || '			return Array.isArray(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''integer'') {' || chr(13) || chr(10) || '			return CParamValidator.isInteger(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''float'') {' || chr(13) || chr(10) || '			return CParamValidator.isFloat(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (typeof value === type);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isInteger: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseInt(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isFloat: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+\.\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseFloat(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '	isDefined: function(value) {' || chr(13) || chr(10) || '		return !CParamValidator.isType(value, ''undefined'');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isEmpty: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be checked for emptiness.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (value.trim() === '''');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isMacroSet: function(value, macro) {' || chr(13) || chr(10) || '		if (CParamValidator.isDefined(macro)) {' || chr(13) || chr(10) || '			return !(CParamValidator.ifMatch(value, ''^\{'' + macro + ''\}$''))' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !(CParamValidator.ifMatch(value, ''^\{[$#]{0,1}[A-Z_\.]+[\:]{0,1}["]{0,1}.*["]{0,1}\}$'') || value === ''*UNKNOWN*'')' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	withinRange: function(value, min, max) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''number'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a number to be checked for range.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (value < ((CParamValidator.isDefined(min)) ? min : value)' || chr(13) || chr(10) || '			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return true;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	inArray: function(value, array) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(array, ''array'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			throw ''The array must be an array to check the value for existing in it.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (array.indexOf((typeof value === ''string'') ? value.toLowerCase() : value) !== -1);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	ifMatch: function(value, regex) {' || chr(13) || chr(10) || '		return (new RegExp(regex)).test(value);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	match: function(value, regex) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be matched with the regular expression.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.match(new RegExp(regex));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	checkURL: function(value) {' || chr(13) || chr(10) || '		if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must be a non-empty string.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, ''^(http|https):\/\/.+'')) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must contain a schema.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.endsWith(''/'') ? value.slice(0, -1) : value;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	check: function(key, rule, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(rule.type)) {' || chr(13) || chr(10) || '			throw ''Mandatory attribute "type" has not been defined for parameter "'' + key + ''".'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(params[key])) {' || chr(13) || chr(10) || '			throw ''Checked parameter "'' + key + ''" was not found in the list of input parameters.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('		}' || chr(13) || chr(10) || '		var value = params[key],' || chr(13) || chr(10) || '			error_message = null;' || chr(13) || chr(10) || '		switch (rule.type) {' || chr(13) || chr(10) || '			case ''string'':' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" must be a string.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a non-empty string'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a string with a length > '' + rule.len;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must match the regular expression "'' + rule.regex + ''"'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.url) && rule.url === true) {' || chr(13) || chr(10) || '					value = CParamValidator.checkURL(value);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''integer'':' || chr(13) || chr(10) || '				if (!CParamValidator.isInteger(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an integer'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseInt(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''float'':' || chr(13) || chr(10) || '				if (!CParamValidator.isFloat(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a floating-point number'';' || chr(13) || chr(10) || '')||
TO_NCLOB('					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseFloat(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''boolean'':' || chr(13) || chr(10) || '				if (CParamValidator.inArray(value, [''1'', ''true'', ''yes'', ''on''])) {' || chr(13) || chr(10) || '					value = true;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (CParamValidator.inArray(value, [''0'', ''false'', ''no'', ''off''])) {' || chr(13) || chr(10) || '					value = false;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a boolean-like.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''array'':' || chr(13) || chr(10) || '				try {' || chr(13) || chr(10) || '					value = JSON.parse(value);' || chr(13) || chr(10) || '				} catch (error) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" contains invalid JSON.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''array'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an array.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {' || chr(13) || chr(10) || '					value = value.reduce(function(acc, obj) {' || chr(13) || chr(10) || '						acc[obj.tag] = obj.value || null;' || chr(13) || chr(10) || '						return acc;' || chr(13) || chr(10) || '					}, {});' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''object'':' || chr(13) || chr(10) || '				value = JSON.parse(value);' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''object'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an object.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '')||
TO_NCLOB('				break;' || chr(13) || chr(10) || '			default:' || chr(13) || chr(10) || '				throw ''Unexpected attribute type "'' + rule.type + ''" for value "'' + key + ''". Available: '' +' || chr(13) || chr(10) || '				[''integer'', ''float'', ''string'', ''boolean'', ''array'', ''object''].join('', '');' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		params[key] = value;' || chr(13) || chr(10) || '		if (CParamValidator.inArray(rule.type, [''integer'', ''float'']) && error_message === null && (CParamValidator.isDefined(rule.min)' || chr(13) || chr(10) || '			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be a number '' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))' || chr(13) || chr(10) || '				? (rule.min + ''..'' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? ''>'' + rule.min : ''<'' + rule.max));' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be in the array '' + JSON.stringify(rule.array);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {' || chr(13) || chr(10) || '			error_message = ''The macro '' + ((CParamValidator.isDefined(rule.macro)) ? ''{'' + rule.macro + ''} '' : '' '') + ''is not set'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (error_message !== null) {' || chr(13) || chr(10) || '			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {' || chr(13) || chr(10) || '				params[key] = rule.default;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '')||
TO_NCLOB('				Zabbix.log(4, ''Default value for "'' + key + ''" must be a '' + rule.type + ''. Skipped.'');' || chr(13) || chr(10) || '				throw ''Incorrect value for variable "'' + key + ''". '' + error_message;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return this;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	validate: function(rules, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(params, ''object'') || CParamValidator.isType(params, ''array'')) {' || chr(13) || chr(10) || '			throw ''Incorrect parameters value. The value must be an object.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		for (var key in rules) {' || chr(13) || chr(10) || '			CParamValidator.check(key, rules[key], params);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CHttpRequest = function(logger) {' || chr(13) || chr(10) || '	this.request = new HttpRequest();' || chr(13) || chr(10) || '	if (typeof logger !== ''object'' || logger === null) {' || chr(13) || chr(10) || '		this.logger = Zabbix;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		this.logger = logger;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.clearHeader = function() {' || chr(13) || chr(10) || '		this.request.clearHeader();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.addHeaders = function(value) {' || chr(13) || chr(10) || '		var headers = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (typeof value === ''object'' && value !== null) {' || chr(13) || chr(10) || '			if (!Array.isArray(value)) {' || chr(13) || chr(10) || '				Object.keys(value).forEach(function(key) {' || chr(13) || chr(10) || '					headers.push(key + '': '' + value[key]);' || chr(13) || chr(10) || '				});' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '')||
TO_NCLOB('				headers = value;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (typeof value === ''string'') {' || chr(13) || chr(10) || '			value.split(''\r\n'').forEach(function(header) {' || chr(13) || chr(10) || '				headers.push(header);' || chr(13) || chr(10) || '			});' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		for (var idx in headers) {' || chr(13) || chr(10) || '			this.request.addHeader(headers[idx]);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.setProxy = function(proxy) {' || chr(13) || chr(10) || '		this.request.setProxy(proxy);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.plainRequest = function(method, url, data) {' || chr(13) || chr(10) || '		var resp = null;' || chr(13) || chr(10) || '		method = method.toLowerCase();' || chr(13) || chr(10) || '		this.logger.log(4, ''Sending '' + method + '' request:'' + JSON.stringify(data));' || chr(13) || chr(10) || '		if ([''get'', ''post'', ''put'', ''patch'', ''delete'', ''trace''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url, data);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if ([''connect'', ''head'', ''options''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unexpected method. Method '' + method + '' is not supported.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.logger.log(4, ''Response has been received: '' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.jsonRequest = function(method, url, data) {' || chr(13) || chr(10) || '		this.addHeaders(''Content-Type: application/json'');' || chr(13) || chr(10) || '')||
TO_NCLOB('		var resp = this.plainRequest(method, url, JSON.stringify(data));' || chr(13) || chr(10) || '		try {' || chr(13) || chr(10) || '			resp = JSON.parse(resp);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		catch (error) {' || chr(13) || chr(10) || '			throw ''Failed to parse response: not well-formed JSON was received'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.getStatus = function() {' || chr(13) || chr(10) || '		return this.request.getStatus();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var ZABBIX_SEVERITY_MAP = ["not_classified", "information", "warning", "average", "high", "disaster"];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var serviceLogName = ''Jira Webhook'',' || chr(13) || chr(10) || '	Logger = new CLogger(serviceLogName),' || chr(13) || chr(10) || '	Jira = CWebhook;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.onCheckParams = function () {' || chr(13) || chr(10) || '	CParamValidator.validate({' || chr(13) || chr(10) || '		jira_url: { type: ''string'', url: true},' || chr(13) || chr(10) || '		jira_user: { type: ''string'' },' || chr(13) || chr(10) || '		jira_password: { type: ''string'' },' || chr(13) || chr(10) || '		jira_issue_type: { type: ''string'' },' || chr(13) || chr(10) || '		jira_project_key: { type: ''string'' },' || chr(13) || chr(10) || '		event_source: { type: ''string'' },' || chr(13) || chr(10) || '		alert_subject: { type: ''string'' },' || chr(13) || chr(10) || '		alert_message: { type: ''string'' },' || chr(13) || chr(10) || '		event_nseverity: { type: ''integer'', default: 0 }' || chr(13) || chr(10) || '	}, this.params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('	this.priority = this.params.event_source == 3 ? this.params.jira_priority_internal : this.params[''severity_'' + ZABBIX_SEVERITY_MAP[this.params.event_nseverity]];' || chr(13) || chr(10) || '	this.params.event_tags_json = parseTags(this.params.event_tags_json, false);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.event_tags_json.length > 0) {' || chr(13) || chr(10) || '		this.labels = setLabels(this.params.event_tags_json);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	parseOptionalFields();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.result = { tags: {} };' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function escapeMarkup(str) {' || chr(13) || chr(10) || '	var length = str.length,' || chr(13) || chr(10) || '		result = '''',' || chr(13) || chr(10) || '		markup = [''{'', ''|'', ''}'', ''~'', ''_'', ''\\'', ''['', '']'', ''^'', ''<'', ''>'', ''?'', ''!'', ''#'', ''+'', ''*'', ''&''];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	for (var i = 0; i < length; i++) {' || chr(13) || chr(10) || '		var char = str[i];' || chr(13) || chr(10) || '		result += (markup.indexOf(char) !== -1) ? (''&#'' + str[i].charCodeAt() + '';'') : char;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function parseOptionalFields() {' || chr(13) || chr(10) || '	this.params.customfields = {};' || chr(13) || chr(10) || '	this.params.components = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	Object.keys(this.params).forEach(function (key) {' || chr(13) || chr(10) || '		if (key.startsWith(''customfield_'')) {' || chr(13) || chr(10) || '			this.params.customfields[key] = this.params[key];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (key.startsWith(''component_'')) {' || chr(13) || chr(10) || '			this.params.components.push({"name": this.params[key]})' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	});' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || 'Jira.prototype.addCustomFields = function (data) {' || chr(13) || chr(10) || '	if (typeof this.params.customfields === ''object'' && Object.keys(this.params.customfields).length) {' || chr(13) || chr(10) || '		var schemaData = this.sendRequest(''GET'', ''/rest/api/latest/field''),' || chr(13) || chr(10) || '			schema = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		schemaData.forEach(function (item) {' || chr(13) || chr(10) || '			schema[item.id] = item.schema;' || chr(13) || chr(10) || '		});' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		Object.keys(this.params.customfields).forEach(function (field) {' || chr(13) || chr(10) || '			if (typeof schema[field] === ''object'' && schema[field].type) {				' || chr(13) || chr(10) || '				const type = schema[field].type;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				if (type === ''number'') {' || chr(13) || chr(10) || '					data.fields[field] = parseInt(this.params.customfields[field]);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (type === ''string'' && schema[field][''custom''].split('':'')[1] === ''url'') {' || chr(13) || chr(10) || '					if (this.params.customfields[field] === ''zabbix_url'') {' || chr(13) || chr(10) || '						data.fields[field] = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);' || chr(13) || chr(10) || '					} else {' || chr(13) || chr(10) || '						data.fields[field] = this.params.customfields[field];' || chr(13) || chr(10) || '					}' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (type === ''date'') {' || chr(13) || chr(10) || '					if (this.params.customfields[field].match(/\d+[.-]\d+[.-]\d+/) !== null) {' || chr(13) || chr(10) || '						data.fields[field] = this.params.customfields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '					}' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '')||
TO_NCLOB('				else if (type === ''datetime'') {' || chr(13) || chr(10) || '					if (this.params.customfields[field].match(/\d+[.-]\d+[.-]\d+T\d+:\d+:\d+/) !== null) {' || chr(13) || chr(10) || '						data.fields[field] = this.params.customfields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '					}' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (type === ''option'') {' || chr(13) || chr(10) || '					data.fields[field] = { ''value'': this.params.customfields[field] };' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (type === ''array'') {' || chr(13) || chr(10) || '					if (schema[field].items === ''option'') {' || chr(13) || chr(10) || '						const valuesList = this.params.customfields[field].split('','');' || chr(13) || chr(10) || '						data.fields[field] = [];' || chr(13) || chr(10) || '						valuesList.forEach(function (val) {' || chr(13) || chr(10) || '							data.fields[field].push({''value'': val})' || chr(13) || chr(10) || '						});' || chr(13) || chr(10) || '					}' || chr(13) || chr(10) || '					else {' || chr(13) || chr(10) || '						data.fields[field] = [this.params.customfields[field]];' || chr(13) || chr(10) || '					}' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else {' || chr(13) || chr(10) || '					data.fields[field] = this.params.customfields[field];' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		});' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		Logger.log(Logger.WARN, ''No customfields found.'');' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return data;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function parseTags(event_tags) {' || chr(13) || chr(10) || '	try {' || chr(13) || chr(10) || '		return JSON.parse(event_tags);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	catch (error) {' || chr(13) || chr(10) || '		if (this.params.event_source == 0 || this.params.event_source > 2) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			Logger.log(Logger.WARN, ''No event tags were found. Should be an object. Received event tags: "'' + event_tags + ''".'');' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		return [];' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getTagValue(tags, key, throw_on_fail) {' || chr(13) || chr(10) || '	for (i in tags) {' || chr(13) || chr(10) || '		if (tags[i].tag === key) {' || chr(13) || chr(10) || '			return tags[i].value' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (!throw_on_fail) {' || chr(13) || chr(10) || '		return false;' || chr(13) || chr(10) || '	} else {' || chr(13) || chr(10) || '		throw ''Tag "'' + key + ''" is not in the event tag list.''' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function setLabels(event_tags_json) {' || chr(13) || chr(10) || '	var buffer = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	event_tags_json.forEach(function (tag) {' || chr(13) || chr(10) || '		if (typeof tag.tag !== ''undefined'' && typeof tag.value !== ''undefined'' && !tag.tag.startsWith(''__zbx'')) {' || chr(13) || chr(10) || '			label = (tag.tag + (tag.value ? ('':'' + tag.value) : '''')).replace(/\s/g, ''_'');' || chr(13) || chr(10) || '			if (label.length < 256) {' || chr(13) || chr(10) || '				buffer.push(label);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	});' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (buffer.length === 0) {' || chr(13) || chr(10) || '		Logger.log(Logger.WARN, ''No labels were set.'');' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return buffer;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.commentIssue = function (issue_key) {' || chr(13) || chr(10) || '	var data = {' || chr(13) || chr(10) || '')||
TO_NCLOB('		body: this.params.alert_message,' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '	this.sendRequest(''POST'', ''/rest/api/latest/issue/'' + encodeURIComponent(issue_key) + ''/comment'', data);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.sendRequest = function (method, path, data) {' || chr(13) || chr(10) || '	this.request.clearHeader();' || chr(13) || chr(10) || '	this.request.addHeaders(''Authorization: Basic '' + btoa(this.params.jira_user + '':'' + this.params.jira_password));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	var response = this.request.jsonRequest(method, this.params.jira_url + path, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if ((this.request.getStatus() !== 200 && this.request.getStatus() !== 201)) {' || chr(13) || chr(10) || '		Logger.log(Logger.WARN, ''HTTP code: '' + this.request.getStatus());' || chr(13) || chr(10) || '		if (CParamValidator.isType(response.description, ''string'')) {' || chr(13) || chr(10) || '			throw response.description;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			Logger.log(Logger.WARN, ''Request not successful. Received response: '' + JSON.stringify(response));' || chr(13) || chr(10) || '			throw ''Unknown error. Check debug log for more information.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return response;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.onProblem = function (alert) {' || chr(13) || chr(10) || '	if (this.params.event_tags_json.length > 0 && getTagValue(this.params.event_tags_json, ''__zbx_jira_issuekey'', false) !== false) {' || chr(13) || chr(10) || '		return this.onUpdate(alert, true);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	var data = {' || chr(13) || chr(10) || '		fields: {' || chr(13) || chr(10) || '')||
TO_NCLOB('			project: {' || chr(13) || chr(10) || '				key: this.params.jira_project_key' || chr(13) || chr(10) || '			},' || chr(13) || chr(10) || '			issuetype: {' || chr(13) || chr(10) || '				name: this.params.jira_issue_type' || chr(13) || chr(10) || '			},' || chr(13) || chr(10) || '			summary: this.params.alert_subject,' || chr(13) || chr(10) || '			description: this.params.alert_message,' || chr(13) || chr(10) || '			priority: {' || chr(13) || chr(10) || '				"name": this.priority' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.labels && this.labels.length > 0) {' || chr(13) || chr(10) || '		data.fields.labels = this.labels;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.components && this.params.components.length > 0) {' || chr(13) || chr(10) || '		data.fields.components = this.params.components;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	var response = this.sendRequest(''POST'', ''/rest/api/latest/issue'', this.addCustomFields(data));' || chr(13) || chr(10) || '	this.result.tags = {' || chr(13) || chr(10) || '		__zbx_jira_issuekey: response.key,' || chr(13) || chr(10) || '		__zbx_jira_issuelink: this.params.jira_url + ''/browse/'' + response.key' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.onUpdate = function (alert, dontUpdatePriority) {' || chr(13) || chr(10) || '	var data = {' || chr(13) || chr(10) || '		fields: {' || chr(13) || chr(10) || '			summary: this.params.alert_subject,' || chr(13) || chr(10) || '			priority: {' || chr(13) || chr(10) || '				"name": this.priority' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (dontUpdatePriority && this.params.event_source != 0) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		delete data[''fields''][''priority''];' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	var jira_issue_key = getTagValue(this.params.event_tags_json, ''__zbx_jira_issuekey'', true);' || chr(13) || chr(10) || '	this.sendRequest(''PUT'', ''/rest/api/latest/issue/'' + encodeURIComponent(jira_issue_key) + ''?returnIssue=true'', this.addCustomFields(data));' || chr(13) || chr(10) || '	this.commentIssue(jira_issue_key);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.onResolve = function (alert) {' || chr(13) || chr(10) || '	return this.onUpdate(alert, true);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.onDiscovery = function (alert) {' || chr(13) || chr(10) || '	this.priority = this.params.jira_priority_discovery;' || chr(13) || chr(10) || '	return this.onProblem(alert);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.onAutoreg = function (alert) {' || chr(13) || chr(10) || '	this.priority = this.params.jira_priority_autoregistration;' || chr(13) || chr(10) || '	return this.onProblem(alert);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '	var hook = new Jira(value);' || chr(13) || chr(10) || '	hook.request = new CHttpRequest(Logger);' || chr(13) || chr(10) || '	return hook.run();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '	Logger.log(Logger.WARN, ''notification failed: '' + error);' || chr(13) || chr(10) || '	throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_jira_issuelink}','Jira: {EVENT.TAGS.__zbx_jira_issuekey}','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/jira' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. To make this integration work, you will need the following from Jira:' || chr(13) || chr(10) || '  * Jira instance URL;' || chr(13) || chr(10) || '  * Jira project key and issue type that the issues created by Zabbix will use;' || chr(13) || chr(10) || '  * Jira username and password or API token. API token is strongly recommended and can be obtained at https://id.atlassian.com/manage/api-tokens.' || chr(13) || chr(10) || '2. In the Zabbix web interface, go to Administration → Macros section. Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend.' || chr(13) || chr(10) || '3. On this page replace the placeholder ''<...>'' values with the ones from the step #1.' || chr(13) || chr(10) || '4. In Zabbix, you need to have a Zabbix user and add Media with the Jira media type. Make sure this user has access to all hosts for which you would like problem issues to be created in Jira.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('47','4','Jira Service Management','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('const CLogger = function(serviceName) {' || chr(13) || chr(10) || '	this.serviceName = serviceName;' || chr(13) || chr(10) || '	this.INFO = 4' || chr(13) || chr(10) || '	this.WARN = 3' || chr(13) || chr(10) || '	this.ERROR = 2' || chr(13) || chr(10) || '	this.log = function(level, msg) {' || chr(13) || chr(10) || '		Zabbix.log(level, ''['' + this.serviceName + ''] '' + msg);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhook = function(value) {' || chr(13) || chr(10) || '	try {' || chr(13) || chr(10) || '		params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''1'', ''2'', ''3'', ''4''].indexOf(params.event_source) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''.\nMust be 0-4.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1 && [''0'', ''1''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1) {' || chr(13) || chr(10) || '			if (params.event_source === ''1'' && [''0'', ''1'', ''2'', ''3''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0-3.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if (params.event_source === ''0'' && [''0'', ''1''].indexOf(params.event_update_status) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '			if (params.event_source === ''4'') {' || chr(13) || chr(10) || '				if ([''0'', ''1'', ''2'', ''3'', ''4'', ''5''].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {' || chr(13) || chr(10) || '					params.event_nseverity = params.event_update_nseverity;' || chr(13) || chr(10) || '					params.event_severity = params.event_update_severity;' || chr(13) || chr(10) || '					params.event_update_status = ''1'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.runCallback = function(name, params) {' || chr(13) || chr(10) || '			if (typeof this[name] === ''function'') {' || chr(13) || chr(10) || '				return this[name].apply(this, [params]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEvent = function(source, event) {' || chr(13) || chr(10) || '			const alert = { source: source, event: event };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''on'' + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEventless = function(source) {' || chr(13) || chr(10) || '			const alert = { source: source, event: null };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.run = function() {' || chr(13) || chr(10) || '			var results = [];' || chr(13) || chr(10) || '')||
TO_NCLOB('			if (typeof this.httpProxy === ''string'' && this.httpProxy.trim() !== '''') {' || chr(13) || chr(10) || '				this.request.setProxy(this.httpProxy);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			const types = { ''0'': ''Trigger'', ''1'': ''Discovery'', ''2'': ''Autoreg'', ''3'': ''Internal'', ''4'': ''Service'' };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if ([''0'', ''3'', ''4''].indexOf(this.params.event_source) !== -1) {' || chr(13) || chr(10) || '				var event = (this.params.event_update_status === ''1'')' || chr(13) || chr(10) || '					? ''Update''' || chr(13) || chr(10) || '					: ((this.params.event_value === ''1'') ? ''Problem'' : ''Resolve'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				results = this.handleEvent(types[this.params.event_source], event);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else if (typeof types[this.params.event_source] !== ''undefined'') {' || chr(13) || chr(10) || '				results = this.handleEventless(types[this.params.event_source]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				throw ''Unexpected "event_source": '' + this.params.event_source;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			for (idx in results) {' || chr(13) || chr(10) || '				if (typeof results[idx] !== ''undefined'') {' || chr(13) || chr(10) || '					return JSON.stringify(results[idx]);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.httpProxy = params.http_proxy;' || chr(13) || chr(10) || '		this.params = params;' || chr(13) || chr(10) || '		this.runCallback(''onCheckParams'', {});' || chr(13) || chr(10) || '	} catch (error) {' || chr(13) || chr(10) || '		throw ''Webhook processing failed: '' + error;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhookHelper = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {' || chr(13) || chr(10) || '		if (event_source === ''0'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/tr_events.php?triggerid='' + trigger_id + ''&eventid='' + event_id;' || chr(13) || chr(10) || '		} else if (event_source === ''4'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/zabbix.php?action=service.list'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return zabbix_url;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CParamValidator = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isType: function(value, type) {' || chr(13) || chr(10) || '		if (type === ''array'') {' || chr(13) || chr(10) || '			return Array.isArray(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''integer'') {' || chr(13) || chr(10) || '			return CParamValidator.isInteger(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''float'') {' || chr(13) || chr(10) || '			return CParamValidator.isFloat(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (typeof value === type);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isInteger: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseInt(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isFloat: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+\.\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseFloat(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '	isDefined: function(value) {' || chr(13) || chr(10) || '		return !CParamValidator.isType(value, ''undefined'');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isEmpty: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be checked for emptiness.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (value.trim() === '''');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isMacroSet: function(value, macro) {' || chr(13) || chr(10) || '		if (CParamValidator.isDefined(macro)) {' || chr(13) || chr(10) || '			return !(CParamValidator.ifMatch(value, ''^\{'' + macro + ''\}$''))' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !(CParamValidator.ifMatch(value, ''^\{[$#]{0,1}[A-Z_\.]+[\:]{0,1}["]{0,1}.*["]{0,1}\}$'') || value === ''*UNKNOWN*'')' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	withinRange: function(value, min, max) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''number'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a number to be checked for range.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (value < ((CParamValidator.isDefined(min)) ? min : value)' || chr(13) || chr(10) || '			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return true;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	inArray: function(value, array) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(array, ''array'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			throw ''The array must be an array to check the value for existing in it.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (array.indexOf((typeof value === ''string'') ? value.toLowerCase() : value) !== -1);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	ifMatch: function(value, regex) {' || chr(13) || chr(10) || '		return (new RegExp(regex)).test(value);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	match: function(value, regex) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be matched with the regular expression.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.match(new RegExp(regex));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	checkURL: function(value) {' || chr(13) || chr(10) || '		if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must be a non-empty string.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, ''^(http|https):\/\/.+'')) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must contain a schema.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.endsWith(''/'') ? value.slice(0, -1) : value;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	check: function(key, rule, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(rule.type)) {' || chr(13) || chr(10) || '			throw ''Mandatory attribute "type" has not been defined for parameter "'' + key + ''".'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(params[key])) {' || chr(13) || chr(10) || '			throw ''Checked parameter "'' + key + ''" was not found in the list of input parameters.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('		}' || chr(13) || chr(10) || '		var value = params[key],' || chr(13) || chr(10) || '			error_message = null;' || chr(13) || chr(10) || '		switch (rule.type) {' || chr(13) || chr(10) || '			case ''string'':' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" must be a string.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a non-empty string'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a string with a length > '' + rule.len;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must match the regular expression "'' + rule.regex + ''"'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.url) && rule.url === true) {' || chr(13) || chr(10) || '					value = CParamValidator.checkURL(value);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''integer'':' || chr(13) || chr(10) || '				if (!CParamValidator.isInteger(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an integer'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseInt(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''float'':' || chr(13) || chr(10) || '				if (!CParamValidator.isFloat(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a floating-point number'';' || chr(13) || chr(10) || '')||
TO_NCLOB('					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseFloat(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''boolean'':' || chr(13) || chr(10) || '				if (CParamValidator.inArray(value, [''1'', ''true'', ''yes'', ''on''])) {' || chr(13) || chr(10) || '					value = true;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (CParamValidator.inArray(value, [''0'', ''false'', ''no'', ''off''])) {' || chr(13) || chr(10) || '					value = false;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a boolean-like.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''array'':' || chr(13) || chr(10) || '				try {' || chr(13) || chr(10) || '					value = JSON.parse(value);' || chr(13) || chr(10) || '				} catch (error) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" contains invalid JSON.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''array'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an array.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {' || chr(13) || chr(10) || '					value = value.reduce(function(acc, obj) {' || chr(13) || chr(10) || '						acc[obj.tag] = obj.value || null;' || chr(13) || chr(10) || '						return acc;' || chr(13) || chr(10) || '					}, {});' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''object'':' || chr(13) || chr(10) || '				value = JSON.parse(value);' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''object'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an object.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '')||
TO_NCLOB('				break;' || chr(13) || chr(10) || '			default:' || chr(13) || chr(10) || '				throw ''Unexpected attribute type "'' + rule.type + ''" for value "'' + key + ''". Available: '' +' || chr(13) || chr(10) || '				[''integer'', ''float'', ''string'', ''boolean'', ''array'', ''object''].join('', '');' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		params[key] = value;' || chr(13) || chr(10) || '		if (CParamValidator.inArray(rule.type, [''integer'', ''float'']) && error_message === null && (CParamValidator.isDefined(rule.min)' || chr(13) || chr(10) || '			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be a number '' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))' || chr(13) || chr(10) || '				? (rule.min + ''..'' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? ''>'' + rule.min : ''<'' + rule.max));' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be in the array '' + JSON.stringify(rule.array);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {' || chr(13) || chr(10) || '			error_message = ''The macro '' + ((CParamValidator.isDefined(rule.macro)) ? ''{'' + rule.macro + ''} '' : '' '') + ''is not set'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (error_message !== null) {' || chr(13) || chr(10) || '			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {' || chr(13) || chr(10) || '				params[key] = rule.default;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '')||
TO_NCLOB('				Zabbix.log(4, ''Default value for "'' + key + ''" must be a '' + rule.type + ''. Skipped.'');' || chr(13) || chr(10) || '				throw ''Incorrect value for variable "'' + key + ''". '' + error_message;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return this;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	validate: function(rules, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(params, ''object'') || CParamValidator.isType(params, ''array'')) {' || chr(13) || chr(10) || '			throw ''Incorrect parameters value. The value must be an object.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		for (var key in rules) {' || chr(13) || chr(10) || '			CParamValidator.check(key, rules[key], params);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CHttpRequest = function(logger) {' || chr(13) || chr(10) || '	this.request = new HttpRequest();' || chr(13) || chr(10) || '	if (typeof logger !== ''object'' || logger === null) {' || chr(13) || chr(10) || '		this.logger = Zabbix;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		this.logger = logger;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.clearHeader = function() {' || chr(13) || chr(10) || '		this.request.clearHeader();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.addHeaders = function(value) {' || chr(13) || chr(10) || '		var headers = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (typeof value === ''object'' && value !== null) {' || chr(13) || chr(10) || '			if (!Array.isArray(value)) {' || chr(13) || chr(10) || '				Object.keys(value).forEach(function(key) {' || chr(13) || chr(10) || '					headers.push(key + '': '' + value[key]);' || chr(13) || chr(10) || '				});' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '')||
TO_NCLOB('				headers = value;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (typeof value === ''string'') {' || chr(13) || chr(10) || '			value.split(''\r\n'').forEach(function(header) {' || chr(13) || chr(10) || '				headers.push(header);' || chr(13) || chr(10) || '			});' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		for (var idx in headers) {' || chr(13) || chr(10) || '			this.request.addHeader(headers[idx]);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.setProxy = function(proxy) {' || chr(13) || chr(10) || '		this.request.setProxy(proxy);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.plainRequest = function(method, url, data) {' || chr(13) || chr(10) || '		var resp = null;' || chr(13) || chr(10) || '		method = method.toLowerCase();' || chr(13) || chr(10) || '		this.logger.log(4, ''Sending '' + method + '' request:'' + JSON.stringify(data));' || chr(13) || chr(10) || '		if ([''get'', ''post'', ''put'', ''patch'', ''delete'', ''trace''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url, data);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if ([''connect'', ''head'', ''options''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unexpected method. Method '' + method + '' is not supported.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.logger.log(4, ''Response has been received: '' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.jsonRequest = function(method, url, data) {' || chr(13) || chr(10) || '		this.addHeaders(''Content-Type: application/json'');' || chr(13) || chr(10) || '')||
TO_NCLOB('		var resp = this.plainRequest(method, url, JSON.stringify(data));' || chr(13) || chr(10) || '		try {' || chr(13) || chr(10) || '			resp = JSON.parse(resp);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		catch (error) {' || chr(13) || chr(10) || '			throw ''Failed to parse response: not well-formed JSON was received'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.getStatus = function() {' || chr(13) || chr(10) || '		return this.request.getStatus();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var ZABBIX_SEVERITY_MAP = ["not_classified", "information", "warning", "average", "high", "disaster"];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var serviceLogName = ''Jira Service Management Webhook'',' || chr(13) || chr(10) || '	Logger = new CLogger(serviceLogName),' || chr(13) || chr(10) || '	Jira = CWebhook;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.onCheckParams = function () {' || chr(13) || chr(10) || '	CParamValidator.validate({' || chr(13) || chr(10) || '		jira_url: { type: ''string'', url: true},' || chr(13) || chr(10) || '		jira_user: { type: ''string'' },' || chr(13) || chr(10) || '		jira_password: { type: ''string'' },' || chr(13) || chr(10) || '		jira_request_type_id: { type: ''string'' },' || chr(13) || chr(10) || '		jira_servicedesk_id: { type: ''string'' },' || chr(13) || chr(10) || '		issue_comments_public: {type: ''boolean'', default: false},' || chr(13) || chr(10) || '		event_source: { type: ''string'' },' || chr(13) || chr(10) || '		alert_subject: { type: ''string'' },' || chr(13) || chr(10) || '		alert_message: { type: ''string'' },' || chr(13) || chr(10) || '		event_nseverity: { type: ''integer'', default: 0 }' || chr(13) || chr(10) || '	}, this.params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('	this.priority = this.params.event_source == 3 ? this.params.jira_priority_internal : this.params[''severity_'' + ZABBIX_SEVERITY_MAP[this.params.event_nseverity]];' || chr(13) || chr(10) || '	this.params.event_tags_json = parseTags(this.params.event_tags_json, false);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.event_tags_json.length > 0) {' || chr(13) || chr(10) || '		this.labels = setLabels(this.params.event_tags_json);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	parseOptionalFields();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.result = { tags: {} };' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function escapeMarkup(str) {' || chr(13) || chr(10) || '	var length = str.length,' || chr(13) || chr(10) || '		result = '''',' || chr(13) || chr(10) || '		markup = [''{'', ''|'', ''}'', ''~'', ''_'', ''\\'', ''['', '']'', ''^'', ''<'', ''>'', ''?'', ''!'', ''#'', ''+'', ''*'', ''&''];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	for (var i = 0; i < length; i++) {' || chr(13) || chr(10) || '		var char = str[i];' || chr(13) || chr(10) || '		result += (markup.indexOf(char) !== -1) ? (''&#'' + str[i].charCodeAt() + '';'') : char;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function parseOptionalFields() {' || chr(13) || chr(10) || '	this.params.customfields = {};' || chr(13) || chr(10) || '	this.params.components = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	Object.keys(this.params).forEach(function (key) {' || chr(13) || chr(10) || '		if (key.startsWith(''customfield_'')) {' || chr(13) || chr(10) || '			this.params.customfields[key] = this.params[key];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (key.startsWith(''component_'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			this.params.components.push({"name": this.params[key]})' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	});' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.addCustomFields = function (data, requestFieldValues) {' || chr(13) || chr(10) || '	if (typeof this.params.customfields === ''object'' && Object.keys(this.params.customfields).length) {' || chr(13) || chr(10) || '		var schemaData = this.sendRequest(''GET'', ''/rest/api/latest/field''),' || chr(13) || chr(10) || '			schema = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		schemaData.forEach(function (item) {' || chr(13) || chr(10) || '			schema[item.id] = item.schema;' || chr(13) || chr(10) || '		});' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		var placeholder = (requestFieldValues ? ''requestFieldValues'' : ''fields'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		Object.keys(this.params.customfields).forEach(function (field) {' || chr(13) || chr(10) || '			if (typeof schema[field] === ''object'' && schema[field].type) {' || chr(13) || chr(10) || '				const type = schema[field].type;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				if (type === ''number'') {' || chr(13) || chr(10) || '					data[placeholder][field] = parseInt(this.params.customfields[field]);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (type === ''string'' && schema[field][''custom''].split('':'')[1] === ''url'') {' || chr(13) || chr(10) || '					if (this.params.customfields[field] === ''zabbix_url'') {' || chr(13) || chr(10) || '						data[placeholder][field] = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);' || chr(13) || chr(10) || '					} else {' || chr(13) || chr(10) || '						data[placeholder][field] = this.params.customfields[field];' || chr(13) || chr(10) || '					}' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (type === ''date'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('					if (this.params.customfields[field].match(/\d+[.-]\d+[.-]\d+/) !== null) {' || chr(13) || chr(10) || '						data[placeholder][field] = this.params.customfields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '					}' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (type === ''datetime'') {' || chr(13) || chr(10) || '					if (this.params.customfields[field].match(/\d+[.-]\d+[.-]\d+T\d+:\d+:\d+/) !== null) {' || chr(13) || chr(10) || '						data[placeholder][field] = this.params.customfields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '					}' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (type === ''option'') {' || chr(13) || chr(10) || '					data[placeholder][field] = { ''value'': this.params.customfields[field] };' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (type === ''array'') {' || chr(13) || chr(10) || '					if (schema[field].items === ''option'') {' || chr(13) || chr(10) || '						const valuesList = this.params.customfields[field].split('','');' || chr(13) || chr(10) || '						data[placeholder][field] = [];' || chr(13) || chr(10) || '						valuesList.forEach(function (val) {' || chr(13) || chr(10) || '							data[placeholder][field].push({''value'': val})' || chr(13) || chr(10) || '						});' || chr(13) || chr(10) || '					}' || chr(13) || chr(10) || '					else {' || chr(13) || chr(10) || '						data[placeholder][field] = [this.params.customfields[field]];' || chr(13) || chr(10) || '					}' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else {' || chr(13) || chr(10) || '					data[placeholder][field] = this.params.customfields[field];' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		});' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		Logger.log(Logger.WARN, ''No customfields found.'');' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return data;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('function parseTags(event_tags) {' || chr(13) || chr(10) || '	try {' || chr(13) || chr(10) || '		return JSON.parse(event_tags);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	catch (error) {' || chr(13) || chr(10) || '		if (this.params.event_source == 0 || this.params.event_source > 2) {' || chr(13) || chr(10) || '			Logger.log(Logger.WARN, ''No event tags were found. Should be an object. Received event tags: "'' + event_tags + ''".'');' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		return [];' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getTagValue(tags, key, throw_on_fail) {' || chr(13) || chr(10) || '	for (i in tags) {' || chr(13) || chr(10) || '		if (tags[i].tag === key) {' || chr(13) || chr(10) || '			return tags[i].value' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (!throw_on_fail) {' || chr(13) || chr(10) || '		return false;' || chr(13) || chr(10) || '	} else {' || chr(13) || chr(10) || '		throw ''Tag "'' + key + ''" is not in the event tag list.''' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function setLabels(event_tags_json) {' || chr(13) || chr(10) || '	var buffer = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	event_tags_json.forEach(function (tag) {' || chr(13) || chr(10) || '		if (typeof tag.tag !== ''undefined'' && typeof tag.value !== ''undefined'' && !tag.tag.startsWith(''__zbx'')) {' || chr(13) || chr(10) || '			label = (tag.tag + (tag.value ? ('':'' + tag.value) : '''')).replace(/\s/g, ''_'');' || chr(13) || chr(10) || '			if (label.length < 256) {' || chr(13) || chr(10) || '				buffer.push(label);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	});' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (buffer.length === 0) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		Logger.log(Logger.WARN, ''No labels were set.'');' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return buffer;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.commentIssue = function (issue_key) {' || chr(13) || chr(10) || '	var data = {' || chr(13) || chr(10) || '		body: this.params.alert_message,' || chr(13) || chr(10) || '		public: this.params.issue_comments_public' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '	this.sendRequest(''POST'', ''/rest/servicedeskapi/request/'' + encodeURIComponent(issue_key) + ''/comment'', data);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.sendRequest = function (method, path, data) {' || chr(13) || chr(10) || '	this.request.clearHeader();' || chr(13) || chr(10) || '	this.request.addHeaders(''Authorization: Basic '' + btoa(this.params.jira_user + '':'' + this.params.jira_password));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	var response = this.request.jsonRequest(method, this.params.jira_url + path, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if ((this.request.getStatus() !== 200 && this.request.getStatus() !== 201)) {' || chr(13) || chr(10) || '		Logger.log(Logger.WARN, ''HTTP code: '' + this.request.getStatus());' || chr(13) || chr(10) || '		if (CParamValidator.isType(response.description, ''string'')) {' || chr(13) || chr(10) || '			throw response.description;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			Logger.log(Logger.WARN, ''Request not successful. Received response: '' + JSON.stringify(response));' || chr(13) || chr(10) || '			throw ''Unknown error. Check debug log for more information.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return response;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('Jira.prototype.onProblem = function (alert) {' || chr(13) || chr(10) || '	if (this.params.event_tags_json.length > 0 && getTagValue(this.params.event_tags_json, ''__zbx_jira_requestkey'', false) !== false) {' || chr(13) || chr(10) || '		return this.onUpdate(alert, true);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	var data = {' || chr(13) || chr(10) || '		serviceDeskId: this.params.jira_servicedesk_id,' || chr(13) || chr(10) || '		requestTypeId: this.params.jira_request_type_id,' || chr(13) || chr(10) || '		requestFieldValues: {' || chr(13) || chr(10) || '			summary: this.params.alert_subject,' || chr(13) || chr(10) || '			description: this.params.alert_message,' || chr(13) || chr(10) || '			priority: {' || chr(13) || chr(10) || '				"name": this.priority' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.labels && this.labels.length > 0) {' || chr(13) || chr(10) || '		data.requestFieldValues.labels = this.labels;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.components && this.params.components.length > 0) {' || chr(13) || chr(10) || '		data.requestFieldValues.components = this.params.components;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	var response = this.sendRequest(''POST'', ''/rest/servicedeskapi/request'', this.addCustomFields(data, true));' || chr(13) || chr(10) || '	this.result.tags = {' || chr(13) || chr(10) || '		__zbx_jira_requestkey: response.issueKey,' || chr(13) || chr(10) || '		__zbx_jira_requestlink: this.params.jira_url + ''/browse/'' + response.issueKey' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.onUpdate = function (alert, dontUpdatePriority) {' || chr(13) || chr(10) || '	var data = {' || chr(13) || chr(10) || '		fields: {' || chr(13) || chr(10) || '')||
TO_NCLOB('			summary: this.params.alert_subject,' || chr(13) || chr(10) || '			priority: {' || chr(13) || chr(10) || '				"name": this.priority' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (dontUpdatePriority && this.params.event_source != 0) {' || chr(13) || chr(10) || '		delete data[''fields''][''priority''];' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	var jira_issue_key = getTagValue(this.params.event_tags_json, ''__zbx_jira_requestkey'', true);' || chr(13) || chr(10) || '	this.sendRequest(''PUT'', ''/rest/api/latest/issue/'' + encodeURIComponent(jira_issue_key) + ''?returnIssue=true'', this.addCustomFields(data));' || chr(13) || chr(10) || '	this.commentIssue(jira_issue_key);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.onResolve = function (alert) {' || chr(13) || chr(10) || '	return this.onUpdate(alert, true);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.onDiscovery = function (alert) {' || chr(13) || chr(10) || '	this.priority = this.params.jira_priority_discovery;' || chr(13) || chr(10) || '	return this.onProblem(alert);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Jira.prototype.onAutoreg = function (alert) {' || chr(13) || chr(10) || '	this.priority = this.params.jira_priority_autoregistration;' || chr(13) || chr(10) || '	return this.onProblem(alert);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '	var hook = new Jira(value);' || chr(13) || chr(10) || '	hook.request = new CHttpRequest(Logger);' || chr(13) || chr(10) || '	return hook.run();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '')||
TO_NCLOB('	Logger.log(Logger.WARN, ''notification failed: '' + error);' || chr(13) || chr(10) || '	throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_jira_requestlink}','Jira Service Management: {EVENT.TAGS.__zbx_jira_requestkey}','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/jira_service_management' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. To make this integration work, you will need the following from Jira:' || chr(13) || chr(10) || '  * Jira instance URL;' || chr(13) || chr(10) || '  * Jira service desk id and request type id that the issues created by Zabbix will use;' || chr(13) || chr(10) || '  * Jira username and password or API token. API token is strongly recommended and can be obtained at https://id.atlassian.com/manage/api-tokens.' || chr(13) || chr(10) || '2. In the Zabbix web interface, go to Administration → Macros section. Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend.' || chr(13) || chr(10) || '3. On this page replace the placeholder ''<...>'' values with the ones from the step #1.' || chr(13) || chr(10) || '4. In Zabbix, you need to have a Zabbix user and add Media with the Jira Service Management media type. Make sure this user has access to all hosts for which you would like problem issues to be created in Jira.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('48','4','Line','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('function sendMessage(to, messages, params) {' || chr(13) || chr(10) || '    var response,' || chr(13) || chr(10) || '        request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        request.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '    request.addHeader(''Authorization: Bearer '' + params.bot_token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    response = request.post(''https://api.line.me/v2/bot/message/push'', JSON.stringify({' || chr(13) || chr(10) || '        "to": to,' || chr(13) || chr(10) || '        "messages": messages' || chr(13) || chr(10) || '    }));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (request.getStatus() !== 200) {' || chr(13) || chr(10) || '        throw response;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function validateParams(params) {' || chr(13) || chr(10) || '    if (typeof params.bot_token !== ''string'' || params.bot_token.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "bot_token" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''0'';' || chr(13) || chr(10) || '        params.event_severity = ''Not classified'';' || chr(13) || chr(10) || '        params.event_update_status = ''0'';' || chr(13) || chr(10) || '')||
TO_NCLOB('    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''1'' || params.event_source === ''2'') {' || chr(13) || chr(10) || '        params.event_value = ''1'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_nseverity" parameter given: '' + params.event_nseverity + ''\nMust be 0-5.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(params.trigger_id) && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''field "trigger_id" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!/^(http|https):\/\/.+/.test(params.zabbix_url)) {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" must contain a schema'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getZabbixProblemLink(params) {' || chr(13) || chr(10) || '')||
TO_NCLOB('    return params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') + ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id;    ' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    validateParams(params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    severity_emoji = [' || chr(13) || chr(10) || '        "\u26AA",' || chr(13) || chr(10) || '        "\uD83D\uDD35",' || chr(13) || chr(10) || '        "\uD83D\uDFE4",' || chr(13) || chr(10) || '        "\uD83D\uDFE1",' || chr(13) || chr(10) || '        "\uD83D\uDFE0",' || chr(13) || chr(10) || '        "\uD83D\uDD34",' || chr(13) || chr(10) || '    ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // If its a trigger and a recovery operation and not an update operation.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_value === ''0'' && params.event_update_status === ''0'') {' || chr(13) || chr(10) || '        var line_message = [' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                "type": "text",' || chr(13) || chr(10) || '                "text": ''\u2705 '' + params.alert_subject + ''\n\n'' + params.alert_message + ''\n'' + params.trigger_description + ''\n\n'' + getZabbixProblemLink(params)' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // If its a trigger and its a problem.' || chr(13) || chr(10) || '    else if (params.event_source === ''0'' && params.event_value === ''1'') {' || chr(13) || chr(10) || '        var line_message = [' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                "type": "text",' || chr(13) || chr(10) || '')||
TO_NCLOB('                "text": severity_emoji[params.event_nseverity] + '' '' + params.alert_subject + ''\n\n'' + params.alert_message + ''\n'' + params.trigger_description + ''\n\n'' + getZabbixProblemLink(params)' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // If its a trigger and its an update operation.' || chr(13) || chr(10) || '    else if (params.event_source === ''0'' && params.event_update_status === ''1'') {' || chr(13) || chr(10) || '        var line_message = [' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                "type": "text",' || chr(13) || chr(10) || '                "text": ''\u2733 '' + severity_emoji[params.event_nseverity] + '' '' + params.alert_subject + ''\n\n'' + params.alert_message + ''\n'' + params.trigger_description + ''\n\n'' + getZabbixProblemLink(params)' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        var line_message = [' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                "type": "text",' || chr(13) || chr(10) || '                "text": params.alert_subject + ''\n\n'' + params.alert_message + ''\n''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    sendMessage(params.send_to, line_message, params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (err) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Line Webhook ] Line notification failed : '' + err);' || chr(13) || chr(10) || '    throw ''Line notification failed : '' + err;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','Please refer to setup guide here: https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/line' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Set bot_token parameter to your Line bot token.' || chr(13) || chr(10) || 'When assigning Line media to the Zabbix user - add the ID of the target recipient. Use a userId, groupId, or roomId value.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('49','4','ManageEngine ServiceDesk','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var MEngine = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        MEngine.params = params;' || chr(13) || chr(10) || '        if (typeof MEngine.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!MEngine.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                MEngine.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            MEngine.params.url += ''api/v3/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (MEngine.params.on_premise.toLowerCase() !== ''true''' || chr(13) || chr(10) || '                && typeof MEngine.params.on_demand_url_auth === ''string'') {' || chr(13) || chr(10) || '            if (!MEngine.params.on_demand_url_auth.endsWith(''/'')) {' || chr(13) || chr(10) || '                MEngine.params.on_demand_url_auth += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            MEngine.params.on_demand_url_auth += ''oauth/v2/token?'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        MEngine.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createLink: function (id, url) {' || chr(13) || chr(10) || '        return url + (url.endsWith(''/'') ? '''' : ''/'') +' || chr(13) || chr(10) || '            ((MEngine.params.on_premise.toLowerCase() === ''true'')' || chr(13) || chr(10) || '                ? (''WorkOrder.do?woMode=viewWO&woID='' + id)' || chr(13) || chr(10) || '')||
TO_NCLOB('                : (''app/itdesk/ui/requests/'' + id + ''/details'')' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    refreshAccessToken: function () {' || chr(13) || chr(10) || '        [' || chr(13) || chr(10) || '            ''on_demand_url_auth'',' || chr(13) || chr(10) || '            ''on_demand_refresh_token'',' || chr(13) || chr(10) || '            ''on_demand_client_id'',' || chr(13) || chr(10) || '            ''on_demand_client_secret''' || chr(13) || chr(10) || '        ].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof MEngine.params !== ''object'' || typeof MEngine.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || MEngine.params[field].trim() === '''' ) {' || chr(13) || chr(10) || '                throw ''Required MEngine param is not set: "sd_'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            url = MEngine.params.on_demand_url_auth +' || chr(13) || chr(10) || '                ''refresh_token='' + encodeURIComponent(MEngine.params.on_demand_refresh_token) +' || chr(13) || chr(10) || '                ''&grant_type=refresh_token&client_id='' + encodeURIComponent(MEngine.params.on_demand_client_id) +' || chr(13) || chr(10) || '                ''&client_secret='' + encodeURIComponent(MEngine.params.on_demand_client_secret) +' || chr(13) || chr(10) || '                ''&redirect_uri=https://www.zoho.com&scope=SDPOnDemand.requests.ALL'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (MEngine.HTTPProxy) {' || chr(13) || chr(10) || '            request.setProxy(MEngine.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        Zabbix.log(4, ''[ ManageEngine Webhook ] Refreshing access token. Request: '' + url);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(url);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ManageEngine Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '        request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            response = JSON.parse(response);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        catch (error) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ ManageEngine Webhook ] Failed to parse response received from Zoho Accounts'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if ((request.getStatus() < 200 || request.getStatus() >= 300) && !response.access_token) {' || chr(13) || chr(10) || '            throw ''Access token refresh failed with HTTP status code '' + request.getStatus() +' || chr(13) || chr(10) || '                ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            MEngine.params.on_demand_auth_token = response.access_token;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = MEngine.params.url + query,' || chr(13) || chr(10) || '            input,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            message;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (MEngine.params.on_premise.toLowerCase() === ''true'') {' || chr(13) || chr(10) || '            request.addHeader(''TECHNICIAN_KEY: '' + MEngine.params.on_premise_auth_token);' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            request.addHeader(''Authorization: Zoho-oauthtoken '' + MEngine.params.on_demand_auth_token);' || chr(13) || chr(10) || '            request.addHeader(''Accept: application/v3+json'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (MEngine.HTTPProxy) {' || chr(13) || chr(10) || '            request.setProxy(MEngine.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        input = ''input_data='' + encodeURIComponent(data);' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ManageEngine Webhook ] Sending request: '' + url + ''?'' + input);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, input);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, input);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ManageEngine Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            response = JSON.parse(response);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('        catch (error) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ ManageEngine Webhook ] Failed to parse response received from ManageEngine'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if ((request.getStatus() < 200 || request.getStatus() >= 300)' || chr(13) || chr(10) || '                && typeof response.response_status !== ''object'') {' || chr(13) || chr(10) || '            throw ''Request failed with HTTP status code '' + request.getStatus() +' || chr(13) || chr(10) || '                ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if (typeof response.response_status === ''object'' && response.response_status.status === ''failed'') {' || chr(13) || chr(10) || '            message = ''Request failed with status_code '';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (typeof response.response_status.messages === ''object''' || chr(13) || chr(10) || '                    && response.response_status.messages[0]' || chr(13) || chr(10) || '                    && response.response_status.messages[0].message) {' || chr(13) || chr(10) || '                message += response.response_status.messages[0].status_code +' || chr(13) || chr(10) || '                    ''. Message: '' + response.response_status.messages[0].message;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '                message += response.response_status.status_code;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            message += ''. Check debug log for more information.'';' || chr(13) || chr(10) || '            throw message;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if (response.request) {' || chr(13) || chr(10) || '            return response.request.id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createPaylaod: function (fields, isNote) {' || chr(13) || chr(10) || '        var data = {},' || chr(13) || chr(10) || '            result;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (isNote) {' || chr(13) || chr(10) || '            data.description = fields[''field_string:description''].replace(/(?:\r\n|\r|\n)/g, ''<br>'');' || chr(13) || chr(10) || '            result = {request_note: data};' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    if (fields[field].trim() === '''') {' || chr(13) || chr(10) || '                        Zabbix.log(4, ''[ ManageEngine Webhook ] Field "'' + field +' || chr(13) || chr(10) || '                            ''" can\''t be empty. The field ignored.'');' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                    else {' || chr(13) || chr(10) || '                        try {' || chr(13) || chr(10) || '                            var prefix = field.split('':'')[0],' || chr(13) || chr(10) || '                                root;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                            if  (prefix.startsWith(''udf_'') && !data.udf_fields) {' || chr(13) || chr(10) || '                                data.udf_fields = {};' || chr(13) || chr(10) || '                                root = data.udf_fields;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                            else if (prefix.startsWith(''udf_'')) {' || chr(13) || chr(10) || '                                root = data.udf_fields;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                            else {' || chr(13) || chr(10) || '')||
TO_NCLOB('                                root = data;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                            if (prefix.endsWith(''string'')) {' || chr(13) || chr(10) || '                                root[field.substring(field.indexOf('':'') + 1)' || chr(13) || chr(10) || '                                    .toLowerCase()] = fields[field];' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                            else {' || chr(13) || chr(10) || '                                root[field.substring(field.indexOf('':'') + 1)' || chr(13) || chr(10) || '                                    .toLowerCase()] = {' || chr(13) || chr(10) || '                                    name: fields[field]' || chr(13) || chr(10) || '                                };' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                        catch (error) {' || chr(13) || chr(10) || '                            Zabbix.log(4, ''[ ManageEngine Webhook ] Can\''t parse field "'' + field +' || chr(13) || chr(10) || '                                ''". The field ignored.'');' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '            if (data.description) {' || chr(13) || chr(10) || '                data.description = data.description.replace(/(?:\r\n|\r|\n)/g, ''<br>'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            result = {request: data};' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '')||
TO_NCLOB('        sd = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''sd_on_premise'', ''field_string:subject'', ''field_string:description'',' || chr(13) || chr(10) || '            ''event_recovery_value'', ''event_source'', ''event_value'', ''event_update_status''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''sd_'')) {' || chr(13) || chr(10) || '                sd[key.substring(3)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''field_'') || key.startsWith(''udf_field_'')) {' || chr(13) || chr(10) || '                fields[key] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_update_status === ''1'' && (typeof params.sd_request_id === ''undefined''' || chr(13) || chr(10) || '            || params.sd_request_id.trim() === ''''' || chr(13) || chr(10) || '            || params.sd_request_id === ''{EVENT.TAGS.__zbx_sd_request_id}''' || chr(13) || chr(10) || '')||
TO_NCLOB('            || params.sd_request_id === ''*UNKNOWN*'')) {' || chr(13) || chr(10) || '        throw ''Parameter "sd_request_id" can\''t be empty for update operation.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    MEngine.setParams(sd);' || chr(13) || chr(10) || '    MEngine.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (MEngine.params.on_premise.toLowerCase() !== ''true'') {' || chr(13) || chr(10) || '        MEngine.refreshAccessToken();' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {' || chr(13) || chr(10) || '        fields[''field_object:priority''] = params[''priority_'' + severities[params.event_nseverity].name]' || chr(13) || chr(10) || '        || ''Normal'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        MEngine.request(''post'', ''requests'', MEngine.createPaylaod(fields));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params.event_update_status === ''0'') {' || chr(13) || chr(10) || '        fields[''field_object:priority''] = params[''priority_'' + severities[params.event_nseverity].name]' || chr(13) || chr(10) || '        || ''Normal'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var id = MEngine.request(''post'', ''requests'', MEngine.createPaylaod(fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_sd_request_id = id;' || chr(13) || chr(10) || '        result.tags.__zbx_sd_request_link = MEngine.createLink(id, params.sd_url);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (params.event_update_status === ''1'') {' || chr(13) || chr(10) || '            MEngine.request(''post'', ''requests/'' + params.sd_request_id + ''/notes'',' || chr(13) || chr(10) || '                MEngine.createPaylaod(fields, true)' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        delete fields[''field_string:description''];' || chr(13) || chr(10) || '        MEngine.request(''put'', ''requests/'' + params.sd_request_id, MEngine.createPaylaod(fields));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ ManageEngine Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_sd_request_link}','ManageEngine: {EVENT.TAGS.__zbx_sd_request_id}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('50','4','MantisBT','','','','','','','','25','0','0','0','0','1','1','10s','1',TO_NCLOB('var Mantisbt = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        Mantisbt.params = params;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Mantisbt.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    checkUrlFormat: function (url) {' || chr(13) || chr(10) || '        if (typeof url === ''string'' && !url.endsWith(''/'')) {' || chr(13) || chr(10) || '            url += ''/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (url.indexOf(''http://'') === -1 && url.indexOf(''https://'') === -1) {' || chr(13) || chr(10) || '            url = ''https://'' + url;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return url;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getProblemURL: function (zabbix_url, triggerid, eventid, event_source) {' || chr(13) || chr(10) || '        var problem_url = zabbix_url;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (event_source === ''0'') {' || chr(13) || chr(10) || '            problem_url += ''tr_events.php?triggerid='' + triggerid + ''&eventid='' + eventid;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return problem_url;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, url, data) {' || chr(13) || chr(10) || '        [''token'', ''url'', ''category''].forEach(function (field) {' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (typeof Mantisbt.params !== ''object'' || typeof Mantisbt.params[field] === ''undefined'' || Mantisbt.params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required MantisBT param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: '' + Mantisbt.params.token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Mantisbt.HTTPProxy !== ''undefined'' && Mantisbt.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Mantisbt.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ MantisBT Webhook ] Sending request: '' + url + ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''patch'':' || chr(13) || chr(10) || '                response = request.patch(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        Zabbix.log(4, ''[ MantisBT Webhook ] Received response with status code '' + request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ MantisBT Webhook ] Failed to parse the response received from MantisBT'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof response !== ''object'') {' || chr(13) || chr(10) || '            throw ''Failed to process the response received from MantisBT. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (typeof response.message !== ''undefined'') {' || chr(13) || chr(10) || '                message += '': '' + response.message;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        mantisbt = {},' || chr(13) || chr(10) || '        url = '''',' || chr(13) || chr(10) || '        data = {},' || chr(13) || chr(10) || '')||
TO_NCLOB('        result = { tags: {} },' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''alert_message'', ''event_source'', ''event_value'', ''event_update_action'',' || chr(13) || chr(10) || '            ''event_update_status'', ''event_recovery_value'', ''event_nseverity'', ''event_tagsjson'',' || chr(13) || chr(10) || '            ''event_id'', ''trigger_id'', ''zabbix_url'', ''alert_sendto'',' || chr(13) || chr(10) || '            ''mantisbt_token'', ''mantisbt_url'', ''mantisbt_category'', ''mantisbt_issue_number'', ''mantisbt_use_zabbix_tags''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        method,' || chr(13) || chr(10) || '        severities = [''none'', ''low'', ''normal'', ''high'', ''urgent'', ''immediate''];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''mantisbt_'')) {' || chr(13) || chr(10) || '                mantisbt[key.substring(9)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1'' && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported for trigger-based actions only.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''' || params.zabbix_url === ''{$ZABBIX.URL}'') {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" cannot be empty.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check for backslash in the end of url and schema.' || chr(13) || chr(10) || '    mantisbt.url = Mantisbt.checkUrlFormat(mantisbt.url);' || chr(13) || chr(10) || '    params.zabbix_url = Mantisbt.checkUrlFormat(params.zabbix_url);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // In case of resolve event.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        method = "patch";' || chr(13) || chr(10) || '        url = mantisbt.url + ''api/rest/issues/'' + mantisbt.issue_number;' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '            summary: params.alert_subject,' || chr(13) || chr(10) || '            status: {' || chr(13) || chr(10) || '')||
TO_NCLOB('                name: "resolved"' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        if (/commented/.test(params.event_update_action)) {' || chr(13) || chr(10) || '            data.additional_information = params.event_update_message;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        process_tags = false;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // In case of update event.' || chr(13) || chr(10) || '    else if (params.event_source === ''0'' && params.event_update_status === ''1'') {' || chr(13) || chr(10) || '        method = "patch";' || chr(13) || chr(10) || '        url = mantisbt.url + ''api/rest/issues/'' + mantisbt.issue_number;' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '            status: {},' || chr(13) || chr(10) || '            priority: {' || chr(13) || chr(10) || '                name: severities[parseInt(params.event_nseverity, 10)]' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        if (/commented/.test(params.event_update_action)) {' || chr(13) || chr(10) || '            data.additional_information = params.event_update_message;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (/acknowledged/.test(params.event_update_action)) {' || chr(13) || chr(10) || '            data.status.name = "acknowledged";' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (/unacknowledged/.test(params.event_update_action)) {' || chr(13) || chr(10) || '            data.status.name = "new";' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        process_tags = false;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        method = ''post'';' || chr(13) || chr(10) || '        url = mantisbt.url + ''api/rest/issues'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '')||
TO_NCLOB('            summary: params.alert_subject,' || chr(13) || chr(10) || '            description: params.alert_message,' || chr(13) || chr(10) || '            project: { name: params.alert_sendto },' || chr(13) || chr(10) || '            category: { name: mantisbt.category },' || chr(13) || chr(10) || '            priority: {' || chr(13) || chr(10) || '                name: parseInt(params.event_nseverity, 10) ? severities[parseInt(params.event_nseverity, 10)] : "none"' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        if (params.event_source === ''0'') {' || chr(13) || chr(10) || '            problem_url = Mantisbt.getProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source);' || chr(13) || chr(10) || '            data.description += ''\n'' + problem_url;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (mantisbt.use_zabbix_tags === "true") {' || chr(13) || chr(10) || '                var alert_tags = JSON.parse(params.event_tagsjson);' || chr(13) || chr(10) || '                data.tags = alert_tags.map(function (t) { return { name: t.value ? (t.tag + '': '' + t.value) : t.tag }; });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        process_tags = true;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Mantisbt.setParams(mantisbt);' || chr(13) || chr(10) || '    Mantisbt.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var response = Mantisbt.request(method, url, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (process_tags) {' || chr(13) || chr(10) || '        result.tags.__zbx_mantisbt_issue_number = response.issue.id;' || chr(13) || chr(10) || '        result.tags.__zbx_mantisbt_link = mantisbt.url + ''view.php?id='' + response.issue.id;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    Zabbix.log(4, ''[ MantisBT Webhook ] Result: '' + JSON.stringify(result));' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ MantisBT Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_mantisbt_link}','MantisBT: Issue ID {EVENT.TAGS.__zbx_mantisbt_issue_number}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('51','4','Mattermost','','','','','','','','25','0','0','0','0','1','1','10s','1',TO_NCLOB('var SEVERITY_COLORS = [' || chr(13) || chr(10) || '    ''#97AAB3'', ''#7499FF'', ''#FFC859'',' || chr(13) || chr(10) || '    ''#FFA059'', ''#E97659'', ''#E45959''' || chr(13) || chr(10) || '];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var RESOLVE_COLOR = ''#009900'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var SEND_MODE_HANDLERS = {' || chr(13) || chr(10) || '    alarm: handlerAlarm,' || chr(13) || chr(10) || '    event: handlerEvent' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'if (!String.prototype.format) {' || chr(13) || chr(10) || '    String.prototype.format = function() {' || chr(13) || chr(10) || '        var args = arguments;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return this.replace(/{(\d+)}/g, function(match, number) {' || chr(13) || chr(10) || '            return number in args' || chr(13) || chr(10) || '                ? args[number]' || chr(13) || chr(10) || '                : match' || chr(13) || chr(10) || '            ;' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventProblem(params) {' || chr(13) || chr(10) || '    return params.event_value == 1' || chr(13) || chr(10) || '        && params.event_update_status == 0' || chr(13) || chr(10) || '    ;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventUpdate(params) {' || chr(13) || chr(10) || '    return params.event_value == 1' || chr(13) || chr(10) || '        && params.event_update_status == 1' || chr(13) || chr(10) || '    ;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventResolve(params) {' || chr(13) || chr(10) || '    return params.event_value == 0;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getPermalink(mattermost_url, team_name, postid) {' || chr(13) || chr(10) || '')||
TO_NCLOB('    return ''{0}/{1}/pl/{2}''.format(' || chr(13) || chr(10) || '        mattermost_url.replace(/\/+$/, ''''),' || chr(13) || chr(10) || '        team_name,' || chr(13) || chr(10) || '        postid' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getChannel(send_to) {' || chr(13) || chr(10) || '    switch (true) {' || chr(13) || chr(10) || '        case /.+\/#.+/.test(send_to):' || chr(13) || chr(10) || '            return getChannelByName(send_to);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        case /@.+/.test(send_to):' || chr(13) || chr(10) || '            return getDirectChannel(send_to);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        default:' || chr(13) || chr(10) || '            return getChannelByID(send_to);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getChannelByName(send_to) {' || chr(13) || chr(10) || '    var team_chan = send_to' || chr(13) || chr(10) || '        .trim()' || chr(13) || chr(10) || '        .split(''/#'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.channel_byname.format(team_chan[0], team_chan[1]),' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getDirectChannel(send_to) {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '')||
TO_NCLOB('        JSON.stringify(arguments)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var teamUser = send_to' || chr(13) || chr(10) || '            .trim()' || chr(13) || chr(10) || '            .split(''/@''),' || chr(13) || chr(10) || '        bot = getBotUser(),' || chr(13) || chr(10) || '        user = getUserByName(teamUser[1]);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.post(' || chr(13) || chr(10) || '        Mattermost.direct_channel,' || chr(13) || chr(10) || '        JSON.stringify([bot.id, user.id])' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 201) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    resp.team_name = teamUser[0];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getChannelByID(channelID) {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(arguments)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.get_channel.format(channelID),' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getBotUser() {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(arguments)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.bot_user,' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getUserByName(userName) {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(arguments)' || chr(13) || chr(10) || '')||
TO_NCLOB('    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.user_byname.format(userName),' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getTeamByID(teamID) {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(arguments)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.get_team.format(teamID),' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function createProblemURL(zabbix_url, triggerid, eventid, event_source) {' || chr(13) || chr(10) || '    var problem_url = '''';' || chr(13) || chr(10) || '    if (event_source === ''0'') {' || chr(13) || chr(10) || '        problem_url = ''{0}/tr_events.php?triggerid={1}&eventid={2}''' || chr(13) || chr(10) || '            .format(' || chr(13) || chr(10) || '                zabbix_url,' || chr(13) || chr(10) || '                triggerid,' || chr(13) || chr(10) || '                eventid' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        problem_url = zabbix_url;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return problem_url;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getTagValue(event_tags, key) {' || chr(13) || chr(10) || '    var pattern = new RegExp(''('' + key + '':.+)'');' || chr(13) || chr(10) || '    var tagValue = event_tags' || chr(13) || chr(10) || '        .split('','')' || chr(13) || chr(10) || '        .filter(function (v) {' || chr(13) || chr(10) || '            return v.match(pattern);' || chr(13) || chr(10) || '        })' || chr(13) || chr(10) || '        .map(function (v) {' || chr(13) || chr(10) || '            return v.split('':'')[1];' || chr(13) || chr(10) || '        })[0]' || chr(13) || chr(10) || '        || 0;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return tagValue;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function handlerAlarm(req, params) {' || chr(13) || chr(10) || '    var channel = getChannel(params.send_to);' || chr(13) || chr(10) || '    var fields = {' || chr(13) || chr(10) || '        channel_id: channel.id,' || chr(13) || chr(10) || '        props: {}' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (isEventProblem(params)) {' || chr(13) || chr(10) || '        var team_name = channel.team_name' || chr(13) || chr(10) || '            ? channel.team_name' || chr(13) || chr(10) || '            : getTeamByID(channel.team_id).name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var resp = JSON.parse(req.post(' || chr(13) || chr(10) || '            Mattermost.post_message,' || chr(13) || chr(10) || '            JSON.stringify(fields)' || chr(13) || chr(10) || '        )' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__mattermost_post_id = resp.id;' || chr(13) || chr(10) || '        result.tags.__mattermost_channel_id = channel.id;' || chr(13) || chr(10) || '        result.tags.__mattermost_channel_name = channel.name;' || chr(13) || chr(10) || '        result.tags.__mattermost_message_link = getPermalink(' || chr(13) || chr(10) || '            params.mattermost_url,' || chr(13) || chr(10) || '            team_name,' || chr(13) || chr(10) || '            resp.id' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '')||
TO_NCLOB('    else if (isEventUpdate(params)) {' || chr(13) || chr(10) || '        fields.root_id = getTagValue(params.event_tags, ''mattermost_post_id'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_source === ''0'') {}' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_update_date,' || chr(13) || chr(10) || '                params.event_update_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),' || chr(13) || chr(10) || '                true' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(' || chr(13) || chr(10) || '            Mattermost.post_message, JSON.stringify(fields)' || chr(13) || chr(10) || '        )' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventResolve(params)) {' || chr(13) || chr(10) || '        fields.channel_id = getTagValue(params.event_tags, ''mattermost_channel_id'');' || chr(13) || chr(10) || '        fields.id = getTagValue(params.event_tags, ''mattermost_post_id'');' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                RESOLVE_COLOR,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '')||
TO_NCLOB('                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var post_id = getTagValue(params.event_tags, ''mattermost_post_id'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.put(' || chr(13) || chr(10) || '            Mattermost.chat_update.format(post_id),' || chr(13) || chr(10) || '            JSON.stringify(fields)' || chr(13) || chr(10) || '        )' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 200) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function handlerEvent(req, params) {' || chr(13) || chr(10) || '    var channel = getChannel(params.send_to);' || chr(13) || chr(10) || '    var fields = {' || chr(13) || chr(10) || '        channel_id: channel.id,' || chr(13) || chr(10) || '        props: {}' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isEventProblem(params)) {' || chr(13) || chr(10) || '        var team_name = channel.team_name' || chr(13) || chr(10) || '            ? channel.team_name' || chr(13) || chr(10) || '            : getTeamByID(channel.team_id).name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '')||
TO_NCLOB('        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__mattermost_channel_name = channel.name;' || chr(13) || chr(10) || '        result.tags.__mattermost_message_link = getPermalink(' || chr(13) || chr(10) || '            params.mattermost_url,' || chr(13) || chr(10) || '            team_name,' || chr(13) || chr(10) || '            resp.id' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventUpdate(params)) {' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_update_date,' || chr(13) || chr(10) || '                params.event_update_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),' || chr(13) || chr(10) || '                false' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventResolve(params)) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                RESOLVE_COLOR,' || chr(13) || chr(10) || '                params.event_recovery_date,' || chr(13) || chr(10) || '                params.event_recovery_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function createMessage(' || chr(13) || chr(10) || '    event_severity_color,' || chr(13) || chr(10) || '    event_date,' || chr(13) || chr(10) || '    event_time,' || chr(13) || chr(10) || '    problem_url,' || chr(13) || chr(10) || '    isShort' || chr(13) || chr(10) || ') {' || chr(13) || chr(10) || '    var message = {' || chr(13) || chr(10) || '        fallbac: params.alert_subject,' || chr(13) || chr(10) || '        title: params.alert_subject,' || chr(13) || chr(10) || '        color: event_severity_color,' || chr(13) || chr(10) || '        title_link: problem_url,' || chr(13) || chr(10) || '        footer: problem_url,' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields: [' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Host'',' || chr(13) || chr(10) || '                value: ''{0} [{1}]''.format(params.host_name, params.host_ip),' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '')||
TO_NCLOB('                title: ''Event time'',' || chr(13) || chr(10) || '                value: ''{0} {1}''.format(event_date, event_time),' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Severity'',' || chr(13) || chr(10) || '                value: params.event_severity,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Opdata'',' || chr(13) || chr(10) || '                value: params.event_opdata,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!isShort && params.event_source === ''0'') {' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Event tags'',' || chr(13) || chr(10) || '                value: ''`{0}`''.format(params.event_tags.replace(/__.+?:(.+?,|.+)/g, '''') || ''None''),' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Trigger description'',' || chr(13) || chr(10) || '                value: params.trigger_description,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (params.event_source !== ''0'' || params.event_update_status === ''1'') {' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Details'',' || chr(13) || chr(10) || '                value: params.alert_message,' || chr(13) || chr(10) || '                short: false' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return message;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function validateParams(params) {' || chr(13) || chr(10) || '    if (typeof params.bot_token !== ''string'' || params.bot_token.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "bot_token" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(params.event_id)) {' || chr(13) || chr(10) || '        throw ''Field "event_id" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''0'';' || chr(13) || chr(10) || '        params.event_severity = ''Not classified'';' || chr(13) || chr(10) || '        params.event_update_status = ''0'';' || chr(13) || chr(10) || '        params.send_mode = ''event'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''1'' || params.event_source === ''2'') {' || chr(13) || chr(10) || '        params.event_value = ''1'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '    if (params.event_source === ''1'') {' || chr(13) || chr(10) || '        params.host_name = params.discovery_host_dns;' || chr(13) || chr(10) || '        params.host_ip = params.discovery_host_ip;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_nseverity" parameter given: '' + params.event_nseverity + ''\nMust be 0-5.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.event_severity !== ''string'' || params.event_severity.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "event_severity" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.host_ip !== ''string'' || params.host_ip.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "host_ip" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.host_name !== ''string'' || params.host_name.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "host_name" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (typeof params.mattermost_url !== ''string'' || params.mattermost_url.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "mattermost_url" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!/^(http|https):\/\/.+/.test(params.mattermost_url)) {' || chr(13) || chr(10) || '        throw ''Field "mattermost_url" must contain a schema'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([''alarm'', ''event''].indexOf(params.send_mode) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "send_mode" parameter given: '' + params.send_mode + ''\nMust be "alarm" or "event".'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.send_to !== ''string'' || params.send_to.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "send_to" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(params.trigger_id) && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''field "trigger_id" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!/^(http|https):\/\/.+/.test(params.zabbix_url)) {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" must contain a schema'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    validateParams(params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var req = new HttpRequest(),' || chr(13) || chr(10) || '')||
TO_NCLOB('        fields = {},' || chr(13) || chr(10) || '        result = {tags: {}};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        req.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    req.addHeader(''Content-Type: application/json; charset=utf-8'');' || chr(13) || chr(10) || '    req.addHeader(''Authorization: Bearer '' + params.bot_token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    params.mattermost_url = params.mattermost_url.replace(/\/+$/, '''');' || chr(13) || chr(10) || '    params.zabbix_url = params.zabbix_url.replace(/\/+$/, '''');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var APIEndpoint = params.mattermost_url + ''/api/v4/'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var Mattermost = {' || chr(13) || chr(10) || '        post_message: APIEndpoint + ''posts'',' || chr(13) || chr(10) || '        get_channel: APIEndpoint + ''channels/{0}'',' || chr(13) || chr(10) || '        get_team: APIEndpoint + ''teams/{0}'',' || chr(13) || chr(10) || '        chat_update: APIEndpoint + ''posts/{0}'',' || chr(13) || chr(10) || '        direct_channel: APIEndpoint + ''channels/direct'',' || chr(13) || chr(10) || '        channel_byname: APIEndpoint + ''teams/name/{0}/channels/name/{1}'',' || chr(13) || chr(10) || '        user_byname: APIEndpoint + ''users/username/{0}'',' || chr(13) || chr(10) || '        bot_user: APIEndpoint + ''users/me''' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    params.send_mode = params.send_mode.toLowerCase();' || chr(13) || chr(10) || '    params.send_mode = params.send_mode in SEND_MODE_HANDLERS' || chr(13) || chr(10) || '        ? params.send_mode' || chr(13) || chr(10) || '        : ''alarm'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    SEND_MODE_HANDLERS[params.send_mode](req, params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        return JSON.stringify(result);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        return ''OK'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Mattermost Webhook ] Mattermost notification failed: '' + error);' || chr(13) || chr(10) || '    throw ''Mattermost notification failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__mattermost_message_link}','Open in Mattermost: {EVENT.TAGS.__mattermost_channel_name}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('52','4','MS Teams','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('const CLogger = function(serviceName) {' || chr(13) || chr(10) || '	this.serviceName = serviceName;' || chr(13) || chr(10) || '	this.INFO = 4' || chr(13) || chr(10) || '	this.WARN = 3' || chr(13) || chr(10) || '	this.ERROR = 2' || chr(13) || chr(10) || '	this.log = function(level, msg) {' || chr(13) || chr(10) || '		Zabbix.log(level, ''['' + this.serviceName + ''] '' + msg);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhook = function(value) {' || chr(13) || chr(10) || '	try {' || chr(13) || chr(10) || '		params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''1'', ''2'', ''3'', ''4''].indexOf(params.event_source) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''.\nMust be 0-4.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1 && [''0'', ''1''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1) {' || chr(13) || chr(10) || '			if (params.event_source === ''1'' && [''0'', ''1'', ''2'', ''3''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0-3.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if (params.event_source === ''0'' && [''0'', ''1''].indexOf(params.event_update_status) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '			if (params.event_source === ''4'') {' || chr(13) || chr(10) || '				if ([''0'', ''1'', ''2'', ''3'', ''4'', ''5''].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {' || chr(13) || chr(10) || '					params.event_nseverity = params.event_update_nseverity;' || chr(13) || chr(10) || '					params.event_severity = params.event_update_severity;' || chr(13) || chr(10) || '					params.event_update_status = ''1'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.runCallback = function(name, params) {' || chr(13) || chr(10) || '			if (typeof this[name] === ''function'') {' || chr(13) || chr(10) || '				return this[name].apply(this, [params]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEvent = function(source, event) {' || chr(13) || chr(10) || '			const alert = { source: source, event: event };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''on'' + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEventless = function(source) {' || chr(13) || chr(10) || '			const alert = { source: source, event: null };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.run = function() {' || chr(13) || chr(10) || '			var results = [];' || chr(13) || chr(10) || '')||
TO_NCLOB('			if (typeof this.httpProxy === ''string'' && this.httpProxy.trim() !== '''') {' || chr(13) || chr(10) || '				this.request.setProxy(this.httpProxy);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			const types = { ''0'': ''Trigger'', ''1'': ''Discovery'', ''2'': ''Autoreg'', ''3'': ''Internal'', ''4'': ''Service'' };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if ([''0'', ''3'', ''4''].indexOf(this.params.event_source) !== -1) {' || chr(13) || chr(10) || '				var event = (this.params.event_update_status === ''1'')' || chr(13) || chr(10) || '					? ''Update''' || chr(13) || chr(10) || '					: ((this.params.event_value === ''1'') ? ''Problem'' : ''Resolve'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				results = this.handleEvent(types[this.params.event_source], event);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else if (typeof types[this.params.event_source] !== ''undefined'') {' || chr(13) || chr(10) || '				results = this.handleEventless(types[this.params.event_source]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				throw ''Unexpected "event_source": '' + this.params.event_source;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			for (idx in results) {' || chr(13) || chr(10) || '				if (typeof results[idx] !== ''undefined'') {' || chr(13) || chr(10) || '					return JSON.stringify(results[idx]);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.httpProxy = params.http_proxy;' || chr(13) || chr(10) || '		this.params = params;' || chr(13) || chr(10) || '		this.runCallback(''onCheckParams'', {});' || chr(13) || chr(10) || '	} catch (error) {' || chr(13) || chr(10) || '		throw ''Webhook processing failed: '' + error;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhookHelper = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {' || chr(13) || chr(10) || '		if (event_source === ''0'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/tr_events.php?triggerid='' + trigger_id + ''&eventid='' + event_id;' || chr(13) || chr(10) || '		} else if (event_source === ''4'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/zabbix.php?action=service.list'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return zabbix_url;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CParamValidator = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isType: function(value, type) {' || chr(13) || chr(10) || '		if (type === ''array'') {' || chr(13) || chr(10) || '			return Array.isArray(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''integer'') {' || chr(13) || chr(10) || '			return CParamValidator.isInteger(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''float'') {' || chr(13) || chr(10) || '			return CParamValidator.isFloat(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (typeof value === type);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isInteger: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseInt(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isFloat: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+\.\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseFloat(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '	isDefined: function(value) {' || chr(13) || chr(10) || '		return !CParamValidator.isType(value, ''undefined'');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isEmpty: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be checked for emptiness.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (value.trim() === '''');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isMacroSet: function(value, macro) {' || chr(13) || chr(10) || '		if (CParamValidator.isDefined(macro)) {' || chr(13) || chr(10) || '			return !(CParamValidator.ifMatch(value, ''^\{'' + macro + ''\}$''))' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !(CParamValidator.ifMatch(value, ''^\{[$#]{0,1}[A-Z_\.]+[\:]{0,1}["]{0,1}.*["]{0,1}\}$'') || value === ''*UNKNOWN*'')' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	withinRange: function(value, min, max) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''number'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a number to be checked for range.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (value < ((CParamValidator.isDefined(min)) ? min : value)' || chr(13) || chr(10) || '			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return true;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	inArray: function(value, array) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(array, ''array'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			throw ''The array must be an array to check the value for existing in it.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (array.indexOf((typeof value === ''string'') ? value.toLowerCase() : value) !== -1);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	ifMatch: function(value, regex) {' || chr(13) || chr(10) || '		return (new RegExp(regex)).test(value);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	match: function(value, regex) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be matched with the regular expression.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.match(new RegExp(regex));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	checkURL: function(value) {' || chr(13) || chr(10) || '		if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must be a non-empty string.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, ''^(http|https):\/\/.+'')) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must contain a schema.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.endsWith(''/'') ? value.slice(0, -1) : value;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	check: function(key, rule, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(rule.type)) {' || chr(13) || chr(10) || '			throw ''Mandatory attribute "type" has not been defined for parameter "'' + key + ''".'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(params[key])) {' || chr(13) || chr(10) || '			throw ''Checked parameter "'' + key + ''" was not found in the list of input parameters.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('		}' || chr(13) || chr(10) || '		var value = params[key],' || chr(13) || chr(10) || '			error_message = null;' || chr(13) || chr(10) || '		switch (rule.type) {' || chr(13) || chr(10) || '			case ''string'':' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" must be a string.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a non-empty string'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a string with a length > '' + rule.len;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must match the regular expression "'' + rule.regex + ''"'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.url) && rule.url === true) {' || chr(13) || chr(10) || '					value = CParamValidator.checkURL(value);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''integer'':' || chr(13) || chr(10) || '				if (!CParamValidator.isInteger(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an integer'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseInt(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''float'':' || chr(13) || chr(10) || '				if (!CParamValidator.isFloat(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a floating-point number'';' || chr(13) || chr(10) || '')||
TO_NCLOB('					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseFloat(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''boolean'':' || chr(13) || chr(10) || '				if (CParamValidator.inArray(value, [''1'', ''true'', ''yes'', ''on''])) {' || chr(13) || chr(10) || '					value = true;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (CParamValidator.inArray(value, [''0'', ''false'', ''no'', ''off''])) {' || chr(13) || chr(10) || '					value = false;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a boolean-like.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''array'':' || chr(13) || chr(10) || '				try {' || chr(13) || chr(10) || '					value = JSON.parse(value);' || chr(13) || chr(10) || '				} catch (error) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" contains invalid JSON.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''array'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an array.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {' || chr(13) || chr(10) || '					value = value.reduce(function(acc, obj) {' || chr(13) || chr(10) || '						acc[obj.tag] = obj.value || null;' || chr(13) || chr(10) || '						return acc;' || chr(13) || chr(10) || '					}, {});' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''object'':' || chr(13) || chr(10) || '				value = JSON.parse(value);' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''object'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an object.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '')||
TO_NCLOB('				break;' || chr(13) || chr(10) || '			default:' || chr(13) || chr(10) || '				throw ''Unexpected attribute type "'' + rule.type + ''" for value "'' + key + ''". Available: '' +' || chr(13) || chr(10) || '				[''integer'', ''float'', ''string'', ''boolean'', ''array'', ''object''].join('', '');' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		params[key] = value;' || chr(13) || chr(10) || '		if (CParamValidator.inArray(rule.type, [''integer'', ''float'']) && error_message === null && (CParamValidator.isDefined(rule.min)' || chr(13) || chr(10) || '			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be a number '' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))' || chr(13) || chr(10) || '				? (rule.min + ''..'' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? ''>'' + rule.min : ''<'' + rule.max));' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be in the array '' + JSON.stringify(rule.array);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {' || chr(13) || chr(10) || '			error_message = ''The macro '' + ((CParamValidator.isDefined(rule.macro)) ? ''{'' + rule.macro + ''} '' : '' '') + ''is not set'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (error_message !== null) {' || chr(13) || chr(10) || '			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {' || chr(13) || chr(10) || '				params[key] = rule.default;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '')||
TO_NCLOB('				Zabbix.log(4, ''Default value for "'' + key + ''" must be a '' + rule.type + ''. Skipped.'');' || chr(13) || chr(10) || '				throw ''Incorrect value for variable "'' + key + ''". '' + error_message;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return this;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	validate: function(rules, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(params, ''object'') || CParamValidator.isType(params, ''array'')) {' || chr(13) || chr(10) || '			throw ''Incorrect parameters value. The value must be an object.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		for (var key in rules) {' || chr(13) || chr(10) || '			CParamValidator.check(key, rules[key], params);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CHttpRequest = function(logger) {' || chr(13) || chr(10) || '	this.request = new HttpRequest();' || chr(13) || chr(10) || '	if (typeof logger !== ''object'' || logger === null) {' || chr(13) || chr(10) || '		this.logger = Zabbix;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		this.logger = logger;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.clearHeader = function() {' || chr(13) || chr(10) || '		this.request.clearHeader();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.addHeaders = function(value) {' || chr(13) || chr(10) || '		var headers = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (typeof value === ''object'' && value !== null) {' || chr(13) || chr(10) || '			if (!Array.isArray(value)) {' || chr(13) || chr(10) || '				Object.keys(value).forEach(function(key) {' || chr(13) || chr(10) || '					headers.push(key + '': '' + value[key]);' || chr(13) || chr(10) || '				});' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '')||
TO_NCLOB('				headers = value;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (typeof value === ''string'') {' || chr(13) || chr(10) || '			value.split(''\r\n'').forEach(function(header) {' || chr(13) || chr(10) || '				headers.push(header);' || chr(13) || chr(10) || '			});' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		for (var idx in headers) {' || chr(13) || chr(10) || '			this.request.addHeader(headers[idx]);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.setProxy = function(proxy) {' || chr(13) || chr(10) || '		this.request.setProxy(proxy);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.plainRequest = function(method, url, data) {' || chr(13) || chr(10) || '		var resp = null;' || chr(13) || chr(10) || '		method = method.toLowerCase();' || chr(13) || chr(10) || '		this.logger.log(4, ''Sending '' + method + '' request:'' + JSON.stringify(data));' || chr(13) || chr(10) || '		if ([''get'', ''post'', ''put'', ''patch'', ''delete'', ''trace''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url, data);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if ([''connect'', ''head'', ''options''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unexpected method. Method '' + method + '' is not supported.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.logger.log(4, ''Response has been received: '' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.jsonRequest = function(method, url, data) {' || chr(13) || chr(10) || '		this.addHeaders(''Content-Type: application/json'');' || chr(13) || chr(10) || '')||
TO_NCLOB('		var resp = this.plainRequest(method, url, JSON.stringify(data));' || chr(13) || chr(10) || '		try {' || chr(13) || chr(10) || '			resp = JSON.parse(resp);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		catch (error) {' || chr(13) || chr(10) || '			throw ''Failed to parse response: not well-formed JSON was received'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.getStatus = function() {' || chr(13) || chr(10) || '		return this.request.getStatus();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var SEVERITY_COLORS = [' || chr(13) || chr(10) || '	''#97AAB3'',' || chr(13) || chr(10) || '	''#7499FF'',' || chr(13) || chr(10) || '	''#FFC859'',' || chr(13) || chr(10) || '	''#FFA059'',' || chr(13) || chr(10) || '	''#E97659'',' || chr(13) || chr(10) || '	''#E45959'',' || chr(13) || chr(10) || '	''#009900'',' || chr(13) || chr(10) || '	''#1F1F1F''' || chr(13) || chr(10) || '],' || chr(13) || chr(10) || '	serviceLogName = ''MS Teams Webhook'',' || chr(13) || chr(10) || '	Logger = new CLogger(serviceLogName),' || chr(13) || chr(10) || '	MSTeams = CWebhook;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MSTeams.prototype.addBodyFact = function (name, value) {' || chr(13) || chr(10) || '	if (!CParamValidator.isDefined(this.data.sections[0].facts)) {' || chr(13) || chr(10) || '		this.data.sections[0].facts = [];' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	this.data.sections[0].facts.push({name: name, value: value});' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MSTeams.prototype.onCheckParams = function () {' || chr(13) || chr(10) || '	CParamValidator.validate({teams_endpoint: {type: ''string''}, event_source: {type: ''string''}, alert_subject: {type: ''string''},' || chr(13) || chr(10) || '')||
TO_NCLOB('		alert_message: {type: ''string''}, host_ip: {type: ''string'', default: ''''}, zabbix_url: {type: ''string'', url: true},' || chr(13) || chr(10) || '		use_default_message: {type: ''boolean'', default: false}, event_nseverity: {type: ''integer'', default: 7}}, this.params);' || chr(13) || chr(10) || '	var actionName = ''Zabbix Home'';' || chr(13) || chr(10) || '	if (!CParamValidator.inArray(this.params.event_source, [''0'',''3'',''4''])' || chr(13) || chr(10) || '		|| this.params.alert_message.startsWith("NOTE: Escalation canceled:")) {' || chr(13) || chr(10) || '		this.params[''use_default_message''] = true;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	if (this.params.event_source === ''0'') {' || chr(13) || chr(10) || '		CParamValidator.validate({event_id: {type: ''integer''}, trigger_id: {type: ''integer''}}, this.params);' || chr(13) || chr(10) || '		actionName = ''Event Info'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	var actionURL = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);' || chr(13) || chr(10) || '	if (this.params.event_value === ''0'') {' || chr(13) || chr(10) || '		this.params.event_nseverity = 6;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	this.data = {' || chr(13) || chr(10) || '		themeColor: SEVERITY_COLORS[this.params.event_nseverity].replace(''#'', ''''),' || chr(13) || chr(10) || '		summary: this.params.alert_subject,' || chr(13) || chr(10) || '		sections: [{' || chr(13) || chr(10) || '			markdown: ''false'',' || chr(13) || chr(10) || '			activityTitle: this.params.alert_subject,' || chr(13) || chr(10) || '			text: (this.params.event_source === ''0'' && !this.params.use_default_message) ? this.params.trigger_description : this.params.alert_message' || chr(13) || chr(10) || '		}],' || chr(13) || chr(10) || '		potentialAction: [{' || chr(13) || chr(10) || '			''@type'': ''OpenUri'',' || chr(13) || chr(10) || '			name: actionName,' || chr(13) || chr(10) || '			targets: [{' || chr(13) || chr(10) || '')||
TO_NCLOB('				os: ''default'',' || chr(13) || chr(10) || '				uri: actionURL' || chr(13) || chr(10) || '			}]' || chr(13) || chr(10) || '		}]' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MSTeams.prototype.makeUpDefaultMessage = function () {' || chr(13) || chr(10) || '	if (!this.params.use_default_message) {' || chr(13) || chr(10) || '		if (!CParamValidator.isEmpty(this.params.host_name) && CParamValidator.isMacroSet(this.params.host_name, ''HOST.NAME'')) {' || chr(13) || chr(10) || '			this.addBodyFact(''Host'', this.params.host_name + ((!CParamValidator.isEmpty(this.params.host_ip)) ? '' ['' + this.params.host_ip + '']'' : ''''));' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isEmpty(this.params.event_severity) && CParamValidator.isMacroSet(this.params.event_severity, ''EVENT.SEVERITY'')) {' || chr(13) || chr(10) || '			this.addBodyFact(''Severity'', this.params.event_severity);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isEmpty(this.params.event_opdata) && CParamValidator.isMacroSet(this.params.event_opdata, ''EVENT.OPDATA'')) {' || chr(13) || chr(10) || '			this.addBodyFact(''Operational data'', this.params.event_opdata);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isEmpty(this.params.event_tags) && CParamValidator.isMacroSet(this.params.event_tags, ''EVENT.TAGS'')) {' || chr(13) || chr(10) || '			this.addBodyFact(''Event tags'', this.params.event_tags);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		Object.keys(this.params).forEach(function (key) {' || chr(13) || chr(10) || '			if (key.startsWith(''fact_'') && this.params[key] !== '''') {' || chr(13) || chr(10) || '				this.addBodyFact(key.substring(5), this.params[key]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else if (key.startsWith(''openUri_'') && this.params[key] !== '''' && !this.params[key].startsWith(''{'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('				this.data.potentialAction.push({' || chr(13) || chr(10) || '					''@type'': ''OpenUri'',' || chr(13) || chr(10) || '					name: key.substring(8),' || chr(13) || chr(10) || '					targets: [{' || chr(13) || chr(10) || '						os: ''default'',' || chr(13) || chr(10) || '						uri: this.params[key]' || chr(13) || chr(10) || '					}]' || chr(13) || chr(10) || '				});' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		});' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const htmlMultiline = function (text) {' || chr(13) || chr(10) || '	return text.replace(/(?:\r\n|\r|\n)/g, ''<br>'');' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MSTeams.prototype.sendRequest = function () {' || chr(13) || chr(10) || '	this.request.addHeaders({"Content-Type": "application/json"});' || chr(13) || chr(10) || '	var response = this.request.plainRequest(''POST'', this.params.teams_endpoint, JSON.stringify(this.data));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (response !== ''1'') {' || chr(13) || chr(10) || '		Logger.log(Logger.WARN, ''FAILED with response: '' + response);' || chr(13) || chr(10) || '		throw response;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	return ''OK'';' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MSTeams.prototype.onProblem = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '	if (!this.params.use_default_message) {' || chr(13) || chr(10) || '		this.addBodyFact(''Event time'', this.params.event_time + '' '' + this.params.event_date);' || chr(13) || chr(10) || '		this.makeUpDefaultMessage();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	this.data.sections[0].text = htmlMultiline(this.data.sections[0].text);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.sendRequest();' || chr(13) || chr(10) || '')||
TO_NCLOB('}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MSTeams.prototype.onUpdate = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '	if (!this.params.use_default_message) {' || chr(13) || chr(10) || '		this.data.sections[0].text = this.params.event_update_user + '' '' + this.params.event_update_action + ''.'';' || chr(13) || chr(10) || '		if (this.params.event_update_message) {' || chr(13) || chr(10) || '			this.data.sections[0].text += ''<br>Message:<br>'' + this.params.event_update_message;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.addBodyFact(''Event update time'', this.params.event_update_time + '' '' + this.params.event_update_date);' || chr(13) || chr(10) || '		this.makeUpDefaultMessage();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	this.data.sections[0].text = htmlMultiline(this.data.sections[0].text);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.sendRequest();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MSTeams.prototype.onResolve = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '	if (!this.params.use_default_message) {' || chr(13) || chr(10) || '		this.addBodyFact(''Recovery time'', this.params.event_recovery_time + '' '' + this.params.event_recovery_date);' || chr(13) || chr(10) || '		this.makeUpDefaultMessage();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	this.data.sections[0].text = htmlMultiline(this.data.sections[0].text);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.sendRequest();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MSTeams.prototype.onDiscovery = function (alert) {' || chr(13) || chr(10) || '	return this.onProblem(alert);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('MSTeams.prototype.onAutoreg = function (alert) {' || chr(13) || chr(10) || '	return this.onProblem(alert);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '	var hook = new MSTeams(value);' || chr(13) || chr(10) || '	hook.request = new CHttpRequest(Logger);' || chr(13) || chr(10) || '	return hook.run();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '	Logger.log(Logger.WARN, ''notification failed: '' + error);' || chr(13) || chr(10) || '	throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/msteams' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Add official Zabbix webhook connector from MS Teams apps for the channel, where you want to receive notifications.' || chr(13) || chr(10) || '2. Create Incoming webhook for your channel.' || chr(13) || chr(10) || '3. In the Zabbix web interface go to Administration → Macros section. Setup the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend. ' || chr(13) || chr(10) || '4. On this page replace placeholder <PLACE WEBHOOK URL HERE> with the incoming webhook URL, created during the webhook setup in MS Teams.' || chr(13) || chr(10) || '5. To receive Zabbix notifications in MS Teams, you need to create a Zabbix user and add Media with the MS Teams media type. Make sure this user has access to all hosts for which you would like problem notifications to be sent to MS Teams.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('53','4','MS Teams Workflow','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('const CLogger = function(serviceName) {' || chr(13) || chr(10) || '	this.serviceName = serviceName;' || chr(13) || chr(10) || '	this.INFO = 4' || chr(13) || chr(10) || '	this.WARN = 3' || chr(13) || chr(10) || '	this.ERROR = 2' || chr(13) || chr(10) || '	this.log = function(level, msg) {' || chr(13) || chr(10) || '		Zabbix.log(level, ''['' + this.serviceName + ''] '' + msg);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhook = function(value) {' || chr(13) || chr(10) || '	try {' || chr(13) || chr(10) || '		params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''1'', ''2'', ''3'', ''4''].indexOf(params.event_source) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''.\nMust be 0-4.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1 && [''0'', ''1''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1) {' || chr(13) || chr(10) || '			if (params.event_source === ''1'' && [''0'', ''1'', ''2'', ''3''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0-3.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if (params.event_source === ''0'' && [''0'', ''1''].indexOf(params.event_update_status) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '			if (params.event_source === ''4'') {' || chr(13) || chr(10) || '				if ([''0'', ''1'', ''2'', ''3'', ''4'', ''5''].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {' || chr(13) || chr(10) || '					params.event_nseverity = params.event_update_nseverity;' || chr(13) || chr(10) || '					params.event_severity = params.event_update_severity;' || chr(13) || chr(10) || '					params.event_update_status = ''1'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.runCallback = function(name, params) {' || chr(13) || chr(10) || '			if (typeof this[name] === ''function'') {' || chr(13) || chr(10) || '				return this[name].apply(this, [params]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEvent = function(source, event) {' || chr(13) || chr(10) || '			const alert = { source: source, event: event };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''on'' + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEventless = function(source) {' || chr(13) || chr(10) || '			const alert = { source: source, event: null };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.run = function() {' || chr(13) || chr(10) || '			var results = [];' || chr(13) || chr(10) || '')||
TO_NCLOB('			if (typeof this.httpProxy === ''string'' && this.httpProxy.trim() !== '''') {' || chr(13) || chr(10) || '				this.request.setProxy(this.httpProxy);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			const types = { ''0'': ''Trigger'', ''1'': ''Discovery'', ''2'': ''Autoreg'', ''3'': ''Internal'', ''4'': ''Service'' };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if ([''0'', ''3'', ''4''].indexOf(this.params.event_source) !== -1) {' || chr(13) || chr(10) || '				var event = (this.params.event_update_status === ''1'')' || chr(13) || chr(10) || '					? ''Update''' || chr(13) || chr(10) || '					: ((this.params.event_value === ''1'') ? ''Problem'' : ''Resolve'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				results = this.handleEvent(types[this.params.event_source], event);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else if (typeof types[this.params.event_source] !== ''undefined'') {' || chr(13) || chr(10) || '				results = this.handleEventless(types[this.params.event_source]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				throw ''Unexpected "event_source": '' + this.params.event_source;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			for (idx in results) {' || chr(13) || chr(10) || '				if (typeof results[idx] !== ''undefined'') {' || chr(13) || chr(10) || '					return JSON.stringify(results[idx]);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.httpProxy = params.http_proxy;' || chr(13) || chr(10) || '		this.params = params;' || chr(13) || chr(10) || '		this.runCallback(''onCheckParams'', {});' || chr(13) || chr(10) || '	} catch (error) {' || chr(13) || chr(10) || '		throw ''Webhook processing failed: '' + error;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CParamValidator = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isType: function(value, type) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (type === ''array'') {' || chr(13) || chr(10) || '			return Array.isArray(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''integer'') {' || chr(13) || chr(10) || '			return CParamValidator.isInteger(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''float'') {' || chr(13) || chr(10) || '			return CParamValidator.isFloat(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (typeof value === type);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isInteger: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseInt(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isFloat: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+\.\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseFloat(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isDefined: function(value) {' || chr(13) || chr(10) || '		return !CParamValidator.isType(value, ''undefined'');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isEmpty: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be checked for emptiness.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (value.trim() === '''');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isMacroSet: function(value, macro) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (CParamValidator.isDefined(macro)) {' || chr(13) || chr(10) || '			return !(CParamValidator.ifMatch(value, ''^\{'' + macro + ''\}$''))' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !(CParamValidator.ifMatch(value, ''^\{[$#]{0,1}[A-Z_\.]+[\:]{0,1}["]{0,1}.*["]{0,1}\}$'') || value === ''*UNKNOWN*'')' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	withinRange: function(value, min, max) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''number'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a number to be checked for range.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (value < ((CParamValidator.isDefined(min)) ? min : value)' || chr(13) || chr(10) || '			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return true;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	inArray: function(value, array) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(array, ''array'')) {' || chr(13) || chr(10) || '			throw ''The array must be an array to check the value for existing in it.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (array.indexOf((typeof value === ''string'') ? value.toLowerCase() : value) !== -1);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	ifMatch: function(value, regex) {' || chr(13) || chr(10) || '		return (new RegExp(regex)).test(value);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	match: function(value, regex) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be matched with the regular expression.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '		return value.match(new RegExp(regex));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	checkURL: function(value) {' || chr(13) || chr(10) || '		if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must be a non-empty string.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, ''^(http|https):\/\/.+'')) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must contain a schema.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.endsWith(''/'') ? value.slice(0, -1) : value;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	check: function(key, rule, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(rule.type)) {' || chr(13) || chr(10) || '			throw ''Mandatory attribute "type" has not been defined for parameter "'' + key + ''".'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(params[key])) {' || chr(13) || chr(10) || '			throw ''Checked parameter "'' + key + ''" was not found in the list of input parameters.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		var value = params[key],' || chr(13) || chr(10) || '			error_message = null;' || chr(13) || chr(10) || '		switch (rule.type) {' || chr(13) || chr(10) || '			case ''string'':' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" must be a string.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a non-empty string'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '')||
TO_NCLOB('				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a string with a length > '' + rule.len;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must match the regular expression "'' + rule.regex + ''"'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.url) && rule.url === true) {' || chr(13) || chr(10) || '					value = CParamValidator.checkURL(value);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''integer'':' || chr(13) || chr(10) || '				if (!CParamValidator.isInteger(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an integer'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseInt(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''float'':' || chr(13) || chr(10) || '				if (!CParamValidator.isFloat(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a floating-point number'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseFloat(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''boolean'':' || chr(13) || chr(10) || '				if (CParamValidator.inArray(value, [''1'', ''true'', ''yes'', ''on''])) {' || chr(13) || chr(10) || '					value = true;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (CParamValidator.inArray(value, [''0'', ''false'', ''no'', ''off''])) {' || chr(13) || chr(10) || '					value = false;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a boolean-like.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''array'':' || chr(13) || chr(10) || '				try {' || chr(13) || chr(10) || '					value = JSON.parse(value);' || chr(13) || chr(10) || '				} catch (error) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" contains invalid JSON.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''array'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an array.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {' || chr(13) || chr(10) || '					value = value.reduce(function(acc, obj) {' || chr(13) || chr(10) || '						acc[obj.tag] = obj.value || null;' || chr(13) || chr(10) || '						return acc;' || chr(13) || chr(10) || '					}, {});' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''object'':' || chr(13) || chr(10) || '				value = JSON.parse(value);' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''object'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an object.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			default:' || chr(13) || chr(10) || '				throw ''Unexpected attribute type "'' + rule.type + ''" for value "'' + key + ''". Available: '' +' || chr(13) || chr(10) || '				[''integer'', ''float'', ''string'', ''boolean'', ''array'', ''object''].join('', '');' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		params[key] = value;' || chr(13) || chr(10) || '		if (CParamValidator.inArray(rule.type, [''integer'', ''float'']) && error_message === null && (CParamValidator.isDefined(rule.min)' || chr(13) || chr(10) || '			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			error_message = ''Value "'' + key + ''" must be a number '' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))' || chr(13) || chr(10) || '				? (rule.min + ''..'' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? ''>'' + rule.min : ''<'' + rule.max));' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be in the array '' + JSON.stringify(rule.array);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {' || chr(13) || chr(10) || '			error_message = ''The macro '' + ((CParamValidator.isDefined(rule.macro)) ? ''{'' + rule.macro + ''} '' : '' '') + ''is not set'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (error_message !== null) {' || chr(13) || chr(10) || '			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {' || chr(13) || chr(10) || '				params[key] = rule.default;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				Zabbix.log(4, ''Default value for "'' + key + ''" must be a '' + rule.type + ''. Skipped.'');' || chr(13) || chr(10) || '				throw ''Incorrect value for variable "'' + key + ''". '' + error_message;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return this;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	validate: function(rules, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(params, ''object'') || CParamValidator.isType(params, ''array'')) {' || chr(13) || chr(10) || '			throw ''Incorrect parameters value. The value must be an object.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		for (var key in rules) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			CParamValidator.check(key, rules[key], params);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CHttpRequest = function(logger) {' || chr(13) || chr(10) || '	this.request = new HttpRequest();' || chr(13) || chr(10) || '	if (typeof logger !== ''object'' || logger === null) {' || chr(13) || chr(10) || '		this.logger = Zabbix;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		this.logger = logger;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.clearHeader = function() {' || chr(13) || chr(10) || '		this.request.clearHeader();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.addHeaders = function(value) {' || chr(13) || chr(10) || '		var headers = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (typeof value === ''object'' && value !== null) {' || chr(13) || chr(10) || '			if (!Array.isArray(value)) {' || chr(13) || chr(10) || '				Object.keys(value).forEach(function(key) {' || chr(13) || chr(10) || '					headers.push(key + '': '' + value[key]);' || chr(13) || chr(10) || '				});' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				headers = value;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (typeof value === ''string'') {' || chr(13) || chr(10) || '			value.split(''\r\n'').forEach(function(header) {' || chr(13) || chr(10) || '				headers.push(header);' || chr(13) || chr(10) || '			});' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		for (var idx in headers) {' || chr(13) || chr(10) || '			this.request.addHeader(headers[idx]);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.setProxy = function(proxy) {' || chr(13) || chr(10) || '		this.request.setProxy(proxy);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '	this.plainRequest = function(method, url, data) {' || chr(13) || chr(10) || '		var resp = null;' || chr(13) || chr(10) || '		method = method.toLowerCase();' || chr(13) || chr(10) || '		this.logger.log(4, ''Sending '' + method + '' request:'' + JSON.stringify(data));' || chr(13) || chr(10) || '		if ([''get'', ''post'', ''put'', ''patch'', ''delete'', ''trace''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url, data);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if ([''connect'', ''head'', ''options''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unexpected method. Method '' + method + '' is not supported.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.logger.log(4, ''Response has been received: '' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.jsonRequest = function(method, url, data) {' || chr(13) || chr(10) || '		this.addHeaders(''Content-Type: application/json'');' || chr(13) || chr(10) || '		var resp = this.plainRequest(method, url, JSON.stringify(data));' || chr(13) || chr(10) || '		try {' || chr(13) || chr(10) || '			resp = JSON.parse(resp);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		catch (error) {' || chr(13) || chr(10) || '			throw ''Failed to parse response: not well-formed JSON was received'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.getStatus = function() {' || chr(13) || chr(10) || '		return this.request.getStatus();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('const CWebhookHelper = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {' || chr(13) || chr(10) || '		if (event_source === ''0'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/tr_events.php?triggerid='' + trigger_id + ''&eventid='' + event_id;' || chr(13) || chr(10) || '		} else if (event_source === ''4'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/zabbix.php?action=service.list'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return zabbix_url;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var serviceLogName = ''MS Teams Webhook'',' || chr(13) || chr(10) || '	Logger = new CLogger(serviceLogName),' || chr(13) || chr(10) || '	MSTeams = CWebhook;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MSTeams.prototype.onCheckParams = function () {' || chr(13) || chr(10) || '	CParamValidator.validate({' || chr(13) || chr(10) || '		alert_subject: { type: ''string'' }, alert_message: { type: ''string'' },' || chr(13) || chr(10) || '		zabbix_url: { type: ''string'', url: true }, teams_endpoint: { type: ''string'', url: true }' || chr(13) || chr(10) || '	}, this.params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.event_source === ''0'') {' || chr(13) || chr(10) || '		CParamValidator.validate({ event_id: { type: ''integer'' }, trigger_id: { type: ''integer'' } }, this.params);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.body = {' || chr(13) || chr(10) || '		type: "message",' || chr(13) || chr(10) || '		attachments: [' || chr(13) || chr(10) || '			{' || chr(13) || chr(10) || '				contentType: "application/vnd.microsoft.card.adaptive",' || chr(13) || chr(10) || '				contentUrl: null,' || chr(13) || chr(10) || '				content: {' || chr(13) || chr(10) || '')||
TO_NCLOB('					$schema: "http://adaptivecards.io/schemas/adaptive-card.json",' || chr(13) || chr(10) || '					type: "AdaptiveCard",' || chr(13) || chr(10) || '					version: "1.4",' || chr(13) || chr(10) || '					body: [' || chr(13) || chr(10) || '						{' || chr(13) || chr(10) || '							type: "Container",' || chr(13) || chr(10) || '							items: [' || chr(13) || chr(10) || '								{' || chr(13) || chr(10) || '									type: "TextBlock",' || chr(13) || chr(10) || '									size: "Medium",' || chr(13) || chr(10) || '									wrap: "true",' || chr(13) || chr(10) || '									weight: "Bolder",' || chr(13) || chr(10) || '									text: this.params.alert_subject' || chr(13) || chr(10) || '								}' || chr(13) || chr(10) || '							],' || chr(13) || chr(10) || '							style: "",' || chr(13) || chr(10) || '							bleed: true' || chr(13) || chr(10) || '						}' || chr(13) || chr(10) || '					],' || chr(13) || chr(10) || '					actions: [' || chr(13) || chr(10) || '						{' || chr(13) || chr(10) || '							type: "Action.OpenUrl",' || chr(13) || chr(10) || '							title: "Event info",' || chr(13) || chr(10) || '							url: CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id)' || chr(13) || chr(10) || '						}' || chr(13) || chr(10) || '					]' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		]' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.params.alert_message = this.params.alert_message.split(''\n'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	for (line in this.params.alert_message) {' || chr(13) || chr(10) || '		this.body.attachments[0].content.body.push({' || chr(13) || chr(10) || '			type: "TextBlock",' || chr(13) || chr(10) || '			wrap: "true",' || chr(13) || chr(10) || '			text: this.params.alert_message[line]' || chr(13) || chr(10) || '		});' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('MSTeams.prototype.sendRequest = function (color) {' || chr(13) || chr(10) || '	this.body.attachments[0].content.body[0].style = color;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.request.addHeaders({ "Content-Type": "application/json" });' || chr(13) || chr(10) || '	var response = this.request.plainRequest(''POST'', this.params.teams_endpoint, JSON.stringify(this.body));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.request.getStatus() !== 202) {' || chr(13) || chr(10) || '		Logger.log(Logger.INFO, ''HTTP code: '' + this.request.getStatus() + ''. Endpoint response:'' + response);' || chr(13) || chr(10) || '		throw ''HTTP code: '' + this.request.getStatus() + ''. Endpoint response:'' + response;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return ''OK'';' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MSTeams.prototype.onProblem = function () {' || chr(13) || chr(10) || '	return this.sendRequest("attention");' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MSTeams.prototype.onResolve = function () {' || chr(13) || chr(10) || '	return this.sendRequest("good");' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MSTeams.prototype.onUpdate = function () {' || chr(13) || chr(10) || '	return this.sendRequest("emphasis");' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MSTeams.prototype.onDiscovery = function () {' || chr(13) || chr(10) || '	return this.sendRequest("emphasis");' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MSTeams.prototype.onAutoreg = function () {' || chr(13) || chr(10) || '	return this.sendRequest("emphasis");' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '	var hook = new MSTeams(value);' || chr(13) || chr(10) || '	hook.request = new CHttpRequest(Logger);' || chr(13) || chr(10) || '')||
TO_NCLOB('	return hook.run();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '	Logger.log(Logger.WARN, ''notification failed: '' + error);' || chr(13) || chr(10) || '	throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('};'),'30s','0','0','','','To set up a webhook, please follow these steps:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '- Create a workflow in MS Teams. You can use the "Post a message in a channel when a webhook request is received" template for it.' || chr(13) || chr(10) || '- Copy the endpoint URL and place it in the teams_endpoint parameter.' || chr(13) || chr(10) || '- Set up the global macro {$ZABBIX.URL}, which will contain the URL to the Zabbix frontend.' || chr(13) || chr(10) || '- Create a Zabbix user and add the MS Teams Workflow media to it.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'For more detailed instructions, please visit https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('54','4','Opsgenie','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var method,' || chr(13) || chr(10) || '    Media = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '    name: '''',' || chr(13) || chr(10) || '    labels: [],' || chr(13) || chr(10) || '    HTTPProxy: '''',' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Media.params = params;' || chr(13) || chr(10) || '        Media.params.api += Media.params.api.endsWith(''/'') ? '''' : ''/'';' || chr(13) || chr(10) || '        Media.params.web += Media.params.web.endsWith(''/'') ? '''' : ''/'';' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        if (typeof HTTPProxy !== ''undefined'' && HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            Media.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setTags: function(event_tags_json) {' || chr(13) || chr(10) || '        if (typeof event_tags_json !== ''undefined'' && event_tags_json !== ''''' || chr(13) || chr(10) || '                && event_tags_json !== ''{EVENT.TAGSJSON}'') {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                var tags = JSON.parse(event_tags_json),' || chr(13) || chr(10) || '                    label;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                tags.forEach(function (tag) {' || chr(13) || chr(10) || '                    if (typeof tag.tag === ''string'') {' || chr(13) || chr(10) || '                        label = (tag.tag + (typeof tag.value !== ''undefined''' || chr(13) || chr(10) || '')||
TO_NCLOB('                                && tag.value !== '''' ? ('':'' + tag.value) : '''')).replace(/\s/g, ''_'');' || chr(13) || chr(10) || '                        Media.labels.push(label);' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Failed to parse "event_tags_json" param'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data, allow_404) {' || chr(13) || chr(10) || '        if (typeof(allow_404) === ''undefined'') {' || chr(13) || chr(10) || '            allow_404 = false;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        [''api'', ''token''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Media.params !== ''object'' || typeof Media.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || Media.params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required '' + Media.name + '' param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Media.params.api + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: '' + Media.params.token);' || chr(13) || chr(10) || '        request.setProxy(Media.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Failed to parse response.'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        if ((request.getStatus() < 200 || request.getStatus() >= 300)' || chr(13) || chr(10) || '                && (!allow_404 || request.getStatus() !== 404)) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null) {' || chr(13) || chr(10) || '                if (typeof response.errors === ''object'' && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                    message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                else if (typeof response.errorMessages === ''object'' && Object.keys(response.errorMessages).length > 0) {' || chr(13) || chr(10) || '                    message += '': '' + JSON.stringify(response.errorMessages);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                else if (typeof response.message === ''string'') {' || chr(13) || chr(10) || '                    message += '': '' + response.message;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getAlertId: function (requestId) {' || chr(13) || chr(10) || '        status_counter = params.status_counter || 25; ' || chr(13) || chr(10) || '        do {' || chr(13) || chr(10) || '            resp = Media.request(''get'', ''requests/'' + requestId, undefined, true);' || chr(13) || chr(10) || '        status_counter -= 1;            ' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('        while ( status_counter > 0 && ' || chr(13) || chr(10) || '            ( ' || chr(13) || chr(10) || '            typeof resp.response !== ''object'' || ' || chr(13) || chr(10) || '            typeof resp.response.data === ''undefined'' ||' || chr(13) || chr(10) || '            resp.response.data.success === false &&' || chr(13) || chr(10) || '                !resp.response.data.status.includes("There is no open alert") &&' || chr(13) || chr(10) || '                !resp.response.data.status.includes("Alert is already")' || chr(13) || chr(10) || '            ) ' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof resp.response !== ''object'' || typeof resp.response.data === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot get '' + Media.name + '' issue ID. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if (resp.response.data.success === false ) {' || chr(13) || chr(10) || '            throw Media.name + '': Operation status ('' + resp.response.data.status + '')'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return resp;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var result = {tags: {}},' || chr(13) || chr(10) || '        params = JSON.parse(value),' || chr(13) || chr(10) || '        media = {},' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        resp = {},' || chr(13) || chr(10) || '        responders = [],' || chr(13) || chr(10) || '        tags = [],' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'',' || chr(13) || chr(10) || '            ''alert_message'',' || chr(13) || chr(10) || '            ''event_id'',' || chr(13) || chr(10) || '            ''event_source'',' || chr(13) || chr(10) || '')||
TO_NCLOB('            ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'',' || chr(13) || chr(10) || '            ''opsgenie_api'',' || chr(13) || chr(10) || '            ''opsgenie_web'',' || chr(13) || chr(10) || '            ''opsgenie_token''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            ''not_classified'',' || chr(13) || chr(10) || '            ''information'',' || chr(13) || chr(10) || '            ''warning'',' || chr(13) || chr(10) || '            ''average'',' || chr(13) || chr(10) || '            ''high'',' || chr(13) || chr(10) || '            ''disaster'',' || chr(13) || chr(10) || '            ''resolved'',' || chr(13) || chr(10) || '            ''default''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            if (key.startsWith(''opsgenie_'')) {' || chr(13) || chr(10) || '                media[key.substring(9)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Possible values of event_source:' || chr(13) || chr(10) || '    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    // Check event_value for trigger-based and internal events.' || chr(13) || chr(10) || '    // Possible values: 1 for problem, 0 for recovering' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_update_status only for trigger-based events.' || chr(13) || chr(10) || '    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_id for a numeric value.' || chr(13) || chr(10) || '    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_id" parameter given: '' + params.event_id + ''\nMust be a positive number.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ((params.event_source === ''1'' || params.event_source === ''2'')  && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for Trigger and Internal actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity]];' || chr(13) || chr(10) || '    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(''/'') ? '''' : ''/'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Media.name = ''Opsgenie'';' || chr(13) || chr(10) || '    Media.setParams(media);' || chr(13) || chr(10) || '    Media.params.token = ''GenieKey '' + Media.params.token;' || chr(13) || chr(10) || '    Media.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    Media.setTags(params.event_tags_json); // Set Media.labels' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create an issue.' || chr(13) || chr(10) || '    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).' || chr(13) || chr(10) || '    // Numeric value of the problem update status. Possible values:' || chr(13) || chr(10) || '    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)' || chr(13) || chr(10) || '            || (params.event_source == 3 && params.event_value == 1)' || chr(13) || chr(10) || '            || params.event_source == 1 || params.event_source == 2) {' || chr(13) || chr(10) || '        fields.message = params.alert_subject;' || chr(13) || chr(10) || '        fields.alias = params.event_id;' || chr(13) || chr(10) || '        fields.description = params.alert_message;' || chr(13) || chr(10) || '        fields.priority = priority;' || chr(13) || chr(10) || '        fields.source = ''Zabbix'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_source === ''0'') {' || chr(13) || chr(10) || '            fields.details = {' || chr(13) || chr(10) || '')||
TO_NCLOB('                ''Zabbix server'': params.zbxurl,' || chr(13) || chr(10) || '                Problem: params.zbxurl + ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            fields.details = {''Zabbix server'': params.zbxurl};' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof params.opsgenie_teams === ''string'') {' || chr(13) || chr(10) || '            responders = params.opsgenie_teams.split('','');' || chr(13) || chr(10) || '            fields.responders = responders.map(function(team) {' || chr(13) || chr(10) || '                return {type: ''team'', name: team.trim()};' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.tags = Media.labels;' || chr(13) || chr(10) || '        if (typeof params.opsgenie_tags === ''string'') {' || chr(13) || chr(10) || '            tags = params.opsgenie_tags.split('','');' || chr(13) || chr(10) || '            tags.forEach(function(item) {' || chr(13) || chr(10) || '                fields.tags.push(item.trim());' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = Media.request(''post'', '''', fields);' || chr(13) || chr(10) || '        if (typeof resp.response !== ''object'' || typeof resp.response.result === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create '' + Media.name + '' issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (resp.status === 202) {' || chr(13) || chr(10) || '            resp = Media.getAlertId(resp.response.requestId);' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {' || chr(13) || chr(10) || '                result.tags.__zbx_ops_issuekey = resp.response.data.alertId;' || chr(13) || chr(10) || '                result.tags.__zbx_ops_issuelink = Media.params.web + ''alert/detail/'' + resp.response.data.alertId;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            throw Media.name + '' response code is unexpected. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update or close the created issue.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        fields.user = (params.event_value != 0) ? params.zbxuser : '''';' || chr(13) || chr(10) || '        fields.note = params.alert_message;' || chr(13) || chr(10) || '        if ( [0, 3].indexOf(parseInt(params.event_source)) > -1  && params.event_value == 0 ) {' || chr(13) || chr(10) || '            // skip sending of close request from update operation(mandatory when both update & recovery operations are defined in action)  ' || chr(13) || chr(10) || '            method = params.event_update_status == 0 ? "close" : "skip";' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if ( params.event_source == 0 && params.event_value == 1 && params.event_update_status == 1 && params.event_update_action.includes(''acknowledged'')) {' || chr(13) || chr(10) || '            method = params.event_update_action.includes(''unacknowledged'') ? "unacknowledge" : "acknowledge";' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            method = "notes";' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (method !== "skip") {' || chr(13) || chr(10) || '        resp = Media.request(''post'', params.event_id + ''/'' + method +''?identifierType=alias'', fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (typeof resp.response !== ''object'' || typeof resp.response.result === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot update '' + Media.name + '' issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (resp.status === 202) {' || chr(13) || chr(10) || '            resp = Media.getAlertId(resp.response.requestId);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            throw Media.name + '' response code is unexpected. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ '' + Media.name + '' Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_ops_issuelink}','Opsgenie: {EVENT.TAGS.__zbx_ops_issuekey}','Please refer to https://docs.opsgenie.com/docs/alert-api and https://www.zabbix.com/documentation/7.0/manual/config/notifications/media/webhook#example_scripts.' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || 'Set global macro {$ZABBIX.URL} with your Zabbix server URL.' || chr(13) || chr(10) || 'Add dedicated user with media type "Opsgenie".' || chr(13) || chr(10) || 'Change the values of the variables opsgenie_api (https://api.opsgenie.com/v2/alerts or https://api.eu.opsgenie.com/v2/alerts),' || chr(13) || chr(10) || 'opsgenie_web (for example, https://myzabbix.app.opsgenie.com), opsgenie_token.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('55','4','OTRS CE','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('const CLogger = function(serviceName) {' || chr(13) || chr(10) || '	this.serviceName = serviceName;' || chr(13) || chr(10) || '	this.INFO = 4' || chr(13) || chr(10) || '	this.WARN = 3' || chr(13) || chr(10) || '	this.ERROR = 2' || chr(13) || chr(10) || '	this.log = function(level, msg) {' || chr(13) || chr(10) || '		Zabbix.log(level, ''['' + this.serviceName + ''] '' + msg);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhook = function(value) {' || chr(13) || chr(10) || '	try {' || chr(13) || chr(10) || '		params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''1'', ''2'', ''3'', ''4''].indexOf(params.event_source) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''.\nMust be 0-4.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1 && [''0'', ''1''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1) {' || chr(13) || chr(10) || '			if (params.event_source === ''1'' && [''0'', ''1'', ''2'', ''3''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0-3.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if (params.event_source === ''0'' && [''0'', ''1''].indexOf(params.event_update_status) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '			if (params.event_source === ''4'') {' || chr(13) || chr(10) || '				if ([''0'', ''1'', ''2'', ''3'', ''4'', ''5''].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {' || chr(13) || chr(10) || '					params.event_nseverity = params.event_update_nseverity;' || chr(13) || chr(10) || '					params.event_severity = params.event_update_severity;' || chr(13) || chr(10) || '					params.event_update_status = ''1'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.runCallback = function(name, params) {' || chr(13) || chr(10) || '			if (typeof this[name] === ''function'') {' || chr(13) || chr(10) || '				return this[name].apply(this, [params]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEvent = function(source, event) {' || chr(13) || chr(10) || '			const alert = { source: source, event: event };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''on'' + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEventless = function(source) {' || chr(13) || chr(10) || '			const alert = { source: source, event: null };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.run = function() {' || chr(13) || chr(10) || '			var results = [];' || chr(13) || chr(10) || '')||
TO_NCLOB('			if (typeof this.httpProxy === ''string'' && this.httpProxy.trim() !== '''') {' || chr(13) || chr(10) || '				this.request.setProxy(this.httpProxy);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			const types = { ''0'': ''Trigger'', ''1'': ''Discovery'', ''2'': ''Autoreg'', ''3'': ''Internal'', ''4'': ''Service'' };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if ([''0'', ''3'', ''4''].indexOf(this.params.event_source) !== -1) {' || chr(13) || chr(10) || '				var event = (this.params.event_update_status === ''1'')' || chr(13) || chr(10) || '					? ''Update''' || chr(13) || chr(10) || '					: ((this.params.event_value === ''1'') ? ''Problem'' : ''Resolve'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				results = this.handleEvent(types[this.params.event_source], event);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else if (typeof types[this.params.event_source] !== ''undefined'') {' || chr(13) || chr(10) || '				results = this.handleEventless(types[this.params.event_source]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				throw ''Unexpected "event_source": '' + this.params.event_source;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			for (idx in results) {' || chr(13) || chr(10) || '				if (typeof results[idx] !== ''undefined'') {' || chr(13) || chr(10) || '					return JSON.stringify(results[idx]);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.httpProxy = params.http_proxy;' || chr(13) || chr(10) || '		this.params = params;' || chr(13) || chr(10) || '		this.runCallback(''onCheckParams'', {});' || chr(13) || chr(10) || '	} catch (error) {' || chr(13) || chr(10) || '		throw ''Webhook processing failed: '' + error;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhookHelper = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {' || chr(13) || chr(10) || '		if (event_source === ''0'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/tr_events.php?triggerid='' + trigger_id + ''&eventid='' + event_id;' || chr(13) || chr(10) || '		} else if (event_source === ''4'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/zabbix.php?action=service.list'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return zabbix_url;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CParamValidator = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isType: function(value, type) {' || chr(13) || chr(10) || '		if (type === ''array'') {' || chr(13) || chr(10) || '			return Array.isArray(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''integer'') {' || chr(13) || chr(10) || '			return CParamValidator.isInteger(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''float'') {' || chr(13) || chr(10) || '			return CParamValidator.isFloat(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (typeof value === type);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isInteger: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseInt(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isFloat: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+\.\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseFloat(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '	isDefined: function(value) {' || chr(13) || chr(10) || '		return !CParamValidator.isType(value, ''undefined'');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isEmpty: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be checked for emptiness.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (value.trim() === '''');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isMacroSet: function(value, macro) {' || chr(13) || chr(10) || '		if (CParamValidator.isDefined(macro)) {' || chr(13) || chr(10) || '			return !(CParamValidator.ifMatch(value, ''^\{'' + macro + ''\}$''))' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !(CParamValidator.ifMatch(value, ''^\{[$#]{0,1}[A-Z_\.]+[\:]{0,1}["]{0,1}.*["]{0,1}\}$'') || value === ''*UNKNOWN*'')' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	withinRange: function(value, min, max) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''number'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a number to be checked for range.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (value < ((CParamValidator.isDefined(min)) ? min : value)' || chr(13) || chr(10) || '			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return true;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	inArray: function(value, array) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(array, ''array'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			throw ''The array must be an array to check the value for existing in it.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (array.indexOf((typeof value === ''string'') ? value.toLowerCase() : value) !== -1);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	ifMatch: function(value, regex) {' || chr(13) || chr(10) || '		return (new RegExp(regex)).test(value);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	match: function(value, regex) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be matched with the regular expression.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.match(new RegExp(regex));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	checkURL: function(value) {' || chr(13) || chr(10) || '		if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must be a non-empty string.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, ''^(http|https):\/\/.+'')) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must contain a schema.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.endsWith(''/'') ? value.slice(0, -1) : value;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	check: function(key, rule, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(rule.type)) {' || chr(13) || chr(10) || '			throw ''Mandatory attribute "type" has not been defined for parameter "'' + key + ''".'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(params[key])) {' || chr(13) || chr(10) || '			throw ''Checked parameter "'' + key + ''" was not found in the list of input parameters.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('		}' || chr(13) || chr(10) || '		var value = params[key],' || chr(13) || chr(10) || '			error_message = null;' || chr(13) || chr(10) || '		switch (rule.type) {' || chr(13) || chr(10) || '			case ''string'':' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" must be a string.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a non-empty string'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a string with a length > '' + rule.len;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must match the regular expression "'' + rule.regex + ''"'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.url) && rule.url === true) {' || chr(13) || chr(10) || '					value = CParamValidator.checkURL(value);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''integer'':' || chr(13) || chr(10) || '				if (!CParamValidator.isInteger(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an integer'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseInt(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''float'':' || chr(13) || chr(10) || '				if (!CParamValidator.isFloat(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a floating-point number'';' || chr(13) || chr(10) || '')||
TO_NCLOB('					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseFloat(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''boolean'':' || chr(13) || chr(10) || '				if (CParamValidator.inArray(value, [''1'', ''true'', ''yes'', ''on''])) {' || chr(13) || chr(10) || '					value = true;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (CParamValidator.inArray(value, [''0'', ''false'', ''no'', ''off''])) {' || chr(13) || chr(10) || '					value = false;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a boolean-like.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''array'':' || chr(13) || chr(10) || '				try {' || chr(13) || chr(10) || '					value = JSON.parse(value);' || chr(13) || chr(10) || '				} catch (error) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" contains invalid JSON.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''array'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an array.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {' || chr(13) || chr(10) || '					value = value.reduce(function(acc, obj) {' || chr(13) || chr(10) || '						acc[obj.tag] = obj.value || null;' || chr(13) || chr(10) || '						return acc;' || chr(13) || chr(10) || '					}, {});' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''object'':' || chr(13) || chr(10) || '				value = JSON.parse(value);' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''object'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an object.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '')||
TO_NCLOB('				break;' || chr(13) || chr(10) || '			default:' || chr(13) || chr(10) || '				throw ''Unexpected attribute type "'' + rule.type + ''" for value "'' + key + ''". Available: '' +' || chr(13) || chr(10) || '				[''integer'', ''float'', ''string'', ''boolean'', ''array'', ''object''].join('', '');' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		params[key] = value;' || chr(13) || chr(10) || '		if (CParamValidator.inArray(rule.type, [''integer'', ''float'']) && error_message === null && (CParamValidator.isDefined(rule.min)' || chr(13) || chr(10) || '			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be a number '' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))' || chr(13) || chr(10) || '				? (rule.min + ''..'' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? ''>'' + rule.min : ''<'' + rule.max));' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be in the array '' + JSON.stringify(rule.array);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {' || chr(13) || chr(10) || '			error_message = ''The macro '' + ((CParamValidator.isDefined(rule.macro)) ? ''{'' + rule.macro + ''} '' : '' '') + ''is not set'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (error_message !== null) {' || chr(13) || chr(10) || '			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {' || chr(13) || chr(10) || '				params[key] = rule.default;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '')||
TO_NCLOB('				Zabbix.log(4, ''Default value for "'' + key + ''" must be a '' + rule.type + ''. Skipped.'');' || chr(13) || chr(10) || '				throw ''Incorrect value for variable "'' + key + ''". '' + error_message;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return this;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	validate: function(rules, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(params, ''object'') || CParamValidator.isType(params, ''array'')) {' || chr(13) || chr(10) || '			throw ''Incorrect parameters value. The value must be an object.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		for (var key in rules) {' || chr(13) || chr(10) || '			CParamValidator.check(key, rules[key], params);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CHttpRequest = function(logger) {' || chr(13) || chr(10) || '	this.request = new HttpRequest();' || chr(13) || chr(10) || '	if (typeof logger !== ''object'' || logger === null) {' || chr(13) || chr(10) || '		this.logger = Zabbix;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		this.logger = logger;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.clearHeader = function() {' || chr(13) || chr(10) || '		this.request.clearHeader();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.addHeaders = function(value) {' || chr(13) || chr(10) || '		var headers = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (typeof value === ''object'' && value !== null) {' || chr(13) || chr(10) || '			if (!Array.isArray(value)) {' || chr(13) || chr(10) || '				Object.keys(value).forEach(function(key) {' || chr(13) || chr(10) || '					headers.push(key + '': '' + value[key]);' || chr(13) || chr(10) || '				});' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '')||
TO_NCLOB('				headers = value;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (typeof value === ''string'') {' || chr(13) || chr(10) || '			value.split(''\r\n'').forEach(function(header) {' || chr(13) || chr(10) || '				headers.push(header);' || chr(13) || chr(10) || '			});' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		for (var idx in headers) {' || chr(13) || chr(10) || '			this.request.addHeader(headers[idx]);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.setProxy = function(proxy) {' || chr(13) || chr(10) || '		this.request.setProxy(proxy);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.plainRequest = function(method, url, data) {' || chr(13) || chr(10) || '		var resp = null;' || chr(13) || chr(10) || '		method = method.toLowerCase();' || chr(13) || chr(10) || '		this.logger.log(4, ''Sending '' + method + '' request:'' + JSON.stringify(data));' || chr(13) || chr(10) || '		if ([''get'', ''post'', ''put'', ''patch'', ''delete'', ''trace''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url, data);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if ([''connect'', ''head'', ''options''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unexpected method. Method '' + method + '' is not supported.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.logger.log(4, ''Response has been received: '' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.jsonRequest = function(method, url, data) {' || chr(13) || chr(10) || '		this.addHeaders(''Content-Type: application/json'');' || chr(13) || chr(10) || '')||
TO_NCLOB('		var resp = this.plainRequest(method, url, JSON.stringify(data));' || chr(13) || chr(10) || '		try {' || chr(13) || chr(10) || '			resp = JSON.parse(resp);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		catch (error) {' || chr(13) || chr(10) || '			throw ''Failed to parse response: not well-formed JSON was received'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.getStatus = function() {' || chr(13) || chr(10) || '		return this.request.getStatus();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const SEVERITIES = ["not_classified", "information", "warning", "average", "high", "disaster"],' || chr(13) || chr(10) || '	serviceLogName = '' ((OTRS)) CE Webhook '',' || chr(13) || chr(10) || '	Logger = new CLogger(serviceLogName),' || chr(13) || chr(10) || '	OTRS = CWebhook;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'OTRS.prototype.onCheckParams = function () {' || chr(13) || chr(10) || '	CParamValidator.validate({alert_subject: {type: ''string''}, alert_message: {type: ''string''},' || chr(13) || chr(10) || '		event_nseverity: {type: ''integer'', default: -1}, otrs_url: {type: ''string'', url: true}, otrs_auth_user: {type: ''string''},' || chr(13) || chr(10) || '		otrs_auth_password: {type: ''string''}, otrs_customer: {type: ''string''}, otrs_default_priority_id: {type: ''integer'', min: 1, max: 5},' || chr(13) || chr(10) || '		otrs_queue: {type: ''string''}, otrs_ticket_type: {type: ''string''}, otrs_ticket_state: {type: ''string''}, otrs_time_unit: {type: ''integer''},' || chr(13) || chr(10) || '		otrs_closed_state_id: {type: ''integer'', default: 0}, zabbix_url: {type: ''string'', url: true}}, this.params);' || chr(13) || chr(10) || '	this.params.entrypoint = ''/nph-genericinterface.pl/Webservice/ZabbixTicketConnector/Ticket'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('	var priority;' || chr(13) || chr(10) || '	if (this.params.event_nseverity >= 0 && this.params.event_nseverity < SEVERITIES.length) {' || chr(13) || chr(10) || '		priority = this.params[''severity_'' + SEVERITIES[this.params.event_nseverity]];' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	this.priority = (CParamValidator.isDefined(priority)) ? priority.trim() : this.params.otrs_default_priority_id;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.event_source === ''0'') {' || chr(13) || chr(10) || '		CParamValidator.validate({trigger_id: {type: ''integer''}, event_id: {type: ''integer''}}, this.params);' || chr(13) || chr(10) || '		this.params.zabbix_url = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);' || chr(13) || chr(10) || '		this.params.alert_message = this.params.alert_subject + ''\n'' + this.params.alert_message + ''\n'' +' || chr(13) || chr(10) || '			this.params.zabbix_url + ''\n'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	if (this.params.event_value != ''0'' && CParamValidator.isMacroSet(this.params.otrs_ticket_id)) {' || chr(13) || chr(10) || '		this.params.event_update_status = ''1'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	this.dynamicFields = {}' || chr(13) || chr(10) || '	Object.keys(this.params).forEach(function (key) {' || chr(13) || chr(10) || '		if (key.startsWith(''dynamicfield_'')) {' || chr(13) || chr(10) || '			this.dynamicFields[key.substring(13)] = this.params[key];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	});' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.data = {' || chr(13) || chr(10) || '		Article: {' || chr(13) || chr(10) || '			Subject: this.params.alert_subject,' || chr(13) || chr(10) || '			Body: (CParamValidator.isDefined(this.params.alert_message)) ? this.params.alert_message : '''',' || chr(13) || chr(10) || '			TimeUnit: this.params.otrs_time_unit.toString(),' || chr(13) || chr(10) || '')||
TO_NCLOB('			ContentType: ''text/plain; charset=utf8''' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.result = {tags: {}};' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'OTRS.prototype.sendRequest = function (method) {' || chr(13) || chr(10) || '	var url = this.params.otrs_url + this.params.entrypoint +' || chr(13) || chr(10) || '		''?UserLogin='' + encodeURIComponent(this.params.otrs_auth_user) +' || chr(13) || chr(10) || '		''&Password='' + encodeURIComponent(this.params.otrs_auth_password);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	var response = this.request.jsonRequest(method, url, this.data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (!CParamValidator.isType(response, ''object'')) {' || chr(13) || chr(10) || '		Logger.log(Logger.INFO, ''API response ERROR: '' + response);' || chr(13) || chr(10) || '		throw ''Unknown error. Check debug log for more information.'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	if (this.request.getStatus() < 200 || this.request.getStatus() >= 300) {' || chr(13) || chr(10) || '		var message = ''status code '' + this.request.getStatus();' || chr(13) || chr(10) || '		Logger.log(Logger.INFO, ''API response ERROR with '' + message + '': '' + response);' || chr(13) || chr(10) || '		throw ''Request failed with '' + message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	if (CParamValidator.isDefined(response.Error) && Object.keys(response.Error).length > 0) {' || chr(13) || chr(10) || '		Logger.log(Logger.INFO, ''API response ERROR: '' + JSON.stringify(response.Error));' || chr(13) || chr(10) || '		throw ''Request failed: '' + JSON.stringify(response.Error);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return {' || chr(13) || chr(10) || '		status: this.request.getStatus(),' || chr(13) || chr(10) || '		response: response' || chr(13) || chr(10) || '')||
TO_NCLOB('	};' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'OTRS.prototype.createTicket = function () {' || chr(13) || chr(10) || '	this.data[''Ticket''] = {' || chr(13) || chr(10) || '		Title: this.params.alert_subject,' || chr(13) || chr(10) || '		Queue: this.params.otrs_queue,' || chr(13) || chr(10) || '		Type: this.params.otrs_ticket_type,' || chr(13) || chr(10) || '		State: this.params.otrs_ticket_state,' || chr(13) || chr(10) || '		PriorityID: this.priority.toString(),' || chr(13) || chr(10) || '		CustomerUser: this.params.otrs_customer' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	var result = this.sendRequest(''post'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (!CParamValidator.isDefined(result.response.TicketID) || result.status != 200) {' || chr(13) || chr(10) || '		throw ''Cannot create ((OTRS)) CE ticket. Check debug log for more information.'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return result.response.TicketID;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'OTRS.prototype.updateTicket = function () {' || chr(13) || chr(10) || '	CParamValidator.validate({otrs_ticket_id: {type: ''string''}, entrypoint: {type: ''string''}}, this.params);' || chr(13) || chr(10) || '	this.params.entrypoint += ''/'' + encodeURIComponent(this.params.otrs_ticket_id);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	var result = this.sendRequest(''put'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (!CParamValidator.isDefined(result.response.TicketID) || result.status != 200) {' || chr(13) || chr(10) || '		throw ''Cannot update ((OTRS)) CE ticket. Check debug log for more information.'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return result.response.TicketID;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('OTRS.prototype.onProblem = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '	if (CParamValidator.isDefined(alert.source) && CParamValidator.inArray(alert.source, [''trigger'', ''service'', ''internal''])) {' || chr(13) || chr(10) || '		if (Object.keys(this.dynamicFields).length > 0) {' || chr(13) || chr(10) || '			this.data.DynamicField = [];' || chr(13) || chr(10) || '			Object.keys(this.dynamicFields).forEach(function(field) {' || chr(13) || chr(10) || '				if (field !== undefined) {' || chr(13) || chr(10) || '					if (this.dynamicFields[field].match(/^\d{4}[.-]\d{2}[.-]\d{2}$/)) {' || chr(13) || chr(10) || '						this.dynamicFields[field] = this.dynamicFields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '					}' || chr(13) || chr(10) || '	' || chr(13) || chr(10) || '					this.data.DynamicField.push({Name: field, Value: this.dynamicFields[field]});' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			});' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		const ticket_id = this.createTicket(alert);' || chr(13) || chr(10) || '		this.result.tags.__zbx_otrs_ticket_id = ticket_id;' || chr(13) || chr(10) || '		this.result.tags.__zbx_otrs_ticketlink = this.params.otrs_url + ''index.pl?Action=AgentTicketZoom;TicketID='' + ticket_id;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return this.result;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	return this.createTicket();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'OTRS.prototype.onUpdate = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '	this.updateTicket();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'OTRS.prototype.onResolve = function (alert) {' || chr(13) || chr(10) || '')||
TO_NCLOB('	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '	if (this.params.otrs_closed_state_id > 0) {' || chr(13) || chr(10) || '		this.data[''Ticket''] = {' || chr(13) || chr(10) || '			StateID: this.params.otrs_closed_state_id' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	this.updateTicket();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'OTRS.prototype.onDiscovery = function (alert) {' || chr(13) || chr(10) || '	return this.onProblem(alert);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'OTRS.prototype.onAutoreg = function (alert) {' || chr(13) || chr(10) || '	return this.onProblem(alert);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '	var hook = new OTRS(value);' || chr(13) || chr(10) || '	hook.request = new CHttpRequest(Logger);' || chr(13) || chr(10) || '	return hook.run();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '	Logger.log(Logger.WARN, ''notification failed: '' + error);' || chr(13) || chr(10) || '	throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_otrs_ticketlink}','((OTRS)) CE: ticket #{EVENT.TAGS.__zbx_otrs_ticket_id}',TO_NCLOB('This media type integrates your Zabbix installation with your ((OTRS)) CE installation using the Zabbix webhook feature.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '((OTRS)) CE configuration:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Create a new web service. To do so, navigate to "Admin" → "Web services" and import the "ZabbixTicketConnector.yml" file (it can be found in the official Zabbix repository next to the media type file).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Create a new customer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. Create a new customer user. Select the ID of the customer that you created in the previous step.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '4. Create a new agent. Depending on the ticket queue you want to use for tickets created by the webhook, set the "RW" permission for the group that this ticket queue belongs to. In the example below, if you want to use the "Misc" queue, you must set the "RW" permission for the group "users".' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Zabbix configuration:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Before you can start using the ((OTRS)) CE webhook, set the global macro "{$ZABBIX.URL}":' || chr(13) || chr(10) || '- In the Zabbix web interface, go to "Administration" → "Macros" in the top-left dropdown menu.' || chr(13) || chr(10) || '- Set the global macro "{$ZABBIX.URL}" to the URL of the Zabbix frontend. The URL should be either an IP address, a fully qualified domain name, or localhost.' || chr(13) || chr(10) || '- Specifying a protocol is mandatory, whereas the port is optional. Depending on the web server configuration, you might also need to append "/zabbix" to the end of URL. Good examples:' || chr(13) || chr(10) || '  - http://zabbix.com' || chr(13) || chr(10) || '  - https://zabbix.lan/zabbix' || chr(13) || chr(10) || '  - http://server.zabbix.lan/' || chr(13) || chr(10) || '  - http://localhost' || chr(13) || chr(10) || '')||
TO_NCLOB('  - http://127.0.0.1:8080' || chr(13) || chr(10) || '- Bad examples:' || chr(13) || chr(10) || '  - zabbix.com' || chr(13) || chr(10) || '  - http://zabbix/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the following webhook parameters:' || chr(13) || chr(10) || '- otrs_auth_user - the username of the agent' || chr(13) || chr(10) || '- otrs_auth_password - the password of the agent' || chr(13) || chr(10) || '- otrs_customer - the email of the customer user' || chr(13) || chr(10) || '- otrs_queue - the queue that will be used for tickets created by the webhook' || chr(13) || chr(10) || '- otrs_url - the frontend URL of your ((OTRS)) CE installation (for example, "https://otrs.example.com/otrs")' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. If you want to prioritize issues according to the severity values in Zabbix, you can define mapping parameters (create them as additional webhook parameters):' || chr(13) || chr(10) || '- severity_<name> - the ((OTRS)) CE priority ID (<name> in the parameter name can be one of the following values: "not_classified", "information", "warning", "average", "high", "disaster")' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '4. If you have dynamic fields in ((OTRS)) CE and want them to be filled with values from Zabbix, add webhook parameters in the format "dynamicfield_<((OTRS)) CE dynamic field name>", similarly to the previous step. Dynamic fields can only be of the types "text", "textarea", "checkbox", or "date".' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '5. If you want the webhook to close tickets related to **resolved** problems in Zabbix, you can change the following parameter value:' || chr(13) || chr(10) || '- otrs_closed_state_id - ((OTRS)) CE state ID for closed tasks (possible values: 0 - Disable tickets closing, >0 - State ID from the State Management page).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '6. If you use the ticket type feature, you can change the type of the created tickets:' || chr(13) || chr(10) || '')||
TO_NCLOB('- otrs_ticket_type - ((OTRS)) CE ticket type (set to "Unclassified" by default; present on fresh installations).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '7. Click the "Enabled" checkbox to enable the mediatype and click the "Update" button to save the webhook settings.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '8. Create a Zabbix user and add media:' || chr(13) || chr(10) || '- To create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks).' || chr(13) || chr(10) || '- In the "Media" tab, click "Add" and select the type "OTRS CE" from the drop-down list. Add any value in the "Send to" field: it is not used in the webhook, but is required.' || chr(13) || chr(10) || '- Make sure this user has access to all hosts for which you would like problem notifications to be sent to ((OTRS)) CE.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '9. Done! You can now start using this media type in actions and create tickets.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can find the latest version of this media and additional information in the official Zabbix repository:' || chr(13) || chr(10) || '')||
TO_NCLOB('https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/otrs_ce'),'0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('56','4','PagerDuty','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('const CLogger = function(serviceName) {' || chr(13) || chr(10) || '	this.serviceName = serviceName;' || chr(13) || chr(10) || '	this.INFO = 4' || chr(13) || chr(10) || '	this.WARN = 3' || chr(13) || chr(10) || '	this.ERROR = 2' || chr(13) || chr(10) || '	this.log = function(level, msg) {' || chr(13) || chr(10) || '		Zabbix.log(level, ''['' + this.serviceName + ''] '' + msg);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhook = function(value) {' || chr(13) || chr(10) || '	try {' || chr(13) || chr(10) || '		params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''1'', ''2'', ''3'', ''4''].indexOf(params.event_source) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''.\nMust be 0-4.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1 && [''0'', ''1''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1) {' || chr(13) || chr(10) || '			if (params.event_source === ''1'' && [''0'', ''1'', ''2'', ''3''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0-3.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if (params.event_source === ''0'' && [''0'', ''1''].indexOf(params.event_update_status) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '			if (params.event_source === ''4'') {' || chr(13) || chr(10) || '				if ([''0'', ''1'', ''2'', ''3'', ''4'', ''5''].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {' || chr(13) || chr(10) || '					params.event_nseverity = params.event_update_nseverity;' || chr(13) || chr(10) || '					params.event_severity = params.event_update_severity;' || chr(13) || chr(10) || '					params.event_update_status = ''1'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.runCallback = function(name, params) {' || chr(13) || chr(10) || '			if (typeof this[name] === ''function'') {' || chr(13) || chr(10) || '				return this[name].apply(this, [params]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEvent = function(source, event) {' || chr(13) || chr(10) || '			const alert = { source: source, event: event };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''on'' + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEventless = function(source) {' || chr(13) || chr(10) || '			const alert = { source: source, event: null };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.run = function() {' || chr(13) || chr(10) || '			var results = [];' || chr(13) || chr(10) || '')||
TO_NCLOB('			if (typeof this.httpProxy === ''string'' && this.httpProxy.trim() !== '''') {' || chr(13) || chr(10) || '				this.request.setProxy(this.httpProxy);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			const types = { ''0'': ''Trigger'', ''1'': ''Discovery'', ''2'': ''Autoreg'', ''3'': ''Internal'', ''4'': ''Service'' };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if ([''0'', ''3'', ''4''].indexOf(this.params.event_source) !== -1) {' || chr(13) || chr(10) || '				var event = (this.params.event_update_status === ''1'')' || chr(13) || chr(10) || '					? ''Update''' || chr(13) || chr(10) || '					: ((this.params.event_value === ''1'') ? ''Problem'' : ''Resolve'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				results = this.handleEvent(types[this.params.event_source], event);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else if (typeof types[this.params.event_source] !== ''undefined'') {' || chr(13) || chr(10) || '				results = this.handleEventless(types[this.params.event_source]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				throw ''Unexpected "event_source": '' + this.params.event_source;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			for (idx in results) {' || chr(13) || chr(10) || '				if (typeof results[idx] !== ''undefined'') {' || chr(13) || chr(10) || '					return JSON.stringify(results[idx]);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.httpProxy = params.http_proxy;' || chr(13) || chr(10) || '		this.params = params;' || chr(13) || chr(10) || '		this.runCallback(''onCheckParams'', {});' || chr(13) || chr(10) || '	} catch (error) {' || chr(13) || chr(10) || '		throw ''Webhook processing failed: '' + error;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhookHelper = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {' || chr(13) || chr(10) || '		if (event_source === ''0'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/tr_events.php?triggerid='' + trigger_id + ''&eventid='' + event_id;' || chr(13) || chr(10) || '		} else if (event_source === ''4'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/zabbix.php?action=service.list'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return zabbix_url;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CParamValidator = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isType: function(value, type) {' || chr(13) || chr(10) || '		if (type === ''array'') {' || chr(13) || chr(10) || '			return Array.isArray(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''integer'') {' || chr(13) || chr(10) || '			return CParamValidator.isInteger(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''float'') {' || chr(13) || chr(10) || '			return CParamValidator.isFloat(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (typeof value === type);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isInteger: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseInt(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isFloat: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+\.\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseFloat(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '	isDefined: function(value) {' || chr(13) || chr(10) || '		return !CParamValidator.isType(value, ''undefined'');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isEmpty: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be checked for emptiness.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (value.trim() === '''');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isMacroSet: function(value, macro) {' || chr(13) || chr(10) || '		if (CParamValidator.isDefined(macro)) {' || chr(13) || chr(10) || '			return !(CParamValidator.ifMatch(value, ''^\{'' + macro + ''\}$''))' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !(CParamValidator.ifMatch(value, ''^\{[$#]{0,1}[A-Z_\.]+[\:]{0,1}["]{0,1}.*["]{0,1}\}$'') || value === ''*UNKNOWN*'')' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	withinRange: function(value, min, max) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''number'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a number to be checked for range.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (value < ((CParamValidator.isDefined(min)) ? min : value)' || chr(13) || chr(10) || '			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return true;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	inArray: function(value, array) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(array, ''array'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			throw ''The array must be an array to check the value for existing in it.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (array.indexOf((typeof value === ''string'') ? value.toLowerCase() : value) !== -1);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	ifMatch: function(value, regex) {' || chr(13) || chr(10) || '		return (new RegExp(regex)).test(value);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	match: function(value, regex) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be matched with the regular expression.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.match(new RegExp(regex));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	checkURL: function(value) {' || chr(13) || chr(10) || '		if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must be a non-empty string.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, ''^(http|https):\/\/.+'')) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must contain a schema.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.endsWith(''/'') ? value.slice(0, -1) : value;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	check: function(key, rule, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(rule.type)) {' || chr(13) || chr(10) || '			throw ''Mandatory attribute "type" has not been defined for parameter "'' + key + ''".'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(params[key])) {' || chr(13) || chr(10) || '			throw ''Checked parameter "'' + key + ''" was not found in the list of input parameters.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('		}' || chr(13) || chr(10) || '		var value = params[key],' || chr(13) || chr(10) || '			error_message = null;' || chr(13) || chr(10) || '		switch (rule.type) {' || chr(13) || chr(10) || '			case ''string'':' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" must be a string.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a non-empty string'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a string with a length > '' + rule.len;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must match the regular expression "'' + rule.regex + ''"'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.url) && rule.url === true) {' || chr(13) || chr(10) || '					value = CParamValidator.checkURL(value);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''integer'':' || chr(13) || chr(10) || '				if (!CParamValidator.isInteger(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an integer'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseInt(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''float'':' || chr(13) || chr(10) || '				if (!CParamValidator.isFloat(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a floating-point number'';' || chr(13) || chr(10) || '')||
TO_NCLOB('					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseFloat(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''boolean'':' || chr(13) || chr(10) || '				if (CParamValidator.inArray(value, [''1'', ''true'', ''yes'', ''on''])) {' || chr(13) || chr(10) || '					value = true;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (CParamValidator.inArray(value, [''0'', ''false'', ''no'', ''off''])) {' || chr(13) || chr(10) || '					value = false;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a boolean-like.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''array'':' || chr(13) || chr(10) || '				try {' || chr(13) || chr(10) || '					value = JSON.parse(value);' || chr(13) || chr(10) || '				} catch (error) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" contains invalid JSON.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''array'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an array.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {' || chr(13) || chr(10) || '					value = value.reduce(function(acc, obj) {' || chr(13) || chr(10) || '						acc[obj.tag] = obj.value || null;' || chr(13) || chr(10) || '						return acc;' || chr(13) || chr(10) || '					}, {});' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''object'':' || chr(13) || chr(10) || '				value = JSON.parse(value);' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''object'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an object.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '')||
TO_NCLOB('				break;' || chr(13) || chr(10) || '			default:' || chr(13) || chr(10) || '				throw ''Unexpected attribute type "'' + rule.type + ''" for value "'' + key + ''". Available: '' +' || chr(13) || chr(10) || '				[''integer'', ''float'', ''string'', ''boolean'', ''array'', ''object''].join('', '');' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		params[key] = value;' || chr(13) || chr(10) || '		if (CParamValidator.inArray(rule.type, [''integer'', ''float'']) && error_message === null && (CParamValidator.isDefined(rule.min)' || chr(13) || chr(10) || '			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be a number '' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))' || chr(13) || chr(10) || '				? (rule.min + ''..'' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? ''>'' + rule.min : ''<'' + rule.max));' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be in the array '' + JSON.stringify(rule.array);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {' || chr(13) || chr(10) || '			error_message = ''The macro '' + ((CParamValidator.isDefined(rule.macro)) ? ''{'' + rule.macro + ''} '' : '' '') + ''is not set'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (error_message !== null) {' || chr(13) || chr(10) || '			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {' || chr(13) || chr(10) || '				params[key] = rule.default;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '')||
TO_NCLOB('				Zabbix.log(4, ''Default value for "'' + key + ''" must be a '' + rule.type + ''. Skipped.'');' || chr(13) || chr(10) || '				throw ''Incorrect value for variable "'' + key + ''". '' + error_message;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return this;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	validate: function(rules, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(params, ''object'') || CParamValidator.isType(params, ''array'')) {' || chr(13) || chr(10) || '			throw ''Incorrect parameters value. The value must be an object.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		for (var key in rules) {' || chr(13) || chr(10) || '			CParamValidator.check(key, rules[key], params);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CHttpRequest = function(logger) {' || chr(13) || chr(10) || '	this.request = new HttpRequest();' || chr(13) || chr(10) || '	if (typeof logger !== ''object'' || logger === null) {' || chr(13) || chr(10) || '		this.logger = Zabbix;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		this.logger = logger;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.clearHeader = function() {' || chr(13) || chr(10) || '		this.request.clearHeader();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.addHeaders = function(value) {' || chr(13) || chr(10) || '		var headers = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (typeof value === ''object'' && value !== null) {' || chr(13) || chr(10) || '			if (!Array.isArray(value)) {' || chr(13) || chr(10) || '				Object.keys(value).forEach(function(key) {' || chr(13) || chr(10) || '					headers.push(key + '': '' + value[key]);' || chr(13) || chr(10) || '				});' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '')||
TO_NCLOB('				headers = value;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (typeof value === ''string'') {' || chr(13) || chr(10) || '			value.split(''\r\n'').forEach(function(header) {' || chr(13) || chr(10) || '				headers.push(header);' || chr(13) || chr(10) || '			});' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		for (var idx in headers) {' || chr(13) || chr(10) || '			this.request.addHeader(headers[idx]);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.setProxy = function(proxy) {' || chr(13) || chr(10) || '		this.request.setProxy(proxy);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.plainRequest = function(method, url, data) {' || chr(13) || chr(10) || '		var resp = null;' || chr(13) || chr(10) || '		method = method.toLowerCase();' || chr(13) || chr(10) || '		this.logger.log(4, ''Sending '' + method + '' request:'' + JSON.stringify(data));' || chr(13) || chr(10) || '		if ([''get'', ''post'', ''put'', ''patch'', ''delete'', ''trace''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url, data);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if ([''connect'', ''head'', ''options''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unexpected method. Method '' + method + '' is not supported.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.logger.log(4, ''Response has been received: '' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.jsonRequest = function(method, url, data) {' || chr(13) || chr(10) || '		this.addHeaders(''Content-Type: application/json'');' || chr(13) || chr(10) || '')||
TO_NCLOB('		var resp = this.plainRequest(method, url, JSON.stringify(data));' || chr(13) || chr(10) || '		try {' || chr(13) || chr(10) || '			resp = JSON.parse(resp);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		catch (error) {' || chr(13) || chr(10) || '			throw ''Failed to parse response: not well-formed JSON was received'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.getStatus = function() {' || chr(13) || chr(10) || '		return this.request.getStatus();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var severityMapping = [' || chr(13) || chr(10) || '	''info'',' || chr(13) || chr(10) || '	''info'',' || chr(13) || chr(10) || '	''warning'',' || chr(13) || chr(10) || '	''warning'',' || chr(13) || chr(10) || '	''error'',' || chr(13) || chr(10) || '	''critical''' || chr(13) || chr(10) || '],' || chr(13) || chr(10) || '	serviceLogName = ''PagerDuty Webhook'',' || chr(13) || chr(10) || '	Logger = new CLogger(serviceLogName),' || chr(13) || chr(10) || '	PagerDuty = CWebhook;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getDefaultEventData(data, params) {' || chr(13) || chr(10) || '	data.event_action = ''trigger'';' || chr(13) || chr(10) || '	data.payload.custom_details = {' || chr(13) || chr(10) || '		''Alert message'': params.alert_message' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '	Object.keys(params).forEach(function (key) {' || chr(13) || chr(10) || '		if (key.startsWith(''customdetails_'') && !CParamValidator.isEmpty(params[key])) {' || chr(13) || chr(10) || '			data.payload.custom_details[key.substring(14)] = params[key];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	});' || chr(13) || chr(10) || '	data.client = ''Zabbix'';' || chr(13) || chr(10) || '	data.client_url = params.zabbix_url;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('	return data;' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'PagerDuty.prototype.onCheckParams = function () {' || chr(13) || chr(10) || '	this.params.url = ''https://events.pagerduty.com/v2/enqueue'';' || chr(13) || chr(10) || '	CParamValidator.validate({api_token: {type: ''string''}, event_id: {type: ''integer''},' || chr(13) || chr(10) || '		alert_subject: {type: ''string''}, host_ip: {type: ''string'', default: ''''}, zabbix_url: {type: ''string'', url: true},' || chr(13) || chr(10) || '		event_nseverity: {type: ''integer'', min: 0, max: 5, default: 0}}, this.params);' || chr(13) || chr(10) || '	if (CParamValidator.inArray(this.params.event_source, [''0'',''3'',''4''])) {' || chr(13) || chr(10) || '		CParamValidator.validate({host_name: {type: ''string'', default: ''''}}, this.params);' || chr(13) || chr(10) || '		if (this.params.event_source === ''0'') {' || chr(13) || chr(10) || '			CParamValidator.validate({trigger_id: {type: ''integer''}, event_update_status: {type: ''string'', array: [''0'', ''1'']},' || chr(13) || chr(10) || '				event_ack: {type: ''boolean''}}, this.params);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			CParamValidator.validate({alert_message: {type: ''string''}, event_ack: {type: ''boolean'', default: false}}, this.params);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	this.data = {' || chr(13) || chr(10) || '		routing_key: this.params.api_token,' || chr(13) || chr(10) || '		dedup_key: String(this.params.event_id),' || chr(13) || chr(10) || '		payload: {' || chr(13) || chr(10) || '			summary: this.params.alert_subject,' || chr(13) || chr(10) || '			source: (!CParamValidator.isEmpty(this.params.host_name)) ? (this.params.host_name +' || chr(13) || chr(10) || '				((!CParamValidator.isEmpty(this.params.host_ip)) ? '' : '' + this.params.host_ip : '''')) : ''Zabbix'',' || chr(13) || chr(10) || '			severity: severityMapping[this.params.event_nseverity],' || chr(13) || chr(10) || '')||
TO_NCLOB('		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'PagerDuty.prototype.onProblem = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '	this.data = getDefaultEventData(this.data, this.params);' || chr(13) || chr(10) || '	if (CParamValidator.isDefined(alert.source) && alert.source === ''Trigger'') {' || chr(13) || chr(10) || '		this.data.links = [{' || chr(13) || chr(10) || '			href: CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id),' || chr(13) || chr(10) || '			text: ''Event link''' || chr(13) || chr(10) || '		}];' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.sendRequest();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'PagerDuty.prototype.onUpdate = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '	if (this.params.event_ack === true) {' || chr(13) || chr(10) || '		this.data.event_action = ''acknowledge'';' || chr(13) || chr(10) || '		return this.sendRequest();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	this.data = getDefaultEventData(this.data, this.params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.sendRequest();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'PagerDuty.prototype.onResolve = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '	this.data = getDefaultEventData(this.data, this.params);' || chr(13) || chr(10) || '	this.data.event_action = ''resolve'';' || chr(13) || chr(10) || '	' || chr(13) || chr(10) || '	return this.sendRequest();' || chr(13) || chr(10) || '')||
TO_NCLOB('}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'PagerDuty.prototype.onDiscovery = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '	this.data = getDefaultEventData(this.data, this.params);' || chr(13) || chr(10) || '	this.data.payload.source = ''Discovery'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.sendRequest();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'PagerDuty.prototype.onAutoreg = function (alert) {' || chr(13) || chr(10) || '	return this.onProblem(alert);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'PagerDuty.prototype.sendRequest = function () {' || chr(13) || chr(10) || '	var response = this.request.jsonRequest(''POST'', this.params.url, this.data);' || chr(13) || chr(10) || '	if (!CParamValidator.isType(response, ''object'')) {' || chr(13) || chr(10) || '		Logger.log(Logger.INFO, ''API response ERROR: '' + response);' || chr(13) || chr(10) || '		throw ''Unknown error. Check debug log for more information.'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	if (this.request.getStatus() != 202) {' || chr(13) || chr(10) || '		if (CParamValidator.isType(response.errors, ''array'') && CParamValidator.isType(response.errors[0], ''string'')) {' || chr(13) || chr(10) || '			throw response.errors[0];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unknown error. HTTP status: '' + this.request.getStatus();' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	if (response.status != ''success'') {' || chr(13) || chr(10) || '		Logger.log(Logger.INFO, ''API response ERROR: '' + response);' || chr(13) || chr(10) || '		throw ''Unknown error. Check debug log for more information.'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return ''OK'';' || chr(13) || chr(10) || '')||
TO_NCLOB('};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '	var hook = new PagerDuty(value);' || chr(13) || chr(10) || '	hook.request = new CHttpRequest(Logger);' || chr(13) || chr(10) || '	return hook.run();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '	Logger.log(Logger.WARN, ''notification failed: '' + error);' || chr(13) || chr(10) || '	throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','Please refer to https://v2.developer.pagerduty.com/docs/send-an-event-events-api-v2 and https://www.zabbix.com/documentation/7.0/manual/config/notifications/media/webhook#example_scripts.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Set global macro {$ZABBIX.URL} with your Zabbix server URL.' || chr(13) || chr(10) || 'Add a dedicated user with the media type "PagerDuty" and place the integration key in the user''s "Send to" parameter to integrate into the service.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('57','4','Pushover','','','','','','','','25','0','0','0','0','0','3','10s','1',TO_NCLOB('try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        request = new HttpRequest(),' || chr(13) || chr(10) || '        data,' || chr(13) || chr(10) || '        response,' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        request.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''priority_'' + severities[params.event_nseverity].name] || params.priority_default;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(priority) || priority < -2 || priority > 2) {' || chr(13) || chr(10) || '        throw ''"priority" should be -2..2'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && isNaN(params.triggerid)) {' || chr(13) || chr(10) || '        throw ''field "triggerid" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(params.eventid)) {' || chr(13) || chr(10) || '        throw ''field "eventid" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.message !== ''string'' || params.message.trim() === '''') {' || chr(13) || chr(10) || '        throw ''field "message" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    data = {' || chr(13) || chr(10) || '        token: params.token,' || chr(13) || chr(10) || '        user: params.user,' || chr(13) || chr(10) || '        title: params.title,' || chr(13) || chr(10) || '        message: params.message,' || chr(13) || chr(10) || '        url: (params.event_source === ''0'') ' || chr(13) || chr(10) || '            ? params.url + ''/tr_events.php?triggerid='' + params.triggerid + ''&eventid='' + params.eventid' || chr(13) || chr(10) || '            : params.url,' || chr(13) || chr(10) || '        url_title: params.url_title,' || chr(13) || chr(10) || '')||
TO_NCLOB('        priority: priority' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (priority == 2) {' || chr(13) || chr(10) || '        if (isNaN(params.retry) || params.retry < 30) {' || chr(13) || chr(10) || '            throw ''field "retry" should be a number with value of at least 30 if "priority" is set to 2'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (isNaN(params.expire) || params.expire > 10800) {' || chr(13) || chr(10) || '            throw ''field "expire" should be a number with value of at most 10800 if "priority" is set to 2'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        data.retry = params.retry;' || chr(13) || chr(10) || '        data.expire = params.expire;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    data = JSON.stringify(data);' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Pushover Webhook ] Sending request: '' + params.endpoint + ''\n'' + data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '    response = request.post(params.endpoint, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Pushover Webhook ] Received response with status code '' + request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (response !== null) {' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            response = JSON.parse(response);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        catch (error) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ Pushover Webhook ] Failed to parse response received from Pushover'');' || chr(13) || chr(10) || '            response = null;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (request.getStatus() != 200 || response === null || typeof response !== ''object'' || response.status !== 1) {' || chr(13) || chr(10) || '        if (response !== null && typeof response === ''object'' && typeof response.errors === ''object''' || chr(13) || chr(10) || '                && typeof response.errors[0] === ''string'') {' || chr(13) || chr(10) || '            throw response.errors[0];' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            throw ''Unknown error. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Pushover Webhook ] Pushover notification failed: '' + error);' || chr(13) || chr(10) || '    throw ''Pushover notification failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','Please refer to setup guide here: https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/pushover' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Set token parameter with to your Pushover application key.' || chr(13) || chr(10) || 'When assigning Pushover media to the Zabbix user - add user key into send to field.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('58','4','Redmine','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Redmine = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Redmine.params = params;' || chr(13) || chr(10) || '        if (typeof Redmine.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Redmine.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Redmine.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addCustomFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            data.issue.custom_fields = [];' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function (field) {' || chr(13) || chr(10) || '                    var field_value = fields[field];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                    if (field_value !== undefined) {' || chr(13) || chr(10) || '                        data.issue.custom_fields.push({ id: field, value: field_value });' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''access_key''].forEach(function (field) {' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (typeof Redmine.params !== ''object'' || typeof Redmine.params[field] === ''undefined''' || chr(13) || chr(10) || '                || Redmine.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Redmine.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Redmine.HTTPProxy === ''string'' && Redmine.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Redmine.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''X-Redmine-API-Key: '' + Redmine.params.access_key);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Redmine Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '')||
TO_NCLOB('                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Redmine Webhook ] Received response with status code '' + request.getStatus() + '': '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Redmine Webhook ] Failed to parse response received from Redmine'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.errors !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response.errorMessages !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errorMessages).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errorMessages);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getProjectID: function(name) {' || chr(13) || chr(10) || '        var result = Redmine.request(''get'', ''projects.json''),' || chr(13) || chr(10) || '            project_id;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (result.response) {' || chr(13) || chr(10) || '            var projects = result.response.projects || [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            for (var i in projects) {' || chr(13) || chr(10) || '                if (projects[i].name === name) {' || chr(13) || chr(10) || '                    project_id = projects[i].id;' || chr(13) || chr(10) || '                    break;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ Redmine Webhook ] Failed to retrieve project data.'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof project_id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot find project with name: '' + name;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return project_id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIssue: function(subject, description, priority, fields) {' || chr(13) || chr(10) || '        var project_id = /^\d+$/.test(Redmine.params.project)' || chr(13) || chr(10) || '                ? Redmine.params.project' || chr(13) || chr(10) || '')||
TO_NCLOB('                : Redmine.getProjectID(Redmine.params.project),' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                issue: {' || chr(13) || chr(10) || '                    project_id: project_id,' || chr(13) || chr(10) || '                    tracker_id: Redmine.params.tracker_id,' || chr(13) || chr(10) || '                    subject: subject,' || chr(13) || chr(10) || '                    description: description' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            result;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (priority) {' || chr(13) || chr(10) || '            data.issue.priority_id = priority;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result = Redmine.request(''post'', ''issues.json'', Redmine.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object''' || chr(13) || chr(10) || '            || typeof result.response.issue.id === ''undefined''' || chr(13) || chr(10) || '            || result.status != 201) {' || chr(13) || chr(10) || '            throw ''Cannot create Redmine issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.issue.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateIssue: function (note, fields, status) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            issue: {' || chr(13) || chr(10) || '                notes: note || ''''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (status) {' || chr(13) || chr(10) || '            data.issue.status_id = status;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        Redmine.request(''put'', ''issues/'' + Redmine.params.issue_key + ''.json'', Redmine.addCustomFields(data, fields));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        params_redmine = {},' || chr(13) || chr(10) || '        params_fields = {},' || chr(13) || chr(10) || '        params_update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''tracker_id'', ''project'',' || chr(13) || chr(10) || '            ''event_source'', ''event_value'',  ''event_update_status''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: null, color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''redmine_'')) {' || chr(13) || chr(10) || '                params_redmine[key.substring(8)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''customfield_'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                params_fields[key.substring(12)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                params_update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (typeof params_redmine.close_status_id === ''string'' && params_redmine.close_status_id.trim() !== '''' && !parseInt(params_redmine.close_status_id, 10)) {' || chr(13) || chr(10) || '        throw ''Incorrect "redmine_close_status_id" parameter given! Must be an integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0''' || chr(13) || chr(10) || '        && ((params.event_value === ''1'' && params.event_update_status === ''1'')' || chr(13) || chr(10) || '            || (params.event_value === ''0''' || chr(13) || chr(10) || '                && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))' || chr(13) || chr(10) || '        && (isNaN(parseInt(params.redmine_issue_key)) || parseInt(params.redmine_issue_key) < 1 )) {' || chr(13) || chr(10) || '        throw ''Incorrect "redmine_issue_key" parameter given: '' + params.redmine_issue_key +' || chr(13) || chr(10) || '            ''\nMust be positive integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity].name];' || chr(13) || chr(10) || '    priority = priority && priority.trim() || severities[7].name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Redmine.setParams(params_redmine);' || chr(13) || chr(10) || '')||
TO_NCLOB('    Redmine.HTTPProxy = params.HTTPProxy;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0''' || chr(13) || chr(10) || '        && params.event_value !== ''0'') {' || chr(13) || chr(10) || '        Redmine.createIssue(params.alert_subject, params.alert_message, priority);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params_update.status === ''0'') {' || chr(13) || chr(10) || '        var issue_id = Redmine.createIssue(params.alert_subject,' || chr(13) || chr(10) || '            params.alert_subject + ''\n'' + params.alert_message + ''\n'' +' || chr(13) || chr(10) || '            params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') +' || chr(13) || chr(10) || '            ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id + ''\n'',' || chr(13) || chr(10) || '            priority,' || chr(13) || chr(10) || '            params_fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_redmine_issue_id = issue_id;' || chr(13) || chr(10) || '        result.tags.__zbx_redmine_issuelink = params.redmine_url +' || chr(13) || chr(10) || '            (params.redmine_url.endsWith(''/'') ? '''' : ''/'') + ''issues/'' + issue_id;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Close issue if parameter close_status_id is set and it is a recovery operation' || chr(13) || chr(10) || '    else if (params.event_value === ''0'' && typeof params_redmine.close_status_id === ''string'' && params_redmine.close_status_id.trim() !== '''') {' || chr(13) || chr(10) || '        Redmine.updateIssue(params.alert_subject + ''\n'' + params.alert_message, params_fields, params_redmine.close_status_id);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '')||
TO_NCLOB('    else {' || chr(13) || chr(10) || '        Redmine.updateIssue(params.alert_subject + ''\n'' + params.alert_message, params_fields);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Redmine Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_redmine_issuelink}','Redmine: issue #{EVENT.TAGS.__zbx_redmine_issue_id}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('59','4','Rocket.Chat','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var RocketChat = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        RocketChat.params = params;' || chr(13) || chr(10) || '        if (RocketChat.params.url && RocketChat.params.api_url) {' || chr(13) || chr(10) || '            if (!RocketChat.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                RocketChat.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            if (!RocketChat.params.api_url.endsWith(''/'')) {' || chr(13) || chr(10) || '                RocketChat.params.api_url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            if (RocketChat.params.api_url.startsWith(''/'')) {' || chr(13) || chr(10) || '                RocketChat.params.api_url = RocketChat.params.api_url.substring(1);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            RocketChat.params.url += RocketChat.params.api_url;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        RocketChat.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addFields: function (fields) {' || chr(13) || chr(10) || '        var data = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    if (fields[field] === '''') {' || chr(13) || chr(10) || '')||
TO_NCLOB('                        Zabbix.log(4, ''[ RocketChat Webhook ] Field "'' + field +' || chr(13) || chr(10) || '                            ''" can\''t be empty. The field ignored.'');' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                    else {' || chr(13) || chr(10) || '                        try {' || chr(13) || chr(10) || '                            var parts = field.split('':''),' || chr(13) || chr(10) || '                                prefix = parts[0].split(''_'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                            if (typeof prefix[2] === ''undefined''' || chr(13) || chr(10) || '                                    || (prefix[2] === ''p'' && params.event_value === ''1'')' || chr(13) || chr(10) || '                                    || (prefix[2] === ''r'' && params.event_value === ''0'')) {' || chr(13) || chr(10) || '                                data.push({' || chr(13) || chr(10) || '                                    title: field.substring(field.indexOf('':'') + 1),' || chr(13) || chr(10) || '                                    value: fields[field],' || chr(13) || chr(10) || '                                    short: prefix[1] === ''short''' || chr(13) || chr(10) || '                                });' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                        catch (error) {' || chr(13) || chr(10) || '                            Zabbix.log(4, ''[ RocketChat Webhook ] Can\''t parse field "'' + field +' || chr(13) || chr(10) || '                                ''". The field ignored.'');' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''api_url'', ''user_id'', ''user_token'', ''send_to''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof RocketChat.params !== ''object'' || typeof RocketChat.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || RocketChat.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required parameter is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = RocketChat.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''X-Auth-Token:'' + RocketChat.params.user_token);' || chr(13) || chr(10) || '        request.addHeader(''X-User-Id:'' + RocketChat.params.user_id);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof RocketChat.HTTPProxy !== ''undefined'' && RocketChat.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(RocketChat.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ RocketChat Webhook ] Sending request: '' + url +' || chr(13) || chr(10) || '            ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '')||
TO_NCLOB('                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ RocketChat Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ RocketChat Webhook ] Failed to parse response received from RocketChat'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.message !== ''undefined'') {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.message);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response.error !== ''undefined'') {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.error);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    postMessage: function(use_default_message, message, fields) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            channel: RocketChat.params.send_to,' || chr(13) || chr(10) || '            attachments: [{' || chr(13) || chr(10) || '                collapsed: false,' || chr(13) || chr(10) || '                color: RocketChat.params.color,' || chr(13) || chr(10) || '                title: params.alert_subject' || chr(13) || chr(10) || '            }]' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (RocketChat.params.title_link) {' || chr(13) || chr(10) || '            data.attachments[0].title_link = RocketChat.params.title_link;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (use_default_message) {' || chr(13) || chr(10) || '            data.attachments[0].text = message;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            data.attachments[0].fields = RocketChat.addFields(fields);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var result = RocketChat.request(''post'', ''chat.postMessage'', data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object'' || typeof result.response.message._id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot send RocketChat message. Check debug log for more information.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            id: result.response.message._id,' || chr(13) || chr(10) || '            rid: result.response.message.rid,' || chr(13) || chr(10) || '            channel: result.response.channel' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    sendMessage: function(update, fields) {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            message: {' || chr(13) || chr(10) || '                rid: RocketChat.params.room_id,' || chr(13) || chr(10) || '                tmid: RocketChat.params.msg_id,' || chr(13) || chr(10) || '                tshow: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (update.status === ''0'') {' || chr(13) || chr(10) || '            data.message.attachments = [{' || chr(13) || chr(10) || '                collapsed: false,' || chr(13) || chr(10) || '                color: RocketChat.params.color,' || chr(13) || chr(10) || '                title: params.alert_subject,' || chr(13) || chr(10) || '                title_link: RocketChat.params.title_link,' || chr(13) || chr(10) || '                fields: RocketChat.addFields(fields)' || chr(13) || chr(10) || '            }];' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            data.message.alias = update.user;' || chr(13) || chr(10) || '            data.message.msg = update.action;' || chr(13) || chr(10) || '            if (update.message) {' || chr(13) || chr(10) || '                data.message.attachments = [{' || chr(13) || chr(10) || '                    color: RocketChat.params.color,' || chr(13) || chr(10) || '                    text: update.message' || chr(13) || chr(10) || '                }];' || chr(13) || chr(10) || '')||
TO_NCLOB('            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        RocketChat.request(''post'', ''chat.sendMessage'', data);' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getMessageLink: function(rid, id) {' || chr(13) || chr(10) || '        var room = RocketChat.request(''get'', ''rooms.info?roomId='' + encodeURIComponent(rid)),' || chr(13) || chr(10) || '            link = params.rc_url +' || chr(13) || chr(10) || '                (params.rc_url.endsWith(''/'') ? '''' : ''/'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (room.response.room.t) {' || chr(13) || chr(10) || '            case ''c'':' || chr(13) || chr(10) || '                link += ''channel/'' + room.response.room.name + ''?msg='' + id;' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''p'':' || chr(13) || chr(10) || '                link += ''group/'' + room.response.room.name + ''?msg='' + id;' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''d'':' || chr(13) || chr(10) || '                link += ''direct/'' + rid + ''?msg='' + id;' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ RocketChat Webhook ] Can\''t get room type. Link to message will not be added.'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return link;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        response,' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        rc = {},' || chr(13) || chr(10) || '')||
TO_NCLOB('        update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [''alert_subject'', ''alert_message'', ''event_source'', ''event_value''],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''rc_'')) {' || chr(13) || chr(10) || '                rc[key.substring(3)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''field_'')) {' || chr(13) || chr(10) || '                fields[key.substring(6)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Forcing parameters for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'') {' || chr(13) || chr(10) || '        params.use_default_message = ''true'';' || chr(13) || chr(10) || '        params.event_nseverity = ''0'';' || chr(13) || chr(10) || '        params.rc_title_link = false;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '            && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    RocketChat.setParams(rc);' || chr(13) || chr(10) || '    RocketChat.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    RocketChat.params.color = severities[params.event_nseverity].color;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Send default message if use_default_message === true.' || chr(13) || chr(10) || '    if (params.use_default_message.toLowerCase() === ''true'') {' || chr(13) || chr(10) || '        response = RocketChat.postMessage(true, params.alert_message);' || chr(13) || chr(10) || '        result.tags.__zbx_rc_id = response.id;' || chr(13) || chr(10) || '        result.tags.__zbx_rc_rid = response.rid;' || chr(13) || chr(10) || '        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Send message for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && update.status === ''0'') {' || chr(13) || chr(10) || '        response = RocketChat.postMessage(false, params.alert_message, fields);' || chr(13) || chr(10) || '        result.tags.__zbx_rc_id = response.id;' || chr(13) || chr(10) || '        result.tags.__zbx_rc_rid = response.rid;' || chr(13) || chr(10) || '        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Send thread message for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        RocketChat.sendMessage(update, fields);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ RocketChat Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_rc_msg_url}','Rocket.Chat','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('60','4','ServiceNow','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var ServiceNow = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        ServiceNow.params = params;' || chr(13) || chr(10) || '        if (typeof ServiceNow.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!ServiceNow.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                ServiceNow.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            ServiceNow.params.url += ''api/now/table/incident'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        ServiceNow.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    data[field] = (fields[field].match(/^\d{4}\.\d{2}\.\d{2}$/) !== null)' || chr(13) || chr(10) || '                        ? fields[field].replace(/\./g, ''-'')' || chr(13) || chr(10) || '                        : fields[field];' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, data) {' || chr(13) || chr(10) || '        [''url'', ''user'', ''password''].forEach(function (field) {' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (typeof ServiceNow.params !== ''object'' || typeof ServiceNow.params[field] === ''undefined''' || chr(13) || chr(10) || '                || ServiceNow.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required ServiceNow param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = ServiceNow.params.url,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Basic '' + btoa(ServiceNow.params.user + '':'' + ServiceNow.params.password));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof ServiceNow.HTTPProxy !== ''undefined'' && ServiceNow.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(ServiceNow.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ServiceNow Webhook ] Sending request: '' + url + ((typeof data === ''string'')' || chr(13) || chr(10) || '            ? (''\n'' + data)' || chr(13) || chr(10) || '            : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '')||
TO_NCLOB('                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ServiceNow Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ ServiceNow Webhook ] Failed to parse response received from ServiceNow'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.error.message !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.error).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.error.message);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('        else if (typeof response.result !== ''object'' || typeof response.result.sys_id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create ServiceNow incident. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response.result;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        servicenow = {},' || chr(13) || chr(10) || '        data = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''alert_message'', ''event_source'', ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'', ''event_recovery_value'', ''event_nseverity''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        method = ''post'',' || chr(13) || chr(10) || '        process_tags = true;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (key.startsWith(''servicenow_'')) {' || chr(13) || chr(10) || '                servicenow[key.substring(11)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''u_'')) {' || chr(13) || chr(10) || '                fields[key] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    data.short_description = params.alert_subject;' || chr(13) || chr(10) || '    data.description = params.alert_message;' || chr(13) || chr(10) || '    data.comments = params.alert_message;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params[''urgency_for_'' + severities[params.event_nseverity].name] !== ''undefined'') {' || chr(13) || chr(10) || '        data.urgency = params[''urgency_for_'' + severities[params.event_nseverity].name];' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    ServiceNow.setParams(servicenow);' || chr(13) || chr(10) || '    ServiceNow.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    ServiceNow.setFields(data, fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && (params.event_value === ''0'' || params.event_update_status === ''1'')) {' || chr(13) || chr(10) || '        process_tags = false;' || chr(13) || chr(10) || '        method = ''put'';' || chr(13) || chr(10) || '        delete data.description;' || chr(13) || chr(10) || '        delete data.urgency;' || chr(13) || chr(10) || '        ServiceNow.params.url += ''/'' + params.servicenow_sys_id;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var response = ServiceNow.request(method, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (process_tags) {' || chr(13) || chr(10) || '        result.tags.__zbx_servicenow_sys_id = response.sys_id;' || chr(13) || chr(10) || '        result.tags.__zbx_servicenow_link = params.servicenow_url +' || chr(13) || chr(10) || '')||
TO_NCLOB('            (params.servicenow_url.endsWith(''/'') ? '''' : ''/'') + ''incident.do?sys_id='' + response.sys_id;' || chr(13) || chr(10) || '        result.tags.__zbx_servicenow_number = response.number;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ ServiceNow Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_servicenow_link}','ServiceNow: {EVENT.TAGS.__zbx_servicenow_number}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('61','4','SIGNL4','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('// SIGNL4 Webhook' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var response,' || chr(13) || chr(10) || '        payload,' || chr(13) || chr(10) || '        params = JSON.parse(value),' || chr(13) || chr(10) || '        endpoint = ''https://connect.signl4.com/webhook/'',' || chr(13) || chr(10) || '        request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        request.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.teamsecret === ''string'' && params.teamsecret.trim() !== '''') {' || chr(13) || chr(10) || '        endpoint += params.teamsecret;' || chr(13) || chr(10) || '        delete params.teamsecret;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        throw ''The team secret of your SIGNL4 team cannot be empty.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.Severity === ''string'' && params.Severity === ''{EVENT.SEVERITY}'') {' || chr(13) || chr(10) || '        params.Severity = ''Not classified'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (typeof params.User === ''string'' && params.User === ''{USER.FULLNAME}'') {' || chr(13) || chr(10) || '        params.User = '''';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (typeof params.Event_Update_Action === ''string'' && params.Event_Update_Action === ''{EVENT.UPDATE.ACTION}'') {' || chr(13) || chr(10) || '        params.Event_Update_Action = '''';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	// Assemble X-S4-ExternalID for two-way integration' || chr(13) || chr(10) || '')||
TO_NCLOB('	// Format: "ZabbixEventID: 222 ZabbixURL: https://your-zabbix-server/zabbix/"' || chr(13) || chr(10) || '	params[''X-S4-ExternalID''] = ''ZabbixEventID: '' + params.Event_ID;' || chr(13) || chr(10) || '	if (typeof params.Zabbix_URL === ''string'' && params.Zabbix_URL.indexOf(''http'') == 0) {' || chr(13) || chr(10) || '		// Make sure the URL ends with ''/''' || chr(13) || chr(10) || '		if (params.Zabbix_URL.charAt(params.Zabbix_URL.length - 1) != ''/'') {' || chr(13) || chr(10) || '			params.Zabbix_URL = params.Zabbix_URL + ''/'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		params[''X-S4-ExternalID''] = params[''X-S4-ExternalID''] + '' ZabbixURL: '' +  params.Zabbix_URL;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		// Add Link parameter' || chr(13) || chr(10) || '		params[''Link''] = params.Zabbix_URL + "tr_events.php?triggerid="+params.Trigger_ID + "&eventid=" + params.Event_ID;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	// Check if this is a new problem or a recovery' || chr(13) || chr(10) || '	if (params.Trigger_Status == ''OK'') {' || chr(13) || chr(10) || '		params[''X-S4-Status''] = ''resolved'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		params[''X-S4-Status''] = ''new'';' || chr(13) || chr(10) || '		params[''X-S4-SourceSystem''] = ''Zabbix'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    payload = JSON.stringify(params);' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ SIGNL4 Webhook ] Sending request: '' + payload);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '    response = request.post(endpoint, ''payload='' + payload);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ SIGNL4 Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '    if (request.getStatus() !== 201) {' || chr(13) || chr(10) || '        throw ''Request failed with status code '' + request.getStatus() +' || chr(13) || chr(10) || '                ''. Check debug log for more information.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ SIGNL4 Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','SIGNL4 is a mobile alert notification app for powerful alerting, alert management and mobile assignment of work items. It offers alerting via app push, SMS and voice calls including escalations, tracking, and duty scheduling.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Get the app at https://www.signl4.com.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Find out more including an integration video here: https://www.signl4.com/blog/portfolio_item/zabbix-mobile-alert-notification-duty-schedule-escalation/','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('62','4','Slack','','','','','','','','25','0','0','0','0','1','1','10s','1',TO_NCLOB('const CLogger = function(serviceName) {' || chr(13) || chr(10) || '	this.serviceName = serviceName;' || chr(13) || chr(10) || '	this.INFO = 4' || chr(13) || chr(10) || '	this.WARN = 3' || chr(13) || chr(10) || '	this.ERROR = 2' || chr(13) || chr(10) || '	this.log = function(level, msg) {' || chr(13) || chr(10) || '		Zabbix.log(level, ''['' + this.serviceName + ''] '' + msg);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhook = function(value) {' || chr(13) || chr(10) || '	try {' || chr(13) || chr(10) || '		params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''1'', ''2'', ''3'', ''4''].indexOf(params.event_source) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''.\nMust be 0-4.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1 && [''0'', ''1''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1) {' || chr(13) || chr(10) || '			if (params.event_source === ''1'' && [''0'', ''1'', ''2'', ''3''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0-3.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if (params.event_source === ''0'' && [''0'', ''1''].indexOf(params.event_update_status) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '			if (params.event_source === ''4'') {' || chr(13) || chr(10) || '				if ([''0'', ''1'', ''2'', ''3'', ''4'', ''5''].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {' || chr(13) || chr(10) || '					params.event_nseverity = params.event_update_nseverity;' || chr(13) || chr(10) || '					params.event_severity = params.event_update_severity;' || chr(13) || chr(10) || '					params.event_update_status = ''1'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.runCallback = function(name, params) {' || chr(13) || chr(10) || '			if (typeof this[name] === ''function'') {' || chr(13) || chr(10) || '				return this[name].apply(this, [params]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEvent = function(source, event) {' || chr(13) || chr(10) || '			const alert = { source: source, event: event };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''on'' + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEventless = function(source) {' || chr(13) || chr(10) || '			const alert = { source: source, event: null };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.run = function() {' || chr(13) || chr(10) || '			var results = [];' || chr(13) || chr(10) || '')||
TO_NCLOB('			if (typeof this.httpProxy === ''string'' && this.httpProxy.trim() !== '''') {' || chr(13) || chr(10) || '				this.request.setProxy(this.httpProxy);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			const types = { ''0'': ''Trigger'', ''1'': ''Discovery'', ''2'': ''Autoreg'', ''3'': ''Internal'', ''4'': ''Service'' };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if ([''0'', ''3'', ''4''].indexOf(this.params.event_source) !== -1) {' || chr(13) || chr(10) || '				var event = (this.params.event_update_status === ''1'')' || chr(13) || chr(10) || '					? ''Update''' || chr(13) || chr(10) || '					: ((this.params.event_value === ''1'') ? ''Problem'' : ''Resolve'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				results = this.handleEvent(types[this.params.event_source], event);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else if (typeof types[this.params.event_source] !== ''undefined'') {' || chr(13) || chr(10) || '				results = this.handleEventless(types[this.params.event_source]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				throw ''Unexpected "event_source": '' + this.params.event_source;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			for (idx in results) {' || chr(13) || chr(10) || '				if (typeof results[idx] !== ''undefined'') {' || chr(13) || chr(10) || '					return JSON.stringify(results[idx]);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.httpProxy = params.http_proxy;' || chr(13) || chr(10) || '		this.params = params;' || chr(13) || chr(10) || '		this.runCallback(''onCheckParams'', {});' || chr(13) || chr(10) || '	} catch (error) {' || chr(13) || chr(10) || '		throw ''Webhook processing failed: '' + error;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CParamValidator = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isType: function(value, type) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (type === ''array'') {' || chr(13) || chr(10) || '			return Array.isArray(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''integer'') {' || chr(13) || chr(10) || '			return CParamValidator.isInteger(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''float'') {' || chr(13) || chr(10) || '			return CParamValidator.isFloat(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (typeof value === type);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isInteger: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseInt(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isFloat: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+\.\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseFloat(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isDefined: function(value) {' || chr(13) || chr(10) || '		return !CParamValidator.isType(value, ''undefined'');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isEmpty: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be checked for emptiness.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (value.trim() === '''');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isMacroSet: function(value, macro) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (CParamValidator.isDefined(macro)) {' || chr(13) || chr(10) || '			return !(CParamValidator.ifMatch(value, ''^\{'' + macro + ''\}$''))' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !(CParamValidator.ifMatch(value, ''^\{[$#]{0,1}[A-Z_\.]+[\:]{0,1}["]{0,1}.*["]{0,1}\}$'') || value === ''*UNKNOWN*'')' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	withinRange: function(value, min, max) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''number'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a number to be checked for range.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (value < ((CParamValidator.isDefined(min)) ? min : value)' || chr(13) || chr(10) || '			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return true;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	inArray: function(value, array) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(array, ''array'')) {' || chr(13) || chr(10) || '			throw ''The array must be an array to check the value for existing in it.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (array.indexOf((typeof value === ''string'') ? value.toLowerCase() : value) !== -1);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	ifMatch: function(value, regex) {' || chr(13) || chr(10) || '		return (new RegExp(regex)).test(value);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	match: function(value, regex) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be matched with the regular expression.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '		return value.match(new RegExp(regex));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	checkURL: function(value) {' || chr(13) || chr(10) || '		if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must be a non-empty string.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, ''^(http|https):\/\/.+'')) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must contain a schema.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.endsWith(''/'') ? value.slice(0, -1) : value;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	check: function(key, rule, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(rule.type)) {' || chr(13) || chr(10) || '			throw ''Mandatory attribute "type" has not been defined for parameter "'' + key + ''".'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(params[key])) {' || chr(13) || chr(10) || '			throw ''Checked parameter "'' + key + ''" was not found in the list of input parameters.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		var value = params[key],' || chr(13) || chr(10) || '			error_message = null;' || chr(13) || chr(10) || '		switch (rule.type) {' || chr(13) || chr(10) || '			case ''string'':' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" must be a string.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a non-empty string'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '')||
TO_NCLOB('				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a string with a length > '' + rule.len;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must match the regular expression "'' + rule.regex + ''"'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.url) && rule.url === true) {' || chr(13) || chr(10) || '					value = CParamValidator.checkURL(value);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''integer'':' || chr(13) || chr(10) || '				if (!CParamValidator.isInteger(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an integer'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseInt(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''float'':' || chr(13) || chr(10) || '				if (!CParamValidator.isFloat(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a floating-point number'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseFloat(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''boolean'':' || chr(13) || chr(10) || '				if (CParamValidator.inArray(value, [''1'', ''true'', ''yes'', ''on''])) {' || chr(13) || chr(10) || '					value = true;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (CParamValidator.inArray(value, [''0'', ''false'', ''no'', ''off''])) {' || chr(13) || chr(10) || '					value = false;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a boolean-like.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''array'':' || chr(13) || chr(10) || '				try {' || chr(13) || chr(10) || '					value = JSON.parse(value);' || chr(13) || chr(10) || '				} catch (error) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" contains invalid JSON.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''array'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an array.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {' || chr(13) || chr(10) || '					value = value.reduce(function(acc, obj) {' || chr(13) || chr(10) || '						acc[obj.tag] = obj.value || null;' || chr(13) || chr(10) || '						return acc;' || chr(13) || chr(10) || '					}, {});' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''object'':' || chr(13) || chr(10) || '				value = JSON.parse(value);' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''object'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an object.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			default:' || chr(13) || chr(10) || '				throw ''Unexpected attribute type "'' + rule.type + ''" for value "'' + key + ''". Available: '' +' || chr(13) || chr(10) || '				[''integer'', ''float'', ''string'', ''boolean'', ''array'', ''object''].join('', '');' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		params[key] = value;' || chr(13) || chr(10) || '		if (CParamValidator.inArray(rule.type, [''integer'', ''float'']) && error_message === null && (CParamValidator.isDefined(rule.min)' || chr(13) || chr(10) || '			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			error_message = ''Value "'' + key + ''" must be a number '' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))' || chr(13) || chr(10) || '				? (rule.min + ''..'' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? ''>'' + rule.min : ''<'' + rule.max));' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be in the array '' + JSON.stringify(rule.array);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {' || chr(13) || chr(10) || '			error_message = ''The macro '' + ((CParamValidator.isDefined(rule.macro)) ? ''{'' + rule.macro + ''} '' : '' '') + ''is not set'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (error_message !== null) {' || chr(13) || chr(10) || '			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {' || chr(13) || chr(10) || '				params[key] = rule.default;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				Zabbix.log(4, ''Default value for "'' + key + ''" must be a '' + rule.type + ''. Skipped.'');' || chr(13) || chr(10) || '				throw ''Incorrect value for variable "'' + key + ''". '' + error_message;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return this;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	validate: function(rules, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(params, ''object'') || CParamValidator.isType(params, ''array'')) {' || chr(13) || chr(10) || '			throw ''Incorrect parameters value. The value must be an object.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		for (var key in rules) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			CParamValidator.check(key, rules[key], params);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CHttpRequest = function(logger) {' || chr(13) || chr(10) || '	this.request = new HttpRequest();' || chr(13) || chr(10) || '	if (typeof logger !== ''object'' || logger === null) {' || chr(13) || chr(10) || '		this.logger = Zabbix;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		this.logger = logger;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.clearHeader = function() {' || chr(13) || chr(10) || '		this.request.clearHeader();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.addHeaders = function(value) {' || chr(13) || chr(10) || '		var headers = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (typeof value === ''object'' && value !== null) {' || chr(13) || chr(10) || '			if (!Array.isArray(value)) {' || chr(13) || chr(10) || '				Object.keys(value).forEach(function(key) {' || chr(13) || chr(10) || '					headers.push(key + '': '' + value[key]);' || chr(13) || chr(10) || '				});' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				headers = value;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (typeof value === ''string'') {' || chr(13) || chr(10) || '			value.split(''\r\n'').forEach(function(header) {' || chr(13) || chr(10) || '				headers.push(header);' || chr(13) || chr(10) || '			});' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		for (var idx in headers) {' || chr(13) || chr(10) || '			this.request.addHeader(headers[idx]);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.setProxy = function(proxy) {' || chr(13) || chr(10) || '		this.request.setProxy(proxy);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '	this.plainRequest = function(method, url, data) {' || chr(13) || chr(10) || '		var resp = null;' || chr(13) || chr(10) || '		method = method.toLowerCase();' || chr(13) || chr(10) || '		this.logger.log(4, ''Sending '' + method + '' request:'' + JSON.stringify(data));' || chr(13) || chr(10) || '		if ([''get'', ''post'', ''put'', ''patch'', ''delete'', ''trace''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url, data);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if ([''connect'', ''head'', ''options''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unexpected method. Method '' + method + '' is not supported.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.logger.log(4, ''Response has been received: '' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.jsonRequest = function(method, url, data) {' || chr(13) || chr(10) || '		this.addHeaders(''Content-Type: application/json'');' || chr(13) || chr(10) || '		var resp = this.plainRequest(method, url, JSON.stringify(data));' || chr(13) || chr(10) || '		try {' || chr(13) || chr(10) || '			resp = JSON.parse(resp);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		catch (error) {' || chr(13) || chr(10) || '			throw ''Failed to parse response: not well-formed JSON was received'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.getStatus = function() {' || chr(13) || chr(10) || '		return this.request.getStatus();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('const CWebhookHelper = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {' || chr(13) || chr(10) || '		if (event_source === ''0'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/tr_events.php?triggerid='' + trigger_id + ''&eventid='' + event_id;' || chr(13) || chr(10) || '		} else if (event_source === ''4'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/zabbix.php?action=service.list'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return zabbix_url;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var serviceLogName = ''Slack Webhook'',' || chr(13) || chr(10) || '	Logger = new CLogger(serviceLogName),' || chr(13) || chr(10) || '	Slack = CWebhook;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Slack.prototype.onCheckParams = function () {' || chr(13) || chr(10) || '	CParamValidator.validate({' || chr(13) || chr(10) || '		alert_subject: { type: ''string'' },' || chr(13) || chr(10) || '		alert_message: { type: ''string'' },' || chr(13) || chr(10) || '		bot_token: { type: ''string'' },' || chr(13) || chr(10) || '		zabbix_url: { type: ''string'', url: true },' || chr(13) || chr(10) || '		channel: { type: ''string'', macro: ''ALERT.SENDTO'' },' || chr(13) || chr(10) || '		slack_mode: { type: ''string'', array: [''alarm'', ''event''], }' || chr(13) || chr(10) || '	}, this.params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.event_source === ''0'') {' || chr(13) || chr(10) || '		CParamValidator.validate({' || chr(13) || chr(10) || '			event_id: { type: ''integer'' },' || chr(13) || chr(10) || '			trigger_id: { type: ''integer'' }' || chr(13) || chr(10) || '		}, this.params);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (CParamValidator.inArray(this.params.event_source, [''0'', ''3'', ''4''])) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		CParamValidator.validate({' || chr(13) || chr(10) || '			event_tags: { type: ''array'', macro: ''EVENT.TAGSJSON'', tags: true, default: {} }' || chr(13) || chr(10) || '		}, this.params);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.event_value != ''0'' && CParamValidator.isDefined(this.params.event_tags[''__channel_id_'' + this.params.channel])) {' || chr(13) || chr(10) || '		this.params.event_update_status = ''1'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.severity_colors = [' || chr(13) || chr(10) || '		''#97AAB3'',' || chr(13) || chr(10) || '		''#7499FF'',' || chr(13) || chr(10) || '		''#FFC859'',' || chr(13) || chr(10) || '		''#FFA059'',' || chr(13) || chr(10) || '		''#E97659'',' || chr(13) || chr(10) || '		''#E45959''' || chr(13) || chr(10) || '	];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.resolve_color = ''#009900'';' || chr(13) || chr(10) || '	this.slack_endpoint = ''https://slack.com/api/'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.problem_url = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.data = {' || chr(13) || chr(10) || '		channel: this.params.channel,' || chr(13) || chr(10) || '		attachments: [' || chr(13) || chr(10) || '			{' || chr(13) || chr(10) || '				fallback: this.params.alert_subject,' || chr(13) || chr(10) || '				title: this.params.alert_subject,' || chr(13) || chr(10) || '				color: this.severity_colors[this.params.event_nseverity],' || chr(13) || chr(10) || '				title_link: this.problem_url,' || chr(13) || chr(10) || '				text: this.params.alert_message,' || chr(13) || chr(10) || '				actions: [' || chr(13) || chr(10) || '					{' || chr(13) || chr(10) || '						type: ''button'',' || chr(13) || chr(10) || '						text: ''Open in Zabbix'',' || chr(13) || chr(10) || '						url: this.problem_url' || chr(13) || chr(10) || '')||
TO_NCLOB('					}' || chr(13) || chr(10) || '				]' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		]' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.reply = {' || chr(13) || chr(10) || '		channel: this.params.channel,' || chr(13) || chr(10) || '		thread_ts: '''',' || chr(13) || chr(10) || '		blocks: [' || chr(13) || chr(10) || '			{' || chr(13) || chr(10) || '				type: ''context'',' || chr(13) || chr(10) || '				elements: [' || chr(13) || chr(10) || '					{' || chr(13) || chr(10) || '						type: ''plain_text'',' || chr(13) || chr(10) || '						text: ''Event update message''' || chr(13) || chr(10) || '					}' || chr(13) || chr(10) || '				]' || chr(13) || chr(10) || '			},' || chr(13) || chr(10) || '			{' || chr(13) || chr(10) || '				type: ''rich_text'',' || chr(13) || chr(10) || '				elements: [' || chr(13) || chr(10) || '					{' || chr(13) || chr(10) || '						type: ''rich_text_section'',' || chr(13) || chr(10) || '						elements: [' || chr(13) || chr(10) || '							{' || chr(13) || chr(10) || '								type: ''text'',' || chr(13) || chr(10) || '								text: '''',' || chr(13) || chr(10) || '								style: {' || chr(13) || chr(10) || '									italic: true' || chr(13) || chr(10) || '								}' || chr(13) || chr(10) || '							}' || chr(13) || chr(10) || '						]' || chr(13) || chr(10) || '					}' || chr(13) || chr(10) || '				]' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		]' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Slack.prototype.sendRequest = function (route, data, tags) {' || chr(13) || chr(10) || '	this.request.clearHeader();' || chr(13) || chr(10) || '	this.request.addHeaders({' || chr(13) || chr(10) || '		''Content-Type'': ''application/json; charset=utf-8;'',' || chr(13) || chr(10) || '		''Authorization'': ''Bearer '' + this.params.bot_token' || chr(13) || chr(10) || '	});' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('	var response = this.request.jsonRequest(''POST'', this.slack_endpoint + route, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.request.getStatus() !== 200 || !CParamValidator.isType(response.ok, ''boolean'') || response.ok !== true) {' || chr(13) || chr(10) || '		Logger.log(Logger.INFO, ''HTTP code: '' + this.request.getStatus());' || chr(13) || chr(10) || '		if (CParamValidator.isType(response.error, ''string'')) {' || chr(13) || chr(10) || '			throw ''Endpoint response:'' + response.error;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unknown error. Check debug log for more information.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (tags) {' || chr(13) || chr(10) || '		return {' || chr(13) || chr(10) || '			tags: {' || chr(13) || chr(10) || '				[''__message_ts_'' + this.params.channel]: response.ts,' || chr(13) || chr(10) || '				[''__channel_id_'' + this.params.channel]: response.channel,' || chr(13) || chr(10) || '				[''__message_link_'' + this.params.channel]: this.getPermalink(response.channel, response.ts),' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		return { tags: {} };' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Slack.prototype.getPermalink = function (channel, message_ts) {' || chr(13) || chr(10) || '	var response = this.request.jsonRequest(''GET'', this.slack_endpoint + ''chat.getPermalink'' + ''?channel='' + channel + ''&message_ts='' + message_ts);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.request.getStatus() !== 200 || !CParamValidator.isType(response.ok, ''boolean'') || response.ok !== true) {' || chr(13) || chr(10) || '		Logger.log(Logger.INFO, ''HTTP code: '' + this.request.getStatus());' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (CParamValidator.isType(response.error, ''string'')) {' || chr(13) || chr(10) || '			throw ''Endpoint response:'' + response.error;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unknown error. Check debug log for more information.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (!CParamValidator.isDefined(response.permalink)) {' || chr(13) || chr(10) || '		throw ''Permalink is missed from the JSON response'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return response.permalink;' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Slack.prototype.onProblem = function (properties) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + properties.source + ''; Event: '' + properties.event);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.slack_mode === "alarm") {' || chr(13) || chr(10) || '		return this.sendRequest(''chat.postMessage'', this.data, true);' || chr(13) || chr(10) || '	} else {' || chr(13) || chr(10) || '		return this.sendRequest(''chat.postMessage'', this.data, false);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Slack.prototype.onUpdate = function (properties) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + properties.source + ''; Event: '' + properties.event);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.slack_mode === "alarm") {' || chr(13) || chr(10) || '		this.data.channel = this.params.event_tags[''__channel_id_'' + this.params.channel];' || chr(13) || chr(10) || '		this.data.ts = this.params.event_tags[''__message_ts_'' + this.params.channel];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (CParamValidator.isMacroSet(this.params.event_update_message, ''EVENT.UPDATE.MESSAGE'') && !CParamValidator.isEmpty(this.params.event_update_message)) {' || chr(13) || chr(10) || '			this.reply.thread_ts = this.data.ts;' || chr(13) || chr(10) || '			this.reply.blocks[1].elements[0].elements[0].text = this.params.event_update_message;' || chr(13) || chr(10) || '			this.sendRequest(''chat.postMessage'', this.reply, false);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (/\backnowledged/.test(this.params.event_update_action)) {' || chr(13) || chr(10) || '			this.sendRequest(''reactions.add'', { channel: this.data.channel, timestamp: this.data.ts, name: ''white_check_mark'' }, false);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (/\bunacknowledged/.test(this.params.event_update_action)) {' || chr(13) || chr(10) || '			this.sendRequest(''reactions.remove'', { channel: this.data.channel, timestamp: this.data.ts, name: ''white_check_mark'' }, false);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (/\bclosed/.test(this.params.event_update_action)) {' || chr(13) || chr(10) || '			return { tags: {} };' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			return this.sendRequest(''chat.update'', this.data, false);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	} else {' || chr(13) || chr(10) || '		return this.sendRequest(''chat.postMessage'', this.data, false);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Slack.prototype.onResolve = function (properties) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + properties.source + ''; Event: '' + properties.event);' || chr(13) || chr(10) || '	this.data.attachments[0].color = this.resolve_color;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.slack_mode === "alarm") {' || chr(13) || chr(10) || '		this.data.channel = this.params.event_tags[''__channel_id_'' + this.params.channel];' || chr(13) || chr(10) || '')||
TO_NCLOB('		this.data.ts = this.params.event_tags[''__message_ts_'' + this.params.channel];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return this.sendRequest(''chat.update'', this.data, false);' || chr(13) || chr(10) || '	} else {' || chr(13) || chr(10) || '		return this.sendRequest(''chat.postMessage'', this.data, false);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Slack.prototype.onDiscovery = function (properties) {' || chr(13) || chr(10) || '	return this.onProblem(properties);' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Slack.prototype.onAutoreg = function (properties) {' || chr(13) || chr(10) || '	return this.onProblem(properties);' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '	var hook = new Slack(value);' || chr(13) || chr(10) || '	hook.request = new CHttpRequest(Logger);' || chr(13) || chr(10) || '	return hook.run();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '	Logger.log(Logger.WARN, ''Notification failed: '' + error);' || chr(13) || chr(10) || '	throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','0','','','Preparing slack for a Zabbix media type:' || chr(13) || chr(10) || '1. On the page Your Apps (https://api.slack.com/apps) press ''Create an App'', select ''From scratch'' and specify its name and workspace.' || chr(13) || chr(10) || '2. In the ''Add features and functionality'' section, select ''Bots'' and press ''Review Scopes to Add''.' || chr(13) || chr(10) || '3. In the ''Scopes'' section, find ''Bot Token Scopes'', press ''Add an OAuth Scope'' and add ''chat:write'', ''im:write'', ''groups:write'' and ''reactions:write'' scopes.' || chr(13) || chr(10) || '4. In the ''Settings'' section on the left side of the page press ''Install App'' and then ''Install to Workspace''.' || chr(13) || chr(10) || '5. Press ''Allow'' and copy ''Bot User OAuth Access Token'', which will be used to set up webhook.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'In Zabbix:' || chr(13) || chr(10) || '1. Set global macro {$ZABBIX.URL}' || chr(13) || chr(10) || '2. Set user media for slack using channel name or member ID' || chr(13) || chr(10) || '3. Set media param ''bot_token'' to the previously created token' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'For a detailed instructions please read full README file https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/slack/README.md','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('63','4','SolarWinds Service Desk','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var SolarWinds = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        SolarWinds.params = params;' || chr(13) || chr(10) || '        SolarWinds.params.endpoint = ''https://api.samanage.com/'';' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        SolarWinds.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addCustomFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof data.incident === ''object'' && typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            if (typeof fields.sw_fields === ''object'' && Object.keys(fields.sw_fields).length) {' || chr(13) || chr(10) || '                Object.keys(fields.sw_fields)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        try {' || chr(13) || chr(10) || '                            data.incident[field] = JSON.parse(fields.sw_fields[field]);' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                        catch (error) {' || chr(13) || chr(10) || '                            data.incident[field] = fields.sw_fields[field];' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (typeof fields.sw_customfields === ''object'' && Object.keys(fields.sw_customfields).length) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                data.incident.custom_fields_values = {custom_fields_value: []};' || chr(13) || chr(10) || '                Object.keys(fields.sw_customfields)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        data.incident.custom_fields_values.custom_fields_value.push({' || chr(13) || chr(10) || '                            name: field,' || chr(13) || chr(10) || '                            value: fields.sw_customfields[field]' || chr(13) || chr(10) || '                        });' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''token''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof SolarWinds.params !== ''object'' || typeof SolarWinds.params[field] === ''undefined''' || chr(13) || chr(10) || '                || SolarWinds.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required SolarWinds param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = SolarWinds.params.endpoint + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''X-Samanage-Authorization: Bearer '' + SolarWinds.params.token);' || chr(13) || chr(10) || '        request.addHeader(''Accept: application/vnd.samanage.v2.1+json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof SolarWinds.HTTPProxy !== ''undefined'' && SolarWinds.HTTPProxy !== '''') {' || chr(13) || chr(10) || '')||
TO_NCLOB('            request.setProxy(SolarWinds.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ SolarWinds SD Webhook ] Sending request: '' + url + ((typeof data === ''string'')' || chr(13) || chr(10) || '            ? (''\n'' + data)' || chr(13) || chr(10) || '            : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ SolarWinds SD Webhook ] Received response with status code '' + request.getStatus() +' || chr(13) || chr(10) || '            ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                Zabbix.log(4, ''[ SolarWinds SD Webhook ] Failed to parse response received from SolarWinds'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.error !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.error).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.error);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response === ''object''' || chr(13) || chr(10) || '                && Object.keys(response).length > 0) {' || chr(13) || chr(10) || '                Object.keys(response)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        message += ''\n'' + field + '': '' + response[field][0];' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIncident: function(name, description, fields) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            incident: {' || chr(13) || chr(10) || '')||
TO_NCLOB('                name: name,' || chr(13) || chr(10) || '                description: description,' || chr(13) || chr(10) || '                priority: SolarWinds.params.priority' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var result = SolarWinds.request(''post'', ''incidents.json'', SolarWinds.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object'' || typeof result.response.id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create SolarWinds incident. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateIncident: function(name, fields, message) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            incident: {' || chr(13) || chr(10) || '                name: name,' || chr(13) || chr(10) || '                priority: SolarWinds.params.priority' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        SolarWinds.request(' || chr(13) || chr(10) || '            ''put'',' || chr(13) || chr(10) || '            ''incidents/'' + SolarWinds.params.incident_id + ''.json'',' || chr(13) || chr(10) || '            SolarWinds.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        SolarWinds.commenIncident(message);' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    commenIncident: function(message) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            comment: {' || chr(13) || chr(10) || '                body: message' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '        SolarWinds.request(''post'', ''incidents/'' + SolarWinds.params.incident_id + ''/comments.json'', data);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        samanage = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [''alert_subject'', ''event_recovery_value'', ''event_source'', ''event_value'', ''priority_default''],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified''},' || chr(13) || chr(10) || '            {name: ''information''},' || chr(13) || chr(10) || '            {name: ''warning''},' || chr(13) || chr(10) || '            {name: ''average''},' || chr(13) || chr(10) || '            {name: ''high''},' || chr(13) || chr(10) || '            {name: ''disaster''},' || chr(13) || chr(10) || '            {name: ''resolved''},' || chr(13) || chr(10) || '            {name: ''default''}' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    fields.sw_fields = {};' || chr(13) || chr(10) || '    fields.sw_customfields = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''samanage_'')) {' || chr(13) || chr(10) || '                samanage[key.substring(9)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''sw_field_'')) {' || chr(13) || chr(10) || '                fields.sw_fields[key.substring(9)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''sw_customfield_'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                fields.sw_customfields[key.substring(15)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    samanage.priority = params[''priority_'' + severities[params.event_nseverity].name] || params.priority_default;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    SolarWinds.setParams(samanage);' || chr(13) || chr(10) || '    SolarWinds.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create incident for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {' || chr(13) || chr(10) || '        SolarWinds.createIncident(params.alert_subject, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create incident for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params.event_update_status === ''0''' || chr(13) || chr(10) || '            && (samanage.incident_id === ''{EVENT.TAGS.__zbx_solarwinds_inc_id}'' || samanage.incident_id === ''*UNKNOWN*'')) {' || chr(13) || chr(10) || '        var key = SolarWinds.createIncident(params.alert_subject, params.alert_message, fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_solarwinds_inc_id = key;' || chr(13) || chr(10) || '        result.tags.__zbx_solarwinds_inc_link = params.samanage_url +' || chr(13) || chr(10) || '            (params.samanage_url.endsWith(''/'') ? '''' : ''/'') + ''incidents/'' + key;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created incident for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (samanage.incident_id === ''{EVENT.TAGS.__zbx_solarwinds_inc_id}'' || samanage.incident_id === '''' || samanage.incident_id === ''*UNKNOWN*'') {' || chr(13) || chr(10) || '            throw ''Incorrect incident key given: '' + samanage.incident_id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (!params.alert_message) {' || chr(13) || chr(10) || '            throw ''Parameter "alert_message" can\''t be empty.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        SolarWinds.updateIncident(params.alert_subject, fields, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        return JSON.stringify(result);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        return ''OK'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ SolarWinds SD Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_solarwinds_inc_link}','SolarWinds incident ID: {EVENT.TAGS.__zbx_solarwinds_inc_id}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('64','4','SysAid','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var SysAid = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        var required = [''url'', ''auth_user'', ''auth_password'', ''category_level_1'', ''category_level_2'',' || chr(13) || chr(10) || '            ''category_level_3'', ''incident_id'', ''template_id'', ''urgency_id'', ''incident_state'',' || chr(13) || chr(10) || '            ''default_priority_id''' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        required.forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof params !== ''object'' || typeof params[field] === ''undefined'' || params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        SysAid.params = params;' || chr(13) || chr(10) || '        if (typeof SysAid.params.url === ''string'' && !SysAid.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '            SysAid.params.url += ''/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    login: function () {' || chr(13) || chr(10) || '        var result = SysAid.request(''post'', ''api/v1/login'', {' || chr(13) || chr(10) || '            user_name: SysAid.params.auth_user,' || chr(13) || chr(10) || '            password: SysAid.params.auth_password' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.user.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '')||
TO_NCLOB('            request = SysAid.req || (SysAid.req = new HttpRequest()),' || chr(13) || chr(10) || '            url = SysAid.params.url + query;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof SysAid.HTTPProxy !== ''undefined'' && SysAid.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            request.setProxy(SysAid.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ SysAid Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ SysAid Webhook ] Received response with status code '' + request.getStatus() + '': '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() !== 200) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '            message += '': '' + response;' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ SysAid Webhook ] Failed to parse response received from SysAid'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response === null || (typeof response.Error !== ''undefined'' && Object.keys(response.Error).length > 0)) {' || chr(13) || chr(10) || '            throw ''Request failed: '' + JSON.stringify(response.Error);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIncident: function(subject, message, priority) {' || chr(13) || chr(10) || '        var result = SysAid.request(''post'', ''api/v1/sr/?template='' + encodeURIComponent(SysAid.params.template_id), {' || chr(13) || chr(10) || '            info: [' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''problem_type'',' || chr(13) || chr(10) || '                    value: [' || chr(13) || chr(10) || '                        SysAid.params.category_level_1,' || chr(13) || chr(10) || '                        SysAid.params.category_level_2,' || chr(13) || chr(10) || '')||
TO_NCLOB('                        SysAid.params.category_level_3' || chr(13) || chr(10) || '                    ].join(''_'')' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''title'',' || chr(13) || chr(10) || '                    value: subject' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''description'',' || chr(13) || chr(10) || '                    value: message' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''status'',' || chr(13) || chr(10) || '                    value: ''1''' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''urgency'',' || chr(13) || chr(10) || '                    value: SysAid.params.urgency_id' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''priority'',' || chr(13) || chr(10) || '                    value: priority || SysAid.params.default_priority_id,' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            ]' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (result.response.id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create SysAid incident. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateTicket: function(note) {' || chr(13) || chr(10) || '        var date = new Date().getTime();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        SysAid.request(''put'', ''api/v1/sr/'' + encodeURIComponent(SysAid.params.incident_id), {' || chr(13) || chr(10) || '            id: SysAid.params.incident_id,' || chr(13) || chr(10) || '            info: [' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''update_time'',' || chr(13) || chr(10) || '                    value: date' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''notes'',' || chr(13) || chr(10) || '                    value: [' || chr(13) || chr(10) || '                        {' || chr(13) || chr(10) || '                            userName: ''Zabbix'',' || chr(13) || chr(10) || '                            createDate: date,' || chr(13) || chr(10) || '                            text: note' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    ]' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            ]' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        params_sysaid = {},' || chr(13) || chr(10) || '        params_update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [''alert_subject'', ''event_source'', ''event_value'',  ''event_update_status''],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '')||
TO_NCLOB('            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: null, color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''sysaid_'')) {' || chr(13) || chr(10) || '                params_sysaid[key.substring(7)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                params_update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && ((params.event_value === ''1'' && params.event_update_status === ''1'')' || chr(13) || chr(10) || '            || (params.event_value === ''0'' && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))' || chr(13) || chr(10) || '            && (isNaN(parseInt(params.sysaid_incident_id)) || parseInt(params.sysaid_incident_id) < 1 )) {' || chr(13) || chr(10) || '        throw ''Incorrect "sysaid_incident_id" parameter given: '' + params.sysaid_incident_id + ''\nMust be positive integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity].name];' || chr(13) || chr(10) || '    priority = priority && priority.trim() || severities[7].name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    SysAid.setParams(params_sysaid);' || chr(13) || chr(10) || '    SysAid.HTTPProxy = params.HTTPProxy;' || chr(13) || chr(10) || '')||
TO_NCLOB('    SysAid.login();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value !== ''0'') {' || chr(13) || chr(10) || '        // Create ticket for non trigger-based events.' || chr(13) || chr(10) || '        SysAid.createIncident(params.alert_subject, params.alert_message, priority);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params_update.status === ''0'') {' || chr(13) || chr(10) || '        // Create ticket for trigger-based events.' || chr(13) || chr(10) || '        var incident_id = SysAid.createIncident(params.alert_subject, params.alert_subject + ''\n'' + params.alert_message +' || chr(13) || chr(10) || '                ''\n'' + params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') + ''tr_events.php?triggerid='' +' || chr(13) || chr(10) || '                params.trigger_id + ''&eventid='' + params.event_id + ''\n'', priority' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_sysaid_incident_id = incident_id;' || chr(13) || chr(10) || '        result.tags.__zbx_sysaid_incidentlink = params.sysaid_url +' || chr(13) || chr(10) || '            (params.sysaid_url.endsWith(''/'') ? '''' : ''/'') + ''SREdit.jsp?id='' + incident_id + ''&fromId=IncidentsList'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        // Update created ticket for trigger-based event.' || chr(13) || chr(10) || '        SysAid.updateTicket(params.alert_subject + ''\n'' + params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ SysAid Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_sysaid_incidentlink}','SysAid: incident #{EVENT.TAGS.__zbx_sysaid_incident_id}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('65','4','Telegram','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('const CLogger = function(serviceName) {' || chr(13) || chr(10) || '	this.serviceName = serviceName;' || chr(13) || chr(10) || '	this.INFO = 4' || chr(13) || chr(10) || '	this.WARN = 3' || chr(13) || chr(10) || '	this.ERROR = 2' || chr(13) || chr(10) || '	this.log = function(level, msg) {' || chr(13) || chr(10) || '		Zabbix.log(level, ''['' + this.serviceName + ''] '' + msg);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhook = function(value) {' || chr(13) || chr(10) || '	try {' || chr(13) || chr(10) || '		params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''1'', ''2'', ''3'', ''4''].indexOf(params.event_source) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''.\nMust be 0-4.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1 && [''0'', ''1''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1) {' || chr(13) || chr(10) || '			if (params.event_source === ''1'' && [''0'', ''1'', ''2'', ''3''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0-3.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if (params.event_source === ''0'' && [''0'', ''1''].indexOf(params.event_update_status) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '			if (params.event_source === ''4'') {' || chr(13) || chr(10) || '				if ([''0'', ''1'', ''2'', ''3'', ''4'', ''5''].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {' || chr(13) || chr(10) || '					params.event_nseverity = params.event_update_nseverity;' || chr(13) || chr(10) || '					params.event_severity = params.event_update_severity;' || chr(13) || chr(10) || '					params.event_update_status = ''1'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.runCallback = function(name, params) {' || chr(13) || chr(10) || '			if (typeof this[name] === ''function'') {' || chr(13) || chr(10) || '				return this[name].apply(this, [params]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEvent = function(source, event) {' || chr(13) || chr(10) || '			const alert = { source: source, event: event };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''on'' + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEventless = function(source) {' || chr(13) || chr(10) || '			const alert = { source: source, event: null };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.run = function() {' || chr(13) || chr(10) || '			var results = [];' || chr(13) || chr(10) || '')||
TO_NCLOB('			if (typeof this.httpProxy === ''string'' && this.httpProxy.trim() !== '''') {' || chr(13) || chr(10) || '				this.request.setProxy(this.httpProxy);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			const types = { ''0'': ''Trigger'', ''1'': ''Discovery'', ''2'': ''Autoreg'', ''3'': ''Internal'', ''4'': ''Service'' };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if ([''0'', ''3'', ''4''].indexOf(this.params.event_source) !== -1) {' || chr(13) || chr(10) || '				var event = (this.params.event_update_status === ''1'')' || chr(13) || chr(10) || '					? ''Update''' || chr(13) || chr(10) || '					: ((this.params.event_value === ''1'') ? ''Problem'' : ''Resolve'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				results = this.handleEvent(types[this.params.event_source], event);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else if (typeof types[this.params.event_source] !== ''undefined'') {' || chr(13) || chr(10) || '				results = this.handleEventless(types[this.params.event_source]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				throw ''Unexpected "event_source": '' + this.params.event_source;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			for (idx in results) {' || chr(13) || chr(10) || '				if (typeof results[idx] !== ''undefined'') {' || chr(13) || chr(10) || '					return JSON.stringify(results[idx]);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.httpProxy = params.http_proxy;' || chr(13) || chr(10) || '		this.params = params;' || chr(13) || chr(10) || '		this.runCallback(''onCheckParams'', {});' || chr(13) || chr(10) || '	} catch (error) {' || chr(13) || chr(10) || '		throw ''Webhook processing failed: '' + error;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CParamValidator = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isType: function(value, type) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (type === ''array'') {' || chr(13) || chr(10) || '			return Array.isArray(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''integer'') {' || chr(13) || chr(10) || '			return CParamValidator.isInteger(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''float'') {' || chr(13) || chr(10) || '			return CParamValidator.isFloat(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (typeof value === type);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isInteger: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseInt(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isFloat: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+\.\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseFloat(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isDefined: function(value) {' || chr(13) || chr(10) || '		return !CParamValidator.isType(value, ''undefined'');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isEmpty: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be checked for emptiness.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (value.trim() === '''');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isMacroSet: function(value, macro) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (CParamValidator.isDefined(macro)) {' || chr(13) || chr(10) || '			return !(CParamValidator.ifMatch(value, ''^\{'' + macro + ''\}$''))' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !(CParamValidator.ifMatch(value, ''^\{[$#]{0,1}[A-Z_\.]+[\:]{0,1}["]{0,1}.*["]{0,1}\}$'') || value === ''*UNKNOWN*'')' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	withinRange: function(value, min, max) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''number'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a number to be checked for range.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (value < ((CParamValidator.isDefined(min)) ? min : value)' || chr(13) || chr(10) || '			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return true;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	inArray: function(value, array) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(array, ''array'')) {' || chr(13) || chr(10) || '			throw ''The array must be an array to check the value for existing in it.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (array.indexOf((typeof value === ''string'') ? value.toLowerCase() : value) !== -1);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	ifMatch: function(value, regex) {' || chr(13) || chr(10) || '		return (new RegExp(regex)).test(value);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	match: function(value, regex) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be matched with the regular expression.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '		return value.match(new RegExp(regex));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	checkURL: function(value) {' || chr(13) || chr(10) || '		if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must be a non-empty string.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, ''^(http|https):\/\/.+'')) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must contain a schema.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.endsWith(''/'') ? value.slice(0, -1) : value;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	check: function(key, rule, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(rule.type)) {' || chr(13) || chr(10) || '			throw ''Mandatory attribute "type" has not been defined for parameter "'' + key + ''".'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(params[key])) {' || chr(13) || chr(10) || '			throw ''Checked parameter "'' + key + ''" was not found in the list of input parameters.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		var value = params[key],' || chr(13) || chr(10) || '			error_message = null;' || chr(13) || chr(10) || '		switch (rule.type) {' || chr(13) || chr(10) || '			case ''string'':' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" must be a string.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a non-empty string'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '')||
TO_NCLOB('				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a string with a length > '' + rule.len;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must match the regular expression "'' + rule.regex + ''"'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.url) && rule.url === true) {' || chr(13) || chr(10) || '					value = CParamValidator.checkURL(value);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''integer'':' || chr(13) || chr(10) || '				if (!CParamValidator.isInteger(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an integer'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseInt(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''float'':' || chr(13) || chr(10) || '				if (!CParamValidator.isFloat(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a floating-point number'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseFloat(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''boolean'':' || chr(13) || chr(10) || '				if (CParamValidator.inArray(value, [''1'', ''true'', ''yes'', ''on''])) {' || chr(13) || chr(10) || '					value = true;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (CParamValidator.inArray(value, [''0'', ''false'', ''no'', ''off''])) {' || chr(13) || chr(10) || '					value = false;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a boolean-like.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''array'':' || chr(13) || chr(10) || '				try {' || chr(13) || chr(10) || '					value = JSON.parse(value);' || chr(13) || chr(10) || '				} catch (error) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" contains invalid JSON.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''array'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an array.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {' || chr(13) || chr(10) || '					value = value.reduce(function(acc, obj) {' || chr(13) || chr(10) || '						acc[obj.tag] = obj.value || null;' || chr(13) || chr(10) || '						return acc;' || chr(13) || chr(10) || '					}, {});' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''object'':' || chr(13) || chr(10) || '				value = JSON.parse(value);' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''object'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an object.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			default:' || chr(13) || chr(10) || '				throw ''Unexpected attribute type "'' + rule.type + ''" for value "'' + key + ''". Available: '' +' || chr(13) || chr(10) || '				[''integer'', ''float'', ''string'', ''boolean'', ''array'', ''object''].join('', '');' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		params[key] = value;' || chr(13) || chr(10) || '		if (CParamValidator.inArray(rule.type, [''integer'', ''float'']) && error_message === null && (CParamValidator.isDefined(rule.min)' || chr(13) || chr(10) || '			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			error_message = ''Value "'' + key + ''" must be a number '' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))' || chr(13) || chr(10) || '				? (rule.min + ''..'' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? ''>'' + rule.min : ''<'' + rule.max));' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be in the array '' + JSON.stringify(rule.array);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {' || chr(13) || chr(10) || '			error_message = ''The macro '' + ((CParamValidator.isDefined(rule.macro)) ? ''{'' + rule.macro + ''} '' : '' '') + ''is not set'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (error_message !== null) {' || chr(13) || chr(10) || '			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {' || chr(13) || chr(10) || '				params[key] = rule.default;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				Zabbix.log(4, ''Default value for "'' + key + ''" must be a '' + rule.type + ''. Skipped.'');' || chr(13) || chr(10) || '				throw ''Incorrect value for variable "'' + key + ''". '' + error_message;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return this;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	validate: function(rules, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(params, ''object'') || CParamValidator.isType(params, ''array'')) {' || chr(13) || chr(10) || '			throw ''Incorrect parameters value. The value must be an object.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		for (var key in rules) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			CParamValidator.check(key, rules[key], params);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CHttpRequest = function(logger) {' || chr(13) || chr(10) || '	this.request = new HttpRequest();' || chr(13) || chr(10) || '	if (typeof logger !== ''object'' || logger === null) {' || chr(13) || chr(10) || '		this.logger = Zabbix;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		this.logger = logger;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.clearHeader = function() {' || chr(13) || chr(10) || '		this.request.clearHeader();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.addHeaders = function(value) {' || chr(13) || chr(10) || '		var headers = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (typeof value === ''object'' && value !== null) {' || chr(13) || chr(10) || '			if (!Array.isArray(value)) {' || chr(13) || chr(10) || '				Object.keys(value).forEach(function(key) {' || chr(13) || chr(10) || '					headers.push(key + '': '' + value[key]);' || chr(13) || chr(10) || '				});' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				headers = value;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (typeof value === ''string'') {' || chr(13) || chr(10) || '			value.split(''\r\n'').forEach(function(header) {' || chr(13) || chr(10) || '				headers.push(header);' || chr(13) || chr(10) || '			});' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		for (var idx in headers) {' || chr(13) || chr(10) || '			this.request.addHeader(headers[idx]);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.setProxy = function(proxy) {' || chr(13) || chr(10) || '		this.request.setProxy(proxy);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '	this.plainRequest = function(method, url, data) {' || chr(13) || chr(10) || '		var resp = null;' || chr(13) || chr(10) || '		method = method.toLowerCase();' || chr(13) || chr(10) || '		this.logger.log(4, ''Sending '' + method + '' request:'' + JSON.stringify(data));' || chr(13) || chr(10) || '		if ([''get'', ''post'', ''put'', ''patch'', ''delete'', ''trace''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url, data);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if ([''connect'', ''head'', ''options''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unexpected method. Method '' + method + '' is not supported.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.logger.log(4, ''Response has been received: '' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.jsonRequest = function(method, url, data) {' || chr(13) || chr(10) || '		this.addHeaders(''Content-Type: application/json'');' || chr(13) || chr(10) || '		var resp = this.plainRequest(method, url, JSON.stringify(data));' || chr(13) || chr(10) || '		try {' || chr(13) || chr(10) || '			resp = JSON.parse(resp);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		catch (error) {' || chr(13) || chr(10) || '			throw ''Failed to parse response: not well-formed JSON was received'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.getStatus = function() {' || chr(13) || chr(10) || '		return this.request.getStatus();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('var serviceLogName = ''Telegram Webhook'',' || chr(13) || chr(10) || '	Logger = new CLogger(serviceLogName),' || chr(13) || chr(10) || '	Telegram = CWebhook;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function escapeMarkup(str, mode) {' || chr(13) || chr(10) || '	switch (mode) {' || chr(13) || chr(10) || '		case ''markdown'':' || chr(13) || chr(10) || '			return str.replace(/([_*\[`])/g, ''\\$&'');' || chr(13) || chr(10) || '		case ''markdownv2'':' || chr(13) || chr(10) || '			return str.replace(/([_*\[\]()~`>#+\-=|{}.!])/g, ''\\$&'');' || chr(13) || chr(10) || '		case ''html'':' || chr(13) || chr(10) || '			return str.replace(/<(\s|[^a-z\/])/g, ''&lt;$1'');' || chr(13) || chr(10) || '		default:' || chr(13) || chr(10) || '			return str;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Telegram.prototype.getMessageID = function (chat_id, message_thread_id) {' || chr(13) || chr(10) || '	const tag_key = ''__telegram_msg_id_'' + chat_id + (message_thread_id ? ''_'' + message_thread_id : '''');' || chr(13) || chr(10) || '	if (CParamValidator.isDefined(this.params.event_tags[tag_key])) {' || chr(13) || chr(10) || '		return this.params.event_tags[tag_key];' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	return null;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Telegram.prototype.onCheckParams = function () {' || chr(13) || chr(10) || '	CParamValidator.validate(' || chr(13) || chr(10) || '		{' || chr(13) || chr(10) || '			api_token: {type: ''string''},' || chr(13) || chr(10) || '			api_chat_id: {type: ''string''},' || chr(13) || chr(10) || '			alert_message: {type: ''string''}' || chr(13) || chr(10) || '		},' || chr(13) || chr(10) || '		this.params' || chr(13) || chr(10) || '	);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (CParamValidator.inArray(this.params.event_source, [''0'', ''3'', ''4''])) {' || chr(13) || chr(10) || '		CParamValidator.validate({' || chr(13) || chr(10) || '')||
TO_NCLOB('			event_tags: {type: ''array'', macro: ''EVENT.TAGSJSON'', tags: true, default: {}}' || chr(13) || chr(10) || '		}, this.params);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.params.url = ''https://api.telegram.org/bot'';' || chr(13) || chr(10) || '	this.data = {' || chr(13) || chr(10) || '		disable_web_page_preview: true,' || chr(13) || chr(10) || '		disable_notification: false' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '	const match = this.params.api_chat_id.match(/^(-?\d+|@[a-zA-Z0-9_]+)(?::(\d+))?$/);' || chr(13) || chr(10) || '	if (!match) {' || chr(13) || chr(10) || '		throw ''Invalid format for api_chat_id: "'' + this.params.api_chat_id + ''". Must be a numeric group ID or @GroupName, optionally followed by :message_thread_id.'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	this.data[''chat_id''] = match[1];' || chr(13) || chr(10) || '	if (CParamValidator.isDefined(match[2])) {' || chr(13) || chr(10) || '		this.data[''message_thread_id''] = match[2];' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	this.data[''text''] = ((this.params.alert_subject !== '''') ? this.params.alert_subject + ''\n'' : '''') + this.params.alert_message;' || chr(13) || chr(10) || '	if ([''markdown'', ''html'', ''markdownv2''].indexOf(this.params.api_parse_mode.toLowerCase()) !== -1) {' || chr(13) || chr(10) || '		this.data[''parse_mode''] = this.params.api_parse_mode.toLowerCase();' || chr(13) || chr(10) || '		this.data[''text''] = escapeMarkup(this.data[''text''], this.data[''parse_mode'']);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	const reply_to_message_id = this.getMessageID(this.data[''chat_id''], this.data[''message_thread_id'']);' || chr(13) || chr(10) || '	if (reply_to_message_id !== null) {' || chr(13) || chr(10) || '		this.data[''reply_to_message_id''] = reply_to_message_id;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	this.result = {tags: {}};' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('Telegram.prototype.onEvent = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''URL: '' + this.params.url.replace(this.params.api_token, ''<TOKEN>''));' || chr(13) || chr(10) || '	var response = this.request.jsonRequest(''POST'', this.params.url + this.params.api_token + ''/sendMessage'', this.data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.request.getStatus() !== 200 || !CParamValidator.isType(response.ok, ''boolean'') || response.ok !== true) {' || chr(13) || chr(10) || '		Logger.log(Logger.INFO, ''HTTP code: '' + this.request.getStatus());' || chr(13) || chr(10) || '		if (CParamValidator.isType(response.description, ''string'')) {' || chr(13) || chr(10) || '			throw response.description;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unknown error. Check debug log for more information.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (CParamValidator.isDefined(response.result.message_id) && this.getMessageID(this.data[''chat_id''], this.data[''message_thread_id'']) === null) {' || chr(13) || chr(10) || '		this.result.tags[''__telegram_msg_id_'' + this.data[''chat_id''] + (this.data[''message_thread_id''] ? ''_'' + this.data[''message_thread_id''] : '''')] = response.result.message_id;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '	var hook = new Telegram(value);' || chr(13) || chr(10) || '	hook.request = new CHttpRequest(Logger);' || chr(13) || chr(10) || '	return hook.run();' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '	Logger.log(Logger.WARN, ''notification failed: '' + error);' || chr(13) || chr(10) || '')||
TO_NCLOB('	throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','0','','',TO_NCLOB('This media type integrates your Zabbix installation with Telegram using the Zabbix webhook feature.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Telegram configuration:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Register a new Telegram bot: send "/newbot" to "@BotFather" and follow the instructions. The token provided by "@BotFather" in the final step will be needed for configuring the Zabbix webhook.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set up personal or group notifications:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2.1 Personal notifications:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2.1.1 Retrieve the chat ID of the user the bot should send messages to. The user should send "/getid" to "@myidbot" in the Telegram messenger.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2.1.2 The user should also send "/start" to the bot created in step 1. If you skip this step, the Telegram bot won''t be able to send messages to the user (bots cannot initiate conversations with users).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2.2 Group notifications:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2.2.1 Retrieve the group ID of the group that the bot should send messages to. Add "@myidbot" and the bot created in step 1 to your group.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2.2.2 In the group chat, send: "/getgroupid@myidbot".' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2.2.3 If the bot is added to a supergroup and you want the bot to send messages to a specific topic instead of the default "General" channel, right-click any message in that topic and click "Copy Message Link". The copied link will have the following format: "https://t.me/c/<short_group_id>/<topic_id>/<message_id>", for example: "https://t.me/c/1234567890/2/1". In this example, the topic ID is "2".' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Note:' || chr(13) || chr(10) || '')||
TO_NCLOB('- The group ID is a negative number, for example: "-1234567890".' || chr(13) || chr(10) || '- The supergroup ID is a negative number prefixed with "-100", for example: "-1001234567890"' || chr(13) || chr(10) || '- The public group or supergroup ID can also be specified in media type properties as a name prefixed by "@", for example: "@MyGroupName".' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. Depending on where you want to send notifications, copy and save the bot token, personal chat ID or group ID, and topic ID (if you want to send messages to a specific supergroup topic), as you will need these later to set up the media type in Zabbix.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Zabbix configuration:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Set the following webhook parameters:' || chr(13) || chr(10) || '- "api_parse_mode" - the formatting mode applied for messages (possible values: "markdown", "html", "markdownv2")' || chr(13) || chr(10) || '- "api_token" - the token of the bot used to send messages' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Learn more about message formatting options in Telegram Bot API documentation:' || chr(13) || chr(10) || '- Markdown: https://core.telegram.org/bots/api#markdown-style' || chr(13) || chr(10) || '- HTML: https://core.telegram.org/bots/api#html-style' || chr(13) || chr(10) || '- MarkdownV2: https://core.telegram.org/bots/api#markdownv2-style' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Note: Your Telegram-related actions should be separated from other notification types (e.g., SMS); otherwise, if you use Markdown or HTML in the alert subject or body, you may receive plain-text alerts with raw tags.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Click the "Enabled" checkbox to enable the media type and click the "Update" button to save the webhook settings.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. Create a Zabbix user and add media:' || chr(13) || chr(10) || '')||
TO_NCLOB('- To create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks).' || chr(13) || chr(10) || '- Make sure this user has access to all hosts for which you would like problem notifications to be sent to Telegram.' || chr(13) || chr(10) || '- In the "Media" tab, click "Add" and select the type "Telegram" from the drop-down list.' || chr(13) || chr(10) || '- In the "Send to" field, specify the Telegram user chat ID or group ID that you retrieved during Telegram setup. To send notifications to a specific topic within a supergroup, specify the topic ID after the semicolon delimiter in the format "<group_id>:<topic_id>", for example: "-1001234567890:2", "@MyGroupName:2".' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '4. Done! You can now start using this media type in actions and create tickets.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can find the latest version of this media and additional information in the official Zabbix repository:' || chr(13) || chr(10) || '')||
TO_NCLOB('https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/telegram'),'0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('66','4','TOPdesk','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Media = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '    name: '''',' || chr(13) || chr(10) || '    labels: [],' || chr(13) || chr(10) || '    HTTPProxy: '''',' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Media.params = params;' || chr(13) || chr(10) || '        Media.params.api += Media.params.api.endsWith(''/'') ? '''' : ''/'';' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        if (typeof HTTPProxy !== ''undefined'' && HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            Media.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''api'', ''token''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Media.params !== ''object'' || typeof Media.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || Media.params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required '' + Media.name + '' param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Media.params.api + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Accept: application/json'');' || chr(13) || chr(10) || '')||
TO_NCLOB('        request.addHeader(''Authorization: '' + Media.params.token);' || chr(13) || chr(10) || '        request.setProxy(Media.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Failed to parse response.'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null) {' || chr(13) || chr(10) || '                if (typeof response.errors === ''object'' && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                    message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                else if (typeof response.errorMessages === ''object'' && Object.keys(response.errorMessages).length > 0) {' || chr(13) || chr(10) || '                    message += '': '' + JSON.stringify(response.errorMessages);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                else if (typeof response.message === ''string'') {' || chr(13) || chr(10) || '                    message += '': '' + response.message;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var result = {tags: {}},' || chr(13) || chr(10) || '')||
TO_NCLOB('        params = JSON.parse(value),' || chr(13) || chr(10) || '        media = {},' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        resp = {},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'',' || chr(13) || chr(10) || '            ''alert_message'',' || chr(13) || chr(10) || '            ''event_id'',' || chr(13) || chr(10) || '            ''event_source'',' || chr(13) || chr(10) || '            ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'',' || chr(13) || chr(10) || '            ''topdesk_api'',' || chr(13) || chr(10) || '            ''topdesk_user'',' || chr(13) || chr(10) || '            ''topdesk_password''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            ''not_classified'',' || chr(13) || chr(10) || '            ''information'',' || chr(13) || chr(10) || '            ''warning'',' || chr(13) || chr(10) || '            ''average'',' || chr(13) || chr(10) || '            ''high'',' || chr(13) || chr(10) || '            ''disaster'',' || chr(13) || chr(10) || '            ''resolved'',' || chr(13) || chr(10) || '            ''default''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            if (key.startsWith(''topdesk_'')) {' || chr(13) || chr(10) || '                media[key.substring(8)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Possible values of event_source:' || chr(13) || chr(10) || '')||
TO_NCLOB('    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_value for trigger-based and internal events.' || chr(13) || chr(10) || '    // Possible values: 1 for problem, 0 for recovering' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_update_status only for trigger-based events.' || chr(13) || chr(10) || '    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_id for a numeric value.' || chr(13) || chr(10) || '    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_id" parameter given: '' + params.event_id + ''\nMust be a positive number.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ((params.event_source === ''1'' || params.event_source === ''2'')  && params.event_value === ''0'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Recovery operations are supported only for Trigger and Internal actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity]];' || chr(13) || chr(10) || '    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(''/'') ? '''' : ''/'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Media.name = ''TOPdesk'';' || chr(13) || chr(10) || '    Media.setParams(media);' || chr(13) || chr(10) || '    Media.params.token = ''Basic '' + btoa(Media.params.user + '':'' + Media.params.password);' || chr(13) || chr(10) || '    Media.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create an issue.' || chr(13) || chr(10) || '    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).' || chr(13) || chr(10) || '    // Numeric value of the problem update status. Possible values:' || chr(13) || chr(10) || '    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)' || chr(13) || chr(10) || '            || (params.event_source == 3 && params.event_value == 1)' || chr(13) || chr(10) || '            || params.event_source == 1 || params.event_source == 2) {' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Request of the ticket creating.'');' || chr(13) || chr(10) || '')||
TO_NCLOB('        fields.caller = {dynamicName: ''Zabbix''};' || chr(13) || chr(10) || '        fields.briefDescription = params.alert_subject;' || chr(13) || chr(10) || '        fields.request = params.alert_message.replace(/\n/g, ''<br>'');' || chr(13) || chr(10) || '        fields.priority = {name: priority};' || chr(13) || chr(10) || '        fields.processingStatus = {name: Media.params.status};' || chr(13) || chr(10) || '        fields.externalNumber = params.event_id;' || chr(13) || chr(10) || '        fields.request += ''<br>'' + params.zbxurl;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_source === ''0'') {' || chr(13) || chr(10) || '            fields.request += ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = Media.request(''post'', ''tas/api/incidents'', fields);' || chr(13) || chr(10) || '        if (typeof resp.response !== ''object'' || typeof resp.response.id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create '' + Media.name + '' issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {' || chr(13) || chr(10) || '            result.tags.__zbx_tpd_issuekey = resp.response.number;' || chr(13) || chr(10) || '            result.tags.__zbx_tpd_issuelink = Media.params.api +' || chr(13) || chr(10) || '                ''tas/secure/incident?action=show&unid='' + resp.response.id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update a created issue.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        if (params.event_source == 3 && params.event_value == 0) {' || chr(13) || chr(10) || '            throw ''Internal event recovery actions are not supported.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Request of the ticket updating.'');' || chr(13) || chr(10) || '        fields.action = params.alert_message.replace(/\n/g, ''<br>'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = Media.request(''put'', ''tas/api/incidents/number/'' + Media.params.issue_key, fields);' || chr(13) || chr(10) || '        if (typeof resp.response !== ''object'' || typeof resp.response.id === ''undefined''' || chr(13) || chr(10) || '                || resp.response.number !== Media.params.issue_key) {' || chr(13) || chr(10) || '            throw ''Cannot update '' + Media.name + '' issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ '' + Media.name + '' Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_tpd_issuelink}','TOPdesk: {EVENT.TAGS.__zbx_tpd_issuekey}','Please refer to https://developers.topdesk.com/documentation/index.html and https://www.zabbix.com/documentation/7.0/manual/config/notifications/media/webhook#example_scripts.' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || 'Set global macro {$ZABBIX.URL} with your Zabbix server URL.' || chr(13) || chr(10) || 'Add a dedicated user with the media type "TOPdesk".' || chr(13) || chr(10) || 'Change the values of the variables topdesk_api (URL), topdesk_password, topdesk_user. The topdesk_status is the default status for creating a new TOPdesk ticket.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('67','4','VictorOps','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var VictorOps = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        VictorOps.params = params;' || chr(13) || chr(10) || '        if (VictorOps.params.endpoint) {' || chr(13) || chr(10) || '            if (!VictorOps.params.endpoint.endsWith(''/'')) {' || chr(13) || chr(10) || '                VictorOps.params.endpoint += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (typeof VictorOps.params.routing_key !== ''undefined''' || chr(13) || chr(10) || '                    && VictorOps.params.routing_key !== ''{ALERT.SENDTO}''' || chr(13) || chr(10) || '                    && VictorOps.params.routing_key !== ''Default'') {' || chr(13) || chr(10) || '                VictorOps.params.endpoint += VictorOps.params.routing_key;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        VictorOps.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addFields: function (fields) {' || chr(13) || chr(10) || '        var data = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof fields === ''object'') {' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    if (fields[field] === '''') {' || chr(13) || chr(10) || '                        Zabbix.log(4, ''[ VictorOps Webhook ] Field "'' + field +' || chr(13) || chr(10) || '')||
TO_NCLOB('                            ''" can\''t be empty. The field ignored.'');' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                    else {' || chr(13) || chr(10) || '                        try {' || chr(13) || chr(10) || '                            var parts = field.split('':''),' || chr(13) || chr(10) || '                                prefix = parts[0].split(''_'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                            if (typeof prefix[1] === ''undefined''' || chr(13) || chr(10) || '                                    || (prefix[1] === ''p'' && params.event_value === ''1''' || chr(13) || chr(10) || '                                        && (params.event_update_status === ''0''' || chr(13) || chr(10) || '                                            || params.event_update_status === ''{EVENT.UPDATE.STATUS}''))' || chr(13) || chr(10) || '                                    || (prefix[1] === ''r'' && params.event_value === ''0''' || chr(13) || chr(10) || '                                        && (params.event_update_status === ''0''' || chr(13) || chr(10) || '                                            || params.event_update_status === ''{EVENT.UPDATE.STATUS}''))' || chr(13) || chr(10) || '                                    || (prefix[1] === ''u'' && params.event_update_status === ''1'')) {' || chr(13) || chr(10) || '                                data[field.substring(field.indexOf('':'') + 1)] = fields[field];' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                        catch (error) {' || chr(13) || chr(10) || '                            Zabbix.log(4, ''[ VictorOps Webhook ] Can\''t parse field "'' + field +' || chr(13) || chr(10) || '                                ''". The field ignored.'');' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (data) {' || chr(13) || chr(10) || '        if (typeof VictorOps.params !== ''object'' || typeof VictorOps.params.endpoint === ''undefined''' || chr(13) || chr(10) || '                || VictorOps.params.endpoint === '''' ) {' || chr(13) || chr(10) || '            throw ''Required parameter is not set: "vops_endpoint".'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = VictorOps.params.endpoint,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof VictorOps.HTTPProxy !== ''undefined'' && VictorOps.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(VictorOps.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ VictorOps Webhook ] Sending request: '' + url +' || chr(13) || chr(10) || '            ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(url, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ VictorOps Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '')||
TO_NCLOB('                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ VictorOps Webhook ] Failed to parse response received from VictorOps'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.messages !== ''undefined'') {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.messages);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        vops = {},' || chr(13) || chr(10) || '        required_params = [''event_source'', ''event_value'', ''priority_update''],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '')||
TO_NCLOB('            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''vops_'')) {' || chr(13) || chr(10) || '                vops[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''field'')) {' || chr(13) || chr(10) || '                fields[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '            && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_update_status === ''1'') {' || chr(13) || chr(10) || '        fields['':message_type''] = params.priority_update;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        fields['':message_type''] = params[''priority_'' + severities[params.event_nseverity].name]' || chr(13) || chr(10) || '            || ''INFO'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_info && params.event_source === ''0'') {' || chr(13) || chr(10) || '        fields['':event_info''] = params.event_info;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    VictorOps.setParams(vops);' || chr(13) || chr(10) || '    VictorOps.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    VictorOps.request(VictorOps.addFields(fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ VictorOps Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('68','4','Zammad','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('const CLogger = function(serviceName) {' || chr(13) || chr(10) || '	this.serviceName = serviceName;' || chr(13) || chr(10) || '	this.INFO = 4' || chr(13) || chr(10) || '	this.WARN = 3' || chr(13) || chr(10) || '	this.ERROR = 2' || chr(13) || chr(10) || '	this.log = function(level, msg) {' || chr(13) || chr(10) || '		Zabbix.log(level, ''['' + this.serviceName + ''] '' + msg);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CWebhook = function(value) {' || chr(13) || chr(10) || '	try {' || chr(13) || chr(10) || '		params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''1'', ''2'', ''3'', ''4''].indexOf(params.event_source) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''.\nMust be 0-4.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1 && [''0'', ''1''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '			throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if ([''0'', ''3'', ''4''].indexOf(params.event_source) !== -1) {' || chr(13) || chr(10) || '			if (params.event_source === ''1'' && [''0'', ''1'', ''2'', ''3''].indexOf(params.event_value) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''.\nMust be 0-3.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if (params.event_source === ''0'' && [''0'', ''1''].indexOf(params.event_update_status) === -1) {' || chr(13) || chr(10) || '				throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''.\nMust be 0 or 1.'';' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '			if (params.event_source === ''4'') {' || chr(13) || chr(10) || '				if ([''0'', ''1'', ''2'', ''3'', ''4'', ''5''].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {' || chr(13) || chr(10) || '					params.event_nseverity = params.event_update_nseverity;' || chr(13) || chr(10) || '					params.event_severity = params.event_update_severity;' || chr(13) || chr(10) || '					params.event_update_status = ''1'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.runCallback = function(name, params) {' || chr(13) || chr(10) || '			if (typeof this[name] === ''function'') {' || chr(13) || chr(10) || '				return this[name].apply(this, [params]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEvent = function(source, event) {' || chr(13) || chr(10) || '			const alert = { source: source, event: event };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''on'' + event, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.handleEventless = function(source) {' || chr(13) || chr(10) || '			const alert = { source: source, event: null };' || chr(13) || chr(10) || '			return [' || chr(13) || chr(10) || '				this.runCallback(''on'' + source, alert),' || chr(13) || chr(10) || '				this.runCallback(''onEvent'', alert)' || chr(13) || chr(10) || '			];' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		this.run = function() {' || chr(13) || chr(10) || '			var results = [];' || chr(13) || chr(10) || '')||
TO_NCLOB('			if (typeof this.httpProxy === ''string'' && this.httpProxy.trim() !== '''') {' || chr(13) || chr(10) || '				this.request.setProxy(this.httpProxy);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			const types = { ''0'': ''Trigger'', ''1'': ''Discovery'', ''2'': ''Autoreg'', ''3'': ''Internal'', ''4'': ''Service'' };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			if ([''0'', ''3'', ''4''].indexOf(this.params.event_source) !== -1) {' || chr(13) || chr(10) || '				var event = (this.params.event_update_status === ''1'')' || chr(13) || chr(10) || '					? ''Update''' || chr(13) || chr(10) || '					: ((this.params.event_value === ''1'') ? ''Problem'' : ''Resolve'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				results = this.handleEvent(types[this.params.event_source], event);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else if (typeof types[this.params.event_source] !== ''undefined'') {' || chr(13) || chr(10) || '				results = this.handleEventless(types[this.params.event_source]);' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				throw ''Unexpected "event_source": '' + this.params.event_source;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '			for (idx in results) {' || chr(13) || chr(10) || '				if (typeof results[idx] !== ''undefined'') {' || chr(13) || chr(10) || '					return JSON.stringify(results[idx]);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.httpProxy = params.http_proxy;' || chr(13) || chr(10) || '		this.params = params;' || chr(13) || chr(10) || '		this.runCallback(''onCheckParams'', {});' || chr(13) || chr(10) || '	} catch (error) {' || chr(13) || chr(10) || '		throw ''Webhook processing failed: '' + error;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CParamValidator = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isType: function(value, type) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (type === ''array'') {' || chr(13) || chr(10) || '			return Array.isArray(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''integer'') {' || chr(13) || chr(10) || '			return CParamValidator.isInteger(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (type === ''float'') {' || chr(13) || chr(10) || '			return CParamValidator.isFloat(value);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (typeof value === type);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isInteger: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseInt(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isFloat: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, /^-?\d+\.\d+$/)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !isNaN(parseFloat(value));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isDefined: function(value) {' || chr(13) || chr(10) || '		return !CParamValidator.isType(value, ''undefined'');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isEmpty: function(value) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be checked for emptiness.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (value.trim() === '''');' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	isMacroSet: function(value, macro) {' || chr(13) || chr(10) || '')||
TO_NCLOB('		if (CParamValidator.isDefined(macro)) {' || chr(13) || chr(10) || '			return !(CParamValidator.ifMatch(value, ''^\{'' + macro + ''\}$''))' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return !(CParamValidator.ifMatch(value, ''^\{[$#]{0,1}[A-Z_\.]+[\:]{0,1}["]{0,1}.*["]{0,1}\}$'') || value === ''*UNKNOWN*'')' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	withinRange: function(value, min, max) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''number'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a number to be checked for range.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (value < ((CParamValidator.isDefined(min)) ? min : value)' || chr(13) || chr(10) || '			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {' || chr(13) || chr(10) || '			return false;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return true;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	inArray: function(value, array) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(array, ''array'')) {' || chr(13) || chr(10) || '			throw ''The array must be an array to check the value for existing in it.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return (array.indexOf((typeof value === ''string'') ? value.toLowerCase() : value) !== -1);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	ifMatch: function(value, regex) {' || chr(13) || chr(10) || '		return (new RegExp(regex)).test(value);' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	match: function(value, regex) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '			throw ''Value "'' + value + ''" must be a string to be matched with the regular expression.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '		return value.match(new RegExp(regex));' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	checkURL: function(value) {' || chr(13) || chr(10) || '		if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must be a non-empty string.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.ifMatch(value, ''^(http|https):\/\/.+'')) {' || chr(13) || chr(10) || '			throw ''URL value "'' + value + ''" must contain a schema.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return value.endsWith(''/'') ? value.slice(0, -1) : value;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	check: function(key, rule, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(rule.type)) {' || chr(13) || chr(10) || '			throw ''Mandatory attribute "type" has not been defined for parameter "'' + key + ''".'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (!CParamValidator.isDefined(params[key])) {' || chr(13) || chr(10) || '			throw ''Checked parameter "'' + key + ''" was not found in the list of input parameters.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		var value = params[key],' || chr(13) || chr(10) || '			error_message = null;' || chr(13) || chr(10) || '		switch (rule.type) {' || chr(13) || chr(10) || '			case ''string'':' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''string'')) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" must be a string.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isEmpty(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a non-empty string'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '')||
TO_NCLOB('				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a string with a length > '' + rule.len;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must match the regular expression "'' + rule.regex + ''"'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.url) && rule.url === true) {' || chr(13) || chr(10) || '					value = CParamValidator.checkURL(value);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''integer'':' || chr(13) || chr(10) || '				if (!CParamValidator.isInteger(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an integer'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseInt(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''float'':' || chr(13) || chr(10) || '				if (!CParamValidator.isFloat(value)) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a floating-point number'';' || chr(13) || chr(10) || '					break;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				value = parseFloat(value);' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''boolean'':' || chr(13) || chr(10) || '				if (CParamValidator.inArray(value, [''1'', ''true'', ''yes'', ''on''])) {' || chr(13) || chr(10) || '					value = true;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else if (CParamValidator.inArray(value, [''0'', ''false'', ''no'', ''off''])) {' || chr(13) || chr(10) || '					value = false;' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				else {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be a boolean-like.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''array'':' || chr(13) || chr(10) || '				try {' || chr(13) || chr(10) || '					value = JSON.parse(value);' || chr(13) || chr(10) || '				} catch (error) {' || chr(13) || chr(10) || '					throw ''Value "'' + key + ''" contains invalid JSON.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''array'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an array.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {' || chr(13) || chr(10) || '					value = value.reduce(function(acc, obj) {' || chr(13) || chr(10) || '						acc[obj.tag] = obj.value || null;' || chr(13) || chr(10) || '						return acc;' || chr(13) || chr(10) || '					}, {});' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			case ''object'':' || chr(13) || chr(10) || '				value = JSON.parse(value);' || chr(13) || chr(10) || '				if (!CParamValidator.isType(value, ''object'')) {' || chr(13) || chr(10) || '					error_message = ''Value "'' + key + ''" must be an object.'';' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '				break;' || chr(13) || chr(10) || '			default:' || chr(13) || chr(10) || '				throw ''Unexpected attribute type "'' + rule.type + ''" for value "'' + key + ''". Available: '' +' || chr(13) || chr(10) || '				[''integer'', ''float'', ''string'', ''boolean'', ''array'', ''object''].join('', '');' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		params[key] = value;' || chr(13) || chr(10) || '		if (CParamValidator.inArray(rule.type, [''integer'', ''float'']) && error_message === null && (CParamValidator.isDefined(rule.min)' || chr(13) || chr(10) || '			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			error_message = ''Value "'' + key + ''" must be a number '' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))' || chr(13) || chr(10) || '				? (rule.min + ''..'' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? ''>'' + rule.min : ''<'' + rule.max));' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {' || chr(13) || chr(10) || '			error_message = ''Value "'' + key + ''" must be in the array '' + JSON.stringify(rule.array);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {' || chr(13) || chr(10) || '			error_message = ''The macro '' + ((CParamValidator.isDefined(rule.macro)) ? ''{'' + rule.macro + ''} '' : '' '') + ''is not set'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		if (error_message !== null) {' || chr(13) || chr(10) || '			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {' || chr(13) || chr(10) || '				params[key] = rule.default;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				Zabbix.log(4, ''Default value for "'' + key + ''" must be a '' + rule.type + ''. Skipped.'');' || chr(13) || chr(10) || '				throw ''Incorrect value for variable "'' + key + ''". '' + error_message;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return this;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	validate: function(rules, params) {' || chr(13) || chr(10) || '		if (!CParamValidator.isType(params, ''object'') || CParamValidator.isType(params, ''array'')) {' || chr(13) || chr(10) || '			throw ''Incorrect parameters value. The value must be an object.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		for (var key in rules) {' || chr(13) || chr(10) || '')||
TO_NCLOB('			CParamValidator.check(key, rules[key], params);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'const CHttpRequest = function(logger) {' || chr(13) || chr(10) || '	this.request = new HttpRequest();' || chr(13) || chr(10) || '	if (typeof logger !== ''object'' || logger === null) {' || chr(13) || chr(10) || '		this.logger = Zabbix;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		this.logger = logger;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.clearHeader = function() {' || chr(13) || chr(10) || '		this.request.clearHeader();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.addHeaders = function(value) {' || chr(13) || chr(10) || '		var headers = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (typeof value === ''object'' && value !== null) {' || chr(13) || chr(10) || '			if (!Array.isArray(value)) {' || chr(13) || chr(10) || '				Object.keys(value).forEach(function(key) {' || chr(13) || chr(10) || '					headers.push(key + '': '' + value[key]);' || chr(13) || chr(10) || '				});' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '			else {' || chr(13) || chr(10) || '				headers = value;' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if (typeof value === ''string'') {' || chr(13) || chr(10) || '			value.split(''\r\n'').forEach(function(header) {' || chr(13) || chr(10) || '				headers.push(header);' || chr(13) || chr(10) || '			});' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		for (var idx in headers) {' || chr(13) || chr(10) || '			this.request.addHeader(headers[idx]);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.setProxy = function(proxy) {' || chr(13) || chr(10) || '		this.request.setProxy(proxy);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '	this.plainRequest = function(method, url, data) {' || chr(13) || chr(10) || '		var resp = null;' || chr(13) || chr(10) || '		method = method.toLowerCase();' || chr(13) || chr(10) || '		this.logger.log(4, ''Sending '' + method + '' request:'' + JSON.stringify(data));' || chr(13) || chr(10) || '		if ([''get'', ''post'', ''put'', ''patch'', ''delete'', ''trace''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url, data);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else if ([''connect'', ''head'', ''options''].indexOf(method) !== -1) {' || chr(13) || chr(10) || '			resp = this.request[method](url);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		else {' || chr(13) || chr(10) || '			throw ''Unexpected method. Method '' + method + '' is not supported.'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		this.logger.log(4, ''Response has been received: '' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.jsonRequest = function(method, url, data) {' || chr(13) || chr(10) || '		this.addHeaders(''Content-Type: application/json'');' || chr(13) || chr(10) || '		var resp = this.plainRequest(method, url, JSON.stringify(data));' || chr(13) || chr(10) || '		try {' || chr(13) || chr(10) || '			resp = JSON.parse(resp);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		catch (error) {' || chr(13) || chr(10) || '			throw ''Failed to parse response: not well-formed JSON was received'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return resp;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.getStatus = function() {' || chr(13) || chr(10) || '		return this.request.getStatus();' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('const CWebhookHelper = {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {' || chr(13) || chr(10) || '		if (event_source === ''0'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/tr_events.php?triggerid='' + trigger_id + ''&eventid='' + event_id;' || chr(13) || chr(10) || '		} else if (event_source === ''4'') {' || chr(13) || chr(10) || '			return zabbix_url + ''/zabbix.php?action=service.list'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		return zabbix_url;' || chr(13) || chr(10) || '	},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var ZABBIX_SEVERITY_MAP = ["not_classified", "information", "warning", "average", "high", "disaster"],' || chr(13) || chr(10) || '	serviceLogName = ''Zammad Webhook'',' || chr(13) || chr(10) || '	Logger = new CLogger(serviceLogName),' || chr(13) || chr(10) || '	Zammad = CWebhook;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Zammad.prototype.onCheckParams = function () {' || chr(13) || chr(10) || '	CParamValidator.validate({' || chr(13) || chr(10) || '		alert_message: {type: ''string''},' || chr(13) || chr(10) || '		alert_subject: {type: ''string''},' || chr(13) || chr(10) || '		zammad_url: {type: ''string'', url: true},' || chr(13) || chr(10) || '		zammad_customer: {type: ''string''},' || chr(13) || chr(10) || '		zammad_access_token: {type: ''string''},' || chr(13) || chr(10) || '		zammad_group: {type: ''string''},' || chr(13) || chr(10) || '		zammad_enable_tags: {type: ''boolean'', default: false},' || chr(13) || chr(10) || '		event_nseverity: {type: ''integer'', default: -1},' || chr(13) || chr(10) || '		zabbix_url: {type: ''string'', url: true}' || chr(13) || chr(10) || '	}, this.params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (CParamValidator.inArray(this.params.event_source, [''0'', ''3'', ''4''])) {' || chr(13) || chr(10) || '		CParamValidator.validate({' || chr(13) || chr(10) || '')||
TO_NCLOB('			event_tags: {type: ''array'', macro: ''EVENT.TAGSJSON'', tags: true, default: {}}' || chr(13) || chr(10) || '		}, this.params);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	var priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.event_nseverity >= 0 && this.params.event_nseverity < ZABBIX_SEVERITY_MAP.length) {' || chr(13) || chr(10) || '		priority = this.params[''severity_'' + ZABBIX_SEVERITY_MAP[this.params.event_nseverity]];' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	this.priority = (CParamValidator.isDefined(priority)) ? priority.trim() : null;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.result = {tags: {}};' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Zammad.prototype.onProblem = function (alert) {' || chr(13) || chr(10) || '	if (CParamValidator.isDefined(this.params.event_tags[''__zbx_zammad_ticket_id''])) {' || chr(13) || chr(10) || '		return this.onUpdate(alert);' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.request.addHeaders(''Authorization: Token token='' + this.params.zammad_access_token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	var payload_data = {' || chr(13) || chr(10) || '		title: this.params.alert_subject,' || chr(13) || chr(10) || '		group: this.params.zammad_group,' || chr(13) || chr(10) || '		article: {' || chr(13) || chr(10) || '			subject: this.params.alert_subject,' || chr(13) || chr(10) || '			body: this.params.alert_message + ''\n'' + CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id),' || chr(13) || chr(10) || '			type: ''note'',' || chr(13) || chr(10) || '			internal: false' || chr(13) || chr(10) || '		},' || chr(13) || chr(10) || '')||
TO_NCLOB('		customer: this.params.zammad_customer' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.priority) {' || chr(13) || chr(10) || '		payload_data.priority_id = this.priority;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	const response = this.request.jsonRequest(''POST'', this.params.zammad_url + ''/api/v1/tickets'', payload_data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.request.getStatus() != 201 || !CParamValidator.isDefined(response.id)) {' || chr(13) || chr(10) || '		var message = ''Cannot create Zammad ticket. Request failed with status code '' + this.request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (CParamValidator.isDefined(response.error) && Object.keys(response.error).length > 0) {' || chr(13) || chr(10) || '			message += '': '' + response.error;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.result.tags = {' || chr(13) || chr(10) || '		__zbx_zammad_ticket_id: response.id,' || chr(13) || chr(10) || '		__zbx_zammad_ticketlink: this.params.zammad_url + ''/#ticket/zoom/'' + response.id' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.params.zammad_enable_tags && Object.keys(this.params.event_tags).length > 0 && CParamValidator.inArray(this.params.event_source, [''0'', ''3'', ''4''])) {' || chr(13) || chr(10) || '		this.request.clearHeader();' || chr(13) || chr(10) || '		this.request.addHeaders({' || chr(13) || chr(10) || '			"Content-Type": "application/json",' || chr(13) || chr(10) || '			"Authorization": "Token token=" + this.params.zammad_access_token' || chr(13) || chr(10) || '		});' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		payload_data = {' || chr(13) || chr(10) || '			item: '''',' || chr(13) || chr(10) || '')||
TO_NCLOB('			object: ''Ticket'',' || chr(13) || chr(10) || '			o_id: response.id' || chr(13) || chr(10) || '		};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		try {' || chr(13) || chr(10) || '			for (var tag in this.params.event_tags) {' || chr(13) || chr(10) || '				payload_data.item = tag;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				if (this.params.event_tags[tag]) {' || chr(13) || chr(10) || '					payload_data.item += ": " + this.params.event_tags[tag];' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				this.request.plainRequest(''POST'', this.params.zammad_url + ''/api/v1/tags/add'', JSON.stringify(payload_data));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '				if (this.request.getStatus() != 201) {' || chr(13) || chr(10) || '					Logger.log(Logger.INFO, ''Failed to set tag: '' + tag);' || chr(13) || chr(10) || '				}' || chr(13) || chr(10) || '			}' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '		catch (error) {' || chr(13) || chr(10) || '			Logger.log(Logger.INFO, ''Failed to add ticket tags: '' + error);' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Zammad.prototype.onUpdate = function (alert) {' || chr(13) || chr(10) || '	Logger.log(Logger.INFO, ''Source: '' + alert.source + ''; Event: '' + alert.event);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (!CParamValidator.isDefined(this.params.event_tags[''__zbx_zammad_ticket_id''])) {' || chr(13) || chr(10) || '		throw "Failed to update the existing ticket: no ticket ID was received."' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	this.request.addHeaders(''Authorization: Token token='' + this.params.zammad_access_token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	const payload_data = {' || chr(13) || chr(10) || '')||
TO_NCLOB('		ticket_id: this.params.event_tags[''__zbx_zammad_ticket_id''],' || chr(13) || chr(10) || '		subject: this.params.alert_subject,' || chr(13) || chr(10) || '		body: this.params.alert_message,' || chr(13) || chr(10) || '		type: ''note'',' || chr(13) || chr(10) || '		internal: false' || chr(13) || chr(10) || '	};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	const response = this.request.jsonRequest(''POST'', this.params.zammad_url + ''/api/v1/ticket_articles'', payload_data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (this.request.getStatus() != 201 || !CParamValidator.isDefined(response.id)) {' || chr(13) || chr(10) || '		var message = ''Cannot update Zammad ticket. Request failed with status code '' + this.request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		if (CParamValidator.isDefined(response.error) && Object.keys(response.error).length > 0) {' || chr(13) || chr(10) || '			message += '': '' + response.error;' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	return this.result;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Zammad.prototype.onResolve = function (alert) {' || chr(13) || chr(10) || '	return this.onUpdate(alert);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Zammad.prototype.onDiscovery = function (alert) {' || chr(13) || chr(10) || '	return this.onProblem(alert);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Zammad.prototype.onAutoreg = function (alert) {' || chr(13) || chr(10) || '	return this.onProblem(alert);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '	var hook = new Zammad(value);' || chr(13) || chr(10) || '	hook.request = new CHttpRequest(Logger);' || chr(13) || chr(10) || '	return hook.run();' || chr(13) || chr(10) || '')||
TO_NCLOB('}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '	Logger.log(Logger.WARN, ''notification failed: '' + error);' || chr(13) || chr(10) || '	throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_zammad_ticketlink}','Zammad: Ticket #{EVENT.TAGS.__zbx_zammad_ticket_id}',TO_NCLOB('This media type integrates your Zabbix installation with your Zammad installation using the Zabbix webhook feature.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Zammad configuration:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Check that API Token Access is enabled in "Settings" → "System" → "API".' || chr(13) || chr(10) || '2. Open the profile settings of the customer user and create a new Personal User Token.' || chr(13) || chr(10) || '3. Set the "ticket.agent" permission for the token and press Create.' || chr(13) || chr(10) || '4. Copy and save the created token somewhere, as it will be shown only once for security reasons.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Zabbix configuration:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Before you can start using Zammad webhook, set up the global macro "{$ZABBIX.URL}":' || chr(13) || chr(10) || '- In the Zabbix web interface, go to "Administration" → "Macros" section in the dropdown menu in the top left corner.' || chr(13) || chr(10) || '- Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend. The URL should be either an IP address, a fully qualified domain name, or localhost.' || chr(13) || chr(10) || '- Specifying a protocol is mandatory, whereas the port is optional. Depending on the web server configuration you might also need to append "/zabbix" to the end of URL. Good examples:' || chr(13) || chr(10) || '  - http://zabbix.com' || chr(13) || chr(10) || '  - https://zabbix.lan/zabbix' || chr(13) || chr(10) || '  - http://server.zabbix.lan/' || chr(13) || chr(10) || '  - http://localhost' || chr(13) || chr(10) || '  - http://127.0.0.1:8080' || chr(13) || chr(10) || '- Bad examples:' || chr(13) || chr(10) || '  - zabbix.com' || chr(13) || chr(10) || '  - http://zabbix/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the following webhook parameters:' || chr(13) || chr(10) || '')||
TO_NCLOB('- zammad_access_token - the access token that you created during Zammad configuration' || chr(13) || chr(10) || '- zammad_url - the frontend URL of your Zammad installation' || chr(13) || chr(10) || '- zammad_customer - the Zammad user email' || chr(13) || chr(10) || '- zammad_enable_tags - if you want to add the Zabbix event tags to the Zammad tickets that are created, you can set it to one of the following values: "1", "true", "yes", "on" (note, that if the tag support is enabled, each tag is sent via separate HTTP request and created tags will also remain in the Zammad when tickets are closed/deleted)' || chr(13) || chr(10) || '- zammad_group - if needed, you can change the Zammad user group' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. If you want to prioritize issues according to the severity values in Zabbix, you can define mapping parameters (create them as additional webhook parameters):' || chr(13) || chr(10) || '- severity_<name> - the Zammad priority ID (<name> in the parameter name can be one of the following values: "not_classified", "information", "warning", "average", "high", "disaster")' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '4. Create a Zabbix user and add media:' || chr(13) || chr(10) || '- If you want to create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks).' || chr(13) || chr(10) || '- In the "Media" tab, add a new media and select "Zammad" type from the drop-down list. Add any value to the "Send to" field: it is required to be filled, but it is not used.' || chr(13) || chr(10) || '- Make sure this user has access to all hosts for which you would like problem notifications to be sent to Zammad.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '5. Great! You can now start using this media type in actions and create tickets!' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can find the latest version of this media and additional information in the official Zabbix repository:' || chr(13) || chr(10) || '')||
TO_NCLOB('https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/zammad'),'0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('69','4','Zendesk','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Zendesk = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zendesk.params = params;' || chr(13) || chr(10) || '        if (typeof Zendesk.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Zendesk.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Zendesk.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            Zendesk.params.url += ''api/v2/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addCustomFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            var schema = Zendesk.getSchema(),' || chr(13) || chr(10) || '                arr = [],' || chr(13) || chr(10) || '                i,' || chr(13) || chr(10) || '                n;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (schema) {' || chr(13) || chr(10) || '                Object.keys(fields)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        for (i = 0, n = schema.ticket_fields.length; i < n; i++) {' || chr(13) || chr(10) || '                            if (schema.ticket_fields[i].id == field' || chr(13) || chr(10) || '                                && [''text'', ''integer'', ''date''].indexOf(schema.ticket_fields[i].type) !== -1){' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                                switch (schema.ticket_fields[i].type) {' || chr(13) || chr(10) || '                                    case ''integer'':' || chr(13) || chr(10) || '')||
TO_NCLOB('                                        fields[field] = parseInt(fields[field]);' || chr(13) || chr(10) || '                                        break;' || chr(13) || chr(10) || '                                    case ''date'':' || chr(13) || chr(10) || '                                        if (fields[field].match(/^\d{4}[.-]\d{2}[.-]\d{2}$/) !== null) {' || chr(13) || chr(10) || '                                            fields[field] = fields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '                                        }' || chr(13) || chr(10) || '                                        else {' || chr(13) || chr(10) || '                                            fields[field] = '''';' || chr(13) || chr(10) || '                                        }' || chr(13) || chr(10) || '                                        break;' || chr(13) || chr(10) || '                                }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                                arr.push({id: field, value: fields[field]});' || chr(13) || chr(10) || '                                break;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                if (arr.length) {' || chr(13) || chr(10) || '                    data.ticket[''custom_fields''] = arr;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[Zendesk Webhook] Failed to retrieve field schema.'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        [''url'', ''token'', ''type''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Zendesk.params !== ''object'' || typeof Zendesk.params[field] === ''undefined'') {' || chr(13) || chr(10) || '                throw ''Required Zendesk param is not set: '' + field + ''\n'' + Zendesk.params[field];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Zendesk.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Zendesk.HTTPProxy === ''string'' && Zendesk.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Zendesk.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Basic '' + btoa(Zendesk.params.token));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[Zendesk Webhook] Sending request: '' + url + ((typeof data === ''string'') ? ('' '' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[Zendesk Webhook] Received response with status code '' + request.getStatus() + ''. '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[Zendesk Webhook] Failed to parse response received from Zendesk.'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.error !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.error).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.error);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response.description !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.description).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.description);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '')||
TO_NCLOB('                message += ''. '' + response;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getSchema: function() {' || chr(13) || chr(10) || '        var result = Zendesk.request(''get'', ''ticket_fields.json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIssue: function(data, fields) {' || chr(13) || chr(10) || '        var result = Zendesk.request(''post'', ''tickets.json'', Zendesk.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object'' || typeof result.response.ticket.id === ''undefined''' || chr(13) || chr(10) || '            || result.status != 201) {' || chr(13) || chr(10) || '            throw ''Cannot create Zendesk issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.ticket.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateIssue: function(data, fields) {' || chr(13) || chr(10) || '        Zendesk.request(''put'', ''tickets/'' + Zendesk.params.issue_key + ''.json'', Zendesk.addCustomFields(data, fields));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '')||
TO_NCLOB('        zendesk = {},' || chr(13) || chr(10) || '        update = {},' || chr(13) || chr(10) || '        data = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'',' || chr(13) || chr(10) || '            ''alert_message'',' || chr(13) || chr(10) || '            ''event_id'',' || chr(13) || chr(10) || '            ''event_source'',' || chr(13) || chr(10) || '            ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''zendesk_'')) {' || chr(13) || chr(10) || '                zendesk[key.substring(8)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''customfield_'')) {' || chr(13) || chr(10) || '                fields[key.substring(12)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter '' + key + '' cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Possible values: question, incident, problems, task' || chr(13) || chr(10) || '    if ([''question'', ''incident'', ''problem'', ''task''].indexOf(params.zendesk_type) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "zendesk_type" parameter given: '' + params.zendesk_type +' || chr(13) || chr(10) || '            ''\nMust be one of question, incident, problem, task.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Possible values: 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    // Possible values: 1 for problem, 0 for recovering' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '')||
TO_NCLOB('    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Zendesk_issue_key must be a positive integer if an update action is being performed.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && ((params.event_value === ''1'' && params.event_update_status === ''1'')' || chr(13) || chr(10) || '        || (params.event_value === ''0'' && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))' || chr(13) || chr(10) || '        && (isNaN(parseInt(params.zendesk_issue_key)) || parseInt(params.zendesk_issue_key) < 1 )) {' || chr(13) || chr(10) || '        throw ''Incorrect "zendesk_issue_key" parameter given: '' + params.zendesk_issue_key +' || chr(13) || chr(10) || '            ''\nMust be positive integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity].name] || severities[7].name;' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '    Zendesk.setParams(zendesk);' || chr(13) || chr(10) || '    Zendesk.HTTPProxy = params.HTTPProxy;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value !== ''0'') {' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '            ticket: {' || chr(13) || chr(10) || '                external_id: params.event_id,' || chr(13) || chr(10) || '                type: Zendesk.params.type,' || chr(13) || chr(10) || '                status: ''new'',' || chr(13) || chr(10) || '                subject: params.alert_subject,' || chr(13) || chr(10) || '                comment: {' || chr(13) || chr(10) || '                    body: params.alert_message,' || chr(13) || chr(10) || '                    public: ''false''' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                priority: priority,' || chr(13) || chr(10) || '                tags: params.event_tags' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zendesk.createIssue(data, fields);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && update.status === ''0'') {' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '            ticket: {' || chr(13) || chr(10) || '                external_id: params.event_id,' || chr(13) || chr(10) || '                type: Zendesk.params.type,' || chr(13) || chr(10) || '                status: ''new'',' || chr(13) || chr(10) || '                subject: params.alert_subject,' || chr(13) || chr(10) || '                comment: {' || chr(13) || chr(10) || '')||
TO_NCLOB('                    body: params.zbxurl + (params.zbxurl.endsWith(''/'') ? '''' : ''/'') + ''tr_events.php?triggerid='' +' || chr(13) || chr(10) || '                        params.trigger_id + ''&eventid='' + params.event_id + ''\n'' + params.alert_message,' || chr(13) || chr(10) || '                    public: ''false''' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                priority: priority,' || chr(13) || chr(10) || '                tags: params.event_tags' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        var key = Zendesk.createIssue(data, fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_zdk_issuekey = key;' || chr(13) || chr(10) || '        result.tags.__zbx_zdk_issuelink = params.zendesk_url +' || chr(13) || chr(10) || '            (params.zendesk_url.endsWith(''/'') ? '''' : ''/'') + ''agent/tickets/'' + key;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '            ticket: {' || chr(13) || chr(10) || '                type: Zendesk.params.type,' || chr(13) || chr(10) || '                subject: params.alert_subject,' || chr(13) || chr(10) || '                comment: {' || chr(13) || chr(10) || '                    body: params.alert_message,' || chr(13) || chr(10) || '                    public: ''false''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zendesk.updateIssue(data, fields);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[Zendesk Webhook] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_zdk_issuelink}','Zendesk: {EVENT.TAGS.__zbx_zdk_issuekey}','','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('1','38','endpoint','<PLACE HTTP API URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('2','38','flash','false','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('3','38','password','<PLACE PASSWORD>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('4','38','ring','false','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('5','38','send_to','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('6','38','telauto','true','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('7','38','text','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('8','38','username','<PLACE USERNAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('9','39','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('10','39','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('11','39','discord_endpoint','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('12','39','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('13','39','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('14','39','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('15','39','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('16','39','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('17','39','event_update_severity','{EVENT.UPDATE.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('18','39','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('19','39','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('20','39','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('21','39','user_agent','ZabbixServer (zabbix.com, 7.0)','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('22','39','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('23','40','acknowledged','{EVENT.ACK.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('24','40','endpoint','/endpoint','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('25','40','event_date','{EVENT.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('26','40','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('27','40','event_name','{EVENT.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('28','40','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('29','40','event_object','{EVENT.OBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('30','40','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('31','40','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('32','40','event_tags','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('33','40','event_time','{EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('34','40','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('35','40','host_groups','{TRIGGER.HOSTGROUP.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('36','40','host_host','{HOST.HOST}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('37','40','host_id','{HOST.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('38','40','host_ip','{HOST.IP}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('39','40','host_port','{HOST.PORT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('40','40','HTTPProxy','','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('41','40','monitoring_source','Zabbix sever','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('42','40','operation_data','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('43','40','send_to','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('44','40','subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('45','40','trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('46','40','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('47','40','trigger_name','{TRIGGER.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('48','41','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('49','41','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('50','41','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('51','41','express_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('52','41','express_send_to','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('53','41','express_tags','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('54','41','express_token','<PLACE BOT TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('55','41','express_url','<PLACE INSTANCE URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('56','42','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('57','42','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('58','42','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('59','42','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('60','42','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('61','42','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('62','42','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('63','42','event_update_severity','{EVENT.UPDATE.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('64','42','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('65','42','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('66','42','github_api_version','2022-11-28','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('67','42','github_issue_number','{EVENT.TAGS.__zbx_github_issue_number}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('68','42','github_repo','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('69','42','github_token','<PLACE GITHUB TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('70','42','github_url','https://api.github.com','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('71','42','github_user_agent','Zabbix/7.0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('72','42','github_zabbix_event_priority_label_prefix','Zabbix Event Priority:','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('73','42','github_zabbix_event_source_label_prefix','Zabbix Event Source:','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('74','42','github_zabbix_event_status_label_prefix','Zabbix Event Status:','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('75','42','github_zabbix_generic_label','Zabbix GitHub Webhook','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('76','42','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('77','42','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('78','43','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('79','43','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('80','43','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('81','43','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('82','43','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('83','43','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('84','43','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('85','43','event_update_severity','{EVENT.UPDATE.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('86','43','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('87','43','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('88','43','glpi_problem_id','{EVENT.TAGS.__zbx_glpi_problem_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('90','43','glpi_url','<PLACE GLPI URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('91','43','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('92','43','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('93','44','.ILERT.ALERT.SOURCE.KEY','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('94','44','.ILERT.INCIDENT.SUMMARY','','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('95','44','ALERT.MESSAGE','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('96','44','ALERT.SUBJECT','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('97','44','EVENT.ACK.STATUS','{EVENT.ACK.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('98','44','EVENT.DATE','{EVENT.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('99','44','EVENT.ID','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('100','44','EVENT.NAME','{EVENT.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('101','44','EVENT.NSEVERITY','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('102','44','EVENT.OPDATA','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('103','44','EVENT.RECOVERY.DATE','{EVENT.RECOVERY.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('104','44','EVENT.RECOVERY.TIME','{EVENT.RECOVERY.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('105','44','EVENT.RECOVERY.VALUE','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('106','44','EVENT.SEVERITY','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('107','44','EVENT.TAGS','{EVENT.TAGS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('108','44','EVENT.TIME','{EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('109','44','EVENT.UPDATE.ACTION','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('110','44','EVENT.UPDATE.DATE','{EVENT.UPDATE.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('111','44','EVENT.UPDATE.MESSAGE','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('112','44','EVENT.UPDATE.STATUS','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('113','44','EVENT.UPDATE.TIME','{EVENT.UPDATE.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('114','44','EVENT.VALUE','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('115','44','HOST.HOST','{HOST.HOST}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('116','44','HOST.IP','{HOST.IP}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('117','44','HOST.NAME','{HOST.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('118','44','ITEM.ID1','{ITEM.ID1}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('119','44','ITEM.ID2','{ITEM.ID2}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('120','44','ITEM.ID3','{ITEM.ID3}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('121','44','ITEM.ID4','{ITEM.ID4}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('122','44','ITEM.ID5','{ITEM.ID5}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('123','44','ITEM.NAME1','{ITEM.NAME1}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('124','44','ITEM.NAME2','{ITEM.NAME2}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('125','44','ITEM.NAME3','{ITEM.NAME3}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('126','44','ITEM.NAME4','{ITEM.NAME4}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('127','44','ITEM.NAME5','{ITEM.NAME5}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('128','44','TRIGGER.DESCRIPTION','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('129','44','TRIGGER.ID','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('130','44','TRIGGER.NAME','{TRIGGER.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('131','44','TRIGGER.SEVERITY','{TRIGGER.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('132','44','TRIGGER.STATUS','{TRIGGER.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('133','44','TRIGGER.URL','{TRIGGER.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('134','44','TRIGGER.VALUE','{TRIGGER.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('135','44','USER.FULLNAME','{USER.FULLNAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('136','44','ZABBIX.URL','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('137','45','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('138','45','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('139','45','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('140','45','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('141','45','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('142','45','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('143','45','itop_api_version','1.3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('144','45','itop_class','UserRequest','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('145','45','itop_comment','Created by Zabbix action {ACTION.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('146','45','itop_id','{EVENT.TAGS.__zbx_itop_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('147','45','itop_log','private_log','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('148','45','itop_organization_id','<PLACE ORGANIZATION ID>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('149','45','itop_password','<PLACE PASSWORD OR TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('150','45','itop_url','<PLACE YOUR ITOP URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('151','45','itop_user','<PLACE LOGIN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('152','46','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('153','46','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('154','46','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('155','46','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('156','46','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('157','46','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('158','46','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('159','46','event_tags_json','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('160','46','event_update_action','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('161','46','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('162','46','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('163','46','event_update_severity','{EVENT.UPDATE.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('164','46','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('165','46','event_update_user','{USER.FULLNAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('166','46','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('167','46','jira_issue_type','<PLACE ISSUETYPE NAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('168','46','jira_password','<PLACE PASSWORD OR TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('169','46','jira_priority_autoregistration','Low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('170','46','jira_priority_discovery','Low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('171','46','jira_priority_internal','Low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('172','46','jira_project_key','<PLACE PROJECT KEY>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('173','46','jira_url','<PLACE YOUR JIRA URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('174','46','jira_user','<PLACE LOGIN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('175','46','severity_average','Medium','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('176','46','severity_disaster','Highest','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('177','46','severity_high','High','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('178','46','severity_information','Lowest','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('179','46','severity_not_classified','Lowest','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('180','46','severity_warning','Low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('181','46','trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('182','46','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('183','46','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('184','47','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('185','47','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('186','47','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('187','47','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('188','47','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('189','47','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('190','47','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('191','47','event_tags_json','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('192','47','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('193','47','event_update_severity','{EVENT.UPDATE.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('194','47','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('195','47','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('196','47','issue_comments_public','false','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('197','47','jira_password','<PLACE PASSWORD OR TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('198','47','jira_priority_autoregistration','Low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('199','47','jira_priority_discovery','Low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('200','47','jira_priority_internal','Low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('201','47','jira_request_type_id','<PLACE REQUEST TYPE ID>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('202','47','jira_servicedesk_id','<PLACE SERVICEDESK ID>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('203','47','jira_url','<PLACE YOUR JIRA URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('204','47','jira_user','<PLACE LOGIN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('205','47','severity_average','Medium','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('206','47','severity_disaster','Highest','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('207','47','severity_high','High','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('208','47','severity_information','Lowest','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('209','47','severity_not_classified','Lowest','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('210','47','severity_warning','Low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('211','47','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('212','47','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('213','48','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('214','48','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('215','48','bot_token','<PLACE BOT TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('216','48','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('217','48','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('218','48','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('219','48','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('220','48','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('221','48','send_to','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('222','48','trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('223','48','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('224','48','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('225','49','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('226','49','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('227','49','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('228','49','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('229','49','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('230','49','field_ref:requester','<PLACE API USER NAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('231','49','field_string:description','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('232','49','field_string:subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('233','49','priority_average','Normal','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('234','49','priority_default','Normal','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('235','49','priority_disaster','High','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('236','49','priority_high','High','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('237','49','priority_information','Low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('238','49','priority_not_classified','Low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('239','49','priority_warning','Medium','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('240','49','sd_on_demand_client_id','<PLACE ON DEMAND CLIENT ID>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('241','49','sd_on_demand_client_secret','<PLACE ON DEMAND CLIENT SECRET>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('242','49','sd_on_demand_refresh_token','<PLACE ON DEMAND REFRESH TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('243','49','sd_on_demand_url_auth','<PLACE AUTHENTICATION URL FOR ON DEMAND>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('244','49','sd_on_premise','true','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('245','49','sd_on_premise_auth_token','<PLACE ON PREMISE TECHNICIAN_KEY>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('246','49','sd_request_id','{EVENT.TAGS.__zbx_sd_request_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('247','49','sd_url','<PLACE INSTANCE URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('248','49','trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('249','50','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('250','50','alert_sendto','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('251','50','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('252','50','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('253','50','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('254','50','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('255','50','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('256','50','event_tagsjson','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('257','50','event_update_action','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('258','50','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('259','50','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('260','50','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('261','50','mantisbt_category','[All Projects] General','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('262','50','mantisbt_issue_number','{EVENT.TAGS.__zbx_mantisbt_issue_number}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('263','50','mantisbt_token','<PLACE MANTISBT TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('264','50','mantisbt_url','<PLACE MANTISBT URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('265','50','mantisbt_use_zabbix_tags','true','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('266','50','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('267','50','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('268','51','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('269','51','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('270','51','bot_token','<YOUR BOT TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('271','51','discovery_host_dns','{DISCOVERY.DEVICE.DNS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('272','51','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('273','51','event_date','{EVENT.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('274','51','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('275','51','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('276','51','event_opdata','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('277','51','event_recovery_date','{EVENT.RECOVERY.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('278','51','event_recovery_time','{EVENT.RECOVERY.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('279','51','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('280','51','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('281','51','event_tags','{EVENT.TAGS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('282','51','event_time','{EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('283','51','event_update_date','{EVENT.UPDATE.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('284','51','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('285','51','event_update_time','{EVENT.UPDATE.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('286','51','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('287','51','host_ip','{HOST.IP}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('288','51','host_name','{HOST.HOST}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('289','51','mattermost_url','<YOUR MATTERMOST URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('290','51','send_mode','alarm','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('291','51','send_to','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('292','51','trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('293','51','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('294','51','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('295','52','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('296','52','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('297','52','event_date','{EVENT.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('298','52','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('299','52','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('300','52','event_opdata','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('301','52','event_recovery_date','{EVENT.RECOVERY.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('302','52','event_recovery_time','{EVENT.RECOVERY.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('303','52','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('304','52','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('305','52','event_status','{EVENT.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('306','52','event_tags','{EVENT.TAGS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('307','52','event_time','{EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('308','52','event_update_action','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('309','52','event_update_date','{EVENT.UPDATE.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('310','52','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('311','52','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('312','52','event_update_severity','{EVENT.UPDATE.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('313','52','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('314','52','event_update_time','{EVENT.UPDATE.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('315','52','event_update_user','{USER.FULLNAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('316','52','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('317','52','host_ip','{HOST.IP}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('318','52','host_name','{HOST.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('319','52','teams_endpoint','<PLACE WEBHOOK URL HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('320','52','trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('321','52','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('322','52','use_default_message','false','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('323','52','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('324','53','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('325','53','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('326','53','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('327','53','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('328','53','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('329','53','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('330','53','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('331','53','event_update_severity','{EVENT.UPDATE.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('332','53','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('333','53','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('334','53','teams_endpoint','<PLACE WEBHOOK URL HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('335','53','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('336','53','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('337','54','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('338','54','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('339','54','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('340','54','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('341','54','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('342','54','event_tags_json','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('343','54','event_update_action','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('344','54','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('345','54','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('346','54','opsgenie_api','<put your opsgenie api>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('347','54','opsgenie_tags','','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('348','54','opsgenie_teams','','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('349','54','opsgenie_token','<put your token>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('350','54','opsgenie_web','<put your opsgenie web>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('351','54','severity_average','P3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('352','54','severity_default','P5','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('353','54','severity_disaster','P1','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('354','54','severity_high','P2','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('355','54','severity_information','P5','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('356','54','severity_not_classified','P5','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('357','54','severity_warning','P4','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('358','54','status_counter','25','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('359','54','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('360','54','zbxurl','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('361','54','zbxuser','{USER.FULLNAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('362','55','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('363','55','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('364','55','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('365','55','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('366','55','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('367','55','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('368','55','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('369','55','event_update_severity','{EVENT.UPDATE.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('370','55','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('371','55','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('372','55','otrs_auth_password','<PUT YOUR USER PASSWORD>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('373','55','otrs_auth_user','<PUT YOUR USER NAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('374','55','otrs_closed_state_id','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('375','55','otrs_customer','<PUT YOUR CUSTOMER EMAIL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('376','55','otrs_default_priority_id','3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('377','55','otrs_queue','<PUT YOUR QUEUE NAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('378','55','otrs_ticket_id','{EVENT.TAGS.__zbx_otrs_ticket_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('379','55','otrs_ticket_state','new','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('380','55','otrs_time_unit','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('381','55','otrs_url','<PUT YOUR ((OTRS)) CE URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('382','55','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('383','55','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('384','56','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('385','56','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('386','56','api_token','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('387','56','event_ack','{EVENT.ACK.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('388','56','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('389','56','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('390','56','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('391','56','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('392','56','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('393','56','event_update_severity','{EVENT.UPDATE.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('394','56','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('395','56','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('396','56','host_ip','{HOST.IP}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('397','56','host_name','{HOST.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('398','56','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('399','56','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('400','57','endpoint','https://api.pushover.net/1/messages.json','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('401','57','eventid','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('402','57','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('403','57','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('404','57','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('405','57','expire','1200','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('406','57','message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('407','57','priority_average','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('408','57','priority_default','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('409','57','priority_disaster','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('410','57','priority_high','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('411','57','priority_information','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('412','57','priority_not_classified','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('413','57','priority_warning','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('414','57','retry','60','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('415','57','title','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('416','57','token','<PUSHOVER TOKEN HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('417','57','triggerid','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('418','57','url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('419','57','url_title','Zabbix','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('420','57','user','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('421','58','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('422','58','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('423','58','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('424','58','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('425','58','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('426','58','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('427','58','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('428','58','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('429','58','redmine_access_key','<PUT YOUR ACCESS KEY>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('430','58','redmine_issue_key','{EVENT.TAGS.__zbx_redmine_issue_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('431','58','redmine_project','<PUT YOUR PROJECT ID OR NAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('432','58','redmine_tracker_id','<PUT YOUR TRACKER ID>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('433','58','redmine_url','<PUT YOUR REDMINE URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('434','58','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('435','58','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('436','59','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('437','59','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('438','59','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('439','59','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('440','59','event_update_action','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('441','59','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('442','59','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('443','59','event_update_user','{USER.FULLNAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('444','59','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('445','59','field_1_full:Host','{HOST.NAME} [{HOST.IP}]','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('446','59','field_2_short:Severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('447','59','field_3_short:Event time','{EVENT.DATE} {EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('448','59','field_3_short_r:Recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('449','59','field_4_short_r:Event duration','{EVENT.DURATION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('450','59','field_5_short:Operational data','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('451','59','field_999_full_p:Trigger description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('452','59','rc_api_url','api/v1/','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('453','59','rc_msg_id','{EVENT.TAGS.__zbx_rc_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('454','59','rc_room_id','{EVENT.TAGS.__zbx_rc_rid}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('455','59','rc_send_to','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('456','59','rc_title_link','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('457','59','rc_url','<PLACE YOUR INSTANCE URL HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('458','59','rc_user_id','<PLACE USER ID HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('459','59','rc_user_token','<PLACE TOKEN HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('460','59','use_default_message','false','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('461','60','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('462','60','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('463','60','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('464','60','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('465','60','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('466','60','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('467','60','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('468','60','servicenow_password','<PLACE PASSWORD HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('469','60','servicenow_sys_id','{EVENT.TAGS.__zbx_servicenow_sys_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('470','60','servicenow_url','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('471','60','servicenow_user','<PLACE USERNAME HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('472','60','urgency_for_average','2','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('473','60','urgency_for_disaster','1','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('474','60','urgency_for_high','2','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('475','60','urgency_for_information','3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('476','60','urgency_for_not_classified','3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('477','60','urgency_for_warning','3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('478','61','Event_Ack_Status','{EVENT.ACK.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('479','61','Event_Date_Time','{EVENT.DATE} {EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('480','61','Event_ID','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('481','61','Event_Update_Action','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('482','61','Event_Update_Status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('483','61','Hostname','{HOST.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('484','61','Host_IP','{HOST.IP}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('485','61','Message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('486','61','Severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('487','61','Subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('488','61','teamsecret','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('489','61','Trigger_ID','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('490','61','Trigger_Status','{TRIGGER.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('491','61','User','{USER.FULLNAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('492','61','Zabbix_URL','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('493','62','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('494','62','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('495','62','bot_token','<PLACE YOUR TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('496','62','channel','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('497','62','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('498','62','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('499','62','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('500','62','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('501','62','event_tags','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('502','62','event_update_action','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('503','62','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('504','62','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('505','62','event_update_severity','{EVENT.UPDATE.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('506','62','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('507','62','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('508','62','slack_mode','alarm','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('509','62','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('510','62','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('511','63','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('512','63','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('513','63','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('514','63','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('515','63','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('516','63','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('517','63','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('518','63','priority_average','Medium','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('519','63','priority_default','Low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('520','63','priority_disaster','Critical','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('521','63','priority_high','High','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('522','63','samanage_incident_id','{EVENT.TAGS.__zbx_solarwinds_inc_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('523','63','samanage_token','<PUT YOUR TOKEN HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('524','63','samanage_url','<PUT YOUR INSTANCE URL HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('525','64','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('526','64','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('527','64','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('528','64','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('529','64','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('530','64','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('531','64','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('532','64','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('533','64','sysaid_auth_password','<PUT YOUR USER PASSWORD>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('534','64','sysaid_auth_user','<PUT YOUR USER NAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('535','64','sysaid_category_level_1','<PUT YOUR CATEGORY>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('536','64','sysaid_category_level_2','<PUT YOUR SUB-CATEGORY>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('537','64','sysaid_category_level_3','<PUT YOUR THIRD LEVEL CATEGORY>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('538','64','sysaid_default_priority_id','1','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('539','64','sysaid_incident_id','{EVENT.TAGS.__zbx_sysaid_incident_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('540','64','sysaid_incident_state','1','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('541','64','sysaid_template_id','<PUT YOUR TEMPLATE ID>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('542','64','sysaid_urgency_id','<PUT YOUR URGENCY ID>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('543','64','sysaid_url','<PUT YOUR SYSAID URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('544','64','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('545','64','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('546','65','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('547','65','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('548','65','api_chat_id','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('549','65','api_parse_mode','<PLACE PARSE MODE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('550','65','api_token','<PLACE YOUR TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('551','65','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('552','65','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('553','65','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('554','65','event_tags','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('555','65','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('556','65','event_update_severity','{EVENT.UPDATE.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('557','65','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('558','65','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('559','66','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('560','66','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('561','66','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('562','66','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('563','66','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('564','66','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('565','66','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('566','66','severity_average','P3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('567','66','severity_default','P5','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('568','66','severity_disaster','P1','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('569','66','severity_high','P2','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('570','66','severity_information','P5','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('571','66','severity_not_classified','P5','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('572','66','severity_warning','P4','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('573','66','topdesk_api','<put your TOPdesk API URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('574','66','topdesk_issue_key','{EVENT.TAGS.__zbx_tpd_issuekey}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('575','66','topdesk_password','<put your TOPdesk application password>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('576','66','topdesk_status','<put default status for new tickets>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('577','66','topdesk_user','<put your TOPdesk username>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('578','66','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('579','66','zbxurl','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('580','67','event_info','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('581','67','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('582','67','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('583','67','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('584','67','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('585','67','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('586','67','field:entity_display_name','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('587','67','field:entity_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('588','67','field:hostname','{HOST.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('589','67','field:monitoring_tool','Zabbix','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('590','67','field:operational_data','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('591','67','field:severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('592','67','field:state_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('593','67','field_p:trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('594','67','field_r:event_duration','{EVENT.DURATION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('595','67','field_r:recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('596','67','priority_average','WARNING','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('597','67','priority_default','INFO','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('598','67','priority_disaster','CRITICAL','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('599','67','priority_high','WARNING','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('600','67','priority_information','INFO','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('601','67','priority_not_classified','INFO','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('602','67','priority_resolved','OK','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('603','67','priority_update','INFO','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('604','67','priority_warning','INFO','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('605','67','vops_endpoint','<PLACE ENDPOINT URL HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('606','67','vops_routing_key','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('607','68','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('608','68','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('609','68','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('610','68','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('611','68','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('612','68','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('613','68','event_tags','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('614','68','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('615','68','event_update_severity','{EVENT.UPDATE.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('616','68','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('617','68','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('618','68','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('619','68','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('620','68','zammad_access_token','<PUT YOUR ACCESS TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('621','68','zammad_customer','<PUT YOUR CUSTOMER EMAIL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('622','68','zammad_enable_tags','false','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('623','68','zammad_group','Users','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('624','68','zammad_url','<PUT YOUR ZAMMAD URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('625','69','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('626','69','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('627','69','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('628','69','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('629','69','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('630','69','event_tags','{EVENT.TAGS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('631','69','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('632','69','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('633','69','severity_average','normal','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('634','69','severity_default','-','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('635','69','severity_disaster','urgent','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('636','69','severity_high','high','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('637','69','severity_information','low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('638','69','severity_not_classified','low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('639','69','severity_warning','normal','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('640','69','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('641','69','zbxurl','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('642','69','zendesk_issue_key','{EVENT.TAGS.__zbx_zdk_issuekey}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('643','69','zendesk_token','<put your {enduser_email_address}/token:{api_token}>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('644','69','zendesk_type','incident','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('645','69','zendesk_url','<put your Zendesk URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('646','55','otrs_ticket_type','Unclassified','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('647','43','glpi_app_token','','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('648','43','glpi_user_token','<PLACE GLPI USER TOKEN>','0')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('1','1','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('2','1','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('3','1','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('4','1','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('5','1','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('6','3','0','0','','{EVENT.SEVERITY}: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || '{EVENT.DATE} {EVENT.TIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('7','3','0','1','','Resolved in {EVENT.DURATION}: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || '{EVENT.DATE} {EVENT.TIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('8','3','0','2','','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem in {EVENT.AGE} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('9','3','1','0','','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('10','3','2','0','','Autoregistration: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('11','4','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('12','4','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('13','4','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('14','4','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('15','4','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('160','34','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('161','34','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('162','34','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('163','34','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('164','34','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('165','35','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('166','35','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('167','35','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('168','35','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('169','35','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('170','36','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('171','36','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('172','36','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('173','36','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('174','36','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('175','37','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('176','37','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('177','37','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('178','37','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('179','37','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('180','38','0','0','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || 'Started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Event info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('181','38','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || 'Resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Event info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('182','38','0','2','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('183','38','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('184','38','2','0','Autoregistration: {HOST.HOST}','Autoregistration: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('185','39','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('186','39','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('187','39','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('188','39','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('189','39','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('190','39','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('191','39','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('192','39','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Service problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Service: {SERVICE.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('193','39','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('194','39','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || 'Current problem age is {EVENT.AGE}.' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('195','40','0','0','Event ID: {EVENT.ID}, Host: {HOST.HOST}, Problem: {EVENT.NAME}','')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('196','41','0','0','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || 'Started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Event info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('197','41','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || 'Resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Event info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('198','41','0','2','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('199','41','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('200','41','2','0','Autoregistration: {HOST.HOST}','Autoregistration: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('201','42','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('202','42','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('203','42','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('204','42','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('205','42','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('206','42','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('207','42','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('208','42','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Service problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Service: {SERVICE.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('209','42','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('210','42','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || 'Current problem age is {EVENT.AGE}.' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('211','43','0','0','Problem: {EVENT.NAME}','<dl><dd><b>Problem started at</b> {EVENT.TIME} <b>on</b> {EVENT.DATE}</b></dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Host:</b> {HOST.NAME}</dd><dd><b>Severity:</b> {EVENT.SEVERITY}</dd><dd><b>Operational data:</b> {EVENT.OPDATA}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd></dl>{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('212','43','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<dl><dd><b>Problem has been resolved in</b> {EVENT.DURATION} <b>at</b> {EVENT.RECOVERY.TIME} <b>on</b> {EVENT.RECOVERY.DATE}</dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Host:</b> {HOST.NAME}</dd><dd><b>Severity:</b> {EVENT.SEVERITY}</dd><dd><b>Operational data:</b> {EVENT.OPDATA}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd></dl>{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('213','43','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.TIME} on {EVENT.UPDATE.DATE}. <br><br>{EVENT.UPDATE.MESSAGE}<br><br>Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.<br><br>')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('214','43','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<dl><dd><b>Discovery rule:</b> {DISCOVERY.RULE.NAME}</dd><br><dd><b>Device IP:</b> {DISCOVERY.DEVICE.IPADDRESS}</dd><dd><b>Device DNS:</b> {DISCOVERY.DEVICE.DNS}</dd><br><dd><b>Device status:</b> {DISCOVERY.DEVICE.STATUS}</dd><br><dd><b>Device uptime:</b> {DISCOVERY.DEVICE.UPTIME}</dd><br><dd><b>Device service name:</b> {DISCOVERY.SERVICE.NAME}</dd><dd><b>Device service port:</b> {DISCOVERY.SERVICE.PORT}</dd><dd><b>Device service status:</b> {DISCOVERY.SERVICE.STATUS}</dd><dd><b>Device service uptime:</b> {DISCOVERY.SERVICE.UPTIME}</dd></dl>')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('215','43','2','0','Autoregistration: {HOST.HOST}','<dl><dd><b>Host name:</b> {HOST.HOST}</dd><dd><b>Host IP:</b> {HOST.IP}</dd><dd><b>Agent port:</b> {HOST.PORT}</dd></dl>')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('216','43','3','0','[{EVENT.STATUS}] {EVENT.NAME}','<dl><dd><b>Problem started at</b> {EVENT.TIME} <b>on</b> {EVENT.DATE}</b></dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Host:</b> {HOST.NAME}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd></dl>')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('217','43','3','1','[{EVENT.STATUS}] {EVENT.NAME}','<dl><dd><b>Problem has been resolved in</b> {EVENT.DURATION} <b>at</b> {EVENT.RECOVERY.TIME} <b>on</b> {EVENT.RECOVERY.DATE}</dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Host:</b> {HOST.NAME}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd></dl>')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('218','43','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','<dl><dd><b>Service problem started at</b> {EVENT.TIME} <b>on</b> {EVENT.DATE}</dd><dd><b>Service problem name:</b> {EVENT.NAME}</dd><dd><b>Service:</b> {SERVICE.NAME}</dd><dd><b>Severity:</b> {EVENT.SEVERITY}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd><dd><b>Service description:</b> {SERVICE.DESCRIPTION}</dd><dd><b><br>{SERVICE.ROOTCAUSE}</dd></dl>')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('219','43','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','<dl><dd><b>Service {SERVICE.NAME} <b>has been resolved at</b> {EVENT.RECOVERY.TIME} <b>on</b> {EVENT.RECOVERY.DATE}</dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Problem duration:</b> {EVENT.DURATION}</dd><dd><b>Severity:</b> {EVENT.SEVERITY}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd><dd><b>Service description:</b {SERVICE.DESCRIPTION}</dd></dl>')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('220','43','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','<dl><dd><b>Changed {SERVICE.NAME} <b>service status to</b> {EVENT.UPDATE.SEVERITY} <b>at</b> {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.</dd><dd><b>Current problem age is</b> {EVENT.AGE}.</dd><dd><b>Service description:</b> {SERVICE.DESCRIPTION}</dd><br>{SERVICE.ROOTCAUSE}</dd></dl>')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('221','44','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('222','44','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('223','44','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('224','45','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('225','45','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('226','45','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('227','45','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('228','45','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('229','46','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('230','46','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('231','46','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('232','46','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('233','46','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('234','46','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('235','46','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('236','46','4','0','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Service problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Service: {SERVICE.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('237','46','4','1','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('238','46','4','2','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || 'Current problem age is {EVENT.AGE}.' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('239','47','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('240','47','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('241','47','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('242','47','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('243','47','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('244','47','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('245','47','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('246','47','4','0','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Service problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Service: {SERVICE.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('247','47','4','1','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('248','47','4','2','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || 'Current problem age is {EVENT.AGE}.' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('249','48','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('250','48','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('251','48','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('252','48','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('253','48','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('254','49','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('255','49','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('256','49','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('257','49','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('258','49','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('259','50','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('260','50','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('261','50','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('262','50','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('263','50','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('264','50','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('265','50','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('266','51','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('267','51','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('268','51','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('269','51','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('270','51','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('271','52','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('272','52','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('273','52','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('274','52','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('275','52','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('276','52','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('277','52','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('278','52','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Service problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Service: {SERVICE.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('279','52','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('280','52','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || 'Current problem age is {EVENT.AGE}.' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('281','53','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('282','53','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('283','53','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('284','53','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('285','53','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('286','53','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('287','53','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('288','53','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Service problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Service: {SERVICE.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('289','53','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('290','53','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || 'Current problem age is {EVENT.AGE}.' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('291','54','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('292','54','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('293','54','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('294','54','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('295','54','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('296','55','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('297','55','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('298','55','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('299','55','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('300','55','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('301','55','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('302','55','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('303','55','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Service problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Service: {SERVICE.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('304','55','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('305','55','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || 'Current problem age is {EVENT.AGE}.' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('306','56','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('307','56','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('308','56','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('309','56','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('310','56','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('311','56','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('312','56','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('313','56','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Service problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Service: {SERVICE.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('314','56','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('315','56','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || 'Current problem age is {EVENT.AGE}.' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('316','57','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('317','57','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('318','57','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('319','57','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('320','57','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('321','58','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('322','58','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('323','58','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('324','58','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('325','58','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('326','59','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('327','59','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('328','59','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('329','59','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('330','59','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('331','60','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('332','60','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('333','60','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('334','60','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('335','60','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('336','61','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('337','61','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('338','61','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('339','61','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('340','61','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('341','62','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('342','62','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('343','62','0','2','Updated: {EVENT.NAME}','Problem updated at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || '{USER.FULLNAME} {EVENT.UPDATE.ACTION}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('344','62','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('345','62','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('346','62','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('347','62','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('348','62','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Service problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Service: {SERVICE.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('349','62','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('350','62','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || 'Current problem age is {EVENT.AGE}.' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('351','63','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Trigger description: {TRIGGER.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('352','63','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('353','63','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('354','63','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('355','63','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('356','64','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('357','64','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('358','64','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('359','64','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('360','64','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('361','65','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('362','65','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('363','65','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('364','65','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('365','65','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('366','65','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('367','65','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('368','65','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Service problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Service: {SERVICE.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('369','65','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('370','65','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || 'Current problem age is {EVENT.AGE}.' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('371','66','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('372','66','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('373','66','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('374','66','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('375','66','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('376','67','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('377','67','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('378','67','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('379','67','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('380','67','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('381','68','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('382','68','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('383','68','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('384','68','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('385','68','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('386','68','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('387','68','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('388','68','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Service problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Service: {SERVICE.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('389','68','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('390','68','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || 'Current problem age is {EVENT.AGE}.' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('391','69','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('392','69','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('393','69','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('394','69','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('395','69','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('396','69','3','0','Internal problem: {EVENT.NAME}','Internal problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode,userdirectoryid,mfa_status,mfaid)
values ('7','Zabbix administrators','0','0','0',NULL,'0',NULL)
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode,userdirectoryid,mfa_status,mfaid)
values ('8','Guests','0','0','0',NULL,'0',NULL)
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode,userdirectoryid,mfa_status,mfaid)
values ('9','Disabled','0','1','0',NULL,'0',NULL)
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode,userdirectoryid,mfa_status,mfaid)
values ('11','Enabled debug mode','0','0','1',NULL,'0',NULL)
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode,userdirectoryid,mfa_status,mfaid)
values ('12','No access to the frontend','3','0','0',NULL,'0',NULL)
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode,userdirectoryid,mfa_status,mfaid)
values ('13','Internal','1','0','0',NULL,'0',NULL)
/

INSERT INTO users_groups (id,usrgrpid,userid)
values ('2','8','2')
/

INSERT INTO users_groups (id,usrgrpid,userid)
values ('3','9','2')
/

INSERT INTO users_groups (id,usrgrpid,userid)
values ('4','7','1')
/

INSERT INTO users_groups (id,usrgrpid,userid)
values ('5','13','1')
/

INSERT INTO users_groups (id,usrgrpid,userid)
values ('6','13','2')
/

INSERT INTO ugset_group (ugsetid,usrgrpid)
values ('1','13')
/

INSERT INTO ugset_group (ugsetid,usrgrpid)
values ('1','8')
/

INSERT INTO ugset_group (ugsetid,usrgrpid)
values ('1','9')
/

INSERT INTO user_ugset (userid,ugsetid)
values ('2','1')
/

INSERT INTO scripts (scriptid,name,command,host_access,usrgrpid,groupid,description,confirmation,type,execute_on,timeout,scope,port,authtype,username,password,publickey,privatekey,menu_path,url,new_window,manualinput,manualinput_prompt,manualinput_validator,manualinput_validator_type,manualinput_default_value)
values ('1','Ping','ping -c 3 {HOST.CONN}; case $? in [01]) true;; *) false;; esac','2',NULL,NULL,'','','0','2','30s','2','','0','','','','','','','1','0','','','0','')
/

INSERT INTO scripts (scriptid,name,command,host_access,usrgrpid,groupid,description,confirmation,type,execute_on,timeout,scope,port,authtype,username,password,publickey,privatekey,menu_path,url,new_window,manualinput,manualinput_prompt,manualinput_validator,manualinput_validator_type,manualinput_default_value)
values ('2','Traceroute','/usr/bin/traceroute {HOST.CONN}','2',NULL,NULL,'','','0','2','30s','2','','0','','','','','','','1','0','','','0','')
/

INSERT INTO scripts (scriptid,name,command,host_access,usrgrpid,groupid,description,confirmation,type,execute_on,timeout,scope,port,authtype,username,password,publickey,privatekey,menu_path,url,new_window,manualinput,manualinput_prompt,manualinput_validator,manualinput_validator_type,manualinput_default_value)
values ('3','Detect operating system','sudo /usr/bin/nmap -O {HOST.CONN}','2','7',NULL,'','','0','2','30s','2','','0','','','','','','','1','0','','','0','')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled,pause_symptoms)
values ('2','Auto discovery. Linux servers.','1','0','1','0','','1','1','1')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled,pause_symptoms)
values ('3','Report problems to Zabbix administrators','0','0','1','1h','','1','1','1')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled,pause_symptoms)
values ('4','Report not supported items','3','0','1','1h','','1','1','1')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled,pause_symptoms)
values ('5','Report not supported low level discovery rules','3','0','1','1h','','1','1','1')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled,pause_symptoms)
values ('6','Report unknown triggers','3','0','1','1h','','1','1','1')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('1','2','6','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('2','2','4','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('3','3','0','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('4','4','0','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('5','5','0','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('6','6','0','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('7','3','11','0','1','1','0','1')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('8','4','11','0','1','1','0','1')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('9','5','11','0','1','1','0','1')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('10','6','11','0','1','1','0','1')
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('3','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('4','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('5','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('6','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('7','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('8','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('9','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('10','1','','',NULL)
/

INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid)
values ('1','3','7')
/

INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid)
values ('2','4','7')
/

INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid)
values ('3','5','7')
/

INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid)
values ('4','6','7')
/

INSERT INTO opgroup (opgroupid,operationid,groupid)
values ('1','2','2')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('2','2','10','0','0','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('3','2','8','0','9','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('4','2','12','2','Linux','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('6','4','23','0','0','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('7','5','23','0','2','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('8','6','23','0','4','')
/

INSERT INTO config (configid,work_period,alert_usrgrpid,discovery_groupid,dbversion_status,geomaps_tile_provider,ldap_userdirectoryid,server_status,mfaid,software_update_check_data)
values ('1','1-5,09:00-18:00','7','5','','OpenStreetMap.Mapnik',NULL,'',NULL,'')
/

INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette)
values ('1','blue-theme','FFFFFF','FFFFFF','CCD5D9','ACBBC2','ACBBC2','1F2C33','E33734','429E47','E33734','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4')
/

INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette)
values ('2','dark-theme','2B2B2B','2B2B2B','454545','4F4F4F','4F4F4F','F2F2F2','E45959','59DB8F','E45959','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4')
/

INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette)
values ('3','hc-light','FFFFFF','FFFFFF','555555','000000','333333','000000','333333','000000','000000','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4')
/

INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette)
values ('4','hc-dark','000000','000000','666666','888888','4F4F4F','FFFFFF','FFFFFF','FFFFFF','FFFFFF','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4')
/

INSERT INTO globalmacro (globalmacroid,macro,value,description,type)
values ('2','{$SNMP_COMMUNITY}','public','','0')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('1','File systems for discovery','ext3')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('2','Network interfaces for discovery','eth0')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('3','Storage devices for SNMP discovery','/boot')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('4','Windows service names for discovery','SysmonLog')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('5','Windows service startup states for discovery','automatic')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('1','1','^(btrfs|ext2|ext3|ext4|reiser|xfs|ffs|ufs|jfs|jfs2|vxfs|hfs|apfs|refs|ntfs|fat32|zfs)$','3',',','0')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('3','3','^(Physical memory|Virtual memory|Memory buffers|Cached memory|Swap space)$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('5','4','^(MMCSS|gupdate|SysmonLog|clr_optimization_v2.0.50727_32|clr_optimization_v4.0.30319_32)$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('6','5','^(automatic|automatic delayed)$','3',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('7','2','^Software Loopback Interface','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('8','2','^(In)?[Ll]oop[Bb]ack[0-9._]*$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('9','2','^NULL[0-9.]*$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('10','2','^[Ll]o[0-9.]*$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('11','2','^[Ss]ystem$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('12','2','^Nu[0-9.]*$','4',',','1')
/

INSERT INTO config_autoreg_tls (autoreg_tlsid,tls_psk_identity,tls_psk)
values ('1','','')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('1','actionlog','widgets/actionlog','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('2','clock','widgets/clock','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('3','dataover','widgets/dataover','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('4','discovery','widgets/discovery','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('5','favgraphs','widgets/favgraphs','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('6','favmaps','widgets/favmaps','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('7','geomap','widgets/geomap','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('8','graph','widgets/graph','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('9','graphprototype','widgets/graphprototype','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('10','hostavail','widgets/hostavail','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('11','item','widgets/item','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('12','map','widgets/map','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('13','navtree','widgets/navtree','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('14','itemhistory','widgets/itemhistory','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('15','problemhosts','widgets/problemhosts','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('16','problems','widgets/problems','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('17','problemsbysv','widgets/problemsbysv','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('18','slareport','widgets/slareport','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('19','svggraph','widgets/svggraph','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('20','systeminfo','widgets/systeminfo','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('21','tophosts','widgets/tophosts','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('22','trigover','widgets/trigover','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('23','url','widgets/url','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('24','web','widgets/web','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('25','gauge','widgets/gauge','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('26','toptriggers','widgets/toptriggers','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('27','piechart','widgets/piechart','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('28','honeycomb','widgets/honeycomb','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('29','hostnavigator','widgets/hostnavigator','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('30','itemnavigator','widgets/itemnavigator','1','[]')
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('1','1','0','ui.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('2','1','0','services.read','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('3','1','0','services.write','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('4','1','0','modules.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('5','1','0','api.access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('6','1','0','api.mode','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('7','1','0','actions.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('8','2','0','ui.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('9','2','0','services.read','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('10','2','0','services.write','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('11','2','0','modules.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('12','2','0','api.access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('13','2','0','api.mode','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('14','2','0','actions.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('15','3','0','ui.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('16','3','0','services.read','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('17','3','0','services.write','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('18','3','0','modules.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('19','3','0','api.access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('20','3','0','api.mode','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('21','3','0','actions.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('22','4','0','ui.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('23','4','0','services.read','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('24','4','0','services.write','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('25','4','0','modules.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('26','4','0','api.access','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('27','4','0','actions.default_access','0','',NULL,NULL)
/

INSERT INTO hgset (hgsetid,hash)
values ('1','e629fa6598d732768f7c726b4b621285f9c3b85303900aa912017db7617d8bdb')
/

INSERT INTO hgset (hgsetid,hash)
values ('2','4ec9599fc203d176a301536c2e091a19bc852759b255bd6818810a42c5fed14a')
/

INSERT INTO hgset (hgsetid,hash)
values ('3','4523540f1504cd17100c4835e85b7eefd49911580f8efff0599a8f283be6b9e3')
/

INSERT INTO hgset (hgsetid,hash)
values ('4','ef8704ac79657fbf2818c74a70a571c131283abd8914eca173cd032929702789')
/

INSERT INTO hgset (hgsetid,hash)
values ('5','6f4b6612125fb3a0daecd2799dfd6c9c299424fd920f9b308110a2c1fbd8f443')
/

INSERT INTO hgset (hgsetid,hash)
values ('6','4b227777d4dd1fc61c6f884f48641d02b4d121d3fd328cb08b5531fcacdabf8a')
/

INSERT INTO hgset (hgsetid,hash)
values ('7','19581e27de7ced00ff1ce50b2047e7a567c76b1cbaebabe5ef03f7c3017bb5b7')
/

INSERT INTO hgset (hgsetid,hash)
values ('8','6b51d431df5d7f141cbececcf79edf3dd861c3b4069f0b11661a3eefacbba918')
/

INSERT INTO hgset (hgsetid,hash)
values ('9','b17ef6d19c7a5b1ee83b907c595526dcb1eb06db8227d650d5dda0a9f4ce8cd9')
/

INSERT INTO hgset (hgsetid,hash)
values ('10','4fc82b26aecb47d2868c4efbe3581732a3e7cbcc6c2efb32062c08170a05eeb8')
/

INSERT INTO hgset (hgsetid,hash)
values ('11','4a44dc15364204a80fe80e9039455cc1608281820fe2b24f1e5233ade6af1dd5')
/

INSERT INTO hgset (hgsetid,hash)
values ('12','3fdba35f04dc8c462986c992bcf875546257113072a909c162f7e470e581e278')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10001',NULL,'Linux by Zabbix agent','3','-1','2','','','Linux by Zabbix agent','0',NULL,'This is an official Linux template. It requires Zabbix agent 7.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Notes on filesystem (FS) discovery:' || chr(13) || chr(10) || '- The ext4/3/2 filesystem reserves space for privileged usage, typically set at 5% by default.' || chr(13) || chr(10) || '- BTRFS allocates a default of 10% of the volume for its own needs.' || chr(13) || chr(10) || '- To mitigate potential disasters, FS usage triggers are based on the maximum available space.' || chr(13) || chr(10) || '  - Utilization formula: ''pused = 100 - 100 * (available / total - free + available)''' || chr(13) || chr(10) || '- The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f8f7908280354f2abeed07dc788c3747','LINUX BY ZABBIX AGENT','Zabbix','7.0-3',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10047',NULL,'Zabbix server health','3','-1','2','','','Zabbix server health','0',NULL,'This template is designed to monitor internal Zabbix metrics on the local Zabbix server.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Link this template to the local Zabbix server host.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e2d2b4e4ac28483996cc11fe42823d57','ZABBIX SERVER HEALTH','Zabbix','7.0-5',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10048',NULL,'Zabbix proxy health','3','-1','2','','','Zabbix proxy health','0',NULL,'This template is designed to monitor internal Zabbix metrics on the local Zabbix proxy.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Link this template to the local Zabbix proxy host.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','dd114bf0fb2f46bc84840f1bb24e2b23','ZABBIX PROXY HEALTH','Zabbix','7.0-3',NULL