/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.cpp;

import java.io.IOException;
import java.io.Reader;
import org.anarres.cpp.Feature;
import org.anarres.cpp.JoinReader;
import org.anarres.cpp.LexerException;
import org.anarres.cpp.Preprocessor;
import org.anarres.cpp.Source;
import org.anarres.cpp.Token;

public class LexerSource
extends Source {
    private static final boolean DEBUG = false;
    private JoinReader reader;
    private boolean ppvalid;
    private boolean bol;
    private boolean include;
    private boolean digraphs;
    private int u0;
    private int u1;
    private int ucount;
    private int line;
    private int column;
    private int lastcolumn;
    private boolean cr;

    public LexerSource(Reader r, boolean ppvalid) {
        this.reader = new JoinReader(r);
        this.ppvalid = ppvalid;
        this.bol = true;
        this.include = false;
        this.digraphs = true;
        this.ucount = 0;
        this.line = 1;
        this.column = 0;
        this.lastcolumn = -1;
        this.cr = false;
    }

    void init(Preprocessor pp) {
        super.init(pp);
        this.digraphs = pp.getFeature(Feature.DIGRAPHS);
        this.reader.init(pp, this);
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    boolean isNumbered() {
        return true;
    }

    private final void _error(String msg, boolean error) throws LexerException {
        int _l = this.line;
        int _c = this.column;
        if (_c == 0) {
            _c = this.lastcolumn;
            --_l;
        } else {
            --_c;
        }
        if (error) {
            super.error(_l, _c, msg);
        } else {
            super.warning(_l, _c, msg);
        }
    }

    final void error(String msg) throws LexerException {
        this._error(msg, true);
    }

    final void warning(String msg) throws LexerException {
        this._error(msg, false);
    }

    void setInclude(boolean b) {
        this.include = b;
    }

    private static final boolean isLineSeparator(int c) {
        switch ((char)c) {
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\u0085': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return c == -1;
    }

    private int read() throws IOException, LexerException {
        assert (this.ucount <= 2) : "Illegal ucount: " + this.ucount;
        switch (this.ucount) {
            case 2: {
                this.ucount = 1;
                return this.u1;
            }
            case 1: {
                this.ucount = 0;
                return this.u0;
            }
        }
        int c = this.reader.read();
        switch (c) {
            case 13: {
                this.cr = true;
                ++this.line;
                this.lastcolumn = this.column;
                this.column = 0;
                break;
            }
            case 10: {
                if (this.cr) {
                    this.cr = false;
                    break;
                }
            }
            case 11: 
            case 12: 
            case 133: 
            case 8232: 
            case 8233: {
                this.cr = false;
                ++this.line;
                this.lastcolumn = this.column;
                this.column = 0;
                break;
            }
            default: {
                this.cr = false;
                ++this.column;
            }
        }
        return c;
    }

    private void unread(int c) throws IOException {
        if (c != -1) {
            if (LexerSource.isLineSeparator(c)) {
                --this.line;
                this.column = this.lastcolumn;
                this.cr = false;
            } else {
                --this.column;
            }
            switch (this.ucount) {
                case 0: {
                    this.u0 = c;
                    this.ucount = 1;
                    break;
                }
                case 1: {
                    this.u1 = c;
                    this.ucount = 2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot unget another character!");
                }
            }
        }
    }

    private Token ccomment() throws IOException, LexerException {
        StringBuilder text = new StringBuilder("/*");
        while (true) {
            int d = this.read();
            text.append((char)d);
            if (d != 42) continue;
            do {
                d = this.read();
                text.append((char)d);
            } while (d == 42);
            if (d == 47) break;
        }
        return new Token(260, text.toString());
    }

    private Token cppcomment() throws IOException, LexerException {
        StringBuilder text = new StringBuilder("//");
        int d = this.read();
        while (!LexerSource.isLineSeparator(d)) {
            text.append((char)d);
            d = this.read();
        }
        this.unread(d);
        return new Token(260, text.toString());
    }

    private int escape(StringBuilder text) throws IOException, LexerException {
        int d = this.read();
        switch (d) {
            case 97: {
                text.append('a');
                return 10;
            }
            case 98: {
                text.append('b');
                return 8;
            }
            case 102: {
                text.append('f');
                return 12;
            }
            case 110: {
                text.append('n');
                return 10;
            }
            case 114: {
                text.append('r');
                return 13;
            }
            case 116: {
                text.append('t');
                return 9;
            }
            case 118: {
                text.append('v');
                return 11;
            }
            case 92: {
                text.append('\\');
                return 92;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int len = 0;
                int val = 0;
                do {
                    val = (val << 3) + Character.digit(d, 8);
                    text.append((char)d);
                    d = this.read();
                } while (++len < 3 && Character.digit(d, 8) != -1);
                this.unread(d);
                return val;
            }
            case 120: {
                int len = 0;
                int val = 0;
                do {
                    val = (val << 4) + Character.digit(d, 16);
                    text.append((char)d);
                    d = this.read();
                } while (++len < 2 && Character.digit(d, 16) != -1);
                this.unread(d);
                return val;
            }
            case 34: {
                text.append('\"');
                return 34;
            }
            case 39: {
                text.append('\'');
                return 39;
            }
        }
        this.warning("Unnecessary escape character " + (char)d);
        text.append((char)d);
        return d;
    }

    private Token character() throws IOException, LexerException {
        StringBuilder text = new StringBuilder("'");
        int d = this.read();
        if (d == 92) {
            text.append('\\');
            d = this.escape(text);
        } else {
            if (LexerSource.isLineSeparator(d)) {
                this.unread(d);
                this.error("Unterminated character literal");
                return new Token(298, text.toString(), null);
            }
            if (d == 39) {
                text.append('\'');
                this.error("Empty character literal");
                return new Token(298, text.toString(), null);
            }
            if (!Character.isDefined(d)) {
                text.append('?');
                this.error("Illegal unicode character literal");
            } else {
                text.append((char)d);
            }
        }
        int e = this.read();
        if (e != 39) {
            this.error("Illegal character constant");
            while (e != 39) {
                if (LexerSource.isLineSeparator(e)) {
                    this.unread(e);
                    break;
                }
                text.append((char)e);
                e = this.read();
            }
            return new Token(298, text.toString(), null);
        }
        text.append('\'');
        return new Token(259, text.toString(), Character.valueOf((char)d));
    }

    private Token string(char open, char close) throws IOException, LexerException {
        int c;
        StringBuilder text = new StringBuilder();
        text.append(open);
        StringBuilder buf = new StringBuilder();
        while ((c = this.read()) != close) {
            if (c == 92) {
                text.append('\\');
                if (this.include) continue;
                char d = (char)this.escape(text);
                buf.append(d);
                continue;
            }
            if (c == -1) {
                this.unread(c);
                this.error("End of file in string literal after " + buf);
                return new Token(298, text.toString(), null);
            }
            if (LexerSource.isLineSeparator(c)) {
                this.unread(c);
                this.error("Unterminated string literal after " + buf);
                return new Token(298, text.toString(), null);
            }
            text.append((char)c);
            buf.append((char)c);
        }
        text.append(close);
        return new Token(close == '>' ? 268 : 290, text.toString(), buf.toString());
    }

    private void number_suffix(StringBuilder text, int d) throws IOException, LexerException {
        if (d == 85) {
            text.append((char)d);
            d = this.read();
        }
        if (d == 76) {
            text.append((char)d);
        } else if (d == 73) {
            text.append((char)d);
        } else {
            this.unread(d);
        }
    }

    private Token number_octal() throws IOException, LexerException {
        StringBuilder text = new StringBuilder("0");
        int d = this.read();
        long val = 0L;
        while (Character.digit(d, 8) != -1) {
            val = (val << 3) + (long)Character.digit(d, 8);
            text.append((char)d);
            d = this.read();
        }
        this.number_suffix(text, d);
        return new Token(271, text.toString(), val);
    }

    private Token number_hex(char x) throws IOException, LexerException {
        StringBuilder text = new StringBuilder("0");
        text.append(x);
        int d = this.read();
        if (Character.digit(d, 16) == -1) {
            this.unread(d);
            this.error("Illegal hexadecimal constant " + (char)d);
            return new Token(298, text.toString(), null);
        }
        long val = 0L;
        do {
            val = (val << 4) + (long)Character.digit(d, 16);
            text.append((char)d);
        } while (Character.digit(d = this.read(), 16) != -1);
        this.number_suffix(text, d);
        return new Token(271, text.toString(), val);
    }

    private Token number_decimal(int c) throws IOException, LexerException {
        StringBuilder text = new StringBuilder((char)c);
        int d = c;
        long val = 0L;
        do {
            val = val * 10L + (long)Character.digit(d, 10);
            text.append((char)d);
        } while (Character.digit(d = this.read(), 10) != -1);
        this.number_suffix(text, d);
        return new Token(271, text.toString(), val);
    }

    private Token identifier(int c) throws IOException, LexerException {
        int d;
        StringBuilder text = new StringBuilder();
        text.append((char)c);
        while (true) {
            if (Character.isIdentifierIgnorable(d = this.read())) {
                continue;
            }
            if (!Character.isJavaIdentifierPart(d)) break;
            text.append((char)d);
        }
        this.unread(d);
        return new Token(269, text.toString());
    }

    private Token whitespace(int c) throws IOException, LexerException {
        int d;
        StringBuilder text = new StringBuilder();
        text.append((char)c);
        while (true) {
            d = this.read();
            if (this.ppvalid && LexerSource.isLineSeparator(d) || !Character.isWhitespace(d)) break;
            text.append((char)d);
        }
        this.unread(d);
        return new Token(292, text.toString());
    }

    private Token cond(char c, int yes, int no) throws IOException, LexerException {
        int d = this.read();
        if (c == d) {
            return new Token(yes);
        }
        this.unread(d);
        return new Token(no);
    }

    public Token token() throws IOException, LexerException {
        Token tok = null;
        int _l = this.line;
        int _c = this.column;
        int c = this.read();
        switch (c) {
            case 10: {
                if (!this.ppvalid) break;
                this.bol = true;
                if (this.include) {
                    tok = new Token(283, _l, _c, "\n");
                } else {
                    int d;
                    int nls = 0;
                    do {
                        d = this.read();
                        ++nls;
                    } while (d == 10);
                    this.unread(d);
                    char[] text = new char[nls];
                    for (int i = 0; i < text.length; ++i) {
                        text[i] = 10;
                    }
                    tok = new Token(283, _l, _c, new String(text));
                }
                return tok;
            }
            case 33: {
                tok = this.cond('=', 282, 33);
                break;
            }
            case 35: {
                if (this.bol) {
                    tok = new Token(267);
                    break;
                }
                tok = this.cond('#', 285, 35);
                break;
            }
            case 43: {
                int d = this.read();
                if (d == 43) {
                    tok = new Token(270);
                    break;
                }
                if (d == 61) {
                    tok = new Token(286);
                    break;
                }
                this.unread(d);
                break;
            }
            case 45: {
                int d = this.read();
                if (d == 45) {
                    tok = new Token(261);
                    break;
                }
                if (d == 61) {
                    tok = new Token(291);
                    break;
                }
                if (d == 62) {
                    tok = new Token(258);
                    break;
                }
                this.unread(d);
                break;
            }
            case 42: {
                tok = this.cond('=', 281, 42);
                break;
            }
            case 47: {
                int d = this.read();
                if (d == 42) {
                    tok = this.ccomment();
                    break;
                }
                if (d == 47) {
                    tok = this.cppcomment();
                    break;
                }
                if (d == 61) {
                    tok = new Token(262);
                    break;
                }
                this.unread(d);
                break;
            }
            case 37: {
                int d = this.read();
                if (d == 61) {
                    tok = new Token(280);
                    break;
                }
                if (this.digraphs && d == 62) {
                    tok = new Token(125);
                    break;
                }
                if (this.digraphs && d == 58) {
                    d = this.read();
                    if (d != 37) {
                        this.unread(d);
                        tok = new Token(35);
                        break;
                    }
                    d = this.read();
                    if (d != 58) {
                        this.unread(d);
                        this.unread(37);
                        tok = new Token(35);
                        break;
                    }
                    tok = new Token(285);
                    break;
                }
                this.unread(d);
                break;
            }
            case 58: {
                int d = this.read();
                if (this.digraphs && d == 62) {
                    tok = new Token(93);
                    break;
                }
                this.unread(d);
                break;
            }
            case 60: {
                if (this.include) {
                    tok = this.string('<', '>');
                    break;
                }
                int d = this.read();
                if (d == 61) {
                    tok = new Token(274);
                    break;
                }
                if (d == 60) {
                    tok = this.cond('=', 279, 278);
                    break;
                }
                if (this.digraphs && d == 58) {
                    tok = new Token(91);
                    break;
                }
                if (this.digraphs && d == 37) {
                    tok = new Token(123);
                    break;
                }
                this.unread(d);
                break;
            }
            case 61: {
                tok = this.cond('=', 265, 61);
                break;
            }
            case 62: {
                int d = this.read();
                if (d == 61) {
                    tok = new Token(266);
                    break;
                }
                if (d == 62) {
                    tok = this.cond('=', 289, 288);
                    break;
                }
                this.unread(d);
                break;
            }
            case 94: {
                tok = this.cond('=', 293, 94);
                break;
            }
            case 124: {
                int d = this.read();
                if (d == 61) {
                    tok = new Token(284);
                    break;
                }
                if (d == 124) {
                    tok = this.cond('=', 277, 276);
                    break;
                }
                this.unread(d);
                break;
            }
            case 38: {
                int d = this.read();
                if (d == 38) {
                    tok = this.cond('=', 273, 272);
                    break;
                }
                if (d == 61) {
                    tok = new Token(257);
                    break;
                }
                this.unread(d);
                break;
            }
            case 46: {
                int d = this.read();
                if (d == 46) {
                    tok = this.cond('.', 263, 287);
                    break;
                }
                this.unread(d);
                break;
            }
            case 48: {
                int d = this.read();
                if (d == 120 || d == 88) {
                    tok = this.number_hex((char)d);
                    break;
                }
                this.unread(d);
                tok = this.number_octal();
                break;
            }
            case 39: {
                tok = this.character();
                break;
            }
            case 34: {
                tok = this.string('\"', '\"');
                break;
            }
            case -1: {
                tok = new Token(264, _l, _c, "<eof>");
            }
        }
        if (tok == null) {
            tok = Character.isWhitespace(c) ? this.whitespace(c) : (Character.isDigit(c) ? this.number_decimal(c) : (Character.isJavaIdentifierStart(c) ? this.identifier(c) : new Token(c)));
        }
        this.bol = false;
        tok.setLocation(_l, _c);
        return tok;
    }
}

