/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.sql;

import java.util.ArrayList;
import java.util.List;
import org.argouml.language.sql.ColumnDefinition;
import org.argouml.language.sql.TableDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKeyDefinition {
    private TableDefinition table;
    private List<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
    private TableDefinition referencesTable;
    private List<ColumnDefinition> referencesColumns = new ArrayList<ColumnDefinition>();
    private String foreignKeyName;
    private int lower;
    private int upper;
    private int referencesLower;
    private int referencesUpper;

    public List<String> getColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnDefinition cd : this.columns) {
            columnNames.add(cd.getName());
        }
        return columnNames;
    }

    public void addColumnDefinition(ColumnDefinition colDef) {
        this.columns.add(colDef);
    }

    public List<String> getReferencesColumnNames() {
        ArrayList<String> referencesColumnNames = new ArrayList<String>();
        for (ColumnDefinition cd : this.referencesColumns) {
            referencesColumnNames.add(cd.getName());
        }
        return referencesColumnNames;
    }

    public void addReferencesColumn(ColumnDefinition colDef) {
        this.referencesColumns.add(colDef);
    }

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public int getLower() {
        return this.lower;
    }

    public List<ColumnDefinition> getReferencesColumns() {
        return this.referencesColumns;
    }

    public int getReferencesLower() {
        return this.referencesLower;
    }

    public TableDefinition getReferencesTable() {
        return this.referencesTable;
    }

    public int getReferencesUpper() {
        return this.referencesUpper;
    }

    public TableDefinition getTable() {
        return this.table;
    }

    public int getUpper() {
        return this.upper;
    }

    public String getReferencesTableName() {
        return this.referencesTable.getName();
    }

    public String getTableName() {
        return this.table.getName();
    }

    public void setForeignKeyName(String foreignKeyName) {
        this.foreignKeyName = foreignKeyName;
    }

    public void setReferencesTable(TableDefinition referencesTable) {
        this.referencesTable = referencesTable;
    }

    public void setTable(TableDefinition table) {
        this.table = table;
    }

    public void setLower(int lower) {
        this.lower = lower;
    }

    public void setReferencesLower(int referencesLower) {
        this.referencesLower = referencesLower;
    }

    public void setReferencesUpper(int referencesUpper) {
        this.referencesUpper = referencesUpper;
    }

    public void setUpper(int upper) {
        this.upper = upper;
    }
}

