/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Encoders;

import Acme.JPM.Encoders.ImageEncoder;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;

public class JpegEncoder
extends ImageEncoder {
    int qfactor = 100;
    int width;
    int height;
    int[][] rgbPixels;
    private static byte[] jfifHuff100Header = new byte[]{-1, -40, -1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, -1, -64, 0, 17, 8, 1, -32, 2, -128, 3, 1, 33, 0, 2, 17, 1, 3, 17, 1, -1, -37, 0, -124, 0, 16, 11, 12, 14, 12, 10, 16, 14, 13, 14, 18, 17, 16, 19, 24, 40, 26, 24, 22, 22, 24, 49, 35, 37, 29, 40, 58, 51, 61, 60, 57, 51, 56, 55, 64, 72, 92, 78, 64, 68, 87, 69, 55, 56, 80, 109, 81, 87, 95, 98, 103, 104, 103, 62, 77, 113, 121, 112, 100, 120, 92, 101, 103, 99, 1, 17, 18, 18, 24, 21, 24, 47, 26, 26, 47, 99, 66, 56, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, -1, -60, 0, 31, 0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, -1, -60, 0, -75, 16, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125, 1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, -127, -111, -95, 8, 35, 66, -79, -63, 21, 82, -47, -16, 36, 51, 98, 114, -126, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -1, -60, 0, 31, 1, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, -1, -60, 0, -75, 17, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119, 0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, -127, 8, 20, 66, -111, -95, -79, -63, 9, 35, 51, 82, -16, 21, 98, 114, -47, 10, 22, 36, 52, -31, 37, -15, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -126, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -30, -29, -28, -27, -26, -25, -24, -23, -22, -14, -13, -12, -11, -10, -9, -8, -7, -6, -1, -38, 0, 12, 3, 1, 0, 2, 17, 3, 17, 0, 63, 0};
    private static byte[] jfifNoHuff100Header = new byte[]{-1, -40, -1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, -1, -64, 0, 17, 8, 1, -32, 2, -128, 3, 1, 33, 0, 2, 17, 1, 3, 17, 1, -1, -37, 0, -124, 0, 16, 11, 12, 14, 12, 10, 16, 14, 13, 14, 18, 17, 16, 19, 24, 40, 26, 24, 22, 22, 24, 49, 35, 37, 29, 40, 58, 51, 61, 60, 57, 51, 56, 55, 64, 72, 92, 78, 64, 68, 87, 69, 55, 56, 80, 109, 81, 87, 95, 98, 103, 104, 103, 62, 77, 113, 121, 112, 100, 120, 92, 101, 103, 99, 1, 17, 18, 18, 24, 21, 24, 47, 26, 26, 47, 99, 66, 56, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, -1, -38, 0, 12, 3, 1, 0, 2, 17, 3, 17, 0, 63, 0};

    public JpegEncoder(Image img, OutputStream out) throws IOException {
        super(img, out);
    }

    public JpegEncoder(ImageProducer prod, OutputStream out) throws IOException {
        super(prod, out);
    }

    public void setQfactor(int qfactor) {
        this.qfactor = qfactor;
    }

    void encodeStart(int width, int height) throws IOException {
        this.width = width;
        this.height = height;
        this.rgbPixels = new int[height][width];
    }

    void encodePixels(int x, int y, int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        for (int row = 0; row < h; ++row) {
            System.arraycopy(rgbPixels, row * scansize + off, this.rgbPixels[y + row], x, w);
        }
    }

    void encodeDone() throws IOException {
        this.writeJfifHuffHeader();
    }

    private void writeJfifHuffHeader() throws IOException {
        byte[] newHeader = new byte[jfifHuff100Header.length];
        System.arraycopy(jfifHuff100Header, 0, newHeader, 0, jfifHuff100Header.length);
        newHeader[27] = (byte)(this.width >>> 8 & 0xFF);
        newHeader[28] = (byte)(this.width & 0xFF);
        newHeader[25] = (byte)(this.height >>> 8 & 0xFF);
        newHeader[26] = (byte)(this.height & 0xFF);
        if (this.qfactor != 100) {
            int t;
            int i;
            for (i = 44; i < 108; ++i) {
                t = newHeader[i] * this.qfactor / 100;
                newHeader[i] = (byte)Math.max(t, 255);
            }
            for (i = 109; i < 173; ++i) {
                t = newHeader[i] * this.qfactor / 100;
                newHeader[i] = (byte)Math.max(t, 255);
            }
        }
        this.out.write(newHeader);
    }

    private void writeJfifNoHuffHeader() throws IOException {
        byte[] newHeader = new byte[jfifNoHuff100Header.length];
        System.arraycopy(jfifNoHuff100Header, 0, newHeader, 0, jfifNoHuff100Header.length);
        newHeader[27] = (byte)(this.width >>> 8 & 0xFF);
        newHeader[28] = (byte)(this.width & 0xFF);
        newHeader[25] = (byte)(this.height >>> 8 & 0xFF);
        newHeader[26] = (byte)(this.height & 0xFF);
        if (this.qfactor != 100) {
            int t;
            int i;
            for (i = 44; i < 108; ++i) {
                t = newHeader[i] * this.qfactor / 100;
                newHeader[i] = (byte)Math.max(t, 255);
            }
            for (i = 109; i < 173; ++i) {
                t = newHeader[i] * this.qfactor / 100;
                newHeader[i] = (byte)Math.max(t, 255);
            }
        }
        this.out.write(newHeader);
    }
}

