/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.presentation.Connector;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.Handle;

public class SelectionResize
extends Selection {
    private static final long serialVersionUID = 1996301098909656022L;
    private int cx;
    private int cy;
    private int cw;
    private int ch;
    private static Log log = LogFactory.getLog(SelectionResize.class);

    public SelectionResize(Fig f) {
        super(f);
    }

    public void hitHandle(Rectangle r, Handle h) {
        if (this.getContent().isResizable()) {
            this.updateHandleBox();
            Rectangle testRect = new Rectangle(0, 0, 0, 0);
            testRect.setBounds(this.cx - 3, this.cy - 3, 6, this.ch + 3);
            boolean leftEdge = r.intersects(testRect);
            testRect.setBounds(this.cx + this.cw - 3, this.cy - 3, 6, this.ch + 3);
            boolean rightEdge = r.intersects(testRect);
            testRect.setBounds(this.cx - 3, this.cy - 3, this.cw + 3, 6);
            boolean topEdge = r.intersects(testRect);
            testRect.setBounds(this.cx - 3, this.cy + this.ch - 3, this.cw + 3, 6);
            boolean bottomEdge = r.intersects(testRect);
            if (leftEdge && topEdge) {
                h.index = 0;
                h.instructions = "Resize top left";
            } else if (rightEdge && topEdge) {
                h.index = 2;
                h.instructions = "Resize top right";
            } else if (leftEdge && bottomEdge) {
                h.index = 5;
                h.instructions = "Resize bottom left";
            } else if (rightEdge && bottomEdge) {
                h.index = 7;
                h.instructions = "Resize bottom right";
            } else {
                h.index = -1;
                h.instructions = "Move object(s)";
            }
        } else {
            h.index = -1;
            h.instructions = "Move object(s)";
        }
    }

    private void updateHandleBox() {
        Rectangle cRect = this.getContent().getHandleBox();
        this.cx = cRect.x;
        this.cy = cRect.y;
        this.cw = cRect.width;
        this.ch = cRect.height;
    }

    public void paint(Graphics g) {
        Fig fig = this.getContent();
        if (this.getContent().isResizable()) {
            this.updateHandleBox();
            g.setColor(Globals.getPrefs().handleColorFor(fig));
            g.fillRect(this.cx - 3, this.cy - 3, 6, 6);
            g.fillRect(this.cx + this.cw - 3, this.cy - 3, 6, 6);
            g.fillRect(this.cx - 3, this.cy + this.ch - 3, 6, 6);
            g.fillRect(this.cx + this.cw - 3, this.cy + this.ch - 3, 6, 6);
        } else {
            int x = fig.getX();
            int y = fig.getY();
            int w = fig.getWidth();
            int h = fig.getHeight();
            g.setColor(Globals.getPrefs().handleColorFor(fig));
            g.drawRect(x - 4, y - 4, w + 8 - 1, h + 8 - 1);
            g.drawRect(x - 4 - 1, y - 4 - 1, w + 8 + 2 - 1, h + 8 + 2 - 1);
            g.fillRect(x - 6, y - 6, 6, 6);
            g.fillRect(x + w, y - 6, 6, 6);
            g.fillRect(x - 6, y + h, 6, 6);
            g.fillRect(x + w, y + h, 6, 6);
        }
    }

    public void dragHandle(int mX, int mY, int anX, int anY, Handle hand) {
        Fig fig = this.getContent();
        if (!fig.isResizable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handle " + hand + " dragged but no action as fig is not resizable"));
            }
            return;
        }
        this.updateHandleBox();
        int x = this.cx;
        int y = this.cy;
        int w = this.cw;
        int h = this.ch;
        int newX = x;
        int newY = y;
        int newWidth = w;
        int newHeight = h;
        Dimension minSize = fig.getMinimumSize();
        int minWidth = minSize.width;
        int minHeight = minSize.height;
        switch (hand.index) {
            case -1: {
                fig.translate(anX - mX, anY - mY);
                return;
            }
            case 0: {
                newWidth = x + w - mX;
                newWidth = newWidth < minWidth ? minWidth : newWidth;
                newHeight = y + h - mY;
                newHeight = newHeight < minHeight ? minHeight : newHeight;
                newX = x + w - newWidth;
                newY = y + h - newHeight;
                fig.setHandleBox(newX, newY, newWidth, newHeight);
                if (newX + newWidth != x + w) {
                    newX += newX + newWidth - (x + w);
                }
                if (newY + newHeight != y + h) {
                    newY += newY + newHeight - (y + h);
                }
                fig.setHandleBox(newX, newY, newWidth, newHeight);
                return;
            }
            case 1: {
                break;
            }
            case 2: {
                newWidth = mX - x;
                newWidth = newWidth < minWidth ? minWidth : newWidth;
                newHeight = y + h - mY;
                newHeight = newHeight < minHeight ? minHeight : newHeight;
                newY = y + h - newHeight;
                fig.setHandleBox(newX, newY, newWidth, newHeight);
                if (newY + newHeight != y + h) {
                    newY += newY + newHeight - (y + h);
                }
                fig.setHandleBox(newX, newY, newWidth, newHeight);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                newWidth = x + w - mX;
                newWidth = newWidth < minWidth ? minWidth : newWidth;
                newHeight = mY - y;
                newHeight = newHeight < minHeight ? minHeight : newHeight;
                newX = x + w - newWidth;
                fig.setHandleBox(newX, newY, newWidth, newHeight);
                if (newX + newWidth != x + w) {
                    newX += newX + newWidth - (x + w);
                }
                fig.setHandleBox(newX, newY, newWidth, newHeight);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                newWidth = mX - x;
                newWidth = newWidth < minWidth ? minWidth : newWidth;
                newHeight = mY - y;
                newHeight = newHeight < minHeight ? minHeight : newHeight;
                fig.setHandleBox(newX, newY, newWidth, newHeight);
                break;
            }
            default: {
                log.error((Object)"invalid handle number for resizing fig");
                return;
            }
        }
        if (fig instanceof FigNode) {
            FigNode figNode = (FigNode)fig;
            for (Connector connector : figNode.getConnectors()) {
                Fig connectorFig = (Fig)((Object)connector);
                Point centre = new Point(connectorFig.getX() + connectorFig.getHalfWidth(), connectorFig.getY() + connectorFig.getHalfHeight());
                Point attachPoint = figNode.getClosestPoint(centre);
                connectorFig.setLocation(attachPoint.x - connectorFig.getHalfWidth(), attachPoint.y - connectorFig.getHalfHeight());
            }
        }
    }
}

