/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.graph.presentation.JGraph;

public class JSplitGraphPane
extends JPanel {
    private static final long serialVersionUID = 3796638763703844578L;
    private static final int MINIMUM_CLONE_HEIGHT = 30;
    private static final Dimension ZERO_DIMENSION = new Dimension(0, 0);
    private static final Dimension MAX_DIMENSION = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private final JPanel CLONE_CONTAINER = new JPanel();
    private JSplitPane splitPane = new JSplitPane(0);
    private JGraph clonedGraph;

    public JSplitGraphPane(JGraph graph) {
        this.setLayout(new BorderLayout());
        this.add(this.splitPane);
        graph.setPreferredSize(MAX_DIMENSION);
        this.CLONE_CONTAINER.setSize(ZERO_DIMENSION);
        this.CLONE_CONTAINER.setMinimumSize(ZERO_DIMENSION);
        this.CLONE_CONTAINER.setPreferredSize(ZERO_DIMENSION);
        this.CLONE_CONTAINER.setLayout(new BorderLayout());
        this.splitPane.add((Component)graph, "top");
        this.splitPane.add((Component)this.CLONE_CONTAINER, "bottom");
        this.splitPane.resetToPreferredSizes();
        this.CLONE_CONTAINER.addComponentListener(new CloneSizeWatcher());
    }

    private class CloneSizeWatcher
    extends ComponentAdapter {
        private CloneSizeWatcher() {
        }

        public void componentResized(ComponentEvent arg0) {
            int newHeight = JSplitGraphPane.this.CLONE_CONTAINER.getHeight();
            if (newHeight > 30) {
                if (JSplitGraphPane.this.clonedGraph == null) {
                    Editor ce = Globals.curEditor();
                    Editor ed = (Editor)ce.clone();
                    JSplitGraphPane.this.clonedGraph = new JGraph(ed);
                    JSplitGraphPane.this.CLONE_CONTAINER.add(JSplitGraphPane.this.clonedGraph);
                    JSplitGraphPane.this.validate();
                }
            } else {
                if (JSplitGraphPane.this.clonedGraph != null) {
                    JSplitGraphPane.this.CLONE_CONTAINER.remove(JSplitGraphPane.this.clonedGraph);
                    JSplitGraphPane.this.clonedGraph = null;
                }
                JSplitGraphPane.this.splitPane.resetToPreferredSizes();
            }
        }
    }
}

