/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.Random;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.Converter;

public class FileHeader {
    long fileId;
    private static final int TIMESTAMP_OFFSET = 8;
    long timeStamp;
    public static final int HEADER_SIZE = 64;

    FileHeader() {
        this.fileId = new Random(new Object().hashCode()).nextLong();
        this.updateTime();
    }

    void write(RandomAccessFile file) throws StorageException {
        try {
            byte[] buffer = new byte[64];
            this.write(buffer);
            file.seek(0L);
            file.write(buffer);
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    void write(byte[] buffer) {
        int offset = 0;
        offset = Converter.writeLong(buffer, offset, this.fileId);
        for (int i = offset = Converter.writeLong(buffer, offset, this.timeStamp); i < 64; ++i) {
            buffer[i] = 0;
        }
    }

    FileHeader(RandomAccessFile file) throws StorageException {
        try {
            file.seek(0L);
            this.fileId = file.readLong();
            this.timeStamp = file.readLong();
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    void updateTime() {
        this.timeStamp = System.currentTimeMillis();
    }

    static void updateTime(CachedPage page, long newTimeStamp) {
        Converter.writeLong(page.contents, 8, newTimeStamp);
    }

    public void addFiles(String[] names, int size, boolean replace) throws StorageException {
        Object file;
        int i;
        if (!replace) {
            for (i = 0; i < names.length; ++i) {
                file = new File(names[i]);
                if (!((File)file).exists()) continue;
                throw new StorageBadRequestException(MessageFormat.format("File {0} already exists", names[i]));
            }
        }
        try {
            for (i = 0; i < names.length; ++i) {
                file = new RandomAccessFile(names[i], "rw");
                this.write((RandomAccessFile)file);
                if (size > 0) {
                    ((RandomAccessFile)file).setLength(size);
                } else {
                    ((RandomAccessFile)file).setLength(((RandomAccessFile)file).getFilePointer());
                }
                ((RandomAccessFile)file).close();
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    public static FileHeader createFiles(String[] names, int size, boolean replace) throws StorageException {
        FileHeader header = new FileHeader();
        header.addFiles(names, size, replace);
        return header;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileHeader)) {
            return false;
        }
        FileHeader header = (FileHeader)o;
        return header.fileId == this.fileId && header.timeStamp == this.timeStamp;
    }
}

