/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ComposedLazyList
extends AbstractList {
    private final List lists = new ArrayList();
    private int elementCount = 0;

    public ComposedLazyList() {
    }

    public ComposedLazyList(Collection col) {
        this();
        this.addAll(col);
    }

    public boolean addAll(Collection col) {
        List result = col instanceof List ? (List)col : new ArrayList(col);
        ++this.modCount;
        this.elementCount += result.size();
        return this.lists.add(result);
    }

    public int size() {
        return this.elementCount;
    }

    public Object get(int index) {
        int listLBound = 0;
        List currentList = null;
        Iterator it = this.lists.iterator();
        for (int listUBound = 0; it.hasNext() && listUBound <= index; listUBound += currentList.size()) {
            currentList = (List)it.next();
            listLBound = listUBound;
        }
        return currentList.get(index - listLBound);
    }

    public Iterator iterator() {
        return new LazyIterator();
    }

    private class LazyIterator
    implements Iterator {
        Iterator listIterator;
        Iterator currentIterator;

        private LazyIterator() {
            this.listIterator = ComposedLazyList.this.lists.iterator();
            this.currentIterator = null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            this.hasNext();
            return this.currentIterator.next();
        }

        public boolean hasNext() {
            if (this.currentIterator == null) {
                if (this.listIterator.hasNext()) {
                    this.currentIterator = ((List)this.listIterator.next()).iterator();
                } else {
                    return false;
                }
            }
            while (!this.currentIterator.hasNext()) {
                if (this.listIterator.hasNext()) {
                    this.currentIterator = ((List)this.listIterator.next()).iterator();
                    continue;
                }
                return false;
            }
            return true;
        }
    }
}

