# fifo-cronolog
This is a little tool that connects a named pipe/FIFO into the stdin of `cronolog`.

This is useful for cases where the logging destination cannot be specified as a
program. It was originally written to do logging from Squid, but later re-used
for Nginx & other tools.

## openrc
1. `cp /etc/conf.d/fifo-cronolog /etc/conf.d/fifo-cronolog.$INSTANCE`
2. Edit `/etc/conf.d/fifo-cronolog.$INSTANCE`
3. `ln -s /etc/init.d/fifo-cronolog /etc/init.d/fifo-cronolog.$INSTANCE`
4. `rc-update add fifo-cronolog.$INSTANCE default`

## systemd
1. Put env into a supported directory, using the entire name of the unit, with instance suffix.
   e.g. `/etc/default/fifo-cronolog@example`
2. `systemctl enable fifo-cronolog@example`
3. Use systemd overrides if you need to add dependencies.

### systemd environment load order
- `/etc/sysconfig/`
- `/etc/default/`
- `/run/sysconfig/`

## how it works
Cronolog's canonical example, in an Apache configuration
```
TransferLog "|/www/sbin/cronolog /www/logs/%Y/%m/%d/access.log"
```

Is converted into:
1. Fifo-cronolog as (via your init system, so it gets restarted):
```
fifo-cronolog /run/apache-access.pid /run/apache-access.fifo /www/logs/%Y/%m/%d/access.log
```
2. Apache configuration:
```
TransferLog "/run/apache-access.fifo"
```
