/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.antlr.base.mod;
import org.python.compiler.LegacyCompiler;
import org.python.core.CompilerFlags;
import org.python.core.Options;
import org.python.core.ParserFacade;
import org.python.core.PyCode;
import org.python.core.PythonCodeBundle;
import org.python.core.PythonCompiler;

public class CompilerFacade {
    private static volatile PythonCompiler compiler = CompilerFacade.loadDefaultCompiler();

    public static void setCompiler(PythonCompiler compiler) {
        CompilerFacade.compiler = compiler;
    }

    private static PythonCompiler loadDefaultCompiler() {
        return new LegacyCompiler();
    }

    public static PyCode compile(mod node, String name, String filename, boolean linenumbers, boolean printResults, CompilerFlags cflags) {
        try {
            PythonCodeBundle bundle = compiler.compile(node, name, filename, linenumbers, printResults, cflags);
            bundle.saveCode(Options.proxyDebugDirectory);
            return bundle.loadCode();
        }
        catch (Throwable t) {
            throw ParserFacade.fixParseError(null, t, filename);
        }
    }
}

