/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.Loader;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.ContentHandlerProxy;
import com.icl.saxon.output.DocumentHandlerProxy;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;

public abstract class Emitter
implements Result {
    protected NamePool namePool;
    protected String systemId;
    protected Writer writer;
    protected OutputStream outputStream;
    protected Properties outputProperties;
    protected Locator locator;

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setOutputProperties(Properties properties) {
        this.outputProperties = properties;
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public boolean usesWriter() {
        return true;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public abstract void startDocument() throws TransformerException;

    public abstract void endDocument() throws TransformerException;

    public abstract void startElement(int var1, Attributes var2, int[] var3, int var4) throws TransformerException;

    public abstract void endElement(int var1) throws TransformerException;

    public abstract void characters(char[] var1, int var2, int var3) throws TransformerException;

    public abstract void processingInstruction(String var1, String var2) throws TransformerException;

    public abstract void comment(char[] var1, int var2, int var3) throws TransformerException;

    public void setEscaping(boolean bl) throws TransformerException {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setUnparsedEntity(String string, String string2) throws TransformerException {
    }

    public static Emitter makeEmitter(String string) throws TransformerException {
        Object object = Loader.getInstance(string);
        if (object instanceof Emitter) {
            return (Emitter)object;
        }
        if (object instanceof DocumentHandler) {
            DocumentHandlerProxy documentHandlerProxy = new DocumentHandlerProxy();
            documentHandlerProxy.setUnderlyingDocumentHandler((DocumentHandler)object);
            return documentHandlerProxy;
        }
        if (object instanceof ContentHandler) {
            ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
            contentHandlerProxy.setUnderlyingContentHandler((ContentHandler)object);
            return contentHandlerProxy;
        }
        throw new TransformerException("Failed to load emitter " + string + ": it is not a SAX DocumentHandler or SAX2 ContentHandler");
    }
}

