/* Generated by wayland-scanner 1.24.0 */

#ifndef COLOR_REPRESENTATION_V1_ENUM_PROTOCOL_H
#define COLOR_REPRESENTATION_V1_ENUM_PROTOCOL_H

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef WP_COLOR_REPRESENTATION_MANAGER_V1_ERROR_ENUM
#define WP_COLOR_REPRESENTATION_MANAGER_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_color_representation_manager_v1
 * protocol errors
 */
enum wp_color_representation_manager_v1_error {
	/**
	 * color representation surface exists already
	 */
	WP_COLOR_REPRESENTATION_MANAGER_V1_ERROR_SURFACE_EXISTS = 1,
};
#endif /* WP_COLOR_REPRESENTATION_MANAGER_V1_ERROR_ENUM */

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_ENUM
#define WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * protocol errors
 */
enum wp_color_representation_surface_v1_error {
	/**
	 * unsupported alpha mode
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_ALPHA_MODE = 1,
	/**
	 * unsupported coefficients
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_COEFFICIENTS = 2,
	/**
	 * the pixel format and a set value are incompatible
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_PIXEL_FORMAT = 3,
	/**
	 * forbidden request on inert object
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_INERT = 4,
	/**
	 * invalid chroma location
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_CHROMA_LOCATION = 5,
};
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_ENUM */

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_ENUM
#define WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * alpha mode
 *
 * Specifies how the alpha channel affects the color channels.
 */
enum wp_color_representation_surface_v1_alpha_mode {
	/**
	 * premultiplied alpha in electrical values
	 *
	 * Electrical color channel values (after transfer function
	 * encoding) are already multiplied with the alpha channel value.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_PREMULTIPLIED_ELECTRICAL = 0,
	/**
	 * premultiplied alpha in optical values
	 *
	 * Optical color channel values (before transfer function
	 * encoding) are already multiplied with the alpha channel value.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_PREMULTIPLIED_OPTICAL = 1,
	/**
	 * straight alpha
	 *
	 * Alpha channel has not been pre-multiplied into color channels.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_STRAIGHT = 2,
};
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_ENUM */

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_ENUM
#define WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * named coefficients
 *
 * Named matrix coefficients used to encode well-known sets of
 * coefficients. H.273 is the authority, when it comes to the exact values
 * of coefficients and authoritative specifications, where an equivalent
 * code point exists.
 *
 * A value of 0 is invalid and will never be present in the list of enums.
 *
 * Descriptions do list the specifications for convenience.
 */
enum wp_color_representation_surface_v1_coefficients {
	/**
	 * The identity matrix
	 *
	 * Coefficients as defined by - IEC 61966-2-1 sRGB - SMPTE ST
	 * 428-1 (2019)
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 0. Compatible
	 * with pixel formats of the RGB family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_IDENTITY = 1,
	/**
	 * BT.709 matrix coefficients
	 *
	 * Coefficients as defined by - Rec. ITU-R BT.709-6 - Rec. ITU-R
	 * BT.1361-0 conventional colour gamut system (historical) - Rec.
	 * ITU-R BT.1361-0 conventional colour gamut system and extended
	 * colour gamut system (historical) - IEC 61966-2-4 xvYCC709 -
	 * SMPTE RP 177 (1993) Annex B
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 1. Compatible
	 * with pixel formats of the YCbCr family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT709 = 2,
	/**
	 * FCC matrix coefficients
	 *
	 * Coefficients as defined by - United States Federal
	 * Communications Commission (2003) Title 47 Code of Federal
	 * Regulations 73.682 (a) (20)
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 4. Compatible
	 * with pixel formats of the YCbCr family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_FCC = 3,
	/**
	 * BT.601-7 matrix coefficients
	 *
	 * Coefficients as defined by - Rec. ITU-R BT.470-6 System B, G
	 * (historical) - Rec. ITU-R BT.601-7 625 - Rec. ITU-R BT.601-7 525
	 * - Rec. ITU-R BT.1358-0 625 (historical) - Rec. ITU-R BT.1358-1
	 * 525 or 625 (historical) - Rec. ITU-R BT.1700-0 625 PAL and 625
	 * SECAM - Rec. ITU-R BT.1700-0 NTSC - IEC 61966-2-1 sYCC - IEC
	 * 61966-2-4 xvYCC601 - SMPTE ST 170 (2004)
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 5, 6.
	 * Compatible with pixel formats of the YCbCr family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT601 = 4,
	/**
	 * SMPTE ST 240 matrix coefficients
	 *
	 * Coefficients as defined by - SMPTE ST 240 (1999)
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 7. Compatible
	 * with pixel formats of the YCbCr family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_SMPTE240 = 5,
	/**
	 * BT.2020 and BT.2100 YCbCr matrix coefficients
	 *
	 * Coefficients as defined by - Rec. ITU-R BT.2020-2
	 * (non-constant luminance) - Rec. ITU-R BT.2100-2 Y′CbCr
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 9. Compatible
	 * with pixel formats of the YCbCr family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT2020 = 6,
	/**
	 * BT.2020 matrix coefficients for constant luminance
	 *
	 * Coefficients as defined by - Rec. ITU-R BT.2020-2 (constant
	 * luminance)
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 10. Compatible
	 * with pixel formats of the YCbCr family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT2020_CL = 7,
	/**
	 * BT.2100 ICtCp matrix coefficients
	 *
	 * Coefficients as defined by - Rec. ITU-R BT.2100-2 ICTCP
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 14. Compatible
	 * with pixel formats of the YCbCr family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_ICTCP = 8,
};
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_ENUM */

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_ENUM
#define WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * Color range values
 *
 * Possible color range values.
 *
 * A value of 0 is invalid and will never be present in the list of enums.
 */
enum wp_color_representation_surface_v1_range {
	/**
	 * Full color range
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_FULL = 1,
	/**
	 * Limited color range
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_LIMITED = 2,
};
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_ENUM */

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_ENUM
#define WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * Chroma sample location for 4:2:0 YCbCr
 *
 * Chroma sample location as defined by H.273 Chroma420SampleLocType.
 *
 * A value of 0 is invalid and will never be present in the list of enums.
 *
 * The descriptions list the matching Vulkan VkChromaLocation combinations
 * for convenience.
 */
enum wp_color_representation_surface_v1_chroma_location {
	/**
	 * Horizontal offset of 0, vertical offset of 0.5
	 *
	 * Corresponding to VkChromaLocations: - xChromaOffset:
	 * VK_CHROMA_LOCATION_COSITED_EVEN - yChromaOffset:
	 * VK_CHROMA_LOCATION_MIDPOINT
	 *
	 * Equivalent to H.273 Chroma420SampleLocType 0.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_0 = 1,
	/**
	 * Horizontal offset of 0.5, vertical offset of 0.5
	 *
	 * Corresponding to VkChromaLocations: - xChromaOffset:
	 * VK_CHROMA_LOCATION_MIDPOINT - yChromaOffset:
	 * VK_CHROMA_LOCATION_MIDPOINT
	 *
	 * Equivalent to H.273 Chroma420SampleLocType 1.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_1 = 2,
	/**
	 * Horizontal offset of 0, vertical offset of 0
	 *
	 * Corresponding to VkChromaLocations: - xChromaOffset:
	 * VK_CHROMA_LOCATION_COSITED_EVEN - yChromaOffset:
	 * VK_CHROMA_LOCATION_COSITED_EVEN
	 *
	 * Equivalent to H.273 Chroma420SampleLocType 2.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_2 = 3,
	/**
	 * Horizontal offset of 0.5, vertical offset of 0
	 *
	 * Corresponding to VkChromaLocations: - xChromaOffset:
	 * VK_CHROMA_LOCATION_MIDPOINT - yChromaOffset:
	 * VK_CHROMA_LOCATION_COSITED_EVEN
	 *
	 * Equivalent to H.273 Chroma420SampleLocType 3.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_3 = 4,
	/**
	 * Horizontal offset of 0, vertical offset of 1
	 *
	 * Equivalent to H.273 Chroma420SampleLocType 4.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_4 = 5,
	/**
	 * Horizontal offset of 0.5, vertical offset of 1
	 *
	 * Equivalent to H.273 Chroma420SampleLocType 5.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_5 = 6,
};
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_ENUM */

#ifdef  __cplusplus
}
#endif

#endif
