# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools flag-o-matic

MY_P=uudeview-${PV}

DESCRIPTION="Library that supports Base64 (MIME), uuencode, xxencode and binhex coding"
HOMEPAGE="http://www.fpx.de/fp/Software/UUDeview/"
SRC_URI="http://www.fpx.de/fp/Software/UUDeview/download/${MY_P}.tar.gz"
S="${WORKDIR}"/${MY_P}/${PN}

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~alpha amd64 arm ~hppa ppc ~ppc64 ~sparc x86 ~x64-macos ~x64-solaris"

PATCHES=(
	"${FILESDIR}"/${P}-libtool.patch # 780018
	"${FILESDIR}"/${PN}-0.5.20-Fix-Wimplicit-function-declaration-for-strerror.patch
)

src_prepare() {
	default
	eautoreconf
}

src_configure() {
	append-cppflags -DPROTOTYPES # 943841
	default
}

src_install() {
	default
	find "${D}" -name '*.la' -delete || die
}
